<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_payment_search = new process_action_payment_search();

// Run the page
$process_action_payment_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_payment_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_action_payment_search->IsModal) { ?>
var fprocess_action_paymentsearch = currentAdvancedSearchForm = new ew.Form("fprocess_action_paymentsearch", "search");
<?php } else { ?>
var fprocess_action_paymentsearch = currentForm = new ew.Form("fprocess_action_paymentsearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_action_paymentsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_paymentsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_paymentsearch.lists["x_location"] = <?php echo $process_action_payment_search->location->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_location"].options = <?php echo JsonEncode($process_action_payment_search->location->lookupOptions()) ?>;
fprocess_action_paymentsearch.lists["x_process"] = <?php echo $process_action_payment_search->process->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_process"].options = <?php echo JsonEncode($process_action_payment_search->process->lookupOptions()) ?>;
fprocess_action_paymentsearch.lists["x_emp_id"] = <?php echo $process_action_payment_search->emp_id->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_search->emp_id->lookupOptions()) ?>;
fprocess_action_paymentsearch.lists["x_ref"] = <?php echo $process_action_payment_search->ref->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_ref"].options = <?php echo JsonEncode($process_action_payment_search->ref->lookupOptions()) ?>;
fprocess_action_paymentsearch.lists["x_c_id"] = <?php echo $process_action_payment_search->c_id->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_c_id"].options = <?php echo JsonEncode($process_action_payment_search->c_id->lookupOptions()) ?>;
fprocess_action_paymentsearch.lists["x_payment_type"] = <?php echo $process_action_payment_search->payment_type->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_payment_type"].options = <?php echo JsonEncode($process_action_payment_search->payment_type->options(FALSE, TRUE)) ?>;
fprocess_action_paymentsearch.lists["x_process_fix"] = <?php echo $process_action_payment_search->process_fix->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_process_fix"].options = <?php echo JsonEncode($process_action_payment_search->process_fix->options(FALSE, TRUE)) ?>;
fprocess_action_paymentsearch.lists["x_method"] = <?php echo $process_action_payment_search->method->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_method"].options = <?php echo JsonEncode($process_action_payment_search->method->options(FALSE, TRUE)) ?>;
fprocess_action_paymentsearch.lists["x_payment[]"] = <?php echo $process_action_payment_search->payment->Lookup->toClientList() ?>;
fprocess_action_paymentsearch.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_payment_search->payment->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocess_action_paymentsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_size_wl");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->size_wl->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process_40");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->process_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_final_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->final_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_c_charge");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->c_charge->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_custom_size");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->custom_size->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ded_jc");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->ded_jc->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ded_pa");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->ded_pa->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm_grp");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->sqm_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__2_srm");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->_2_srm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__4_srm");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->_4_srm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pps");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->pps->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_c_method");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->c_method->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_category");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->category->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_action_payment_search->showPageHeader(); ?>
<?php
$process_action_payment_search->showMessage();
?>
<form name="fprocess_action_paymentsearch" id="fprocess_action_paymentsearch" class="<?php echo $process_action_payment_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_payment_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_payment_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_payment">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_action_payment_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_action_payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_id"><?php echo $process_action_payment->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->id->cellAttributes() ?>>
			<span id="el_process_action_payment_id">
<input type="text" data-table="process_action_payment" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_action_payment->id->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->id->EditValue ?>"<?php echo $process_action_payment->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_location"><?php echo $process_action_payment->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->location->cellAttributes() ?>>
			<span id="el_process_action_payment_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_location" data-value-separator="<?php echo $process_action_payment->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action_payment->location->editAttributes() ?>>
		<?php echo $process_action_payment->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action_payment->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_process"><?php echo $process_action_payment->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->process->cellAttributes() ?>>
			<span id="el_process_action_payment_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_process" data-value-separator="<?php echo $process_action_payment->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_payment->process->editAttributes() ?>>
		<?php echo $process_action_payment->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_payment->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->emp_id->Visible) { // emp_id ?>
	<div id="r_emp_id" class="form-group row">
		<label for="x_emp_id" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_emp_id"><?php echo $process_action_payment->emp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->emp_id->cellAttributes() ?>>
			<span id="el_process_action_payment_emp_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_emp_id" data-value-separator="<?php echo $process_action_payment->emp_id->displayValueSeparatorAttribute() ?>" id="x_emp_id" name="x_emp_id"<?php echo $process_action_payment->emp_id->editAttributes() ?>>
		<?php echo $process_action_payment->emp_id->selectOptionListHtml("x_emp_id") ?>
	</select>
</div>
<?php echo $process_action_payment->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_code"><?php echo $process_action_payment->code->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->code->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_code" id="z_code" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_payment_code">
<input type="text" data-table="process_action_payment" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($process_action_payment->code->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->code->EditValue ?>"<?php echo $process_action_payment->code->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_code d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_payment_code" class="btw1_code d-none">
<input type="text" data-table="process_action_payment" data-field="x_code" name="y_code" id="y_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($process_action_payment->code->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->code->EditValue2 ?>"<?php echo $process_action_payment->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_ref"><?php echo $process_action_payment->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->ref->cellAttributes() ?>>
			<span id="el_process_action_payment_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_ref" data-value-separator="<?php echo $process_action_payment->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $process_action_payment->ref->editAttributes() ?>>
		<?php echo $process_action_payment->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $process_action_payment->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->size_wl->Visible) { // size_wl ?>
	<div id="r_size_wl" class="form-group row">
		<label for="x_size_wl" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_size_wl"><?php echo $process_action_payment->size_wl->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_size_wl" id="z_size_wl" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->size_wl->cellAttributes() ?>>
			<span id="el_process_action_payment_size_wl">
<input type="text" data-table="process_action_payment" data-field="x_size_wl" name="x_size_wl" id="x_size_wl" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->size_wl->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->size_wl->EditValue ?>"<?php echo $process_action_payment->size_wl->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->process_40->Visible) { // process_@ ?>
	<div id="r_process_40" class="form-group row">
		<label for="x_process_40" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_process_40"><?php echo $process_action_payment->process_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_40" id="z_process_40" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->process_40->cellAttributes() ?>>
			<span id="el_process_action_payment_process_40">
<input type="text" data-table="process_action_payment" data-field="x_process_40" name="x_process_40" id="x_process_40" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->process_40->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->process_40->EditValue ?>"<?php echo $process_action_payment->process_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label for="x_final_amount" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_final_amount"><?php echo $process_action_payment->final_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_final_amount" id="z_final_amount" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->final_amount->cellAttributes() ?>>
			<span id="el_process_action_payment_final_amount">
<input type="text" data-table="process_action_payment" data-field="x_final_amount" name="x_final_amount" id="x_final_amount" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->final_amount->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->final_amount->EditValue ?>"<?php echo $process_action_payment->final_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_amount"><?php echo $process_action_payment->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->amount->cellAttributes() ?>>
			<span id="el_process_action_payment_amount">
<input type="text" data-table="process_action_payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->amount->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->amount->EditValue ?>"<?php echo $process_action_payment->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->c_charge->Visible) { // c_charge ?>
	<div id="r_c_charge" class="form-group row">
		<label for="x_c_charge" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_c_charge"><?php echo $process_action_payment->c_charge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_c_charge" id="z_c_charge" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->c_charge->cellAttributes() ?>>
			<span id="el_process_action_payment_c_charge">
<input type="text" data-table="process_action_payment" data-field="x_c_charge" name="x_c_charge" id="x_c_charge" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->c_charge->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->c_charge->EditValue ?>"<?php echo $process_action_payment->c_charge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->custom_size->Visible) { // custom_size ?>
	<div id="r_custom_size" class="form-group row">
		<label for="x_custom_size" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_custom_size"><?php echo $process_action_payment->custom_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_custom_size" id="z_custom_size" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->custom_size->cellAttributes() ?>>
			<span id="el_process_action_payment_custom_size">
<input type="text" data-table="process_action_payment" data-field="x_custom_size" name="x_custom_size" id="x_custom_size" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->custom_size->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->custom_size->EditValue ?>"<?php echo $process_action_payment->custom_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->ded_jc->Visible) { // ded_jc ?>
	<div id="r_ded_jc" class="form-group row">
		<label for="x_ded_jc" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_ded_jc"><?php echo $process_action_payment->ded_jc->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ded_jc" id="z_ded_jc" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->ded_jc->cellAttributes() ?>>
			<span id="el_process_action_payment_ded_jc">
<input type="text" data-table="process_action_payment" data-field="x_ded_jc" name="x_ded_jc" id="x_ded_jc" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->ded_jc->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->ded_jc->EditValue ?>"<?php echo $process_action_payment->ded_jc->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->ded_pa->Visible) { // ded_pa ?>
	<div id="r_ded_pa" class="form-group row">
		<label for="x_ded_pa" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_ded_pa"><?php echo $process_action_payment->ded_pa->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ded_pa" id="z_ded_pa" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->ded_pa->cellAttributes() ?>>
			<span id="el_process_action_payment_ded_pa">
<input type="text" data-table="process_action_payment" data-field="x_ded_pa" name="x_ded_pa" id="x_ded_pa" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->ded_pa->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->ded_pa->EditValue ?>"<?php echo $process_action_payment->ded_pa->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->c_id->Visible) { // c_id ?>
	<div id="r_c_id" class="form-group row">
		<label for="x_c_id" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_c_id"><?php echo $process_action_payment->c_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_c_id" id="z_c_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->c_id->cellAttributes() ?>>
			<span id="el_process_action_payment_c_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_c_id" data-value-separator="<?php echo $process_action_payment->c_id->displayValueSeparatorAttribute() ?>" id="x_c_id" name="x_c_id"<?php echo $process_action_payment->c_id->editAttributes() ?>>
		<?php echo $process_action_payment->c_id->selectOptionListHtml("x_c_id") ?>
	</select>
</div>
<?php echo $process_action_payment->c_id->Lookup->getParamTag("p_x_c_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->payment_type->Visible) { // payment_type ?>
	<div id="r_payment_type" class="form-group row">
		<label for="x_payment_type" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_payment_type"><?php echo $process_action_payment->payment_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment_type" id="z_payment_type" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->payment_type->cellAttributes() ?>>
			<span id="el_process_action_payment_payment_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_payment_type" data-value-separator="<?php echo $process_action_payment->payment_type->displayValueSeparatorAttribute() ?>" id="x_payment_type" name="x_payment_type"<?php echo $process_action_payment->payment_type->editAttributes() ?>>
		<?php echo $process_action_payment->payment_type->selectOptionListHtml("x_payment_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_sqm"><?php echo $process_action_payment->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->sqm->cellAttributes() ?>>
			<span id="el_process_action_payment_sqm">
<input type="text" data-table="process_action_payment" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->sqm->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->sqm->EditValue ?>"<?php echo $process_action_payment->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->sqm_grp->Visible) { // sqm_grp ?>
	<div id="r_sqm_grp" class="form-group row">
		<label for="x_sqm_grp" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_sqm_grp"><?php echo $process_action_payment->sqm_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm_grp" id="z_sqm_grp" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->sqm_grp->cellAttributes() ?>>
			<span id="el_process_action_payment_sqm_grp">
<input type="text" data-table="process_action_payment" data-field="x_sqm_grp" name="x_sqm_grp" id="x_sqm_grp" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->sqm_grp->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->sqm_grp->EditValue ?>"<?php echo $process_action_payment->sqm_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->_2_srm->Visible) { // 2_srm ?>
	<div id="r__2_srm" class="form-group row">
		<label for="x__2_srm" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment__2_srm"><?php echo $process_action_payment->_2_srm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__2_srm" id="z__2_srm" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->_2_srm->cellAttributes() ?>>
			<span id="el_process_action_payment__2_srm">
<input type="text" data-table="process_action_payment" data-field="x__2_srm" name="x__2_srm" id="x__2_srm" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->_2_srm->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->_2_srm->EditValue ?>"<?php echo $process_action_payment->_2_srm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->_4_srm->Visible) { // 4_srm ?>
	<div id="r__4_srm" class="form-group row">
		<label for="x__4_srm" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment__4_srm"><?php echo $process_action_payment->_4_srm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__4_srm" id="z__4_srm" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->_4_srm->cellAttributes() ?>>
			<span id="el_process_action_payment__4_srm">
<input type="text" data-table="process_action_payment" data-field="x__4_srm" name="x__4_srm" id="x__4_srm" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->_4_srm->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->_4_srm->EditValue ?>"<?php echo $process_action_payment->_4_srm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->process_fix->Visible) { // process_fix ?>
	<div id="r_process_fix" class="form-group row">
		<label for="x_process_fix" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_process_fix"><?php echo $process_action_payment->process_fix->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_fix" id="z_process_fix" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->process_fix->cellAttributes() ?>>
			<span id="el_process_action_payment_process_fix">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_process_fix" data-value-separator="<?php echo $process_action_payment->process_fix->displayValueSeparatorAttribute() ?>" id="x_process_fix" name="x_process_fix"<?php echo $process_action_payment->process_fix->editAttributes() ?>>
		<?php echo $process_action_payment->process_fix->selectOptionListHtml("x_process_fix") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_method"><?php echo $process_action_payment->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->method->cellAttributes() ?>>
			<span id="el_process_action_payment_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_method" data-value-separator="<?php echo $process_action_payment->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $process_action_payment->method->editAttributes() ?>>
		<?php echo $process_action_payment->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_datetime"><?php echo $process_action_payment->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_payment_datetime">
<input type="text" data-table="process_action_payment" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action_payment->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->datetime->EditValue ?>"<?php echo $process_action_payment->datetime->editAttributes() ?>>
<?php if (!$process_action_payment->datetime->ReadOnly && !$process_action_payment->datetime->Disabled && !isset($process_action_payment->datetime->EditAttrs["readonly"]) && !isset($process_action_payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_paymentsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_payment_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_action_payment" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action_payment->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->datetime->EditValue2 ?>"<?php echo $process_action_payment->datetime->editAttributes() ?>>
<?php if (!$process_action_payment->datetime->ReadOnly && !$process_action_payment->datetime->Disabled && !isset($process_action_payment->datetime->EditAttrs["readonly"]) && !isset($process_action_payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_paymentsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_payment"><?php echo $process_action_payment->payment->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->payment->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_payment_payment">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_payment->payment->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_payment" data-repeatcolumn="4" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_payment->payment->checkBoxListHtml(TRUE, "x_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_payment->payment->displayValueSeparatorAttribute() ?>" name="x_payment[]" id="x_payment[]" value="{value}"<?php echo $process_action_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_payment->payment->Lookup->getParamTag("p_x_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
			<span class="ew-search-cond btw1_payment d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_payment_payment" class="btw1_payment d-none">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_payment->payment->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_payment" data-repeatcolumn="4" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_payment->payment->checkBoxListHtml(TRUE, "y_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_payment->payment->displayValueSeparatorAttribute() ?>" name="y_payment[]" id="y_payment[]" value="{value}"<?php echo $process_action_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_payment->payment->Lookup->getParamTag("p_y_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_grp"><?php echo $process_action_payment->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->grp->cellAttributes() ?>>
			<span id="el_process_action_payment_grp">
<input type="text" data-table="process_action_payment" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->grp->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->grp->EditValue ?>"<?php echo $process_action_payment->grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label for="x_remark" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_remark"><?php echo $process_action_payment->remark->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remark" id="z_remark" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->remark->cellAttributes() ?>>
			<span id="el_process_action_payment_remark">
<input type="text" data-table="process_action_payment" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="225" placeholder="<?php echo HtmlEncode($process_action_payment->remark->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->remark->EditValue ?>"<?php echo $process_action_payment->remark->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->pps->Visible) { // pps ?>
	<div id="r_pps" class="form-group row">
		<label for="x_pps" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_pps"><?php echo $process_action_payment->pps->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pps" id="z_pps" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->pps->cellAttributes() ?>>
			<span id="el_process_action_payment_pps">
<input type="text" data-table="process_action_payment" data-field="x_pps" name="x_pps" id="x_pps" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->pps->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->pps->EditValue ?>"<?php echo $process_action_payment->pps->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->c_method->Visible) { // c_method ?>
	<div id="r_c_method" class="form-group row">
		<label for="x_c_method" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_c_method"><?php echo $process_action_payment->c_method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_c_method" id="z_c_method" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->c_method->cellAttributes() ?>>
			<span id="el_process_action_payment_c_method">
<input type="text" data-table="process_action_payment" data-field="x_c_method" name="x_c_method" id="x_c_method" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->c_method->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->c_method->EditValue ?>"<?php echo $process_action_payment->c_method->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_payment->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $process_action_payment_search->LeftColumnClass ?>"><span id="elh_process_action_payment_category"><?php echo $process_action_payment->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $process_action_payment_search->RightColumnClass ?>"><div<?php echo $process_action_payment->category->cellAttributes() ?>>
			<span id="el_process_action_payment_category">
<input type="text" data-table="process_action_payment" data-field="x_category" name="x_category" id="x_category" size="30" placeholder="<?php echo HtmlEncode($process_action_payment->category->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->category->EditValue ?>"<?php echo $process_action_payment->category->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_action_payment_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_action_payment_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_action_payment_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_action_payment_search->terminate();
?>