<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_single_list = new process_action_single_list();

// Run the page
$process_action_single_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_single_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_single->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_singlelist = currentForm = new ew.Form("fprocess_action_singlelist", "list");
fprocess_action_singlelist.formKeyCountName = '<?php echo $process_action_single_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_singlelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_singlelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_singlelist.lists["x_location"] = <?php echo $process_action_single_list->location->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_location"].options = <?php echo JsonEncode($process_action_single_list->location->lookupOptions()) ?>;
fprocess_action_singlelist.lists["x_process"] = <?php echo $process_action_single_list->process->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_process"].options = <?php echo JsonEncode($process_action_single_list->process->lookupOptions()) ?>;
fprocess_action_singlelist.lists["x_employee_id[]"] = <?php echo $process_action_single_list->employee_id->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_action_single_list->employee_id->lookupOptions()) ?>;
fprocess_action_singlelist.lists["x_operator"] = <?php echo $process_action_single_list->operator->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_operator"].options = <?php echo JsonEncode($process_action_single_list->operator->lookupOptions()) ?>;
fprocess_action_singlelist.lists["x_valuation"] = <?php echo $process_action_single_list->valuation->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_valuation"].options = <?php echo JsonEncode($process_action_single_list->valuation->options(FALSE, TRUE)) ?>;
fprocess_action_singlelist.lists["x_payment[]"] = <?php echo $process_action_single_list->payment->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_single_list->payment->lookupOptions()) ?>;
fprocess_action_singlelist.lists["x_process_other[]"] = <?php echo $process_action_single_list->process_other->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_process_other[]"].options = <?php echo JsonEncode($process_action_single_list->process_other->lookupOptions()) ?>;
fprocess_action_singlelist.lists["x_buyer_id"] = <?php echo $process_action_single_list->buyer_id->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_buyer_id"].options = <?php echo JsonEncode($process_action_single_list->buyer_id->lookupOptions()) ?>;
fprocess_action_singlelist.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_singlelist.lists["x_design_id"] = <?php echo $process_action_single_list->design_id->Lookup->toClientList() ?>;
fprocess_action_singlelist.lists["x_design_id"].options = <?php echo JsonEncode($process_action_single_list->design_id->lookupOptions()) ?>;
fprocess_action_singlelist.autoSuggests["x_design_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fprocess_action_singlelistsrch = currentSearchForm = new ew.Form("fprocess_action_singlelistsrch");

// Validate function for search
fprocess_action_singlelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_action_singlelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_singlelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_singlelistsrch.lists["x_location"] = <?php echo $process_action_single_list->location->Lookup->toClientList() ?>;
fprocess_action_singlelistsrch.lists["x_location"].options = <?php echo JsonEncode($process_action_single_list->location->lookupOptions()) ?>;
fprocess_action_singlelistsrch.lists["x_process"] = <?php echo $process_action_single_list->process->Lookup->toClientList() ?>;
fprocess_action_singlelistsrch.lists["x_process"].options = <?php echo JsonEncode($process_action_single_list->process->lookupOptions()) ?>;
fprocess_action_singlelistsrch.lists["x_employee_id[]"] = <?php echo $process_action_single_list->employee_id->Lookup->toClientList() ?>;
fprocess_action_singlelistsrch.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_action_single_list->employee_id->lookupOptions()) ?>;
fprocess_action_singlelistsrch.lists["x_payment[]"] = <?php echo $process_action_single_list->payment->Lookup->toClientList() ?>;
fprocess_action_singlelistsrch.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_single_list->payment->lookupOptions()) ?>;
fprocess_action_singlelistsrch.lists["x_buyer_id"] = <?php echo $process_action_single_list->buyer_id->Lookup->toClientList() ?>;
fprocess_action_singlelistsrch.lists["x_buyer_id"].options = <?php echo JsonEncode($process_action_single_list->buyer_id->lookupOptions()) ?>;
fprocess_action_singlelistsrch.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_singlelistsrch.lists["x_design_id"] = <?php echo $process_action_single_list->design_id->Lookup->toClientList() ?>;
fprocess_action_singlelistsrch.lists["x_design_id"].options = <?php echo JsonEncode($process_action_single_list->design_id->lookupOptions()) ?>;
fprocess_action_singlelistsrch.autoSuggests["x_design_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fprocess_action_singlelistsrch.filterList = <?php echo $process_action_single_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_singlelistsrch.initSearchPanel = true;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_single->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_single_list->TotalRecs > 0 && $process_action_single_list->ExportOptions->visible()) { ?>
<?php $process_action_single_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_single_list->ImportOptions->visible()) { ?>
<?php $process_action_single_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_single_list->SearchOptions->visible()) { ?>
<?php $process_action_single_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_single_list->FilterOptions->visible()) { ?>
<?php $process_action_single_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_single_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_single->isExport() && !$process_action_single->CurrentAction) { ?>
<form name="fprocess_action_singlelistsrch" id="fprocess_action_singlelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_single_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_singlelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_single">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_action_single_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_action_single->RowType = ROWTYPE_SEARCH;

// Render row
$process_action_single->resetAttributes();
$process_action_single_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_action_single->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $process_action_single->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_single" data-field="x_location" data-value-separator="<?php echo $process_action_single->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action_single->location->editAttributes() ?>>
		<?php echo $process_action_single->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action_single->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_single->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_action_single->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_single" data-field="x_process" data-value-separator="<?php echo $process_action_single->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_single->process->editAttributes() ?>>
		<?php echo $process_action_single->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_single->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($process_action_single->employee_id->Visible) { // employee_id ?>
	<div id="xsc_employee_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_single->employee_id->caption() ?></label>
		<span class="ew-search-operator"><select name="z_employee_id" id="z_employee_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($process_action_single->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->employee_id->AdvancedSearch->ViewValue) : $process_action_single->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->employee_id->ReadOnly || $process_action_single->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="process_action_single" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $process_action_single->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $process_action_single->employee_id->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_employee_id style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_employee_id style="d-none"">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_employee_id"><?php echo strval($process_action_single->employee_id->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->employee_id->AdvancedSearch->ViewValue2) : $process_action_single->employee_id->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->employee_id->ReadOnly || $process_action_single->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->employee_id->Lookup->getParamTag("p_y_employee_id") ?>
<input type="hidden" data-table="process_action_single" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->employee_id->displayValueSeparatorAttribute() ?>" name="y_employee_id[]" id="y_employee_id[]" value="<?php echo $process_action_single->employee_id->AdvancedSearch->SearchValue2 ?>"<?php echo $process_action_single->employee_id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($process_action_single->code->Visible) { // code ?>
	<div id="xsc_code" class="ew-cell form-group">
		<label for="x_code" class="ew-search-caption ew-label"><?php echo $process_action_single->code->caption() ?></label>
		<span class="ew-search-operator"><select name="z_code" id="z_code" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="process_action_single" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($process_action_single->code->getPlaceHolder()) ?>" value="<?php echo $process_action_single->code->EditValue ?>"<?php echo $process_action_single->code->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_code style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_code style="d-none"">
<input type="text" data-table="process_action_single" data-field="x_code" name="y_code" id="y_code" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($process_action_single->code->getPlaceHolder()) ?>" value="<?php echo $process_action_single->code->EditValue2 ?>"<?php echo $process_action_single->code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($process_action_single->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $process_action_single->datetime->caption() ?></label>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="process_action_single" data-field="x_datetime" data-format="11" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action_single->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_single->datetime->EditValue ?>"<?php echo $process_action_single->datetime->editAttributes() ?>>
<?php if (!$process_action_single->datetime->ReadOnly && !$process_action_single->datetime->Disabled && !isset($process_action_single->datetime->EditAttrs["readonly"]) && !isset($process_action_single->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_singlelistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_datetime style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_datetime style="d-none"">
<input type="text" data-table="process_action_single" data-field="x_datetime" data-format="11" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action_single->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_single->datetime->EditValue2 ?>"<?php echo $process_action_single->datetime->editAttributes() ?>>
<?php if (!$process_action_single->datetime->ReadOnly && !$process_action_single->datetime->Disabled && !isset($process_action_single->datetime->EditAttrs["readonly"]) && !isset($process_action_single->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_singlelistsrch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_single->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_single->payment->caption() ?></label>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_payment"><?php echo strval($process_action_single->payment->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->payment->AdvancedSearch->ViewValue) : $process_action_single->payment->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->payment->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->payment->ReadOnly || $process_action_single->payment->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_payment[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->payment->Lookup->getParamTag("p_x_payment") ?>
<input type="hidden" data-table="process_action_single" data-field="x_payment" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->payment->displayValueSeparatorAttribute() ?>" name="x_payment[]" id="x_payment[]" value="<?php echo $process_action_single->payment->AdvancedSearch->SearchValue ?>"<?php echo $process_action_single->payment->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_payment style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_payment style="d-none"">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_payment"><?php echo strval($process_action_single->payment->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->payment->AdvancedSearch->ViewValue2) : $process_action_single->payment->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->payment->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->payment->ReadOnly || $process_action_single->payment->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_payment[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->payment->Lookup->getParamTag("p_y_payment") ?>
<input type="hidden" data-table="process_action_single" data-field="x_payment" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->payment->displayValueSeparatorAttribute() ?>" name="y_payment[]" id="y_payment[]" value="<?php echo $process_action_single->payment->AdvancedSearch->SearchValue2 ?>"<?php echo $process_action_single->payment->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
<?php if ($process_action_single->buyer_id->Visible) { // buyer_id ?>
	<div id="xsc_buyer_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_single->buyer_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$process_action_single->buyer_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_single->buyer_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_id" class="text-nowrap" style="z-index: 8760">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?php echo RemoveHtml($process_action_single->buyer_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_single->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_single->buyer_id->getPlaceHolder()) ?>"<?php echo $process_action_single->buyer_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->buyer_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->buyer_id->ReadOnly || $process_action_single->buyer_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_single" data-field="x_buyer_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_single->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($process_action_single->buyer_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_singlelistsrch.createAutoSuggest({"id":"x_buyer_id","forceSelect":false});
</script>
<?php echo $process_action_single->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_single->design_id->Visible) { // design_id ?>
	<div id="xsc_design_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_single->design_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$process_action_single->design_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_single->design_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_design_id" class="text-nowrap" style="z-index: 8750">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_design_id" id="sv_x_design_id" value="<?php echo RemoveHtml($process_action_single->design_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_single->design_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_single->design_id->getPlaceHolder()) ?>"<?php echo $process_action_single->design_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->design_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_design_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->design_id->ReadOnly || $process_action_single->design_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_single" data-field="x_design_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_single->design_id->displayValueSeparatorAttribute() ?>" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($process_action_single->design_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_singlelistsrch.createAutoSuggest({"id":"x_design_id","forceSelect":false});
</script>
<?php echo $process_action_single->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_single_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_single_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_single_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_single_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_single_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_single_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_single_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_single_list->showPageHeader(); ?>
<?php
$process_action_single_list->showMessage();
?>
<?php if ($process_action_single_list->TotalRecs > 0 || $process_action_single->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_single_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_single">
<?php if (!$process_action_single->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_single->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_single_list->Pager)) $process_action_single_list->Pager = new PrevNextPager($process_action_single_list->StartRec, $process_action_single_list->DisplayRecs, $process_action_single_list->TotalRecs, $process_action_single_list->AutoHidePager) ?>
<?php if ($process_action_single_list->Pager->RecordCount > 0 && $process_action_single_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_single_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_single_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_single_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_single_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_single_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_single_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_single_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_single_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_single_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_single_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_single_list->TotalRecs > 0 && (!$process_action_single_list->AutoHidePageSizeSelector || $process_action_single_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_single">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_single_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_single_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_single_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_single_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_single_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_single->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_single_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_singlelist" id="fprocess_action_singlelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_single_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_single_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_single">
<div id="gmp_process_action_single" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_single_list->TotalRecs > 0 || $process_action_single->isGridEdit()) { ?>
<table id="tbl_process_action_singlelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_single_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_single_list->renderListOptions();

// Render list options (header, left)
$process_action_single_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_single->id->Visible) { // id ?>
	<?php if ($process_action_single->sortUrl($process_action_single->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_action_single->id->headerCellClass() ?>"><div id="elh_process_action_single_id" class="process_action_single_id"><div class="ew-table-header-caption"><?php echo $process_action_single->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_action_single->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->id) ?>',2);"><div id="elh_process_action_single_id" class="process_action_single_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->location->Visible) { // location ?>
	<?php if ($process_action_single->sortUrl($process_action_single->location) == "") { ?>
		<th data-name="location" class="<?php echo $process_action_single->location->headerCellClass() ?>"><div id="elh_process_action_single_location" class="process_action_single_location"><div class="ew-table-header-caption"><?php echo $process_action_single->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $process_action_single->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->location) ?>',2);"><div id="elh_process_action_single_location" class="process_action_single_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->process->Visible) { // process ?>
	<?php if ($process_action_single->sortUrl($process_action_single->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action_single->process->headerCellClass() ?>"><div id="elh_process_action_single_process" class="process_action_single_process"><div class="ew-table-header-caption"><?php echo $process_action_single->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action_single->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->process) ?>',2);"><div id="elh_process_action_single_process" class="process_action_single_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->employee_id->Visible) { // employee_id ?>
	<?php if ($process_action_single->sortUrl($process_action_single->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $process_action_single->employee_id->headerCellClass() ?>"><div id="elh_process_action_single_employee_id" class="process_action_single_employee_id"><div class="ew-table-header-caption"><?php echo $process_action_single->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $process_action_single->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->employee_id) ?>',2);"><div id="elh_process_action_single_employee_id" class="process_action_single_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->code->Visible) { // code ?>
	<?php if ($process_action_single->sortUrl($process_action_single->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_action_single->code->headerCellClass() ?>"><div id="elh_process_action_single_code" class="process_action_single_code"><div class="ew-table-header-caption"><?php echo $process_action_single->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_action_single->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->code) ?>',2);"><div id="elh_process_action_single_code" class="process_action_single_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->operator->Visible) { // operator ?>
	<?php if ($process_action_single->sortUrl($process_action_single->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_action_single->operator->headerCellClass() ?>"><div id="elh_process_action_single_operator" class="process_action_single_operator"><div class="ew-table-header-caption"><?php echo $process_action_single->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_action_single->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->operator) ?>',2);"><div id="elh_process_action_single_operator" class="process_action_single_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->datetime->Visible) { // datetime ?>
	<?php if ($process_action_single->sortUrl($process_action_single->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_action_single->datetime->headerCellClass() ?>"><div id="elh_process_action_single_datetime" class="process_action_single_datetime"><div class="ew-table-header-caption"><?php echo $process_action_single->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_action_single->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->datetime) ?>',2);"><div id="elh_process_action_single_datetime" class="process_action_single_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->roll_no->Visible) { // roll_no ?>
	<?php if ($process_action_single->sortUrl($process_action_single->roll_no) == "") { ?>
		<th data-name="roll_no" class="<?php echo $process_action_single->roll_no->headerCellClass() ?>"><div id="elh_process_action_single_roll_no" class="process_action_single_roll_no"><div class="ew-table-header-caption"><?php echo $process_action_single->roll_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no" class="<?php echo $process_action_single->roll_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->roll_no) ?>',2);"><div id="elh_process_action_single_roll_no" class="process_action_single_roll_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->roll_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->roll_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->roll_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->qty->Visible) { // qty ?>
	<?php if ($process_action_single->sortUrl($process_action_single->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $process_action_single->qty->headerCellClass() ?>"><div id="elh_process_action_single_qty" class="process_action_single_qty"><div class="ew-table-header-caption"><?php echo $process_action_single->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $process_action_single->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->qty) ?>',2);"><div id="elh_process_action_single_qty" class="process_action_single_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->size_actual->Visible) { // size_actual ?>
	<?php if ($process_action_single->sortUrl($process_action_single->size_actual) == "") { ?>
		<th data-name="size_actual" class="<?php echo $process_action_single->size_actual->headerCellClass() ?>"><div id="elh_process_action_single_size_actual" class="process_action_single_size_actual"><div class="ew-table-header-caption"><?php echo $process_action_single->size_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_actual" class="<?php echo $process_action_single->size_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->size_actual) ?>',2);"><div id="elh_process_action_single_size_actual" class="process_action_single_size_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->size_actual->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->size_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->size_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->weight_actual->Visible) { // weight_actual ?>
	<?php if ($process_action_single->sortUrl($process_action_single->weight_actual) == "") { ?>
		<th data-name="weight_actual" class="<?php echo $process_action_single->weight_actual->headerCellClass() ?>"><div id="elh_process_action_single_weight_actual" class="process_action_single_weight_actual"><div class="ew-table-header-caption"><?php echo $process_action_single->weight_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_actual" class="<?php echo $process_action_single->weight_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->weight_actual) ?>',2);"><div id="elh_process_action_single_weight_actual" class="process_action_single_weight_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->weight_actual->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->weight_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->weight_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->valuation->Visible) { // valuation ?>
	<?php if ($process_action_single->sortUrl($process_action_single->valuation) == "") { ?>
		<th data-name="valuation" class="<?php echo $process_action_single->valuation->headerCellClass() ?>"><div id="elh_process_action_single_valuation" class="process_action_single_valuation"><div class="ew-table-header-caption"><?php echo $process_action_single->valuation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="valuation" class="<?php echo $process_action_single->valuation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->valuation) ?>',2);"><div id="elh_process_action_single_valuation" class="process_action_single_valuation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->valuation->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->valuation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->valuation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->deduction->Visible) { // deduction ?>
	<?php if ($process_action_single->sortUrl($process_action_single->deduction) == "") { ?>
		<th data-name="deduction" class="<?php echo $process_action_single->deduction->headerCellClass() ?>"><div id="elh_process_action_single_deduction" class="process_action_single_deduction"><div class="ew-table-header-caption"><?php echo $process_action_single->deduction->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deduction" class="<?php echo $process_action_single->deduction->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->deduction) ?>',2);"><div id="elh_process_action_single_deduction" class="process_action_single_deduction">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->deduction->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->deduction->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->deduction->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->upload->Visible) { // upload ?>
	<?php if ($process_action_single->sortUrl($process_action_single->upload) == "") { ?>
		<th data-name="upload" class="<?php echo $process_action_single->upload->headerCellClass() ?>"><div id="elh_process_action_single_upload" class="process_action_single_upload"><div class="ew-table-header-caption"><?php echo $process_action_single->upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="upload" class="<?php echo $process_action_single->upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->upload) ?>',2);"><div id="elh_process_action_single_upload" class="process_action_single_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->payment->Visible) { // payment ?>
	<?php if ($process_action_single->sortUrl($process_action_single->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_single->payment->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_single_payment" class="process_action_single_payment"><div class="ew-table-header-caption"><?php echo $process_action_single->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_single->payment->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->payment) ?>',2);"><div id="elh_process_action_single_payment" class="process_action_single_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->remark->Visible) { // remark ?>
	<?php if ($process_action_single->sortUrl($process_action_single->remark) == "") { ?>
		<th data-name="remark" class="<?php echo $process_action_single->remark->headerCellClass() ?>"><div id="elh_process_action_single_remark" class="process_action_single_remark"><div class="ew-table-header-caption"><?php echo $process_action_single->remark->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remark" class="<?php echo $process_action_single->remark->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->remark) ?>',2);"><div id="elh_process_action_single_remark" class="process_action_single_remark">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->remark->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->remark->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->remark->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->tmp_id->Visible) { // tmp_id ?>
	<?php if ($process_action_single->sortUrl($process_action_single->tmp_id) == "") { ?>
		<th data-name="tmp_id" class="<?php echo $process_action_single->tmp_id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_single_tmp_id" class="process_action_single_tmp_id"><div class="ew-table-header-caption"><?php echo $process_action_single->tmp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_id" class="<?php echo $process_action_single->tmp_id->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->tmp_id) ?>',2);"><div id="elh_process_action_single_tmp_id" class="process_action_single_tmp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->tmp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->tmp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->tmp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->process_other->Visible) { // process_other ?>
	<?php if ($process_action_single->sortUrl($process_action_single->process_other) == "") { ?>
		<th data-name="process_other" class="<?php echo $process_action_single->process_other->headerCellClass() ?>"><div id="elh_process_action_single_process_other" class="process_action_single_process_other"><div class="ew-table-header-caption"><?php echo $process_action_single->process_other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_other" class="<?php echo $process_action_single->process_other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->process_other) ?>',2);"><div id="elh_process_action_single_process_other" class="process_action_single_process_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->process_other->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->process_other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->process_other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->buyer_id->Visible) { // buyer_id ?>
	<?php if ($process_action_single->sortUrl($process_action_single->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $process_action_single->buyer_id->headerCellClass() ?>"><div id="elh_process_action_single_buyer_id" class="process_action_single_buyer_id"><div class="ew-table-header-caption"><?php echo $process_action_single->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $process_action_single->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->buyer_id) ?>',2);"><div id="elh_process_action_single_buyer_id" class="process_action_single_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->design_id->Visible) { // design_id ?>
	<?php if ($process_action_single->sortUrl($process_action_single->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $process_action_single->design_id->headerCellClass() ?>"><div id="elh_process_action_single_design_id" class="process_action_single_design_id"><div class="ew-table-header-caption"><?php echo $process_action_single->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $process_action_single->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->design_id) ?>',2);"><div id="elh_process_action_single_design_id" class="process_action_single_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->size_cm->Visible) { // size_cm ?>
	<?php if ($process_action_single->sortUrl($process_action_single->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $process_action_single->size_cm->headerCellClass() ?>"><div id="elh_process_action_single_size_cm" class="process_action_single_size_cm"><div class="ew-table-header-caption"><?php echo $process_action_single->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $process_action_single->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->size_cm) ?>',2);"><div id="elh_process_action_single_size_cm" class="process_action_single_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->sqm->Visible) { // sqm ?>
	<?php if ($process_action_single->sortUrl($process_action_single->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $process_action_single->sqm->headerCellClass() ?>"><div id="elh_process_action_single_sqm" class="process_action_single_sqm"><div class="ew-table-header-caption"><?php echo $process_action_single->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $process_action_single->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->sqm) ?>',2);"><div id="elh_process_action_single_sqm" class="process_action_single_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->jc_no->Visible) { // jc_no ?>
	<?php if ($process_action_single->sortUrl($process_action_single->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $process_action_single->jc_no->headerCellClass() ?>"><div id="elh_process_action_single_jc_no" class="process_action_single_jc_no"><div class="ew-table-header-caption"><?php echo $process_action_single->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $process_action_single->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->jc_no) ?>',2);"><div id="elh_process_action_single_jc_no" class="process_action_single_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_single->loom_id->Visible) { // loom_id ?>
	<?php if ($process_action_single->sortUrl($process_action_single->loom_id) == "") { ?>
		<th data-name="loom_id" class="<?php echo $process_action_single->loom_id->headerCellClass() ?>"><div id="elh_process_action_single_loom_id" class="process_action_single_loom_id"><div class="ew-table-header-caption"><?php echo $process_action_single->loom_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="loom_id" class="<?php echo $process_action_single->loom_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_single->SortUrl($process_action_single->loom_id) ?>',2);"><div id="elh_process_action_single_loom_id" class="process_action_single_loom_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_single->loom_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_single->loom_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_single->loom_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_single_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_single->ExportAll && $process_action_single->isExport()) {
	$process_action_single_list->StopRec = $process_action_single_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_single_list->TotalRecs > $process_action_single_list->StartRec + $process_action_single_list->DisplayRecs - 1)
		$process_action_single_list->StopRec = $process_action_single_list->StartRec + $process_action_single_list->DisplayRecs - 1;
	else
		$process_action_single_list->StopRec = $process_action_single_list->TotalRecs;
}
$process_action_single_list->RecCnt = $process_action_single_list->StartRec - 1;
if ($process_action_single_list->Recordset && !$process_action_single_list->Recordset->EOF) {
	$process_action_single_list->Recordset->moveFirst();
	$selectLimit = $process_action_single_list->UseSelectLimit;
	if (!$selectLimit && $process_action_single_list->StartRec > 1)
		$process_action_single_list->Recordset->move($process_action_single_list->StartRec - 1);
} elseif (!$process_action_single->AllowAddDeleteRow && $process_action_single_list->StopRec == 0) {
	$process_action_single_list->StopRec = $process_action_single->GridAddRowCount;
}

// Initialize aggregate
$process_action_single->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_single->resetAttributes();
$process_action_single_list->renderRow();
while ($process_action_single_list->RecCnt < $process_action_single_list->StopRec) {
	$process_action_single_list->RecCnt++;
	if ($process_action_single_list->RecCnt >= $process_action_single_list->StartRec) {
		$process_action_single_list->RowCnt++;

		// Set up key count
		$process_action_single_list->KeyCount = $process_action_single_list->RowIndex;

		// Init row class and style
		$process_action_single->resetAttributes();
		$process_action_single->CssClass = "";
		if ($process_action_single->isGridAdd()) {
		} else {
			$process_action_single_list->loadRowValues($process_action_single_list->Recordset); // Load row values
		}
		$process_action_single->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_single->RowAttrs = array_merge($process_action_single->RowAttrs, array('data-rowindex'=>$process_action_single_list->RowCnt, 'id'=>'r' . $process_action_single_list->RowCnt . '_process_action_single', 'data-rowtype'=>$process_action_single->RowType));

		// Render row
		$process_action_single_list->renderRow();

		// Render list options
		$process_action_single_list->renderListOptions();
?>
	<tr<?php echo $process_action_single->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_single_list->ListOptions->render("body", "left", $process_action_single_list->RowCnt);
?>
	<?php if ($process_action_single->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_action_single->id->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_id" class="process_action_single_id">
<span<?php echo $process_action_single->id->viewAttributes() ?>>
<?php echo $process_action_single->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->location->Visible) { // location ?>
		<td data-name="location"<?php echo $process_action_single->location->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_location" class="process_action_single_location">
<span<?php echo $process_action_single->location->viewAttributes() ?>>
<?php echo $process_action_single->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action_single->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_process" class="process_action_single_process">
<span<?php echo $process_action_single->process->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_single->process->getViewValue())) && $process_action_single->process->linkAttributes() <> "") { ?>
<a<?php echo $process_action_single->process->linkAttributes() ?>><?php echo $process_action_single->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_single->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $process_action_single->employee_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_employee_id" class="process_action_single_employee_id">
<span<?php echo $process_action_single->employee_id->viewAttributes() ?>>
<?php echo $process_action_single->employee_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_action_single->code->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_code" class="process_action_single_code">
<span<?php echo $process_action_single->code->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_single->code->getViewValue())) && $process_action_single->code->linkAttributes() <> "") { ?>
<a<?php echo $process_action_single->code->linkAttributes() ?>><?php echo $process_action_single->code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_single->code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_action_single->operator->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_operator" class="process_action_single_operator">
<span<?php echo $process_action_single->operator->viewAttributes() ?>>
<?php echo $process_action_single->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_action_single->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_datetime" class="process_action_single_datetime">
<span<?php echo $process_action_single->datetime->viewAttributes() ?>>
<?php echo $process_action_single->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no"<?php echo $process_action_single->roll_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_roll_no" class="process_action_single_roll_no">
<span<?php echo $process_action_single->roll_no->viewAttributes() ?>>
<?php echo $process_action_single->roll_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $process_action_single->qty->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_qty" class="process_action_single_qty">
<span<?php echo $process_action_single->qty->viewAttributes() ?>>
<?php echo $process_action_single->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->size_actual->Visible) { // size_actual ?>
		<td data-name="size_actual"<?php echo $process_action_single->size_actual->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_size_actual" class="process_action_single_size_actual">
<span<?php echo $process_action_single->size_actual->viewAttributes() ?>>
<?php echo $process_action_single->size_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->weight_actual->Visible) { // weight_actual ?>
		<td data-name="weight_actual"<?php echo $process_action_single->weight_actual->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_weight_actual" class="process_action_single_weight_actual">
<span<?php echo $process_action_single->weight_actual->viewAttributes() ?>>
<?php echo $process_action_single->weight_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->valuation->Visible) { // valuation ?>
		<td data-name="valuation"<?php echo $process_action_single->valuation->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_valuation" class="process_action_single_valuation">
<span<?php echo $process_action_single->valuation->viewAttributes() ?>>
<?php echo $process_action_single->valuation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->deduction->Visible) { // deduction ?>
		<td data-name="deduction"<?php echo $process_action_single->deduction->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_deduction" class="process_action_single_deduction">
<span<?php echo $process_action_single->deduction->viewAttributes() ?>>
<?php echo $process_action_single->deduction->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->upload->Visible) { // upload ?>
		<td data-name="upload"<?php echo $process_action_single->upload->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_upload" class="process_action_single_upload">
<span>
<?php echo GetFileViewTag($process_action_single->upload, $process_action_single->upload->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_single->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_payment" class="process_action_single_payment">
<span<?php echo $process_action_single->payment->viewAttributes() ?>>
<?php echo $process_action_single->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->remark->Visible) { // remark ?>
		<td data-name="remark"<?php echo $process_action_single->remark->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_remark" class="process_action_single_remark">
<span<?php echo $process_action_single->remark->viewAttributes() ?>>
<?php echo $process_action_single->remark->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->tmp_id->Visible) { // tmp_id ?>
		<td data-name="tmp_id"<?php echo $process_action_single->tmp_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_tmp_id" class="process_action_single_tmp_id">
<span<?php echo $process_action_single->tmp_id->viewAttributes() ?>>
<?php echo $process_action_single->tmp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->process_other->Visible) { // process_other ?>
		<td data-name="process_other"<?php echo $process_action_single->process_other->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_process_other" class="process_action_single_process_other">
<span<?php echo $process_action_single->process_other->viewAttributes() ?>>
<?php echo $process_action_single->process_other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $process_action_single->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_buyer_id" class="process_action_single_buyer_id">
<span<?php echo $process_action_single->buyer_id->viewAttributes() ?>>
<?php echo $process_action_single->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $process_action_single->design_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_design_id" class="process_action_single_design_id">
<span<?php echo $process_action_single->design_id->viewAttributes() ?>>
<?php echo $process_action_single->design_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $process_action_single->size_cm->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_size_cm" class="process_action_single_size_cm">
<span<?php echo $process_action_single->size_cm->viewAttributes() ?>>
<?php echo $process_action_single->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $process_action_single->sqm->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_sqm" class="process_action_single_sqm">
<span<?php echo $process_action_single->sqm->viewAttributes() ?>>
<?php echo $process_action_single->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $process_action_single->jc_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_jc_no" class="process_action_single_jc_no">
<span<?php echo $process_action_single->jc_no->viewAttributes() ?>>
<?php echo $process_action_single->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_single->loom_id->Visible) { // loom_id ?>
		<td data-name="loom_id"<?php echo $process_action_single->loom_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_single_list->RowCnt ?>_process_action_single_loom_id" class="process_action_single_loom_id">
<span<?php echo $process_action_single->loom_id->viewAttributes() ?>>
<?php echo $process_action_single->loom_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_single_list->ListOptions->render("body", "right", $process_action_single_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_single->isGridAdd())
		$process_action_single_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_single->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_single_list->Recordset)
	$process_action_single_list->Recordset->Close();
?>
<?php if (!$process_action_single->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_single->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_single_list->Pager)) $process_action_single_list->Pager = new PrevNextPager($process_action_single_list->StartRec, $process_action_single_list->DisplayRecs, $process_action_single_list->TotalRecs, $process_action_single_list->AutoHidePager) ?>
<?php if ($process_action_single_list->Pager->RecordCount > 0 && $process_action_single_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_single_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_single_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_single_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_single_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_single_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_single_list->pageUrl() ?>start=<?php echo $process_action_single_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_single_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_single_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_single_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_single_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_single_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_single_list->TotalRecs > 0 && (!$process_action_single_list->AutoHidePageSizeSelector || $process_action_single_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_single">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_single_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_single_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_single_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_single_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_single_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_single->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_single_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_single_list->TotalRecs == 0 && !$process_action_single->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_single_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_single_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_single->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_single->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_single", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_single_list->terminate();
?>