<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_single_search = new process_action_single_search();

// Run the page
$process_action_single_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_single_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_action_single_search->IsModal) { ?>
var fprocess_action_singlesearch = currentAdvancedSearchForm = new ew.Form("fprocess_action_singlesearch", "search");
<?php } else { ?>
var fprocess_action_singlesearch = currentForm = new ew.Form("fprocess_action_singlesearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_action_singlesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_singlesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_singlesearch.lists["x_location"] = <?php echo $process_action_single_search->location->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_location"].options = <?php echo JsonEncode($process_action_single_search->location->lookupOptions()) ?>;
fprocess_action_singlesearch.lists["x_process"] = <?php echo $process_action_single_search->process->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_process"].options = <?php echo JsonEncode($process_action_single_search->process->lookupOptions()) ?>;
fprocess_action_singlesearch.lists["x_employee_id[]"] = <?php echo $process_action_single_search->employee_id->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_action_single_search->employee_id->lookupOptions()) ?>;
fprocess_action_singlesearch.lists["x_operator"] = <?php echo $process_action_single_search->operator->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_operator"].options = <?php echo JsonEncode($process_action_single_search->operator->lookupOptions()) ?>;
fprocess_action_singlesearch.lists["x_valuation"] = <?php echo $process_action_single_search->valuation->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_valuation"].options = <?php echo JsonEncode($process_action_single_search->valuation->options(FALSE, TRUE)) ?>;
fprocess_action_singlesearch.lists["x_payment[]"] = <?php echo $process_action_single_search->payment->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_single_search->payment->lookupOptions()) ?>;
fprocess_action_singlesearch.lists["x_process_other[]"] = <?php echo $process_action_single_search->process_other->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_process_other[]"].options = <?php echo JsonEncode($process_action_single_search->process_other->lookupOptions()) ?>;
fprocess_action_singlesearch.lists["x_buyer_id"] = <?php echo $process_action_single_search->buyer_id->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_buyer_id"].options = <?php echo JsonEncode($process_action_single_search->buyer_id->lookupOptions()) ?>;
fprocess_action_singlesearch.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_singlesearch.lists["x_design_id"] = <?php echo $process_action_single_search->design_id->Lookup->toClientList() ?>;
fprocess_action_singlesearch.lists["x_design_id"].options = <?php echo JsonEncode($process_action_single_search->design_id->lookupOptions()) ?>;
fprocess_action_singlesearch.autoSuggests["x_design_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fprocess_action_singlesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_actual");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->weight_actual->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->deduction->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->tmp_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_single->jc_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_action_single_search->showPageHeader(); ?>
<?php
$process_action_single_search->showMessage();
?>
<form name="fprocess_action_singlesearch" id="fprocess_action_singlesearch" class="<?php echo $process_action_single_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_single_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_single_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_single">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_action_single_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_action_single->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_id"><?php echo $process_action_single->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->id->cellAttributes() ?>>
			<span id="el_process_action_single_id">
<input type="text" data-table="process_action_single" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_action_single->id->getPlaceHolder()) ?>" value="<?php echo $process_action_single->id->EditValue ?>"<?php echo $process_action_single->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_location"><?php echo $process_action_single->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->location->cellAttributes() ?>>
			<span id="el_process_action_single_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_single" data-field="x_location" data-value-separator="<?php echo $process_action_single->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action_single->location->editAttributes() ?>>
		<?php echo $process_action_single->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action_single->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_process"><?php echo $process_action_single->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->process->cellAttributes() ?>>
			<span id="el_process_action_single_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_single" data-field="x_process" data-value-separator="<?php echo $process_action_single->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_single->process->editAttributes() ?>>
		<?php echo $process_action_single->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_single->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_employee_id"><?php echo $process_action_single->employee_id->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->employee_id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_employee_id" id="z_employee_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_single->employee_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_single_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($process_action_single->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->employee_id->AdvancedSearch->ViewValue) : $process_action_single->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->employee_id->ReadOnly || $process_action_single->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="process_action_single" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $process_action_single->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $process_action_single->employee_id->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_employee_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_single_employee_id" class="btw1_employee_id d-none">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_employee_id"><?php echo strval($process_action_single->employee_id->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->employee_id->AdvancedSearch->ViewValue2) : $process_action_single->employee_id->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->employee_id->ReadOnly || $process_action_single->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->employee_id->Lookup->getParamTag("p_y_employee_id") ?>
<input type="hidden" data-table="process_action_single" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->employee_id->displayValueSeparatorAttribute() ?>" name="y_employee_id[]" id="y_employee_id[]" value="<?php echo $process_action_single->employee_id->AdvancedSearch->SearchValue2 ?>"<?php echo $process_action_single->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_code"><?php echo $process_action_single->code->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->code->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_code" id="z_code" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_single->code->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_single_code">
<input type="text" data-table="process_action_single" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($process_action_single->code->getPlaceHolder()) ?>" value="<?php echo $process_action_single->code->EditValue ?>"<?php echo $process_action_single->code->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_code d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_single_code" class="btw1_code d-none">
<input type="text" data-table="process_action_single" data-field="x_code" name="y_code" id="y_code" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($process_action_single->code->getPlaceHolder()) ?>" value="<?php echo $process_action_single->code->EditValue2 ?>"<?php echo $process_action_single->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_operator"><?php echo $process_action_single->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->operator->cellAttributes() ?>>
			<span id="el_process_action_single_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_single" data-field="x_operator" data-value-separator="<?php echo $process_action_single->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process_action_single->operator->editAttributes() ?>>
		<?php echo $process_action_single->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process_action_single->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_datetime"><?php echo $process_action_single->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_single->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_single_datetime">
<input type="text" data-table="process_action_single" data-field="x_datetime" data-format="11" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action_single->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_single->datetime->EditValue ?>"<?php echo $process_action_single->datetime->editAttributes() ?>>
<?php if (!$process_action_single->datetime->ReadOnly && !$process_action_single->datetime->Disabled && !isset($process_action_single->datetime->EditAttrs["readonly"]) && !isset($process_action_single->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_singlesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_single_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_action_single" data-field="x_datetime" data-format="11" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action_single->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_single->datetime->EditValue2 ?>"<?php echo $process_action_single->datetime->editAttributes() ?>>
<?php if (!$process_action_single->datetime->ReadOnly && !$process_action_single->datetime->Disabled && !isset($process_action_single->datetime->EditAttrs["readonly"]) && !isset($process_action_single->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_singlesearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->roll_no->Visible) { // roll_no ?>
	<div id="r_roll_no" class="form-group row">
		<label for="x_roll_no" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_roll_no"><?php echo $process_action_single->roll_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no" id="z_roll_no" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->roll_no->cellAttributes() ?>>
			<span id="el_process_action_single_roll_no">
<input type="text" data-table="process_action_single" data-field="x_roll_no" name="x_roll_no" id="x_roll_no" size="30" placeholder="<?php echo HtmlEncode($process_action_single->roll_no->getPlaceHolder()) ?>" value="<?php echo $process_action_single->roll_no->EditValue ?>"<?php echo $process_action_single->roll_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_qty"><?php echo $process_action_single->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->qty->cellAttributes() ?>>
			<span id="el_process_action_single_qty">
<input type="text" data-table="process_action_single" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($process_action_single->qty->getPlaceHolder()) ?>" value="<?php echo $process_action_single->qty->EditValue ?>"<?php echo $process_action_single->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->size_actual->Visible) { // size_actual ?>
	<div id="r_size_actual" class="form-group row">
		<label for="x_size_actual" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_size_actual"><?php echo $process_action_single->size_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->size_actual->cellAttributes() ?>>
			<span id="el_process_action_single_size_actual">
<input type="text" data-table="process_action_single" data-field="x_size_actual" name="x_size_actual" id="x_size_actual" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_action_single->size_actual->getPlaceHolder()) ?>" value="<?php echo $process_action_single->size_actual->EditValue ?>"<?php echo $process_action_single->size_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->weight_actual->Visible) { // weight_actual ?>
	<div id="r_weight_actual" class="form-group row">
		<label for="x_weight_actual" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_weight_actual"><?php echo $process_action_single->weight_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_actual" id="z_weight_actual" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->weight_actual->cellAttributes() ?>>
			<span id="el_process_action_single_weight_actual">
<input type="text" data-table="process_action_single" data-field="x_weight_actual" name="x_weight_actual" id="x_weight_actual" size="30" placeholder="<?php echo HtmlEncode($process_action_single->weight_actual->getPlaceHolder()) ?>" value="<?php echo $process_action_single->weight_actual->EditValue ?>"<?php echo $process_action_single->weight_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->valuation->Visible) { // valuation ?>
	<div id="r_valuation" class="form-group row">
		<label for="x_valuation" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_valuation"><?php echo $process_action_single->valuation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_valuation" id="z_valuation" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->valuation->cellAttributes() ?>>
			<span id="el_process_action_single_valuation">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_single" data-field="x_valuation" data-value-separator="<?php echo $process_action_single->valuation->displayValueSeparatorAttribute() ?>" id="x_valuation" name="x_valuation"<?php echo $process_action_single->valuation->editAttributes() ?>>
		<?php echo $process_action_single->valuation->selectOptionListHtml("x_valuation") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label for="x_deduction" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_deduction"><?php echo $process_action_single->deduction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_deduction" id="z_deduction" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->deduction->cellAttributes() ?>>
			<span id="el_process_action_single_deduction">
<input type="text" data-table="process_action_single" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($process_action_single->deduction->getPlaceHolder()) ?>" value="<?php echo $process_action_single->deduction->EditValue ?>"<?php echo $process_action_single->deduction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_upload"><?php echo $process_action_single->upload->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_upload" id="z_upload" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->upload->cellAttributes() ?>>
			<span id="el_process_action_single_upload">
<input type="text" data-table="process_action_single" data-field="x_upload" name="x_upload" id="x_upload" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($process_action_single->upload->getPlaceHolder()) ?>" value="<?php echo $process_action_single->upload->EditValue ?>"<?php echo $process_action_single->upload->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_payment"><?php echo $process_action_single->payment->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->payment->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_single->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_single_payment">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_payment"><?php echo strval($process_action_single->payment->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->payment->AdvancedSearch->ViewValue) : $process_action_single->payment->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->payment->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->payment->ReadOnly || $process_action_single->payment->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_payment[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->payment->Lookup->getParamTag("p_x_payment") ?>
<input type="hidden" data-table="process_action_single" data-field="x_payment" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->payment->displayValueSeparatorAttribute() ?>" name="x_payment[]" id="x_payment[]" value="<?php echo $process_action_single->payment->AdvancedSearch->SearchValue ?>"<?php echo $process_action_single->payment->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_payment d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_single_payment" class="btw1_payment d-none">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_payment"><?php echo strval($process_action_single->payment->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_single->payment->AdvancedSearch->ViewValue2) : $process_action_single->payment->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->payment->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->payment->ReadOnly || $process_action_single->payment->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_payment[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_single->payment->Lookup->getParamTag("p_y_payment") ?>
<input type="hidden" data-table="process_action_single" data-field="x_payment" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action_single->payment->displayValueSeparatorAttribute() ?>" name="y_payment[]" id="y_payment[]" value="<?php echo $process_action_single->payment->AdvancedSearch->SearchValue2 ?>"<?php echo $process_action_single->payment->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label for="x_remark" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_remark"><?php echo $process_action_single->remark->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remark" id="z_remark" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->remark->cellAttributes() ?>>
			<span id="el_process_action_single_remark">
<input type="text" data-table="process_action_single" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="225" placeholder="<?php echo HtmlEncode($process_action_single->remark->getPlaceHolder()) ?>" value="<?php echo $process_action_single->remark->EditValue ?>"<?php echo $process_action_single->remark->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->tmp_id->Visible) { // tmp_id ?>
	<div id="r_tmp_id" class="form-group row">
		<label for="x_tmp_id" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_tmp_id"><?php echo $process_action_single->tmp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_id" id="z_tmp_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->tmp_id->cellAttributes() ?>>
			<span id="el_process_action_single_tmp_id">
<input type="text" data-table="process_action_single" data-field="x_tmp_id" name="x_tmp_id" id="x_tmp_id" size="30" placeholder="<?php echo HtmlEncode($process_action_single->tmp_id->getPlaceHolder()) ?>" value="<?php echo $process_action_single->tmp_id->EditValue ?>"<?php echo $process_action_single->tmp_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->process_other->Visible) { // process_other ?>
	<div id="r_process_other" class="form-group row">
		<label class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_process_other"><?php echo $process_action_single->process_other->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_other" id="z_process_other" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->process_other->cellAttributes() ?>>
			<span id="el_process_action_single_process_other">
<div id="tp_x_process_other" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_single" data-field="x_process_other" data-value-separator="<?php echo $process_action_single->process_other->displayValueSeparatorAttribute() ?>" name="x_process_other[]" id="x_process_other[]" value="{value}"<?php echo $process_action_single->process_other->editAttributes() ?>></div>
<div id="dsl_x_process_other" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $process_action_single->process_other->checkBoxListHtml(FALSE, "x_process_other[]") ?>
</div></div>
<?php echo $process_action_single->process_other->Lookup->getParamTag("p_x_process_other") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_buyer_id"><?php echo $process_action_single->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->buyer_id->cellAttributes() ?>>
			<span id="el_process_action_single_buyer_id">
<?php
$wrkonchange = "" . trim(@$process_action_single->buyer_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_single->buyer_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_id" class="text-nowrap" style="z-index: 8760">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?php echo RemoveHtml($process_action_single->buyer_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_single->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_single->buyer_id->getPlaceHolder()) ?>"<?php echo $process_action_single->buyer_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->buyer_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->buyer_id->ReadOnly || $process_action_single->buyer_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_single" data-field="x_buyer_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_single->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($process_action_single->buyer_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_singlesearch.createAutoSuggest({"id":"x_buyer_id","forceSelect":false});
</script>
<?php echo $process_action_single->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_design_id"><?php echo $process_action_single->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->design_id->cellAttributes() ?>>
			<span id="el_process_action_single_design_id">
<?php
$wrkonchange = "" . trim(@$process_action_single->design_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_single->design_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_design_id" class="text-nowrap" style="z-index: 8750">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_design_id" id="sv_x_design_id" value="<?php echo RemoveHtml($process_action_single->design_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_single->design_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_single->design_id->getPlaceHolder()) ?>"<?php echo $process_action_single->design_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_single->design_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_design_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_single->design_id->ReadOnly || $process_action_single->design_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_single" data-field="x_design_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_single->design_id->displayValueSeparatorAttribute() ?>" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($process_action_single->design_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_singlesearch.createAutoSuggest({"id":"x_design_id","forceSelect":false});
</script>
<?php echo $process_action_single->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_size_cm"><?php echo $process_action_single->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->size_cm->cellAttributes() ?>>
			<span id="el_process_action_single_size_cm">
<input type="text" data-table="process_action_single" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($process_action_single->size_cm->getPlaceHolder()) ?>" value="<?php echo $process_action_single->size_cm->EditValue ?>"<?php echo $process_action_single->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_sqm"><?php echo $process_action_single->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->sqm->cellAttributes() ?>>
			<span id="el_process_action_single_sqm">
<input type="text" data-table="process_action_single" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($process_action_single->sqm->getPlaceHolder()) ?>" value="<?php echo $process_action_single->sqm->EditValue ?>"<?php echo $process_action_single->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_jc_no"><?php echo $process_action_single->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->jc_no->cellAttributes() ?>>
			<span id="el_process_action_single_jc_no">
<input type="text" data-table="process_action_single" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($process_action_single->jc_no->getPlaceHolder()) ?>" value="<?php echo $process_action_single->jc_no->EditValue ?>"<?php echo $process_action_single->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_single->loom_id->Visible) { // loom_id ?>
	<div id="r_loom_id" class="form-group row">
		<label for="x_loom_id" class="<?php echo $process_action_single_search->LeftColumnClass ?>"><span id="elh_process_action_single_loom_id"><?php echo $process_action_single->loom_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_loom_id" id="z_loom_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_single_search->RightColumnClass ?>"><div<?php echo $process_action_single->loom_id->cellAttributes() ?>>
			<span id="el_process_action_single_loom_id">
<input type="text" data-table="process_action_single" data-field="x_loom_id" name="x_loom_id" id="x_loom_id" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_action_single->loom_id->getPlaceHolder()) ?>" value="<?php echo $process_action_single->loom_id->EditValue ?>"<?php echo $process_action_single->loom_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_action_single_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_action_single_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_action_single_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_action_single_search->terminate();
?>