<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_add = new process_action_add();

// Run the page
$process_action_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fprocess_actionadd = currentForm = new ew.Form("fprocess_actionadd", "add");

// Validate form
fprocess_actionadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_action_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->process->caption(), $process_action->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->confirm_process->Required) { ?>
			elm = this.getElements("x" + infix + "_confirm_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->confirm_process->caption(), $process_action->confirm_process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->process_other->Required) { ?>
			elm = this.getElements("x" + infix + "_process_other[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->process_other->caption(), $process_action->process_other->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->location->caption(), $process_action->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->godown->caption(), $process_action->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->code->caption(), $process_action->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->code_last->Required) { ?>
			elm = this.getElements("x" + infix + "_code_last");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->code_last->caption(), $process_action->code_last->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->employee_1->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->employee_1->caption(), $process_action->employee_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->employee_2->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->employee_2->caption(), $process_action->employee_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->employee_3->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->employee_3->caption(), $process_action->employee_3->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->employee_id->caption(), $process_action->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->qty->Required) { ?>
			elm = this.getElements("x" + infix + "_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->qty->caption(), $process_action->qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->roll_no->Required) { ?>
			elm = this.getElements("x" + infix + "_roll_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->roll_no->caption(), $process_action->roll_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->operator->caption(), $process_action->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->datetime->caption(), $process_action->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->size_actual->Required) { ?>
			elm = this.getElements("x" + infix + "_size_actual");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->size_actual->caption(), $process_action->size_actual->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->weight_actual->Required) { ?>
			elm = this.getElements("x" + infix + "_weight_actual");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->weight_actual->caption(), $process_action->weight_actual->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weight_actual");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action->weight_actual->errorMessage()) ?>");
		<?php if ($process_action_add->lines_in_30cm->Required) { ?>
			elm = this.getElements("x" + infix + "_lines_in_30cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->lines_in_30cm->caption(), $process_action->lines_in_30cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_lines_in_30cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action->lines_in_30cm->errorMessage()) ?>");
		<?php if ($process_action_add->valuation->Required) { ?>
			elm = this.getElements("x" + infix + "_valuation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->valuation->caption(), $process_action->valuation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->deduction->Required) { ?>
			elm = this.getElements("x" + infix + "_deduction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->deduction->caption(), $process_action->deduction->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_deduction");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action->deduction->errorMessage()) ?>");
		<?php if ($process_action_add->remark->Required) { ?>
			elm = this.getElements("x" + infix + "_remark");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action->remark->caption(), $process_action->remark->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_add->upload->Required) { ?>
			felm = this.getElements("x" + infix + "_upload");
			elm = this.getElements("fn_x" + infix + "_upload");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $process_action->upload->caption(), $process_action->upload->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_actionadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_actionadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_actionadd.lists["x_process"] = <?php echo $process_action_add->process->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_process"].options = <?php echo JsonEncode($process_action_add->process->lookupOptions()) ?>;
fprocess_actionadd.lists["x_confirm_process"] = <?php echo $process_action_add->confirm_process->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_confirm_process"].options = <?php echo JsonEncode($process_action_add->confirm_process->lookupOptions()) ?>;
fprocess_actionadd.lists["x_process_other[]"] = <?php echo $process_action_add->process_other->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_process_other[]"].options = <?php echo JsonEncode($process_action_add->process_other->lookupOptions()) ?>;
fprocess_actionadd.lists["x_location"] = <?php echo $process_action_add->location->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_location"].options = <?php echo JsonEncode($process_action_add->location->lookupOptions()) ?>;
fprocess_actionadd.lists["x_godown"] = <?php echo $process_action_add->godown->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_godown"].options = <?php echo JsonEncode($process_action_add->godown->lookupOptions()) ?>;
fprocess_actionadd.lists["x_employee_1"] = <?php echo $process_action_add->employee_1->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_employee_1"].options = <?php echo JsonEncode($process_action_add->employee_1->lookupOptions()) ?>;
fprocess_actionadd.lists["x_employee_2"] = <?php echo $process_action_add->employee_2->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_employee_2"].options = <?php echo JsonEncode($process_action_add->employee_2->lookupOptions()) ?>;
fprocess_actionadd.lists["x_employee_3"] = <?php echo $process_action_add->employee_3->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_employee_3"].options = <?php echo JsonEncode($process_action_add->employee_3->lookupOptions()) ?>;
fprocess_actionadd.lists["x_employee_id[]"] = <?php echo $process_action_add->employee_id->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_action_add->employee_id->lookupOptions()) ?>;
fprocess_actionadd.lists["x_operator"] = <?php echo $process_action_add->operator->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_operator"].options = <?php echo JsonEncode($process_action_add->operator->lookupOptions()) ?>;
fprocess_actionadd.lists["x_valuation"] = <?php echo $process_action_add->valuation->Lookup->toClientList() ?>;
fprocess_actionadd.lists["x_valuation"].options = <?php echo JsonEncode($process_action_add->valuation->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_action_add->showPageHeader(); ?>
<?php
$process_action_add->showMessage();
?>
<form name="fprocess_actionadd" id="fprocess_actionadd" class="<?php echo $process_action_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$process_action_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($process_action->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_process_action_process" for="x_process" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->process->caption() ?><?php echo ($process_action->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->process->cellAttributes() ?>>
<span id="el_process_action_process">
<?php $process_action->process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action->process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_process" data-value-separator="<?php echo $process_action->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action->process->editAttributes() ?>>
		<?php echo $process_action->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $process_action->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->confirm_process->Visible) { // confirm_process ?>
	<div id="r_confirm_process" class="form-group row">
		<label id="elh_process_action_confirm_process" for="x_confirm_process" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->confirm_process->caption() ?><?php echo ($process_action->confirm_process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->confirm_process->cellAttributes() ?>>
<span id="el_process_action_confirm_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_confirm_process" data-value-separator="<?php echo $process_action->confirm_process->displayValueSeparatorAttribute() ?>" id="x_confirm_process" name="x_confirm_process"<?php echo $process_action->confirm_process->editAttributes() ?>>
		<?php echo $process_action->confirm_process->selectOptionListHtml("x_confirm_process") ?>
	</select>
</div>
<?php echo $process_action->confirm_process->Lookup->getParamTag("p_x_confirm_process") ?>
</span>
<?php echo $process_action->confirm_process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->process_other->Visible) { // process_other ?>
	<div id="r_process_other" class="form-group row">
		<label id="elh_process_action_process_other" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->process_other->caption() ?><?php echo ($process_action->process_other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->process_other->cellAttributes() ?>>
<span id="el_process_action_process_other">
<div id="tp_x_process_other" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action" data-field="x_process_other" data-value-separator="<?php echo $process_action->process_other->displayValueSeparatorAttribute() ?>" name="x_process_other[]" id="x_process_other[]" value="{value}"<?php echo $process_action->process_other->editAttributes() ?>></div>
<div id="dsl_x_process_other" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $process_action->process_other->checkBoxListHtml(FALSE, "x_process_other[]") ?>
</div></div>
<?php echo $process_action->process_other->Lookup->getParamTag("p_x_process_other") ?>
</span>
<?php echo $process_action->process_other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_process_action_location" for="x_location" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->location->caption() ?><?php echo ($process_action->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->location->cellAttributes() ?>>
<span id="el_process_action_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_location" data-value-separator="<?php echo $process_action->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action->location->editAttributes() ?>>
		<?php echo $process_action->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $process_action->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_process_action_godown" for="x_godown" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->godown->caption() ?><?php echo ($process_action->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->godown->cellAttributes() ?>>
<span id="el_process_action_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_godown" data-value-separator="<?php echo $process_action->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_action->godown->editAttributes() ?>>
		<?php echo $process_action->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $process_action->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $process_action->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_process_action_code" for="x_code" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->code->caption() ?><?php echo ($process_action->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->code->cellAttributes() ?>>
<span id="el_process_action_code">
<input type="text" data-table="process_action" data-field="x_code" name="x_code" id="x_code" size="100" maxlength="500" placeholder="<?php echo HtmlEncode($process_action->code->getPlaceHolder()) ?>" value="<?php echo $process_action->code->EditValue ?>"<?php echo $process_action->code->editAttributes() ?>>
</span>
<?php echo $process_action->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->code_last->Visible) { // code_last ?>
	<div id="r_code_last" class="form-group row">
		<label id="elh_process_action_code_last" for="x_code_last" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->code_last->caption() ?><?php echo ($process_action->code_last->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->code_last->cellAttributes() ?>>
<span id="el_process_action_code_last">
<input type="text" data-table="process_action" data-field="x_code_last" name="x_code_last" id="x_code_last" size="100" maxlength="500" placeholder="<?php echo HtmlEncode($process_action->code_last->getPlaceHolder()) ?>" value="<?php echo $process_action->code_last->EditValue ?>"<?php echo $process_action->code_last->editAttributes() ?>>
</span>
<?php echo $process_action->code_last->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->employee_1->Visible) { // employee_1 ?>
	<div id="r_employee_1" class="form-group row">
		<label id="elh_process_action_employee_1" for="x_employee_1" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->employee_1->caption() ?><?php echo ($process_action->employee_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->employee_1->cellAttributes() ?>>
<span id="el_process_action_employee_1">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_employee_1" data-value-separator="<?php echo $process_action->employee_1->displayValueSeparatorAttribute() ?>" id="x_employee_1" name="x_employee_1"<?php echo $process_action->employee_1->editAttributes() ?>>
		<?php echo $process_action->employee_1->selectOptionListHtml("x_employee_1") ?>
	</select>
</div>
<?php echo $process_action->employee_1->Lookup->getParamTag("p_x_employee_1") ?>
</span>
<?php echo $process_action->employee_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->employee_2->Visible) { // employee_2 ?>
	<div id="r_employee_2" class="form-group row">
		<label id="elh_process_action_employee_2" for="x_employee_2" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->employee_2->caption() ?><?php echo ($process_action->employee_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->employee_2->cellAttributes() ?>>
<span id="el_process_action_employee_2">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_employee_2" data-value-separator="<?php echo $process_action->employee_2->displayValueSeparatorAttribute() ?>" id="x_employee_2" name="x_employee_2"<?php echo $process_action->employee_2->editAttributes() ?>>
		<?php echo $process_action->employee_2->selectOptionListHtml("x_employee_2") ?>
	</select>
</div>
<?php echo $process_action->employee_2->Lookup->getParamTag("p_x_employee_2") ?>
</span>
<?php echo $process_action->employee_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->employee_3->Visible) { // employee_3 ?>
	<div id="r_employee_3" class="form-group row">
		<label id="elh_process_action_employee_3" for="x_employee_3" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->employee_3->caption() ?><?php echo ($process_action->employee_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->employee_3->cellAttributes() ?>>
<span id="el_process_action_employee_3">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_employee_3" data-value-separator="<?php echo $process_action->employee_3->displayValueSeparatorAttribute() ?>" id="x_employee_3" name="x_employee_3"<?php echo $process_action->employee_3->editAttributes() ?>>
		<?php echo $process_action->employee_3->selectOptionListHtml("x_employee_3") ?>
	</select>
</div>
<?php echo $process_action->employee_3->Lookup->getParamTag("p_x_employee_3") ?>
</span>
<?php echo $process_action->employee_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_process_action_employee_id" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->employee_id->caption() ?><?php echo ($process_action->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->employee_id->cellAttributes() ?>>
<span id="el_process_action_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($process_action->employee_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action->employee_id->ViewValue) : $process_action->employee_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action->employee_id->ReadOnly || $process_action->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="process_action" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $process_action->employee_id->CurrentValue ?>"<?php echo $process_action->employee_id->editAttributes() ?>>
</span>
<?php echo $process_action->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label id="elh_process_action_qty" for="x_qty" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->qty->caption() ?><?php echo ($process_action->qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->qty->cellAttributes() ?>>
<span id="el_process_action_qty">
<input type="text" data-table="process_action" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($process_action->qty->getPlaceHolder()) ?>" value="<?php echo $process_action->qty->EditValue ?>"<?php echo $process_action->qty->editAttributes() ?>>
</span>
<?php echo $process_action->qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->roll_no->Visible) { // roll_no ?>
	<div id="r_roll_no" class="form-group row">
		<label id="elh_process_action_roll_no" for="x_roll_no" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->roll_no->caption() ?><?php echo ($process_action->roll_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->roll_no->cellAttributes() ?>>
<span id="el_process_action_roll_no">
<input type="text" data-table="process_action" data-field="x_roll_no" name="x_roll_no" id="x_roll_no" size="30" placeholder="<?php echo HtmlEncode($process_action->roll_no->getPlaceHolder()) ?>" value="<?php echo $process_action->roll_no->EditValue ?>"<?php echo $process_action->roll_no->editAttributes() ?>>
</span>
<?php echo $process_action->roll_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->size_actual->Visible) { // size_actual ?>
	<div id="r_size_actual" class="form-group row">
		<label id="elh_process_action_size_actual" for="x_size_actual" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->size_actual->caption() ?><?php echo ($process_action->size_actual->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->size_actual->cellAttributes() ?>>
<span id="el_process_action_size_actual">
<input type="text" data-table="process_action" data-field="x_size_actual" name="x_size_actual" id="x_size_actual" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_action->size_actual->getPlaceHolder()) ?>" value="<?php echo $process_action->size_actual->EditValue ?>"<?php echo $process_action->size_actual->editAttributes() ?>>
</span>
<?php echo $process_action->size_actual->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->weight_actual->Visible) { // weight_actual ?>
	<div id="r_weight_actual" class="form-group row">
		<label id="elh_process_action_weight_actual" for="x_weight_actual" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->weight_actual->caption() ?><?php echo ($process_action->weight_actual->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->weight_actual->cellAttributes() ?>>
<span id="el_process_action_weight_actual">
<input type="text" data-table="process_action" data-field="x_weight_actual" name="x_weight_actual" id="x_weight_actual" size="30" placeholder="<?php echo HtmlEncode($process_action->weight_actual->getPlaceHolder()) ?>" value="<?php echo $process_action->weight_actual->EditValue ?>"<?php echo $process_action->weight_actual->editAttributes() ?>>
</span>
<?php echo $process_action->weight_actual->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<div id="r_lines_in_30cm" class="form-group row">
		<label id="elh_process_action_lines_in_30cm" for="x_lines_in_30cm" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->lines_in_30cm->caption() ?><?php echo ($process_action->lines_in_30cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->lines_in_30cm->cellAttributes() ?>>
<span id="el_process_action_lines_in_30cm">
<input type="text" data-table="process_action" data-field="x_lines_in_30cm" name="x_lines_in_30cm" id="x_lines_in_30cm" size="30" placeholder="<?php echo HtmlEncode($process_action->lines_in_30cm->getPlaceHolder()) ?>" value="<?php echo $process_action->lines_in_30cm->EditValue ?>"<?php echo $process_action->lines_in_30cm->editAttributes() ?>>
</span>
<?php echo $process_action->lines_in_30cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->valuation->Visible) { // valuation ?>
	<div id="r_valuation" class="form-group row">
		<label id="elh_process_action_valuation" for="x_valuation" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->valuation->caption() ?><?php echo ($process_action->valuation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->valuation->cellAttributes() ?>>
<span id="el_process_action_valuation">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_valuation" data-value-separator="<?php echo $process_action->valuation->displayValueSeparatorAttribute() ?>" id="x_valuation" name="x_valuation"<?php echo $process_action->valuation->editAttributes() ?>>
		<?php echo $process_action->valuation->selectOptionListHtml("x_valuation") ?>
	</select>
</div>
</span>
<?php echo $process_action->valuation->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label id="elh_process_action_deduction" for="x_deduction" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->deduction->caption() ?><?php echo ($process_action->deduction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->deduction->cellAttributes() ?>>
<span id="el_process_action_deduction">
<input type="text" data-table="process_action" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($process_action->deduction->getPlaceHolder()) ?>" value="<?php echo $process_action->deduction->EditValue ?>"<?php echo $process_action->deduction->editAttributes() ?>>
</span>
<?php echo $process_action->deduction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label id="elh_process_action_remark" for="x_remark" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->remark->caption() ?><?php echo ($process_action->remark->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->remark->cellAttributes() ?>>
<span id="el_process_action_remark">
<input type="text" data-table="process_action" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="225" placeholder="<?php echo HtmlEncode($process_action->remark->getPlaceHolder()) ?>" value="<?php echo $process_action->remark->EditValue ?>"<?php echo $process_action->remark->editAttributes() ?>>
</span>
<?php echo $process_action->remark->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label id="elh_process_action_upload" class="<?php echo $process_action_add->LeftColumnClass ?>"><?php echo $process_action->upload->caption() ?><?php echo ($process_action->upload->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_add->RightColumnClass ?>"><div<?php echo $process_action->upload->cellAttributes() ?>>
<span id="el_process_action_upload">
<div id="fd_x_upload">
<span title="<?php echo $process_action->upload->title() ? $process_action->upload->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($process_action->upload->ReadOnly || $process_action->upload->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="process_action" data-field="x_upload" name="x_upload" id="x_upload"<?php echo $process_action->upload->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_upload" id= "fn_x_upload" value="<?php echo $process_action->upload->Upload->FileName ?>">
<input type="hidden" name="fa_x_upload" id= "fa_x_upload" value="0">
<input type="hidden" name="fs_x_upload" id= "fs_x_upload" value="255">
<input type="hidden" name="fx_x_upload" id= "fx_x_upload" value="<?php echo $process_action->upload->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_upload" id= "fm_x_upload" value="<?php echo $process_action->upload->UploadMaxFileSize ?>">
</div>
<table id="ft_x_upload" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $process_action->upload->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_action_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_action_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $process_action_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_action_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		$("#fprocess_actionadd #btn-action").attr("disabled","disabled");
		var rn = getCookie("rn");
		var Location = $('#x_location').val();
		if (Location == 1)
		{
		$("#r_godown").show();
		}
		else
		{
		$("#r_godown").hide();
		}
		document.cookie = "rn="+(parseInt(rn)+1);
		var PROCESS = $('#x_process').val();
		$("#sv_x_employee").val('');
		$("#x_employee_id").val('');
		$("#r_roll_no").hide();
		if (PROCESS == 19) {
		$("#r_roll_no").show();
		$("#x_qty").removeAttr('readonly')
		$("#r_weight_actual").show();
		$("#r_valuation").hide();
		$("#r_lines_in_30cm").hide();
		}
		else if ((PROCESS == 27) || (PROCESS == 28) || (PROCESS == 29) || (PROCESS == 16) || (PROCESS == 17) || (PROCESS == 39) || (PROCESS == 45))
		{
		$("#r_size_actual").show();
		$("#r_weight_actual").show();
		$("#r_valuation").show();		
		}
		else if (PROCESS == 32)
		{
		$("#r_size_actual").show();
		$("#r_weight_actual").show();
		$("#r_lines_in_30cm").hide();
		$("#r_valuation").hide();
		}
		else
		{
		$("#r_size_actual").hide();
		$("#r_weight_actual").hide();
		$("#r_lines_in_30cm").hide();		
		$("#r_valuation").hide();
		$("#r_roll_no").val(0);		
		$("#r_roll_no").hide();
		$("#x_qty").attr('disabled',true);
		}
		$.getJSON(window.location.origin +"/apcajax.php?sub_process="+PROCESS,function(data){
			if (data.m_employee == 0)
			{
			$("#r_employee_1").show();
			$("#r_employee_2").hide();
			$("#r_employee_3").hide();
			$("#r_employee_id").hide();
			}
			else if (data.m_employee == 1)
			{
			$("#r_employee_1").show();
			$("#r_employee_2").show();			
			$("#r_employee_3").show();			
			$("#r_employee_id").hide();
			}
			else
			{
			$("#r_employee_1").hide();
			$("#r_employee_2").hide();			
			$("#r_employee_3").hide();
			$("#r_employee_id").show();
			}
		});
		$("#r_deduction").hide();
	$("#el_process_action_code").append('<div class="input-group-append"><h6 style="color:blue" onclick="javascript:barcode(\'code\')"><i class="fa fa-barcode"></i> Scan BarCode</h6></div>');
	$("#el_process_action_code_last").append('<div class="input-group-append"><h6 style="color:blue" onclick="javascript:barcode(\'code_last\')"><i class="fa fa-barcode"></i> Scan BarCode</h6></div>');
</script>
<?php include_once "footer.php" ?>
<?php
$process_action_add->terminate();
?>