<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_list = new process_action_list();

// Run the page
$process_action_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_actionlist = currentForm = new ew.Form("fprocess_actionlist", "list");
fprocess_actionlist.formKeyCountName = '<?php echo $process_action_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_actionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_actionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_actionlist.lists["x_process"] = <?php echo $process_action_list->process->Lookup->toClientList() ?>;
fprocess_actionlist.lists["x_process"].options = <?php echo JsonEncode($process_action_list->process->lookupOptions()) ?>;
fprocess_actionlist.lists["x_process_other[]"] = <?php echo $process_action_list->process_other->Lookup->toClientList() ?>;
fprocess_actionlist.lists["x_process_other[]"].options = <?php echo JsonEncode($process_action_list->process_other->lookupOptions()) ?>;
fprocess_actionlist.lists["x_location"] = <?php echo $process_action_list->location->Lookup->toClientList() ?>;
fprocess_actionlist.lists["x_location"].options = <?php echo JsonEncode($process_action_list->location->lookupOptions()) ?>;
fprocess_actionlist.lists["x_godown"] = <?php echo $process_action_list->godown->Lookup->toClientList() ?>;
fprocess_actionlist.lists["x_godown"].options = <?php echo JsonEncode($process_action_list->godown->lookupOptions()) ?>;
fprocess_actionlist.lists["x_employee_id[]"] = <?php echo $process_action_list->employee_id->Lookup->toClientList() ?>;
fprocess_actionlist.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_action_list->employee_id->lookupOptions()) ?>;
fprocess_actionlist.lists["x_operator"] = <?php echo $process_action_list->operator->Lookup->toClientList() ?>;
fprocess_actionlist.lists["x_operator"].options = <?php echo JsonEncode($process_action_list->operator->lookupOptions()) ?>;
fprocess_actionlist.lists["x_valuation"] = <?php echo $process_action_list->valuation->Lookup->toClientList() ?>;
fprocess_actionlist.lists["x_valuation"].options = <?php echo JsonEncode($process_action_list->valuation->options(FALSE, TRUE)) ?>;

// Form object for search
var fprocess_actionlistsrch = currentSearchForm = new ew.Form("fprocess_actionlistsrch");

// Validate function for search
fprocess_actionlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_actionlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_actionlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_actionlistsrch.lists["x_process"] = <?php echo $process_action_list->process->Lookup->toClientList() ?>;
fprocess_actionlistsrch.lists["x_process"].options = <?php echo JsonEncode($process_action_list->process->lookupOptions()) ?>;
fprocess_actionlistsrch.lists["x_location"] = <?php echo $process_action_list->location->Lookup->toClientList() ?>;
fprocess_actionlistsrch.lists["x_location"].options = <?php echo JsonEncode($process_action_list->location->lookupOptions()) ?>;
fprocess_actionlistsrch.lists["x_employee_id[]"] = <?php echo $process_action_list->employee_id->Lookup->toClientList() ?>;
fprocess_actionlistsrch.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_action_list->employee_id->lookupOptions()) ?>;

// Filters
fprocess_actionlistsrch.filterList = <?php echo $process_action_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_actionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_list->TotalRecs > 0 && $process_action_list->ExportOptions->visible()) { ?>
<?php $process_action_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_list->ImportOptions->visible()) { ?>
<?php $process_action_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_list->SearchOptions->visible()) { ?>
<?php $process_action_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_list->FilterOptions->visible()) { ?>
<?php $process_action_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action->isExport() && !$process_action->CurrentAction) { ?>
<form name="fprocess_actionlistsrch" id="fprocess_actionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_actionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_action_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_action->RowType = ROWTYPE_SEARCH;

// Render row
$process_action->resetAttributes();
$process_action_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_action->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_action->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_process" data-value-separator="<?php echo $process_action->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action->process->editAttributes() ?>>
		<?php echo $process_action->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $process_action->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_location" data-value-separator="<?php echo $process_action->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action->location->editAttributes() ?>>
		<?php echo $process_action->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action->employee_id->Visible) { // employee_id ?>
	<div id="xsc_employee_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action->employee_id->caption() ?></label>
		<span class="ew-search-operator"><select name="z_employee_id" id="z_employee_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($process_action->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action->employee_id->AdvancedSearch->ViewValue) : $process_action->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action->employee_id->ReadOnly || $process_action->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="process_action" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $process_action->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $process_action->employee_id->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_employee_id style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_employee_id style="d-none"">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_employee_id"><?php echo strval($process_action->employee_id->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action->employee_id->AdvancedSearch->ViewValue2) : $process_action->employee_id->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action->employee_id->ReadOnly || $process_action->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action->employee_id->Lookup->getParamTag("p_y_employee_id") ?>
<input type="hidden" data-table="process_action" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action->employee_id->displayValueSeparatorAttribute() ?>" name="y_employee_id[]" id="y_employee_id[]" value="<?php echo $process_action->employee_id->AdvancedSearch->SearchValue2 ?>"<?php echo $process_action->employee_id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($process_action->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $process_action->datetime->caption() ?></label>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="process_action" data-field="x_datetime" data-format="117" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action->datetime->EditValue ?>"<?php echo $process_action->datetime->editAttributes() ?>>
<?php if (!$process_action->datetime->ReadOnly && !$process_action->datetime->Disabled && !isset($process_action->datetime->EditAttrs["readonly"]) && !isset($process_action->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_actionlistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_datetime style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_datetime style="d-none"">
<input type="text" data-table="process_action" data-field="x_datetime" data-format="117" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action->datetime->EditValue2 ?>"<?php echo $process_action->datetime->editAttributes() ?>>
<?php if (!$process_action->datetime->ReadOnly && !$process_action->datetime->Disabled && !isset($process_action->datetime->EditAttrs["readonly"]) && !isset($process_action->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_actionlistsrch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_list->showPageHeader(); ?>
<?php
$process_action_list->showMessage();
?>
<?php if ($process_action_list->TotalRecs > 0 || $process_action->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action">
<?php if (!$process_action->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_list->Pager)) $process_action_list->Pager = new PrevNextPager($process_action_list->StartRec, $process_action_list->DisplayRecs, $process_action_list->TotalRecs, $process_action_list->AutoHidePager) ?>
<?php if ($process_action_list->Pager->RecordCount > 0 && $process_action_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_list->TotalRecs > 0 && (!$process_action_list->AutoHidePageSizeSelector || $process_action_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_actionlist" id="fprocess_actionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action">
<div id="gmp_process_action" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_list->TotalRecs > 0 || $process_action->isGridEdit()) { ?>
<table id="tbl_process_actionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_list->renderListOptions();

// Render list options (header, left)
$process_action_list->ListOptions->render("header", "left");
?>
<?php if ($process_action->id->Visible) { // id ?>
	<?php if ($process_action->sortUrl($process_action->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_action->id->headerCellClass() ?>"><div id="elh_process_action_id" class="process_action_id"><div class="ew-table-header-caption"><?php echo $process_action->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_action->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->id) ?>',2);"><div id="elh_process_action_id" class="process_action_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->process->Visible) { // process ?>
	<?php if ($process_action->sortUrl($process_action->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action->process->headerCellClass() ?>"><div id="elh_process_action_process" class="process_action_process"><div class="ew-table-header-caption"><?php echo $process_action->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->process) ?>',2);"><div id="elh_process_action_process" class="process_action_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->process_other->Visible) { // process_other ?>
	<?php if ($process_action->sortUrl($process_action->process_other) == "") { ?>
		<th data-name="process_other" class="<?php echo $process_action->process_other->headerCellClass() ?>"><div id="elh_process_action_process_other" class="process_action_process_other"><div class="ew-table-header-caption"><?php echo $process_action->process_other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_other" class="<?php echo $process_action->process_other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->process_other) ?>',2);"><div id="elh_process_action_process_other" class="process_action_process_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->process_other->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->process_other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->process_other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->location->Visible) { // location ?>
	<?php if ($process_action->sortUrl($process_action->location) == "") { ?>
		<th data-name="location" class="<?php echo $process_action->location->headerCellClass() ?>"><div id="elh_process_action_location" class="process_action_location"><div class="ew-table-header-caption"><?php echo $process_action->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $process_action->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->location) ?>',2);"><div id="elh_process_action_location" class="process_action_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->godown->Visible) { // godown ?>
	<?php if ($process_action->sortUrl($process_action->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $process_action->godown->headerCellClass() ?>"><div id="elh_process_action_godown" class="process_action_godown"><div class="ew-table-header-caption"><?php echo $process_action->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $process_action->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->godown) ?>',2);"><div id="elh_process_action_godown" class="process_action_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->code->Visible) { // code ?>
	<?php if ($process_action->sortUrl($process_action->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_action->code->headerCellClass() ?>"><div id="elh_process_action_code" class="process_action_code"><div class="ew-table-header-caption"><?php echo $process_action->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_action->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->code) ?>',2);"><div id="elh_process_action_code" class="process_action_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->code_last->Visible) { // code_last ?>
	<?php if ($process_action->sortUrl($process_action->code_last) == "") { ?>
		<th data-name="code_last" class="<?php echo $process_action->code_last->headerCellClass() ?>"><div id="elh_process_action_code_last" class="process_action_code_last"><div class="ew-table-header-caption"><?php echo $process_action->code_last->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code_last" class="<?php echo $process_action->code_last->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->code_last) ?>',2);"><div id="elh_process_action_code_last" class="process_action_code_last">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->code_last->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action->code_last->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->code_last->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->employee_id->Visible) { // employee_id ?>
	<?php if ($process_action->sortUrl($process_action->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $process_action->employee_id->headerCellClass() ?>"><div id="elh_process_action_employee_id" class="process_action_employee_id"><div class="ew-table-header-caption"><?php echo $process_action->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $process_action->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->employee_id) ?>',2);"><div id="elh_process_action_employee_id" class="process_action_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->qty->Visible) { // qty ?>
	<?php if ($process_action->sortUrl($process_action->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $process_action->qty->headerCellClass() ?>"><div id="elh_process_action_qty" class="process_action_qty"><div class="ew-table-header-caption"><?php echo $process_action->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $process_action->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->qty) ?>',2);"><div id="elh_process_action_qty" class="process_action_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->roll_no->Visible) { // roll_no ?>
	<?php if ($process_action->sortUrl($process_action->roll_no) == "") { ?>
		<th data-name="roll_no" class="<?php echo $process_action->roll_no->headerCellClass() ?>"><div id="elh_process_action_roll_no" class="process_action_roll_no"><div class="ew-table-header-caption"><?php echo $process_action->roll_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no" class="<?php echo $process_action->roll_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->roll_no) ?>',2);"><div id="elh_process_action_roll_no" class="process_action_roll_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->roll_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->roll_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->roll_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->operator->Visible) { // operator ?>
	<?php if ($process_action->sortUrl($process_action->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_action->operator->headerCellClass() ?>"><div id="elh_process_action_operator" class="process_action_operator"><div class="ew-table-header-caption"><?php echo $process_action->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_action->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->operator) ?>',2);"><div id="elh_process_action_operator" class="process_action_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->datetime->Visible) { // datetime ?>
	<?php if ($process_action->sortUrl($process_action->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_action->datetime->headerCellClass() ?>"><div id="elh_process_action_datetime" class="process_action_datetime"><div class="ew-table-header-caption"><?php echo $process_action->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_action->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->datetime) ?>',2);"><div id="elh_process_action_datetime" class="process_action_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->size_actual->Visible) { // size_actual ?>
	<?php if ($process_action->sortUrl($process_action->size_actual) == "") { ?>
		<th data-name="size_actual" class="<?php echo $process_action->size_actual->headerCellClass() ?>"><div id="elh_process_action_size_actual" class="process_action_size_actual"><div class="ew-table-header-caption"><?php echo $process_action->size_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_actual" class="<?php echo $process_action->size_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->size_actual) ?>',2);"><div id="elh_process_action_size_actual" class="process_action_size_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->size_actual->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action->size_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->size_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->weight_actual->Visible) { // weight_actual ?>
	<?php if ($process_action->sortUrl($process_action->weight_actual) == "") { ?>
		<th data-name="weight_actual" class="<?php echo $process_action->weight_actual->headerCellClass() ?>"><div id="elh_process_action_weight_actual" class="process_action_weight_actual"><div class="ew-table-header-caption"><?php echo $process_action->weight_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_actual" class="<?php echo $process_action->weight_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->weight_actual) ?>',2);"><div id="elh_process_action_weight_actual" class="process_action_weight_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->weight_actual->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->weight_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->weight_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<?php if ($process_action->sortUrl($process_action->lines_in_30cm) == "") { ?>
		<th data-name="lines_in_30cm" class="<?php echo $process_action->lines_in_30cm->headerCellClass() ?>"><div id="elh_process_action_lines_in_30cm" class="process_action_lines_in_30cm"><div class="ew-table-header-caption"><?php echo $process_action->lines_in_30cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lines_in_30cm" class="<?php echo $process_action->lines_in_30cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->lines_in_30cm) ?>',2);"><div id="elh_process_action_lines_in_30cm" class="process_action_lines_in_30cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->lines_in_30cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->lines_in_30cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->lines_in_30cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->valuation->Visible) { // valuation ?>
	<?php if ($process_action->sortUrl($process_action->valuation) == "") { ?>
		<th data-name="valuation" class="<?php echo $process_action->valuation->headerCellClass() ?>"><div id="elh_process_action_valuation" class="process_action_valuation"><div class="ew-table-header-caption"><?php echo $process_action->valuation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="valuation" class="<?php echo $process_action->valuation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->valuation) ?>',2);"><div id="elh_process_action_valuation" class="process_action_valuation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->valuation->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->valuation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->valuation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->deduction->Visible) { // deduction ?>
	<?php if ($process_action->sortUrl($process_action->deduction) == "") { ?>
		<th data-name="deduction" class="<?php echo $process_action->deduction->headerCellClass() ?>"><div id="elh_process_action_deduction" class="process_action_deduction"><div class="ew-table-header-caption"><?php echo $process_action->deduction->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deduction" class="<?php echo $process_action->deduction->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->deduction) ?>',2);"><div id="elh_process_action_deduction" class="process_action_deduction">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->deduction->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action->deduction->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->deduction->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->remark->Visible) { // remark ?>
	<?php if ($process_action->sortUrl($process_action->remark) == "") { ?>
		<th data-name="remark" class="<?php echo $process_action->remark->headerCellClass() ?>"><div id="elh_process_action_remark" class="process_action_remark"><div class="ew-table-header-caption"><?php echo $process_action->remark->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remark" class="<?php echo $process_action->remark->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->remark) ?>',2);"><div id="elh_process_action_remark" class="process_action_remark">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->remark->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action->remark->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->remark->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action->upload->Visible) { // upload ?>
	<?php if ($process_action->sortUrl($process_action->upload) == "") { ?>
		<th data-name="upload" class="<?php echo $process_action->upload->headerCellClass() ?>"><div id="elh_process_action_upload" class="process_action_upload"><div class="ew-table-header-caption"><?php echo $process_action->upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="upload" class="<?php echo $process_action->upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action->SortUrl($process_action->upload) ?>',2);"><div id="elh_process_action_upload" class="process_action_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action->upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action->upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action->upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action->ExportAll && $process_action->isExport()) {
	$process_action_list->StopRec = $process_action_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_list->TotalRecs > $process_action_list->StartRec + $process_action_list->DisplayRecs - 1)
		$process_action_list->StopRec = $process_action_list->StartRec + $process_action_list->DisplayRecs - 1;
	else
		$process_action_list->StopRec = $process_action_list->TotalRecs;
}
$process_action_list->RecCnt = $process_action_list->StartRec - 1;
if ($process_action_list->Recordset && !$process_action_list->Recordset->EOF) {
	$process_action_list->Recordset->moveFirst();
	$selectLimit = $process_action_list->UseSelectLimit;
	if (!$selectLimit && $process_action_list->StartRec > 1)
		$process_action_list->Recordset->move($process_action_list->StartRec - 1);
} elseif (!$process_action->AllowAddDeleteRow && $process_action_list->StopRec == 0) {
	$process_action_list->StopRec = $process_action->GridAddRowCount;
}

// Initialize aggregate
$process_action->RowType = ROWTYPE_AGGREGATEINIT;
$process_action->resetAttributes();
$process_action_list->renderRow();
while ($process_action_list->RecCnt < $process_action_list->StopRec) {
	$process_action_list->RecCnt++;
	if ($process_action_list->RecCnt >= $process_action_list->StartRec) {
		$process_action_list->RowCnt++;

		// Set up key count
		$process_action_list->KeyCount = $process_action_list->RowIndex;

		// Init row class and style
		$process_action->resetAttributes();
		$process_action->CssClass = "";
		if ($process_action->isGridAdd()) {
		} else {
			$process_action_list->loadRowValues($process_action_list->Recordset); // Load row values
		}
		$process_action->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action->RowAttrs = array_merge($process_action->RowAttrs, array('data-rowindex'=>$process_action_list->RowCnt, 'id'=>'r' . $process_action_list->RowCnt . '_process_action', 'data-rowtype'=>$process_action->RowType));

		// Render row
		$process_action_list->renderRow();

		// Render list options
		$process_action_list->renderListOptions();
?>
	<tr<?php echo $process_action->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_list->ListOptions->render("body", "left", $process_action_list->RowCnt);
?>
	<?php if ($process_action->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_action->id->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_id" class="process_action_id">
<span<?php echo $process_action->id->viewAttributes() ?>>
<?php echo $process_action->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_process" class="process_action_process">
<span<?php echo $process_action->process->viewAttributes() ?>>
<?php if ((!EmptyString($process_action->process->getViewValue())) && $process_action->process->linkAttributes() <> "") { ?>
<a<?php echo $process_action->process->linkAttributes() ?>><?php echo $process_action->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->process_other->Visible) { // process_other ?>
		<td data-name="process_other"<?php echo $process_action->process_other->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_process_other" class="process_action_process_other">
<span<?php echo $process_action->process_other->viewAttributes() ?>>
<?php echo $process_action->process_other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->location->Visible) { // location ?>
		<td data-name="location"<?php echo $process_action->location->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_location" class="process_action_location">
<span<?php echo $process_action->location->viewAttributes() ?>>
<?php echo $process_action->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $process_action->godown->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_godown" class="process_action_godown">
<span<?php echo $process_action->godown->viewAttributes() ?>>
<?php echo $process_action->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_action->code->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_code" class="process_action_code">
<span<?php echo $process_action->code->viewAttributes() ?>>
<?php if ((!EmptyString($process_action->code->getViewValue())) && $process_action->code->linkAttributes() <> "") { ?>
<a<?php echo $process_action->code->linkAttributes() ?>><?php echo $process_action->code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action->code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->code_last->Visible) { // code_last ?>
		<td data-name="code_last"<?php echo $process_action->code_last->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_code_last" class="process_action_code_last">
<span<?php echo $process_action->code_last->viewAttributes() ?>>
<?php echo $process_action->code_last->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $process_action->employee_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_employee_id" class="process_action_employee_id">
<span<?php echo $process_action->employee_id->viewAttributes() ?>>
<?php echo $process_action->employee_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $process_action->qty->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_qty" class="process_action_qty">
<span<?php echo $process_action->qty->viewAttributes() ?>>
<?php echo $process_action->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no"<?php echo $process_action->roll_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_roll_no" class="process_action_roll_no">
<span<?php echo $process_action->roll_no->viewAttributes() ?>>
<?php echo $process_action->roll_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_action->operator->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_operator" class="process_action_operator">
<span<?php echo $process_action->operator->viewAttributes() ?>>
<?php echo $process_action->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_action->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_datetime" class="process_action_datetime">
<span<?php echo $process_action->datetime->viewAttributes() ?>>
<?php echo $process_action->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->size_actual->Visible) { // size_actual ?>
		<td data-name="size_actual"<?php echo $process_action->size_actual->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_size_actual" class="process_action_size_actual">
<span<?php echo $process_action->size_actual->viewAttributes() ?>>
<?php echo $process_action->size_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->weight_actual->Visible) { // weight_actual ?>
		<td data-name="weight_actual"<?php echo $process_action->weight_actual->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_weight_actual" class="process_action_weight_actual">
<span<?php echo $process_action->weight_actual->viewAttributes() ?>>
<?php echo $process_action->weight_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->lines_in_30cm->Visible) { // lines_in_30cm ?>
		<td data-name="lines_in_30cm"<?php echo $process_action->lines_in_30cm->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_lines_in_30cm" class="process_action_lines_in_30cm">
<span<?php echo $process_action->lines_in_30cm->viewAttributes() ?>>
<?php echo $process_action->lines_in_30cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->valuation->Visible) { // valuation ?>
		<td data-name="valuation"<?php echo $process_action->valuation->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_valuation" class="process_action_valuation">
<span<?php echo $process_action->valuation->viewAttributes() ?>>
<?php echo $process_action->valuation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->deduction->Visible) { // deduction ?>
		<td data-name="deduction"<?php echo $process_action->deduction->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_deduction" class="process_action_deduction">
<span<?php echo $process_action->deduction->viewAttributes() ?>>
<?php echo $process_action->deduction->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->remark->Visible) { // remark ?>
		<td data-name="remark"<?php echo $process_action->remark->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_remark" class="process_action_remark">
<span<?php echo $process_action->remark->viewAttributes() ?>>
<?php echo $process_action->remark->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action->upload->Visible) { // upload ?>
		<td data-name="upload"<?php echo $process_action->upload->cellAttributes() ?>>
<span id="el<?php echo $process_action_list->RowCnt ?>_process_action_upload" class="process_action_upload">
<span>
<?php echo GetFileViewTag($process_action->upload, $process_action->upload->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_list->ListOptions->render("body", "right", $process_action_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action->isGridAdd())
		$process_action_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_list->Recordset)
	$process_action_list->Recordset->Close();
?>
<?php if (!$process_action->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_list->Pager)) $process_action_list->Pager = new PrevNextPager($process_action_list->StartRec, $process_action_list->DisplayRecs, $process_action_list->TotalRecs, $process_action_list->AutoHidePager) ?>
<?php if ($process_action_list->Pager->RecordCount > 0 && $process_action_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_list->pageUrl() ?>start=<?php echo $process_action_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_list->TotalRecs > 0 && (!$process_action_list->AutoHidePageSizeSelector || $process_action_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_list->TotalRecs == 0 && !$process_action->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_list->terminate();
?>