<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_search = new process_action_search();

// Run the page
$process_action_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_action_search->IsModal) { ?>
var fprocess_actionsearch = currentAdvancedSearchForm = new ew.Form("fprocess_actionsearch", "search");
<?php } else { ?>
var fprocess_actionsearch = currentForm = new ew.Form("fprocess_actionsearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_actionsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_actionsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_actionsearch.lists["x_process"] = <?php echo $process_action_search->process->Lookup->toClientList() ?>;
fprocess_actionsearch.lists["x_process"].options = <?php echo JsonEncode($process_action_search->process->lookupOptions()) ?>;
fprocess_actionsearch.lists["x_process_other[]"] = <?php echo $process_action_search->process_other->Lookup->toClientList() ?>;
fprocess_actionsearch.lists["x_process_other[]"].options = <?php echo JsonEncode($process_action_search->process_other->lookupOptions()) ?>;
fprocess_actionsearch.lists["x_location"] = <?php echo $process_action_search->location->Lookup->toClientList() ?>;
fprocess_actionsearch.lists["x_location"].options = <?php echo JsonEncode($process_action_search->location->lookupOptions()) ?>;
fprocess_actionsearch.lists["x_godown"] = <?php echo $process_action_search->godown->Lookup->toClientList() ?>;
fprocess_actionsearch.lists["x_godown"].options = <?php echo JsonEncode($process_action_search->godown->lookupOptions()) ?>;
fprocess_actionsearch.lists["x_employee_id[]"] = <?php echo $process_action_search->employee_id->Lookup->toClientList() ?>;
fprocess_actionsearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_action_search->employee_id->lookupOptions()) ?>;
fprocess_actionsearch.lists["x_operator"] = <?php echo $process_action_search->operator->Lookup->toClientList() ?>;
fprocess_actionsearch.lists["x_operator"].options = <?php echo JsonEncode($process_action_search->operator->lookupOptions()) ?>;
fprocess_actionsearch.lists["x_valuation"] = <?php echo $process_action_search->valuation->Lookup->toClientList() ?>;
fprocess_actionsearch.lists["x_valuation"].options = <?php echo JsonEncode($process_action_search->valuation->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fprocess_actionsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_actual");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action->weight_actual->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lines_in_30cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action->lines_in_30cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action->deduction->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_action_search->showPageHeader(); ?>
<?php
$process_action_search->showMessage();
?>
<form name="fprocess_actionsearch" id="fprocess_actionsearch" class="<?php echo $process_action_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_action_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_action->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_id"><?php echo $process_action->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->id->cellAttributes() ?>>
			<span id="el_process_action_id">
<input type="text" data-table="process_action" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_action->id->getPlaceHolder()) ?>" value="<?php echo $process_action->id->EditValue ?>"<?php echo $process_action->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_process"><?php echo $process_action->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->process->cellAttributes() ?>>
			<span id="el_process_action_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_process" data-value-separator="<?php echo $process_action->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action->process->editAttributes() ?>>
		<?php echo $process_action->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->process_other->Visible) { // process_other ?>
	<div id="r_process_other" class="form-group row">
		<label class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_process_other"><?php echo $process_action->process_other->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_other" id="z_process_other" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->process_other->cellAttributes() ?>>
			<span id="el_process_action_process_other">
<div id="tp_x_process_other" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action" data-field="x_process_other" data-value-separator="<?php echo $process_action->process_other->displayValueSeparatorAttribute() ?>" name="x_process_other[]" id="x_process_other[]" value="{value}"<?php echo $process_action->process_other->editAttributes() ?>></div>
<div id="dsl_x_process_other" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $process_action->process_other->checkBoxListHtml(FALSE, "x_process_other[]") ?>
</div></div>
<?php echo $process_action->process_other->Lookup->getParamTag("p_x_process_other") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_location"><?php echo $process_action->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->location->cellAttributes() ?>>
			<span id="el_process_action_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_location" data-value-separator="<?php echo $process_action->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action->location->editAttributes() ?>>
		<?php echo $process_action->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_godown"><?php echo $process_action->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->godown->cellAttributes() ?>>
			<span id="el_process_action_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_godown" data-value-separator="<?php echo $process_action->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_action->godown->editAttributes() ?>>
		<?php echo $process_action->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $process_action->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_code"><?php echo $process_action->code->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->code->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_code" id="z_code" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action->code->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($process_action->code->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_code">
<input type="text" data-table="process_action" data-field="x_code" name="x_code" id="x_code" size="100" maxlength="500" placeholder="<?php echo HtmlEncode($process_action->code->getPlaceHolder()) ?>" value="<?php echo $process_action->code->EditValue ?>"<?php echo $process_action->code->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_code d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_code" class="btw1_code d-none">
<input type="text" data-table="process_action" data-field="x_code" name="y_code" id="y_code" size="100" maxlength="500" placeholder="<?php echo HtmlEncode($process_action->code->getPlaceHolder()) ?>" value="<?php echo $process_action->code->EditValue2 ?>"<?php echo $process_action->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->code_last->Visible) { // code_last ?>
	<div id="r_code_last" class="form-group row">
		<label for="x_code_last" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_code_last"><?php echo $process_action->code_last->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->code_last->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_code_last" id="z_code_last" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($process_action->code_last->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_code_last">
<input type="text" data-table="process_action" data-field="x_code_last" name="x_code_last" id="x_code_last" size="100" maxlength="500" placeholder="<?php echo HtmlEncode($process_action->code_last->getPlaceHolder()) ?>" value="<?php echo $process_action->code_last->EditValue ?>"<?php echo $process_action->code_last->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_code_last d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_code_last" class="btw1_code_last d-none">
<input type="text" data-table="process_action" data-field="x_code_last" name="y_code_last" id="y_code_last" size="100" maxlength="500" placeholder="<?php echo HtmlEncode($process_action->code_last->getPlaceHolder()) ?>" value="<?php echo $process_action->code_last->EditValue2 ?>"<?php echo $process_action->code_last->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_employee_id"><?php echo $process_action->employee_id->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->employee_id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_employee_id" id="z_employee_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action->employee_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($process_action->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action->employee_id->AdvancedSearch->ViewValue) : $process_action->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action->employee_id->ReadOnly || $process_action->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="process_action" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $process_action->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $process_action->employee_id->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_employee_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_employee_id" class="btw1_employee_id d-none">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_employee_id"><?php echo strval($process_action->employee_id->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action->employee_id->AdvancedSearch->ViewValue2) : $process_action->employee_id->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action->employee_id->ReadOnly || $process_action->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action->employee_id->Lookup->getParamTag("p_y_employee_id") ?>
<input type="hidden" data-table="process_action" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_action->employee_id->displayValueSeparatorAttribute() ?>" name="y_employee_id[]" id="y_employee_id[]" value="<?php echo $process_action->employee_id->AdvancedSearch->SearchValue2 ?>"<?php echo $process_action->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_qty"><?php echo $process_action->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->qty->cellAttributes() ?>>
			<span id="el_process_action_qty">
<input type="text" data-table="process_action" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($process_action->qty->getPlaceHolder()) ?>" value="<?php echo $process_action->qty->EditValue ?>"<?php echo $process_action->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->roll_no->Visible) { // roll_no ?>
	<div id="r_roll_no" class="form-group row">
		<label for="x_roll_no" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_roll_no"><?php echo $process_action->roll_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no" id="z_roll_no" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->roll_no->cellAttributes() ?>>
			<span id="el_process_action_roll_no">
<input type="text" data-table="process_action" data-field="x_roll_no" name="x_roll_no" id="x_roll_no" size="30" placeholder="<?php echo HtmlEncode($process_action->roll_no->getPlaceHolder()) ?>" value="<?php echo $process_action->roll_no->EditValue ?>"<?php echo $process_action->roll_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_operator"><?php echo $process_action->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->operator->cellAttributes() ?>>
			<span id="el_process_action_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_operator" data-value-separator="<?php echo $process_action->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process_action->operator->editAttributes() ?>>
		<?php echo $process_action->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process_action->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_datetime"><?php echo $process_action->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_datetime">
<input type="text" data-table="process_action" data-field="x_datetime" data-format="117" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action->datetime->EditValue ?>"<?php echo $process_action->datetime->editAttributes() ?>>
<?php if (!$process_action->datetime->ReadOnly && !$process_action->datetime->Disabled && !isset($process_action->datetime->EditAttrs["readonly"]) && !isset($process_action->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_actionsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_action" data-field="x_datetime" data-format="117" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action->datetime->EditValue2 ?>"<?php echo $process_action->datetime->editAttributes() ?>>
<?php if (!$process_action->datetime->ReadOnly && !$process_action->datetime->Disabled && !isset($process_action->datetime->EditAttrs["readonly"]) && !isset($process_action->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_actionsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->size_actual->Visible) { // size_actual ?>
	<div id="r_size_actual" class="form-group row">
		<label for="x_size_actual" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_size_actual"><?php echo $process_action->size_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->size_actual->cellAttributes() ?>>
			<span id="el_process_action_size_actual">
<input type="text" data-table="process_action" data-field="x_size_actual" name="x_size_actual" id="x_size_actual" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_action->size_actual->getPlaceHolder()) ?>" value="<?php echo $process_action->size_actual->EditValue ?>"<?php echo $process_action->size_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->weight_actual->Visible) { // weight_actual ?>
	<div id="r_weight_actual" class="form-group row">
		<label for="x_weight_actual" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_weight_actual"><?php echo $process_action->weight_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_actual" id="z_weight_actual" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->weight_actual->cellAttributes() ?>>
			<span id="el_process_action_weight_actual">
<input type="text" data-table="process_action" data-field="x_weight_actual" name="x_weight_actual" id="x_weight_actual" size="30" placeholder="<?php echo HtmlEncode($process_action->weight_actual->getPlaceHolder()) ?>" value="<?php echo $process_action->weight_actual->EditValue ?>"<?php echo $process_action->weight_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<div id="r_lines_in_30cm" class="form-group row">
		<label for="x_lines_in_30cm" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_lines_in_30cm"><?php echo $process_action->lines_in_30cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lines_in_30cm" id="z_lines_in_30cm" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->lines_in_30cm->cellAttributes() ?>>
			<span id="el_process_action_lines_in_30cm">
<input type="text" data-table="process_action" data-field="x_lines_in_30cm" name="x_lines_in_30cm" id="x_lines_in_30cm" size="30" placeholder="<?php echo HtmlEncode($process_action->lines_in_30cm->getPlaceHolder()) ?>" value="<?php echo $process_action->lines_in_30cm->EditValue ?>"<?php echo $process_action->lines_in_30cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->valuation->Visible) { // valuation ?>
	<div id="r_valuation" class="form-group row">
		<label for="x_valuation" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_valuation"><?php echo $process_action->valuation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_valuation" id="z_valuation" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->valuation->cellAttributes() ?>>
			<span id="el_process_action_valuation">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action" data-field="x_valuation" data-value-separator="<?php echo $process_action->valuation->displayValueSeparatorAttribute() ?>" id="x_valuation" name="x_valuation"<?php echo $process_action->valuation->editAttributes() ?>>
		<?php echo $process_action->valuation->selectOptionListHtml("x_valuation") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label for="x_deduction" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_deduction"><?php echo $process_action->deduction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_deduction" id="z_deduction" value="="></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->deduction->cellAttributes() ?>>
			<span id="el_process_action_deduction">
<input type="text" data-table="process_action" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($process_action->deduction->getPlaceHolder()) ?>" value="<?php echo $process_action->deduction->EditValue ?>"<?php echo $process_action->deduction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label for="x_remark" class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_remark"><?php echo $process_action->remark->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remark" id="z_remark" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->remark->cellAttributes() ?>>
			<span id="el_process_action_remark">
<input type="text" data-table="process_action" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="225" placeholder="<?php echo HtmlEncode($process_action->remark->getPlaceHolder()) ?>" value="<?php echo $process_action->remark->EditValue ?>"<?php echo $process_action->remark->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label class="<?php echo $process_action_search->LeftColumnClass ?>"><span id="elh_process_action_upload"><?php echo $process_action->upload->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_upload" id="z_upload" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_search->RightColumnClass ?>"><div<?php echo $process_action->upload->cellAttributes() ?>>
			<span id="el_process_action_upload">
<input type="text" data-table="process_action" data-field="x_upload" name="x_upload" id="x_upload" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($process_action->upload->getPlaceHolder()) ?>" value="<?php echo $process_action->upload->EditValue ?>"<?php echo $process_action->upload->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_action_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_action_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_action_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_action_search->terminate();
?>