<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_fp_list = new process_fp_list();

// Run the page
$process_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_fplist = currentForm = new ew.Form("fprocess_fplist", "list");
fprocess_fplist.formKeyCountName = '<?php echo $process_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fprocess_fplistsrch = currentSearchForm = new ew.Form("fprocess_fplistsrch");

// Filters
fprocess_fplistsrch.filterList = <?php echo $process_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_fp_list->TotalRecs > 0 && $process_fp_list->ExportOptions->visible()) { ?>
<?php $process_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_fp_list->ImportOptions->visible()) { ?>
<?php $process_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_fp_list->SearchOptions->visible()) { ?>
<?php $process_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_fp_list->FilterOptions->visible()) { ?>
<?php $process_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_fp->isExport() && !$process_fp->CurrentAction) { ?>
<form name="fprocess_fplistsrch" id="fprocess_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_fp_list->showPageHeader(); ?>
<?php
$process_fp_list->showMessage();
?>
<?php if ($process_fp_list->TotalRecs > 0 || $process_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_fp">
<?php if (!$process_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_fp_list->Pager)) $process_fp_list->Pager = new PrevNextPager($process_fp_list->StartRec, $process_fp_list->DisplayRecs, $process_fp_list->TotalRecs, $process_fp_list->AutoHidePager) ?>
<?php if ($process_fp_list->Pager->RecordCount > 0 && $process_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_fp_list->TotalRecs > 0 && (!$process_fp_list->AutoHidePageSizeSelector || $process_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_fplist" id="fprocess_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_fp">
<div id="gmp_process_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_fp_list->TotalRecs > 0 || $process_fp->isGridEdit()) { ?>
<table id="tbl_process_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_fp_list->renderListOptions();

// Render list options (header, left)
$process_fp_list->ListOptions->render("header", "left");
?>
<?php if ($process_fp->id->Visible) { // id ?>
	<?php if ($process_fp->sortUrl($process_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_fp->id->headerCellClass() ?>"><div id="elh_process_fp_id" class="process_fp_id"><div class="ew-table-header-caption"><?php echo $process_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->id) ?>',2);"><div id="elh_process_fp_id" class="process_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->product->Visible) { // product ?>
	<?php if ($process_fp->sortUrl($process_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $process_fp->product->headerCellClass() ?>"><div id="elh_process_fp_product" class="process_fp_product"><div class="ew-table-header-caption"><?php echo $process_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $process_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->product) ?>',2);"><div id="elh_process_fp_product" class="process_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->product_n->Visible) { // product_n ?>
	<?php if ($process_fp->sortUrl($process_fp->product_n) == "") { ?>
		<th data-name="product_n" class="<?php echo $process_fp->product_n->headerCellClass() ?>"><div id="elh_process_fp_product_n" class="process_fp_product_n"><div class="ew-table-header-caption"><?php echo $process_fp->product_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_n" class="<?php echo $process_fp->product_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->product_n) ?>',2);"><div id="elh_process_fp_product_n" class="process_fp_product_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->product_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_fp->product_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->product_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->rid->Visible) { // rid ?>
	<?php if ($process_fp->sortUrl($process_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $process_fp->rid->headerCellClass() ?>"><div id="elh_process_fp_rid" class="process_fp_rid"><div class="ew-table-header-caption"><?php echo $process_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $process_fp->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->rid) ?>',2);"><div id="elh_process_fp_rid" class="process_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->code->Visible) { // code ?>
	<?php if ($process_fp->sortUrl($process_fp->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_fp->code->headerCellClass() ?>"><div id="elh_process_fp_code" class="process_fp_code"><div class="ew-table-header-caption"><?php echo $process_fp->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_fp->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->code) ?>',2);"><div id="elh_process_fp_code" class="process_fp_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_fp->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->product_code->Visible) { // product_code ?>
	<?php if ($process_fp->sortUrl($process_fp->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $process_fp->product_code->headerCellClass() ?>"><div id="elh_process_fp_product_code" class="process_fp_product_code"><div class="ew-table-header-caption"><?php echo $process_fp->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $process_fp->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->product_code) ?>',2);"><div id="elh_process_fp_product_code" class="process_fp_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_fp->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->process_type->Visible) { // process_type ?>
	<?php if ($process_fp->sortUrl($process_fp->process_type) == "") { ?>
		<th data-name="process_type" class="<?php echo $process_fp->process_type->headerCellClass() ?>"><div id="elh_process_fp_process_type" class="process_fp_process_type"><div class="ew-table-header-caption"><?php echo $process_fp->process_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_type" class="<?php echo $process_fp->process_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->process_type) ?>',2);"><div id="elh_process_fp_process_type" class="process_fp_process_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->process_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->process_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->process_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->packets->Visible) { // packets ?>
	<?php if ($process_fp->sortUrl($process_fp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $process_fp->packets->headerCellClass() ?>"><div id="elh_process_fp_packets" class="process_fp_packets"><div class="ew-table-header-caption"><?php echo $process_fp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $process_fp->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->packets) ?>',2);"><div id="elh_process_fp_packets" class="process_fp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->packing_type->Visible) { // packing_type ?>
	<?php if ($process_fp->sortUrl($process_fp->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $process_fp->packing_type->headerCellClass() ?>"><div id="elh_process_fp_packing_type" class="process_fp_packing_type"><div class="ew-table-header-caption"><?php echo $process_fp->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $process_fp->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->packing_type) ?>',2);"><div id="elh_process_fp_packing_type" class="process_fp_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->godown->Visible) { // godown ?>
	<?php if ($process_fp->sortUrl($process_fp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $process_fp->godown->headerCellClass() ?>"><div id="elh_process_fp_godown" class="process_fp_godown"><div class="ew-table-header-caption"><?php echo $process_fp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $process_fp->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->godown) ?>',2);"><div id="elh_process_fp_godown" class="process_fp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->godown_n->Visible) { // godown_n ?>
	<?php if ($process_fp->sortUrl($process_fp->godown_n) == "") { ?>
		<th data-name="godown_n" class="<?php echo $process_fp->godown_n->headerCellClass() ?>"><div id="elh_process_fp_godown_n" class="process_fp_godown_n"><div class="ew-table-header-caption"><?php echo $process_fp->godown_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown_n" class="<?php echo $process_fp->godown_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->godown_n) ?>',2);"><div id="elh_process_fp_godown_n" class="process_fp_godown_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->godown_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_fp->godown_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->godown_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->gcode->Visible) { // gcode ?>
	<?php if ($process_fp->sortUrl($process_fp->gcode) == "") { ?>
		<th data-name="gcode" class="<?php echo $process_fp->gcode->headerCellClass() ?>"><div id="elh_process_fp_gcode" class="process_fp_gcode"><div class="ew-table-header-caption"><?php echo $process_fp->gcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gcode" class="<?php echo $process_fp->gcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->gcode) ?>',2);"><div id="elh_process_fp_gcode" class="process_fp_gcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->gcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_fp->gcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->gcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->dated->Visible) { // dated ?>
	<?php if ($process_fp->sortUrl($process_fp->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $process_fp->dated->headerCellClass() ?>"><div id="elh_process_fp_dated" class="process_fp_dated"><div class="ew-table-header-caption"><?php echo $process_fp->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $process_fp->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->dated) ?>',2);"><div id="elh_process_fp_dated" class="process_fp_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->IN->Visible) { // IN ?>
	<?php if ($process_fp->sortUrl($process_fp->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $process_fp->IN->headerCellClass() ?>"><div id="elh_process_fp_IN" class="process_fp_IN"><div class="ew-table-header-caption"><?php echo $process_fp->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $process_fp->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->IN) ?>',2);"><div id="elh_process_fp_IN" class="process_fp_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->OUT->Visible) { // OUT ?>
	<?php if ($process_fp->sortUrl($process_fp->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $process_fp->OUT->headerCellClass() ?>"><div id="elh_process_fp_OUT" class="process_fp_OUT"><div class="ew-table-header-caption"><?php echo $process_fp->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $process_fp->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->OUT) ?>',2);"><div id="elh_process_fp_OUT" class="process_fp_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->Balance->Visible) { // Balance ?>
	<?php if ($process_fp->sortUrl($process_fp->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $process_fp->Balance->headerCellClass() ?>"><div id="elh_process_fp_Balance" class="process_fp_Balance"><div class="ew-table-header-caption"><?php echo $process_fp->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $process_fp->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->Balance) ?>',2);"><div id="elh_process_fp_Balance" class="process_fp_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->remarks->Visible) { // remarks ?>
	<?php if ($process_fp->sortUrl($process_fp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_fp->remarks->headerCellClass() ?>"><div id="elh_process_fp_remarks" class="process_fp_remarks"><div class="ew-table-header-caption"><?php echo $process_fp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_fp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->remarks) ?>',2);"><div id="elh_process_fp_remarks" class="process_fp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_fp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_fp->status->Visible) { // status ?>
	<?php if ($process_fp->sortUrl($process_fp->status) == "") { ?>
		<th data-name="status" class="<?php echo $process_fp->status->headerCellClass() ?>"><div id="elh_process_fp_status" class="process_fp_status"><div class="ew-table-header-caption"><?php echo $process_fp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $process_fp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_fp->SortUrl($process_fp->status) ?>',2);"><div id="elh_process_fp_status" class="process_fp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_fp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_fp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_fp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_fp->ExportAll && $process_fp->isExport()) {
	$process_fp_list->StopRec = $process_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_fp_list->TotalRecs > $process_fp_list->StartRec + $process_fp_list->DisplayRecs - 1)
		$process_fp_list->StopRec = $process_fp_list->StartRec + $process_fp_list->DisplayRecs - 1;
	else
		$process_fp_list->StopRec = $process_fp_list->TotalRecs;
}
$process_fp_list->RecCnt = $process_fp_list->StartRec - 1;
if ($process_fp_list->Recordset && !$process_fp_list->Recordset->EOF) {
	$process_fp_list->Recordset->moveFirst();
	$selectLimit = $process_fp_list->UseSelectLimit;
	if (!$selectLimit && $process_fp_list->StartRec > 1)
		$process_fp_list->Recordset->move($process_fp_list->StartRec - 1);
} elseif (!$process_fp->AllowAddDeleteRow && $process_fp_list->StopRec == 0) {
	$process_fp_list->StopRec = $process_fp->GridAddRowCount;
}

// Initialize aggregate
$process_fp->RowType = ROWTYPE_AGGREGATEINIT;
$process_fp->resetAttributes();
$process_fp_list->renderRow();
while ($process_fp_list->RecCnt < $process_fp_list->StopRec) {
	$process_fp_list->RecCnt++;
	if ($process_fp_list->RecCnt >= $process_fp_list->StartRec) {
		$process_fp_list->RowCnt++;

		// Set up key count
		$process_fp_list->KeyCount = $process_fp_list->RowIndex;

		// Init row class and style
		$process_fp->resetAttributes();
		$process_fp->CssClass = "";
		if ($process_fp->isGridAdd()) {
		} else {
			$process_fp_list->loadRowValues($process_fp_list->Recordset); // Load row values
		}
		$process_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_fp->RowAttrs = array_merge($process_fp->RowAttrs, array('data-rowindex'=>$process_fp_list->RowCnt, 'id'=>'r' . $process_fp_list->RowCnt . '_process_fp', 'data-rowtype'=>$process_fp->RowType));

		// Render row
		$process_fp_list->renderRow();

		// Render list options
		$process_fp_list->renderListOptions();
?>
	<tr<?php echo $process_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_fp_list->ListOptions->render("body", "left", $process_fp_list->RowCnt);
?>
	<?php if ($process_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_fp->id->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_id" class="process_fp_id">
<span<?php echo $process_fp->id->viewAttributes() ?>>
<?php echo $process_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $process_fp->product->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_product" class="process_fp_product">
<span<?php echo $process_fp->product->viewAttributes() ?>>
<?php echo $process_fp->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->product_n->Visible) { // product_n ?>
		<td data-name="product_n"<?php echo $process_fp->product_n->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_product_n" class="process_fp_product_n">
<span<?php echo $process_fp->product_n->viewAttributes() ?>>
<?php echo $process_fp->product_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $process_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_rid" class="process_fp_rid">
<span<?php echo $process_fp->rid->viewAttributes() ?>>
<?php echo $process_fp->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_fp->code->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_code" class="process_fp_code">
<span<?php echo $process_fp->code->viewAttributes() ?>>
<?php echo $process_fp->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $process_fp->product_code->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_product_code" class="process_fp_product_code">
<span<?php echo $process_fp->product_code->viewAttributes() ?>>
<?php echo $process_fp->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->process_type->Visible) { // process_type ?>
		<td data-name="process_type"<?php echo $process_fp->process_type->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_process_type" class="process_fp_process_type">
<span<?php echo $process_fp->process_type->viewAttributes() ?>>
<?php echo $process_fp->process_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $process_fp->packets->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_packets" class="process_fp_packets">
<span<?php echo $process_fp->packets->viewAttributes() ?>>
<?php echo $process_fp->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $process_fp->packing_type->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_packing_type" class="process_fp_packing_type">
<span<?php echo $process_fp->packing_type->viewAttributes() ?>>
<?php echo $process_fp->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $process_fp->godown->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_godown" class="process_fp_godown">
<span<?php echo $process_fp->godown->viewAttributes() ?>>
<?php echo $process_fp->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->godown_n->Visible) { // godown_n ?>
		<td data-name="godown_n"<?php echo $process_fp->godown_n->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_godown_n" class="process_fp_godown_n">
<span<?php echo $process_fp->godown_n->viewAttributes() ?>>
<?php echo $process_fp->godown_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->gcode->Visible) { // gcode ?>
		<td data-name="gcode"<?php echo $process_fp->gcode->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_gcode" class="process_fp_gcode">
<span<?php echo $process_fp->gcode->viewAttributes() ?>>
<?php echo $process_fp->gcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $process_fp->dated->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_dated" class="process_fp_dated">
<span<?php echo $process_fp->dated->viewAttributes() ?>>
<?php echo $process_fp->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $process_fp->IN->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_IN" class="process_fp_IN">
<span<?php echo $process_fp->IN->viewAttributes() ?>>
<?php echo $process_fp->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $process_fp->OUT->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_OUT" class="process_fp_OUT">
<span<?php echo $process_fp->OUT->viewAttributes() ?>>
<?php echo $process_fp->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $process_fp->Balance->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_Balance" class="process_fp_Balance">
<span<?php echo $process_fp->Balance->viewAttributes() ?>>
<?php echo $process_fp->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_fp->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_remarks" class="process_fp_remarks">
<span<?php echo $process_fp->remarks->viewAttributes() ?>>
<?php echo $process_fp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_fp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $process_fp->status->cellAttributes() ?>>
<span id="el<?php echo $process_fp_list->RowCnt ?>_process_fp_status" class="process_fp_status">
<span<?php echo $process_fp->status->viewAttributes() ?>>
<?php echo $process_fp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_fp_list->ListOptions->render("body", "right", $process_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_fp->isGridAdd())
		$process_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_fp_list->Recordset)
	$process_fp_list->Recordset->Close();
?>
<?php if (!$process_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_fp_list->Pager)) $process_fp_list->Pager = new PrevNextPager($process_fp_list->StartRec, $process_fp_list->DisplayRecs, $process_fp_list->TotalRecs, $process_fp_list->AutoHidePager) ?>
<?php if ($process_fp_list->Pager->RecordCount > 0 && $process_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_fp_list->pageUrl() ?>start=<?php echo $process_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_fp_list->TotalRecs > 0 && (!$process_fp_list->AutoHidePageSizeSelector || $process_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_fp_list->TotalRecs == 0 && !$process_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_fp_list->terminate();
?>