<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_house_delete = new process_house_delete();

// Run the page
$process_house_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_house_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fprocess_housedelete = currentForm = new ew.Form("fprocess_housedelete", "delete");

// Form_CustomValidate event
fprocess_housedelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_housedelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_housedelete.lists["x_grp"] = <?php echo $process_house_delete->grp->Lookup->toClientList() ?>;
fprocess_housedelete.lists["x_grp"].options = <?php echo JsonEncode($process_house_delete->grp->options(FALSE, TRUE)) ?>;
fprocess_housedelete.lists["x_status"] = <?php echo $process_house_delete->status->Lookup->toClientList() ?>;
fprocess_housedelete.lists["x_status"].options = <?php echo JsonEncode($process_house_delete->status->options(FALSE, TRUE)) ?>;
fprocess_housedelete.lists["x_operator"] = <?php echo $process_house_delete->operator->Lookup->toClientList() ?>;
fprocess_housedelete.lists["x_operator"].options = <?php echo JsonEncode($process_house_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_house_delete->showPageHeader(); ?>
<?php
$process_house_delete->showMessage();
?>
<form name="fprocess_housedelete" id="fprocess_housedelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_house_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_house_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_house">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($process_house_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($process_house->id->Visible) { // id ?>
		<th class="<?php echo $process_house->id->headerCellClass() ?>"><span id="elh_process_house_id" class="process_house_id"><?php echo $process_house->id->caption() ?></span></th>
<?php } ?>
<?php if ($process_house->grp->Visible) { // grp ?>
		<th class="<?php echo $process_house->grp->headerCellClass() ?>"><span id="elh_process_house_grp" class="process_house_grp"><?php echo $process_house->grp->caption() ?></span></th>
<?php } ?>
<?php if ($process_house->name->Visible) { // name ?>
		<th class="<?php echo $process_house->name->headerCellClass() ?>"><span id="elh_process_house_name" class="process_house_name"><?php echo $process_house->name->caption() ?></span></th>
<?php } ?>
<?php if ($process_house->location->Visible) { // location ?>
		<th class="<?php echo $process_house->location->headerCellClass() ?>"><span id="elh_process_house_location" class="process_house_location"><?php echo $process_house->location->caption() ?></span></th>
<?php } ?>
<?php if ($process_house->code->Visible) { // code ?>
		<th class="<?php echo $process_house->code->headerCellClass() ?>"><span id="elh_process_house_code" class="process_house_code"><?php echo $process_house->code->caption() ?></span></th>
<?php } ?>
<?php if ($process_house->status->Visible) { // status ?>
		<th class="<?php echo $process_house->status->headerCellClass() ?>"><span id="elh_process_house_status" class="process_house_status"><?php echo $process_house->status->caption() ?></span></th>
<?php } ?>
<?php if ($process_house->operator->Visible) { // operator ?>
		<th class="<?php echo $process_house->operator->headerCellClass() ?>"><span id="elh_process_house_operator" class="process_house_operator"><?php echo $process_house->operator->caption() ?></span></th>
<?php } ?>
<?php if ($process_house->datetime->Visible) { // datetime ?>
		<th class="<?php echo $process_house->datetime->headerCellClass() ?>"><span id="elh_process_house_datetime" class="process_house_datetime"><?php echo $process_house->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$process_house_delete->RecCnt = 0;
$i = 0;
while (!$process_house_delete->Recordset->EOF) {
	$process_house_delete->RecCnt++;
	$process_house_delete->RowCnt++;

	// Set row properties
	$process_house->resetAttributes();
	$process_house->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$process_house_delete->loadRowValues($process_house_delete->Recordset);

	// Render row
	$process_house_delete->renderRow();
?>
	<tr<?php echo $process_house->rowAttributes() ?>>
<?php if ($process_house->id->Visible) { // id ?>
		<td<?php echo $process_house->id->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_id" class="process_house_id">
<span<?php echo $process_house->id->viewAttributes() ?>>
<?php echo $process_house->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($process_house->grp->Visible) { // grp ?>
		<td<?php echo $process_house->grp->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_grp" class="process_house_grp">
<span<?php echo $process_house->grp->viewAttributes() ?>>
<?php echo $process_house->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($process_house->name->Visible) { // name ?>
		<td<?php echo $process_house->name->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_name" class="process_house_name">
<span<?php echo $process_house->name->viewAttributes() ?>>
<?php echo $process_house->name->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($process_house->location->Visible) { // location ?>
		<td<?php echo $process_house->location->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_location" class="process_house_location">
<span<?php echo $process_house->location->viewAttributes() ?>>
<?php echo $process_house->location->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($process_house->code->Visible) { // code ?>
		<td<?php echo $process_house->code->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_code" class="process_house_code">
<span<?php echo $process_house->code->viewAttributes() ?>>
<?php echo $process_house->code->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($process_house->status->Visible) { // status ?>
		<td<?php echo $process_house->status->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_status" class="process_house_status">
<span<?php echo $process_house->status->viewAttributes() ?>>
<?php echo $process_house->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($process_house->operator->Visible) { // operator ?>
		<td<?php echo $process_house->operator->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_operator" class="process_house_operator">
<span<?php echo $process_house->operator->viewAttributes() ?>>
<?php echo $process_house->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($process_house->datetime->Visible) { // datetime ?>
		<td<?php echo $process_house->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_house_delete->RowCnt ?>_process_house_datetime" class="process_house_datetime">
<span<?php echo $process_house->datetime->viewAttributes() ?>>
<?php echo $process_house->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$process_house_delete->Recordset->moveNext();
}
$process_house_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $process_house_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$process_house_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_house_delete->terminate();
?>