<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_house_edit = new process_house_edit();

// Run the page
$process_house_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_house_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fprocess_houseedit = currentForm = new ew.Form("fprocess_houseedit", "edit");

// Validate form
fprocess_houseedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_house_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->id->caption(), $process_house->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_house_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->grp->caption(), $process_house->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_house_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->name->caption(), $process_house->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_house_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->location->caption(), $process_house->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_house_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->code->caption(), $process_house->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($process_house->code->errorMessage()) ?>");
		<?php if ($process_house_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->status->caption(), $process_house->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_house_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->operator->caption(), $process_house->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_house_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_house->datetime->caption(), $process_house->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_houseedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_houseedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_houseedit.lists["x_grp"] = <?php echo $process_house_edit->grp->Lookup->toClientList() ?>;
fprocess_houseedit.lists["x_grp"].options = <?php echo JsonEncode($process_house_edit->grp->options(FALSE, TRUE)) ?>;
fprocess_houseedit.lists["x_status"] = <?php echo $process_house_edit->status->Lookup->toClientList() ?>;
fprocess_houseedit.lists["x_status"].options = <?php echo JsonEncode($process_house_edit->status->options(FALSE, TRUE)) ?>;
fprocess_houseedit.lists["x_operator"] = <?php echo $process_house_edit->operator->Lookup->toClientList() ?>;
fprocess_houseedit.lists["x_operator"].options = <?php echo JsonEncode($process_house_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_house_edit->showPageHeader(); ?>
<?php
$process_house_edit->showMessage();
?>
<form name="fprocess_houseedit" id="fprocess_houseedit" class="<?php echo $process_house_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_house_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_house_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_house">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$process_house_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($process_house->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_process_house_id" class="<?php echo $process_house_edit->LeftColumnClass ?>"><?php echo $process_house->id->caption() ?><?php echo ($process_house->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_house_edit->RightColumnClass ?>"><div<?php echo $process_house->id->cellAttributes() ?>>
<span id="el_process_house_id">
<span<?php echo $process_house->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($process_house->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="process_house" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($process_house->id->CurrentValue) ?>">
<?php echo $process_house->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_house->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_process_house_grp" for="x_grp" class="<?php echo $process_house_edit->LeftColumnClass ?>"><?php echo $process_house->grp->caption() ?><?php echo ($process_house->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_house_edit->RightColumnClass ?>"><div<?php echo $process_house->grp->cellAttributes() ?>>
<span id="el_process_house_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_house" data-field="x_grp" data-value-separator="<?php echo $process_house->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_house->grp->editAttributes() ?>>
		<?php echo $process_house->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $process_house->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_house->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_process_house_name" for="x_name" class="<?php echo $process_house_edit->LeftColumnClass ?>"><?php echo $process_house->name->caption() ?><?php echo ($process_house->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_house_edit->RightColumnClass ?>"><div<?php echo $process_house->name->cellAttributes() ?>>
<span id="el_process_house_name">
<input type="text" data-table="process_house" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_house->name->getPlaceHolder()) ?>" value="<?php echo $process_house->name->EditValue ?>"<?php echo $process_house->name->editAttributes() ?>>
</span>
<?php echo $process_house->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_house->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_process_house_location" for="x_location" class="<?php echo $process_house_edit->LeftColumnClass ?>"><?php echo $process_house->location->caption() ?><?php echo ($process_house->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_house_edit->RightColumnClass ?>"><div<?php echo $process_house->location->cellAttributes() ?>>
<span id="el_process_house_location">
<textarea data-table="process_house" data-field="x_location" name="x_location" id="x_location" cols="30" rows="4" placeholder="<?php echo HtmlEncode($process_house->location->getPlaceHolder()) ?>"<?php echo $process_house->location->editAttributes() ?>><?php echo $process_house->location->EditValue ?></textarea>
</span>
<?php echo $process_house->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_house->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_process_house_code" for="x_code" class="<?php echo $process_house_edit->LeftColumnClass ?>"><?php echo $process_house->code->caption() ?><?php echo ($process_house->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_house_edit->RightColumnClass ?>"><div<?php echo $process_house->code->cellAttributes() ?>>
<span id="el_process_house_code">
<input type="text" data-table="process_house" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($process_house->code->getPlaceHolder()) ?>" value="<?php echo $process_house->code->EditValue ?>"<?php echo $process_house->code->editAttributes() ?>>
</span>
<?php echo $process_house->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_house->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_process_house_status" for="x_status" class="<?php echo $process_house_edit->LeftColumnClass ?>"><?php echo $process_house->status->caption() ?><?php echo ($process_house->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_house_edit->RightColumnClass ?>"><div<?php echo $process_house->status->cellAttributes() ?>>
<span id="el_process_house_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_house" data-field="x_status" data-value-separator="<?php echo $process_house->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process_house->status->editAttributes() ?>>
		<?php echo $process_house->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $process_house->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_house_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_house_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $process_house_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_house_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_house_edit->terminate();
?>