<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_house_list = new process_house_list();

// Run the page
$process_house_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_house_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_house->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_houselist = currentForm = new ew.Form("fprocess_houselist", "list");
fprocess_houselist.formKeyCountName = '<?php echo $process_house_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_houselist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_houselist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_houselist.lists["x_grp"] = <?php echo $process_house_list->grp->Lookup->toClientList() ?>;
fprocess_houselist.lists["x_grp"].options = <?php echo JsonEncode($process_house_list->grp->options(FALSE, TRUE)) ?>;
fprocess_houselist.lists["x_status"] = <?php echo $process_house_list->status->Lookup->toClientList() ?>;
fprocess_houselist.lists["x_status"].options = <?php echo JsonEncode($process_house_list->status->options(FALSE, TRUE)) ?>;
fprocess_houselist.lists["x_operator"] = <?php echo $process_house_list->operator->Lookup->toClientList() ?>;
fprocess_houselist.lists["x_operator"].options = <?php echo JsonEncode($process_house_list->operator->lookupOptions()) ?>;

// Form object for search
var fprocess_houselistsrch = currentSearchForm = new ew.Form("fprocess_houselistsrch");

// Filters
fprocess_houselistsrch.filterList = <?php echo $process_house_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_houselistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_house->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_house_list->TotalRecs > 0 && $process_house_list->ExportOptions->visible()) { ?>
<?php $process_house_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_house_list->ImportOptions->visible()) { ?>
<?php $process_house_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_house_list->SearchOptions->visible()) { ?>
<?php $process_house_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_house_list->FilterOptions->visible()) { ?>
<?php $process_house_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_house_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_house->isExport() && !$process_house->CurrentAction) { ?>
<form name="fprocess_houselistsrch" id="fprocess_houselistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_house_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_houselistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_house">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_house_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_house_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_house_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_house_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_house_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_house_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_house_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_house_list->showPageHeader(); ?>
<?php
$process_house_list->showMessage();
?>
<?php if ($process_house_list->TotalRecs > 0 || $process_house->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_house_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_house">
<?php if (!$process_house->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_house->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_house_list->Pager)) $process_house_list->Pager = new PrevNextPager($process_house_list->StartRec, $process_house_list->DisplayRecs, $process_house_list->TotalRecs, $process_house_list->AutoHidePager) ?>
<?php if ($process_house_list->Pager->RecordCount > 0 && $process_house_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_house_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_house_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_house_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_house_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_house_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_house_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_house_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_house_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_house_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_house_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_house_list->TotalRecs > 0 && (!$process_house_list->AutoHidePageSizeSelector || $process_house_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_house">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_house_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_house_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_house_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_house_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_house_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_house->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_house_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_houselist" id="fprocess_houselist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_house_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_house_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_house">
<div id="gmp_process_house" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_house_list->TotalRecs > 0 || $process_house->isGridEdit()) { ?>
<table id="tbl_process_houselist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_house_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_house_list->renderListOptions();

// Render list options (header, left)
$process_house_list->ListOptions->render("header", "left");
?>
<?php if ($process_house->id->Visible) { // id ?>
	<?php if ($process_house->sortUrl($process_house->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_house->id->headerCellClass() ?>"><div id="elh_process_house_id" class="process_house_id"><div class="ew-table-header-caption"><?php echo $process_house->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_house->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->id) ?>',2);"><div id="elh_process_house_id" class="process_house_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_house->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_house->grp->Visible) { // grp ?>
	<?php if ($process_house->sortUrl($process_house->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $process_house->grp->headerCellClass() ?>"><div id="elh_process_house_grp" class="process_house_grp"><div class="ew-table-header-caption"><?php echo $process_house->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $process_house->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->grp) ?>',2);"><div id="elh_process_house_grp" class="process_house_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_house->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_house->name->Visible) { // name ?>
	<?php if ($process_house->sortUrl($process_house->name) == "") { ?>
		<th data-name="name" class="<?php echo $process_house->name->headerCellClass() ?>"><div id="elh_process_house_name" class="process_house_name"><div class="ew-table-header-caption"><?php echo $process_house->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $process_house->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->name) ?>',2);"><div id="elh_process_house_name" class="process_house_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_house->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_house->location->Visible) { // location ?>
	<?php if ($process_house->sortUrl($process_house->location) == "") { ?>
		<th data-name="location" class="<?php echo $process_house->location->headerCellClass() ?>"><div id="elh_process_house_location" class="process_house_location"><div class="ew-table-header-caption"><?php echo $process_house->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $process_house->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->location) ?>',2);"><div id="elh_process_house_location" class="process_house_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->location->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_house->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_house->code->Visible) { // code ?>
	<?php if ($process_house->sortUrl($process_house->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_house->code->headerCellClass() ?>"><div id="elh_process_house_code" class="process_house_code"><div class="ew-table-header-caption"><?php echo $process_house->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_house->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->code) ?>',2);"><div id="elh_process_house_code" class="process_house_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_house->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_house->status->Visible) { // status ?>
	<?php if ($process_house->sortUrl($process_house->status) == "") { ?>
		<th data-name="status" class="<?php echo $process_house->status->headerCellClass() ?>"><div id="elh_process_house_status" class="process_house_status"><div class="ew-table-header-caption"><?php echo $process_house->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $process_house->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->status) ?>',2);"><div id="elh_process_house_status" class="process_house_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_house->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_house->operator->Visible) { // operator ?>
	<?php if ($process_house->sortUrl($process_house->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_house->operator->headerCellClass() ?>"><div id="elh_process_house_operator" class="process_house_operator"><div class="ew-table-header-caption"><?php echo $process_house->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_house->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->operator) ?>',2);"><div id="elh_process_house_operator" class="process_house_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_house->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_house->datetime->Visible) { // datetime ?>
	<?php if ($process_house->sortUrl($process_house->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_house->datetime->headerCellClass() ?>"><div id="elh_process_house_datetime" class="process_house_datetime"><div class="ew-table-header-caption"><?php echo $process_house->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_house->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_house->SortUrl($process_house->datetime) ?>',2);"><div id="elh_process_house_datetime" class="process_house_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_house->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_house->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_house->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_house_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_house->ExportAll && $process_house->isExport()) {
	$process_house_list->StopRec = $process_house_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_house_list->TotalRecs > $process_house_list->StartRec + $process_house_list->DisplayRecs - 1)
		$process_house_list->StopRec = $process_house_list->StartRec + $process_house_list->DisplayRecs - 1;
	else
		$process_house_list->StopRec = $process_house_list->TotalRecs;
}
$process_house_list->RecCnt = $process_house_list->StartRec - 1;
if ($process_house_list->Recordset && !$process_house_list->Recordset->EOF) {
	$process_house_list->Recordset->moveFirst();
	$selectLimit = $process_house_list->UseSelectLimit;
	if (!$selectLimit && $process_house_list->StartRec > 1)
		$process_house_list->Recordset->move($process_house_list->StartRec - 1);
} elseif (!$process_house->AllowAddDeleteRow && $process_house_list->StopRec == 0) {
	$process_house_list->StopRec = $process_house->GridAddRowCount;
}

// Initialize aggregate
$process_house->RowType = ROWTYPE_AGGREGATEINIT;
$process_house->resetAttributes();
$process_house_list->renderRow();
while ($process_house_list->RecCnt < $process_house_list->StopRec) {
	$process_house_list->RecCnt++;
	if ($process_house_list->RecCnt >= $process_house_list->StartRec) {
		$process_house_list->RowCnt++;

		// Set up key count
		$process_house_list->KeyCount = $process_house_list->RowIndex;

		// Init row class and style
		$process_house->resetAttributes();
		$process_house->CssClass = "";
		if ($process_house->isGridAdd()) {
		} else {
			$process_house_list->loadRowValues($process_house_list->Recordset); // Load row values
		}
		$process_house->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_house->RowAttrs = array_merge($process_house->RowAttrs, array('data-rowindex'=>$process_house_list->RowCnt, 'id'=>'r' . $process_house_list->RowCnt . '_process_house', 'data-rowtype'=>$process_house->RowType));

		// Render row
		$process_house_list->renderRow();

		// Render list options
		$process_house_list->renderListOptions();
?>
	<tr<?php echo $process_house->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_house_list->ListOptions->render("body", "left", $process_house_list->RowCnt);
?>
	<?php if ($process_house->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_house->id->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_id" class="process_house_id">
<span<?php echo $process_house->id->viewAttributes() ?>>
<?php echo $process_house->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_house->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $process_house->grp->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_grp" class="process_house_grp">
<span<?php echo $process_house->grp->viewAttributes() ?>>
<?php echo $process_house->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_house->name->Visible) { // name ?>
		<td data-name="name"<?php echo $process_house->name->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_name" class="process_house_name">
<span<?php echo $process_house->name->viewAttributes() ?>>
<?php echo $process_house->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_house->location->Visible) { // location ?>
		<td data-name="location"<?php echo $process_house->location->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_location" class="process_house_location">
<span<?php echo $process_house->location->viewAttributes() ?>>
<?php echo $process_house->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_house->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_house->code->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_code" class="process_house_code">
<span<?php echo $process_house->code->viewAttributes() ?>>
<?php echo $process_house->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_house->status->Visible) { // status ?>
		<td data-name="status"<?php echo $process_house->status->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_status" class="process_house_status">
<span<?php echo $process_house->status->viewAttributes() ?>>
<?php echo $process_house->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_house->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_house->operator->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_operator" class="process_house_operator">
<span<?php echo $process_house->operator->viewAttributes() ?>>
<?php echo $process_house->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_house->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_house->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_house_list->RowCnt ?>_process_house_datetime" class="process_house_datetime">
<span<?php echo $process_house->datetime->viewAttributes() ?>>
<?php echo $process_house->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_house_list->ListOptions->render("body", "right", $process_house_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_house->isGridAdd())
		$process_house_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_house->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_house_list->Recordset)
	$process_house_list->Recordset->Close();
?>
<?php if (!$process_house->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_house->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_house_list->Pager)) $process_house_list->Pager = new PrevNextPager($process_house_list->StartRec, $process_house_list->DisplayRecs, $process_house_list->TotalRecs, $process_house_list->AutoHidePager) ?>
<?php if ($process_house_list->Pager->RecordCount > 0 && $process_house_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_house_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_house_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_house_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_house_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_house_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_house_list->pageUrl() ?>start=<?php echo $process_house_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_house_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_house_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_house_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_house_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_house_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_house_list->TotalRecs > 0 && (!$process_house_list->AutoHidePageSizeSelector || $process_house_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_house">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_house_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_house_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_house_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_house_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_house_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_house->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_house_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_house_list->TotalRecs == 0 && !$process_house->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_house_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_house_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_house->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_house->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_house", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_house_list->terminate();
?>