<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_house_view = new process_house_view();

// Run the page
$process_house_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_house_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_house->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fprocess_houseview = currentForm = new ew.Form("fprocess_houseview", "view");

// Form_CustomValidate event
fprocess_houseview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_houseview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_houseview.lists["x_grp"] = <?php echo $process_house_view->grp->Lookup->toClientList() ?>;
fprocess_houseview.lists["x_grp"].options = <?php echo JsonEncode($process_house_view->grp->options(FALSE, TRUE)) ?>;
fprocess_houseview.lists["x_status"] = <?php echo $process_house_view->status->Lookup->toClientList() ?>;
fprocess_houseview.lists["x_status"].options = <?php echo JsonEncode($process_house_view->status->options(FALSE, TRUE)) ?>;
fprocess_houseview.lists["x_operator"] = <?php echo $process_house_view->operator->Lookup->toClientList() ?>;
fprocess_houseview.lists["x_operator"].options = <?php echo JsonEncode($process_house_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_house->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $process_house_view->ExportOptions->render("body") ?>
<?php $process_house_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $process_house_view->showPageHeader(); ?>
<?php
$process_house_view->showMessage();
?>
<form name="fprocess_houseview" id="fprocess_houseview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_house_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_house_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_house">
<input type="hidden" name="modal" value="<?php echo (int)$process_house_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($process_house->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_id"><?php echo $process_house->id->caption() ?></span></td>
		<td data-name="id"<?php echo $process_house->id->cellAttributes() ?>>
<span id="el_process_house_id">
<span<?php echo $process_house->id->viewAttributes() ?>>
<?php echo $process_house->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_house->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_grp"><?php echo $process_house->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $process_house->grp->cellAttributes() ?>>
<span id="el_process_house_grp">
<span<?php echo $process_house->grp->viewAttributes() ?>>
<?php echo $process_house->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_house->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_name"><?php echo $process_house->name->caption() ?></span></td>
		<td data-name="name"<?php echo $process_house->name->cellAttributes() ?>>
<span id="el_process_house_name">
<span<?php echo $process_house->name->viewAttributes() ?>>
<?php echo $process_house->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_house->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_location"><?php echo $process_house->location->caption() ?></span></td>
		<td data-name="location"<?php echo $process_house->location->cellAttributes() ?>>
<span id="el_process_house_location">
<span<?php echo $process_house->location->viewAttributes() ?>>
<?php echo $process_house->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_house->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_code"><?php echo $process_house->code->caption() ?></span></td>
		<td data-name="code"<?php echo $process_house->code->cellAttributes() ?>>
<span id="el_process_house_code">
<span<?php echo $process_house->code->viewAttributes() ?>>
<?php echo $process_house->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_house->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_status"><?php echo $process_house->status->caption() ?></span></td>
		<td data-name="status"<?php echo $process_house->status->cellAttributes() ?>>
<span id="el_process_house_status">
<span<?php echo $process_house->status->viewAttributes() ?>>
<?php echo $process_house->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_house->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_operator"><?php echo $process_house->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $process_house->operator->cellAttributes() ?>>
<span id="el_process_house_operator">
<span<?php echo $process_house->operator->viewAttributes() ?>>
<?php echo $process_house->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_house->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $process_house_view->TableLeftColumnClass ?>"><span id="elh_process_house_datetime"><?php echo $process_house->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $process_house->datetime->cellAttributes() ?>>
<span id="el_process_house_datetime">
<span<?php echo $process_house->datetime->viewAttributes() ?>>
<?php echo $process_house->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$process_house_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_house->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_house_view->terminate();
?>