<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_mismatch_list = new process_mismatch_list();

// Run the page
$process_mismatch_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_mismatch_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_mismatch->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_mismatchlist = currentForm = new ew.Form("fprocess_mismatchlist", "list");
fprocess_mismatchlist.formKeyCountName = '<?php echo $process_mismatch_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_mismatchlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_mismatchlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_mismatchlist.lists["x_process"] = <?php echo $process_mismatch_list->process->Lookup->toClientList() ?>;
fprocess_mismatchlist.lists["x_process"].options = <?php echo JsonEncode($process_mismatch_list->process->lookupOptions()) ?>;
fprocess_mismatchlist.lists["x_process_other[]"] = <?php echo $process_mismatch_list->process_other->Lookup->toClientList() ?>;
fprocess_mismatchlist.lists["x_process_other[]"].options = <?php echo JsonEncode($process_mismatch_list->process_other->lookupOptions()) ?>;
fprocess_mismatchlist.lists["x_process_c[]"] = <?php echo $process_mismatch_list->process_c->Lookup->toClientList() ?>;
fprocess_mismatchlist.lists["x_process_c[]"].options = <?php echo JsonEncode($process_mismatch_list->process_c->lookupOptions()) ?>;
fprocess_mismatchlist.lists["x_operator"] = <?php echo $process_mismatch_list->operator->Lookup->toClientList() ?>;
fprocess_mismatchlist.lists["x_operator"].options = <?php echo JsonEncode($process_mismatch_list->operator->lookupOptions()) ?>;

// Form object for search
var fprocess_mismatchlistsrch = currentSearchForm = new ew.Form("fprocess_mismatchlistsrch");

// Filters
fprocess_mismatchlistsrch.filterList = <?php echo $process_mismatch_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_mismatchlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_mismatch->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_mismatch_list->TotalRecs > 0 && $process_mismatch_list->ExportOptions->visible()) { ?>
<?php $process_mismatch_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_mismatch_list->ImportOptions->visible()) { ?>
<?php $process_mismatch_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_mismatch_list->SearchOptions->visible()) { ?>
<?php $process_mismatch_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_mismatch_list->FilterOptions->visible()) { ?>
<?php $process_mismatch_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_mismatch_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_mismatch->isExport() && !$process_mismatch->CurrentAction) { ?>
<form name="fprocess_mismatchlistsrch" id="fprocess_mismatchlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_mismatch_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_mismatchlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_mismatch">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_mismatch_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_mismatch_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_mismatch_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_mismatch_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_mismatch_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_mismatch_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_mismatch_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_mismatch_list->showPageHeader(); ?>
<?php
$process_mismatch_list->showMessage();
?>
<?php if ($process_mismatch_list->TotalRecs > 0 || $process_mismatch->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_mismatch_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_mismatch">
<?php if (!$process_mismatch->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_mismatch->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_mismatch_list->Pager)) $process_mismatch_list->Pager = new PrevNextPager($process_mismatch_list->StartRec, $process_mismatch_list->DisplayRecs, $process_mismatch_list->TotalRecs, $process_mismatch_list->AutoHidePager) ?>
<?php if ($process_mismatch_list->Pager->RecordCount > 0 && $process_mismatch_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_mismatch_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_mismatch_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_mismatch_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_mismatch_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_mismatch_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_mismatch_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_mismatch_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_mismatch_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_mismatch_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_mismatch_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_mismatch_list->TotalRecs > 0 && (!$process_mismatch_list->AutoHidePageSizeSelector || $process_mismatch_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_mismatch">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_mismatch_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_mismatch_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_mismatch_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_mismatch_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_mismatch_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_mismatch->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_mismatch_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_mismatchlist" id="fprocess_mismatchlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_mismatch_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_mismatch_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_mismatch">
<div id="gmp_process_mismatch" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_mismatch_list->TotalRecs > 0 || $process_mismatch->isGridEdit()) { ?>
<table id="tbl_process_mismatchlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_mismatch_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_mismatch_list->renderListOptions();

// Render list options (header, left)
$process_mismatch_list->ListOptions->render("header", "left");
?>
<?php if ($process_mismatch->_barcode->Visible) { // barcode ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $process_mismatch->_barcode->headerCellClass() ?>"><div id="elh_process_mismatch__barcode" class="process_mismatch__barcode"><div class="ew-table-header-caption"><?php echo $process_mismatch->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $process_mismatch->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->_barcode) ?>',2);"><div id="elh_process_mismatch__barcode" class="process_mismatch__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_mismatch->code->Visible) { // code ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_mismatch->code->headerCellClass() ?>"><div id="elh_process_mismatch_code" class="process_mismatch_code"><div class="ew-table-header-caption"><?php echo $process_mismatch->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_mismatch->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->code) ?>',2);"><div id="elh_process_mismatch_code" class="process_mismatch_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->code->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_mismatch->process->Visible) { // process ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_mismatch->process->headerCellClass() ?>"><div id="elh_process_mismatch_process" class="process_mismatch_process"><div class="ew-table-header-caption"><?php echo $process_mismatch->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_mismatch->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->process) ?>',2);"><div id="elh_process_mismatch_process" class="process_mismatch_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_mismatch->process_other->Visible) { // process_other ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->process_other) == "") { ?>
		<th data-name="process_other" class="<?php echo $process_mismatch->process_other->headerCellClass() ?>"><div id="elh_process_mismatch_process_other" class="process_mismatch_process_other"><div class="ew-table-header-caption"><?php echo $process_mismatch->process_other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_other" class="<?php echo $process_mismatch->process_other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->process_other) ?>',2);"><div id="elh_process_mismatch_process_other" class="process_mismatch_process_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->process_other->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->process_other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->process_other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_mismatch->process_c->Visible) { // process_c ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->process_c) == "") { ?>
		<th data-name="process_c" class="<?php echo $process_mismatch->process_c->headerCellClass() ?>"><div id="elh_process_mismatch_process_c" class="process_mismatch_process_c"><div class="ew-table-header-caption"><?php echo $process_mismatch->process_c->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_c" class="<?php echo $process_mismatch->process_c->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->process_c) ?>',2);"><div id="elh_process_mismatch_process_c" class="process_mismatch_process_c">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->process_c->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->process_c->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->process_c->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_mismatch->operator->Visible) { // operator ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_mismatch->operator->headerCellClass() ?>"><div id="elh_process_mismatch_operator" class="process_mismatch_operator"><div class="ew-table-header-caption"><?php echo $process_mismatch->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_mismatch->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->operator) ?>',2);"><div id="elh_process_mismatch_operator" class="process_mismatch_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_mismatch->datetime->Visible) { // datetime ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_mismatch->datetime->headerCellClass() ?>"><div id="elh_process_mismatch_datetime" class="process_mismatch_datetime"><div class="ew-table-header-caption"><?php echo $process_mismatch->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_mismatch->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->datetime) ?>',2);"><div id="elh_process_mismatch_datetime" class="process_mismatch_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_mismatch->id->Visible) { // id ?>
	<?php if ($process_mismatch->sortUrl($process_mismatch->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_mismatch->id->headerCellClass() ?>"><div id="elh_process_mismatch_id" class="process_mismatch_id"><div class="ew-table-header-caption"><?php echo $process_mismatch->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_mismatch->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_mismatch->SortUrl($process_mismatch->id) ?>',2);"><div id="elh_process_mismatch_id" class="process_mismatch_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_mismatch->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_mismatch->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_mismatch->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_mismatch_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_mismatch->ExportAll && $process_mismatch->isExport()) {
	$process_mismatch_list->StopRec = $process_mismatch_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_mismatch_list->TotalRecs > $process_mismatch_list->StartRec + $process_mismatch_list->DisplayRecs - 1)
		$process_mismatch_list->StopRec = $process_mismatch_list->StartRec + $process_mismatch_list->DisplayRecs - 1;
	else
		$process_mismatch_list->StopRec = $process_mismatch_list->TotalRecs;
}
$process_mismatch_list->RecCnt = $process_mismatch_list->StartRec - 1;
if ($process_mismatch_list->Recordset && !$process_mismatch_list->Recordset->EOF) {
	$process_mismatch_list->Recordset->moveFirst();
	$selectLimit = $process_mismatch_list->UseSelectLimit;
	if (!$selectLimit && $process_mismatch_list->StartRec > 1)
		$process_mismatch_list->Recordset->move($process_mismatch_list->StartRec - 1);
} elseif (!$process_mismatch->AllowAddDeleteRow && $process_mismatch_list->StopRec == 0) {
	$process_mismatch_list->StopRec = $process_mismatch->GridAddRowCount;
}

// Initialize aggregate
$process_mismatch->RowType = ROWTYPE_AGGREGATEINIT;
$process_mismatch->resetAttributes();
$process_mismatch_list->renderRow();
while ($process_mismatch_list->RecCnt < $process_mismatch_list->StopRec) {
	$process_mismatch_list->RecCnt++;
	if ($process_mismatch_list->RecCnt >= $process_mismatch_list->StartRec) {
		$process_mismatch_list->RowCnt++;

		// Set up key count
		$process_mismatch_list->KeyCount = $process_mismatch_list->RowIndex;

		// Init row class and style
		$process_mismatch->resetAttributes();
		$process_mismatch->CssClass = "";
		if ($process_mismatch->isGridAdd()) {
		} else {
			$process_mismatch_list->loadRowValues($process_mismatch_list->Recordset); // Load row values
		}
		$process_mismatch->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_mismatch->RowAttrs = array_merge($process_mismatch->RowAttrs, array('data-rowindex'=>$process_mismatch_list->RowCnt, 'id'=>'r' . $process_mismatch_list->RowCnt . '_process_mismatch', 'data-rowtype'=>$process_mismatch->RowType));

		// Render row
		$process_mismatch_list->renderRow();

		// Render list options
		$process_mismatch_list->renderListOptions();
?>
	<tr<?php echo $process_mismatch->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_mismatch_list->ListOptions->render("body", "left", $process_mismatch_list->RowCnt);
?>
	<?php if ($process_mismatch->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $process_mismatch->_barcode->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch__barcode" class="process_mismatch__barcode">
<span<?php echo $process_mismatch->_barcode->viewAttributes() ?>>
<?php echo $process_mismatch->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_mismatch->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_mismatch->code->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch_code" class="process_mismatch_code">
<span<?php echo $process_mismatch->code->viewAttributes() ?>>
<?php echo $process_mismatch->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_mismatch->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_mismatch->process->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch_process" class="process_mismatch_process">
<span<?php echo $process_mismatch->process->viewAttributes() ?>>
<?php echo $process_mismatch->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_mismatch->process_other->Visible) { // process_other ?>
		<td data-name="process_other"<?php echo $process_mismatch->process_other->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch_process_other" class="process_mismatch_process_other">
<span<?php echo $process_mismatch->process_other->viewAttributes() ?>>
<?php echo $process_mismatch->process_other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_mismatch->process_c->Visible) { // process_c ?>
		<td data-name="process_c"<?php echo $process_mismatch->process_c->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch_process_c" class="process_mismatch_process_c">
<span<?php echo $process_mismatch->process_c->viewAttributes() ?>>
<?php echo $process_mismatch->process_c->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_mismatch->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_mismatch->operator->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch_operator" class="process_mismatch_operator">
<span<?php echo $process_mismatch->operator->viewAttributes() ?>>
<?php echo $process_mismatch->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_mismatch->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_mismatch->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch_datetime" class="process_mismatch_datetime">
<span<?php echo $process_mismatch->datetime->viewAttributes() ?>>
<?php echo $process_mismatch->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_mismatch->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_mismatch->id->cellAttributes() ?>>
<span id="el<?php echo $process_mismatch_list->RowCnt ?>_process_mismatch_id" class="process_mismatch_id">
<span<?php echo $process_mismatch->id->viewAttributes() ?>>
<?php echo $process_mismatch->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_mismatch_list->ListOptions->render("body", "right", $process_mismatch_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_mismatch->isGridAdd())
		$process_mismatch_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_mismatch->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_mismatch_list->Recordset)
	$process_mismatch_list->Recordset->Close();
?>
<?php if (!$process_mismatch->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_mismatch->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_mismatch_list->Pager)) $process_mismatch_list->Pager = new PrevNextPager($process_mismatch_list->StartRec, $process_mismatch_list->DisplayRecs, $process_mismatch_list->TotalRecs, $process_mismatch_list->AutoHidePager) ?>
<?php if ($process_mismatch_list->Pager->RecordCount > 0 && $process_mismatch_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_mismatch_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_mismatch_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_mismatch_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_mismatch_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_mismatch_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_mismatch_list->pageUrl() ?>start=<?php echo $process_mismatch_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_mismatch_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_mismatch_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_mismatch_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_mismatch_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_mismatch_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_mismatch_list->TotalRecs > 0 && (!$process_mismatch_list->AutoHidePageSizeSelector || $process_mismatch_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_mismatch">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_mismatch_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_mismatch_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_mismatch_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_mismatch_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_mismatch_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_mismatch->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_mismatch_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_mismatch_list->TotalRecs == 0 && !$process_mismatch->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_mismatch_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_mismatch_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_mismatch->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_mismatch->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_mismatch", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_mismatch_list->terminate();
?>