<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_product_f_list = new process_product_f_list();

// Run the page
$process_product_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_product_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_product_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_product_flist = currentForm = new ew.Form("fprocess_product_flist", "list");
fprocess_product_flist.formKeyCountName = '<?php echo $process_product_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_product_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_product_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fprocess_product_flistsrch = currentSearchForm = new ew.Form("fprocess_product_flistsrch");

// Filters
fprocess_product_flistsrch.filterList = <?php echo $process_product_f_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_product_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_product_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_product_f_list->TotalRecs > 0 && $process_product_f_list->ExportOptions->visible()) { ?>
<?php $process_product_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_product_f_list->ImportOptions->visible()) { ?>
<?php $process_product_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_product_f_list->SearchOptions->visible()) { ?>
<?php $process_product_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_product_f_list->FilterOptions->visible()) { ?>
<?php $process_product_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_product_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_product_f->isExport() && !$process_product_f->CurrentAction) { ?>
<form name="fprocess_product_flistsrch" id="fprocess_product_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_product_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_product_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_product_f">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_product_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_product_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_product_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_product_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_product_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_product_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_product_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_product_f_list->showPageHeader(); ?>
<?php
$process_product_f_list->showMessage();
?>
<?php if ($process_product_f_list->TotalRecs > 0 || $process_product_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_product_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_product_f">
<?php if (!$process_product_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_product_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_product_f_list->Pager)) $process_product_f_list->Pager = new PrevNextPager($process_product_f_list->StartRec, $process_product_f_list->DisplayRecs, $process_product_f_list->TotalRecs, $process_product_f_list->AutoHidePager) ?>
<?php if ($process_product_f_list->Pager->RecordCount > 0 && $process_product_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_product_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_product_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_product_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_product_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_product_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_product_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_product_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_product_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_product_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_product_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_product_f_list->TotalRecs > 0 && (!$process_product_f_list->AutoHidePageSizeSelector || $process_product_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_product_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_product_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_product_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_product_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_product_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_product_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_product_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_product_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_product_flist" id="fprocess_product_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_product_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_product_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_product_f">
<div id="gmp_process_product_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_product_f_list->TotalRecs > 0 || $process_product_f->isGridEdit()) { ?>
<table id="tbl_process_product_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_product_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_product_f_list->renderListOptions();

// Render list options (header, left)
$process_product_f_list->ListOptions->render("header", "left");
?>
<?php if ($process_product_f->id->Visible) { // id ?>
	<?php if ($process_product_f->sortUrl($process_product_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_product_f->id->headerCellClass() ?>"><div id="elh_process_product_f_id" class="process_product_f_id"><div class="ew-table-header-caption"><?php echo $process_product_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_product_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->id) ?>',2);"><div id="elh_process_product_f_id" class="process_product_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->product->Visible) { // product ?>
	<?php if ($process_product_f->sortUrl($process_product_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $process_product_f->product->headerCellClass() ?>"><div id="elh_process_product_f_product" class="process_product_f_product"><div class="ew-table-header-caption"><?php echo $process_product_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $process_product_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->product) ?>',2);"><div id="elh_process_product_f_product" class="process_product_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->product_n->Visible) { // product_n ?>
	<?php if ($process_product_f->sortUrl($process_product_f->product_n) == "") { ?>
		<th data-name="product_n" class="<?php echo $process_product_f->product_n->headerCellClass() ?>"><div id="elh_process_product_f_product_n" class="process_product_f_product_n"><div class="ew-table-header-caption"><?php echo $process_product_f->product_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_n" class="<?php echo $process_product_f->product_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->product_n) ?>',2);"><div id="elh_process_product_f_product_n" class="process_product_f_product_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->product_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->product_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->product_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->rid->Visible) { // rid ?>
	<?php if ($process_product_f->sortUrl($process_product_f->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $process_product_f->rid->headerCellClass() ?>"><div id="elh_process_product_f_rid" class="process_product_f_rid"><div class="ew-table-header-caption"><?php echo $process_product_f->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $process_product_f->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->rid) ?>',2);"><div id="elh_process_product_f_rid" class="process_product_f_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->code->Visible) { // code ?>
	<?php if ($process_product_f->sortUrl($process_product_f->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_product_f->code->headerCellClass() ?>"><div id="elh_process_product_f_code" class="process_product_f_code"><div class="ew-table-header-caption"><?php echo $process_product_f->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_product_f->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->code) ?>',2);"><div id="elh_process_product_f_code" class="process_product_f_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->lot_no->Visible) { // lot_no ?>
	<?php if ($process_product_f->sortUrl($process_product_f->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $process_product_f->lot_no->headerCellClass() ?>"><div id="elh_process_product_f_lot_no" class="process_product_f_lot_no"><div class="ew-table-header-caption"><?php echo $process_product_f->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $process_product_f->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->lot_no) ?>',2);"><div id="elh_process_product_f_lot_no" class="process_product_f_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->process_type->Visible) { // process_type ?>
	<?php if ($process_product_f->sortUrl($process_product_f->process_type) == "") { ?>
		<th data-name="process_type" class="<?php echo $process_product_f->process_type->headerCellClass() ?>"><div id="elh_process_product_f_process_type" class="process_product_f_process_type"><div class="ew-table-header-caption"><?php echo $process_product_f->process_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_type" class="<?php echo $process_product_f->process_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->process_type) ?>',2);"><div id="elh_process_product_f_process_type" class="process_product_f_process_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->process_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->process_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->process_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($process_product_f->sortUrl($process_product_f->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $process_product_f->tmp_lot->headerCellClass() ?>"><div id="elh_process_product_f_tmp_lot" class="process_product_f_tmp_lot"><div class="ew-table-header-caption"><?php echo $process_product_f->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $process_product_f->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->tmp_lot) ?>',2);"><div id="elh_process_product_f_tmp_lot" class="process_product_f_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->packets->Visible) { // packets ?>
	<?php if ($process_product_f->sortUrl($process_product_f->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $process_product_f->packets->headerCellClass() ?>"><div id="elh_process_product_f_packets" class="process_product_f_packets"><div class="ew-table-header-caption"><?php echo $process_product_f->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $process_product_f->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->packets) ?>',2);"><div id="elh_process_product_f_packets" class="process_product_f_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->packing_type->Visible) { // packing_type ?>
	<?php if ($process_product_f->sortUrl($process_product_f->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $process_product_f->packing_type->headerCellClass() ?>"><div id="elh_process_product_f_packing_type" class="process_product_f_packing_type"><div class="ew-table-header-caption"><?php echo $process_product_f->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $process_product_f->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->packing_type) ?>',2);"><div id="elh_process_product_f_packing_type" class="process_product_f_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->godown->Visible) { // godown ?>
	<?php if ($process_product_f->sortUrl($process_product_f->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $process_product_f->godown->headerCellClass() ?>"><div id="elh_process_product_f_godown" class="process_product_f_godown"><div class="ew-table-header-caption"><?php echo $process_product_f->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $process_product_f->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->godown) ?>',2);"><div id="elh_process_product_f_godown" class="process_product_f_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->godown_n->Visible) { // godown_n ?>
	<?php if ($process_product_f->sortUrl($process_product_f->godown_n) == "") { ?>
		<th data-name="godown_n" class="<?php echo $process_product_f->godown_n->headerCellClass() ?>"><div id="elh_process_product_f_godown_n" class="process_product_f_godown_n"><div class="ew-table-header-caption"><?php echo $process_product_f->godown_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown_n" class="<?php echo $process_product_f->godown_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->godown_n) ?>',2);"><div id="elh_process_product_f_godown_n" class="process_product_f_godown_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->godown_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->godown_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->godown_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->gcode->Visible) { // gcode ?>
	<?php if ($process_product_f->sortUrl($process_product_f->gcode) == "") { ?>
		<th data-name="gcode" class="<?php echo $process_product_f->gcode->headerCellClass() ?>"><div id="elh_process_product_f_gcode" class="process_product_f_gcode"><div class="ew-table-header-caption"><?php echo $process_product_f->gcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gcode" class="<?php echo $process_product_f->gcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->gcode) ?>',2);"><div id="elh_process_product_f_gcode" class="process_product_f_gcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->gcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->gcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->gcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->dated->Visible) { // dated ?>
	<?php if ($process_product_f->sortUrl($process_product_f->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $process_product_f->dated->headerCellClass() ?>"><div id="elh_process_product_f_dated" class="process_product_f_dated"><div class="ew-table-header-caption"><?php echo $process_product_f->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $process_product_f->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->dated) ?>',2);"><div id="elh_process_product_f_dated" class="process_product_f_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->IN->Visible) { // IN ?>
	<?php if ($process_product_f->sortUrl($process_product_f->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $process_product_f->IN->headerCellClass() ?>"><div id="elh_process_product_f_IN" class="process_product_f_IN"><div class="ew-table-header-caption"><?php echo $process_product_f->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $process_product_f->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->IN) ?>',2);"><div id="elh_process_product_f_IN" class="process_product_f_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->OUT->Visible) { // OUT ?>
	<?php if ($process_product_f->sortUrl($process_product_f->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $process_product_f->OUT->headerCellClass() ?>"><div id="elh_process_product_f_OUT" class="process_product_f_OUT"><div class="ew-table-header-caption"><?php echo $process_product_f->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $process_product_f->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->OUT) ?>',2);"><div id="elh_process_product_f_OUT" class="process_product_f_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->Balance->Visible) { // Balance ?>
	<?php if ($process_product_f->sortUrl($process_product_f->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $process_product_f->Balance->headerCellClass() ?>"><div id="elh_process_product_f_Balance" class="process_product_f_Balance"><div class="ew-table-header-caption"><?php echo $process_product_f->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $process_product_f->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->Balance) ?>',2);"><div id="elh_process_product_f_Balance" class="process_product_f_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->remarks->Visible) { // remarks ?>
	<?php if ($process_product_f->sortUrl($process_product_f->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_product_f->remarks->headerCellClass() ?>"><div id="elh_process_product_f_remarks" class="process_product_f_remarks"><div class="ew-table-header-caption"><?php echo $process_product_f->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_product_f->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->remarks) ?>',2);"><div id="elh_process_product_f_remarks" class="process_product_f_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->status->Visible) { // status ?>
	<?php if ($process_product_f->sortUrl($process_product_f->status) == "") { ?>
		<th data-name="status" class="<?php echo $process_product_f->status->headerCellClass() ?>"><div id="elh_process_product_f_status" class="process_product_f_status"><div class="ew-table-header-caption"><?php echo $process_product_f->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $process_product_f->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->status) ?>',2);"><div id="elh_process_product_f_status" class="process_product_f_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->avg_yield->Visible) { // avg_yield ?>
	<?php if ($process_product_f->sortUrl($process_product_f->avg_yield) == "") { ?>
		<th data-name="avg_yield" class="<?php echo $process_product_f->avg_yield->headerCellClass() ?>"><div id="elh_process_product_f_avg_yield" class="process_product_f_avg_yield"><div class="ew-table-header-caption"><?php echo $process_product_f->avg_yield->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_yield" class="<?php echo $process_product_f->avg_yield->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->avg_yield) ?>',2);"><div id="elh_process_product_f_avg_yield" class="process_product_f_avg_yield">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->avg_yield->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->avg_yield->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->avg_yield->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->type->Visible) { // type ?>
	<?php if ($process_product_f->sortUrl($process_product_f->type) == "") { ?>
		<th data-name="type" class="<?php echo $process_product_f->type->headerCellClass() ?>"><div id="elh_process_product_f_type" class="process_product_f_type"><div class="ew-table-header-caption"><?php echo $process_product_f->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $process_product_f->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->type) ?>',2);"><div id="elh_process_product_f_type" class="process_product_f_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->age->Visible) { // age ?>
	<?php if ($process_product_f->sortUrl($process_product_f->age) == "") { ?>
		<th data-name="age" class="<?php echo $process_product_f->age->headerCellClass() ?>"><div id="elh_process_product_f_age" class="process_product_f_age"><div class="ew-table-header-caption"><?php echo $process_product_f->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $process_product_f->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->age) ?>',2);"><div id="elh_process_product_f_age" class="process_product_f_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_product_f->company_id->Visible) { // company_id ?>
	<?php if ($process_product_f->sortUrl($process_product_f->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $process_product_f->company_id->headerCellClass() ?>"><div id="elh_process_product_f_company_id" class="process_product_f_company_id"><div class="ew-table-header-caption"><?php echo $process_product_f->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $process_product_f->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_product_f->SortUrl($process_product_f->company_id) ?>',2);"><div id="elh_process_product_f_company_id" class="process_product_f_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_product_f->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_product_f->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_product_f->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_product_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_product_f->ExportAll && $process_product_f->isExport()) {
	$process_product_f_list->StopRec = $process_product_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_product_f_list->TotalRecs > $process_product_f_list->StartRec + $process_product_f_list->DisplayRecs - 1)
		$process_product_f_list->StopRec = $process_product_f_list->StartRec + $process_product_f_list->DisplayRecs - 1;
	else
		$process_product_f_list->StopRec = $process_product_f_list->TotalRecs;
}
$process_product_f_list->RecCnt = $process_product_f_list->StartRec - 1;
if ($process_product_f_list->Recordset && !$process_product_f_list->Recordset->EOF) {
	$process_product_f_list->Recordset->moveFirst();
	$selectLimit = $process_product_f_list->UseSelectLimit;
	if (!$selectLimit && $process_product_f_list->StartRec > 1)
		$process_product_f_list->Recordset->move($process_product_f_list->StartRec - 1);
} elseif (!$process_product_f->AllowAddDeleteRow && $process_product_f_list->StopRec == 0) {
	$process_product_f_list->StopRec = $process_product_f->GridAddRowCount;
}

// Initialize aggregate
$process_product_f->RowType = ROWTYPE_AGGREGATEINIT;
$process_product_f->resetAttributes();
$process_product_f_list->renderRow();
while ($process_product_f_list->RecCnt < $process_product_f_list->StopRec) {
	$process_product_f_list->RecCnt++;
	if ($process_product_f_list->RecCnt >= $process_product_f_list->StartRec) {
		$process_product_f_list->RowCnt++;

		// Set up key count
		$process_product_f_list->KeyCount = $process_product_f_list->RowIndex;

		// Init row class and style
		$process_product_f->resetAttributes();
		$process_product_f->CssClass = "";
		if ($process_product_f->isGridAdd()) {
		} else {
			$process_product_f_list->loadRowValues($process_product_f_list->Recordset); // Load row values
		}
		$process_product_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_product_f->RowAttrs = array_merge($process_product_f->RowAttrs, array('data-rowindex'=>$process_product_f_list->RowCnt, 'id'=>'r' . $process_product_f_list->RowCnt . '_process_product_f', 'data-rowtype'=>$process_product_f->RowType));

		// Render row
		$process_product_f_list->renderRow();

		// Render list options
		$process_product_f_list->renderListOptions();
?>
	<tr<?php echo $process_product_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_product_f_list->ListOptions->render("body", "left", $process_product_f_list->RowCnt);
?>
	<?php if ($process_product_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_product_f->id->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_id" class="process_product_f_id">
<span<?php echo $process_product_f->id->viewAttributes() ?>>
<?php echo $process_product_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $process_product_f->product->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_product" class="process_product_f_product">
<span<?php echo $process_product_f->product->viewAttributes() ?>>
<?php echo $process_product_f->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->product_n->Visible) { // product_n ?>
		<td data-name="product_n"<?php echo $process_product_f->product_n->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_product_n" class="process_product_f_product_n">
<span<?php echo $process_product_f->product_n->viewAttributes() ?>>
<?php echo $process_product_f->product_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $process_product_f->rid->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_rid" class="process_product_f_rid">
<span<?php echo $process_product_f->rid->viewAttributes() ?>>
<?php echo $process_product_f->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_product_f->code->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_code" class="process_product_f_code">
<span<?php echo $process_product_f->code->viewAttributes() ?>>
<?php echo $process_product_f->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $process_product_f->lot_no->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_lot_no" class="process_product_f_lot_no">
<span<?php echo $process_product_f->lot_no->viewAttributes() ?>>
<?php echo $process_product_f->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->process_type->Visible) { // process_type ?>
		<td data-name="process_type"<?php echo $process_product_f->process_type->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_process_type" class="process_product_f_process_type">
<span<?php echo $process_product_f->process_type->viewAttributes() ?>>
<?php echo $process_product_f->process_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $process_product_f->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_tmp_lot" class="process_product_f_tmp_lot">
<span<?php echo $process_product_f->tmp_lot->viewAttributes() ?>>
<?php echo $process_product_f->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $process_product_f->packets->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_packets" class="process_product_f_packets">
<span<?php echo $process_product_f->packets->viewAttributes() ?>>
<?php echo $process_product_f->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $process_product_f->packing_type->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_packing_type" class="process_product_f_packing_type">
<span<?php echo $process_product_f->packing_type->viewAttributes() ?>>
<?php echo $process_product_f->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $process_product_f->godown->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_godown" class="process_product_f_godown">
<span<?php echo $process_product_f->godown->viewAttributes() ?>>
<?php echo $process_product_f->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->godown_n->Visible) { // godown_n ?>
		<td data-name="godown_n"<?php echo $process_product_f->godown_n->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_godown_n" class="process_product_f_godown_n">
<span<?php echo $process_product_f->godown_n->viewAttributes() ?>>
<?php echo $process_product_f->godown_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->gcode->Visible) { // gcode ?>
		<td data-name="gcode"<?php echo $process_product_f->gcode->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_gcode" class="process_product_f_gcode">
<span<?php echo $process_product_f->gcode->viewAttributes() ?>>
<?php echo $process_product_f->gcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $process_product_f->dated->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_dated" class="process_product_f_dated">
<span<?php echo $process_product_f->dated->viewAttributes() ?>>
<?php echo $process_product_f->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $process_product_f->IN->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_IN" class="process_product_f_IN">
<span<?php echo $process_product_f->IN->viewAttributes() ?>>
<?php echo $process_product_f->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $process_product_f->OUT->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_OUT" class="process_product_f_OUT">
<span<?php echo $process_product_f->OUT->viewAttributes() ?>>
<?php echo $process_product_f->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $process_product_f->Balance->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_Balance" class="process_product_f_Balance">
<span<?php echo $process_product_f->Balance->viewAttributes() ?>>
<?php echo $process_product_f->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_product_f->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_remarks" class="process_product_f_remarks">
<span<?php echo $process_product_f->remarks->viewAttributes() ?>>
<?php echo $process_product_f->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->status->Visible) { // status ?>
		<td data-name="status"<?php echo $process_product_f->status->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_status" class="process_product_f_status">
<span<?php echo $process_product_f->status->viewAttributes() ?>>
<?php echo $process_product_f->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->avg_yield->Visible) { // avg_yield ?>
		<td data-name="avg_yield"<?php echo $process_product_f->avg_yield->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_avg_yield" class="process_product_f_avg_yield">
<span<?php echo $process_product_f->avg_yield->viewAttributes() ?>>
<?php echo $process_product_f->avg_yield->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->type->Visible) { // type ?>
		<td data-name="type"<?php echo $process_product_f->type->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_type" class="process_product_f_type">
<span<?php echo $process_product_f->type->viewAttributes() ?>>
<?php echo $process_product_f->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->age->Visible) { // age ?>
		<td data-name="age"<?php echo $process_product_f->age->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_age" class="process_product_f_age">
<span<?php echo $process_product_f->age->viewAttributes() ?>>
<?php echo $process_product_f->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_product_f->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $process_product_f->company_id->cellAttributes() ?>>
<span id="el<?php echo $process_product_f_list->RowCnt ?>_process_product_f_company_id" class="process_product_f_company_id">
<span<?php echo $process_product_f->company_id->viewAttributes() ?>>
<?php echo $process_product_f->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_product_f_list->ListOptions->render("body", "right", $process_product_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_product_f->isGridAdd())
		$process_product_f_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_product_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_product_f_list->Recordset)
	$process_product_f_list->Recordset->Close();
?>
<?php if (!$process_product_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_product_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_product_f_list->Pager)) $process_product_f_list->Pager = new PrevNextPager($process_product_f_list->StartRec, $process_product_f_list->DisplayRecs, $process_product_f_list->TotalRecs, $process_product_f_list->AutoHidePager) ?>
<?php if ($process_product_f_list->Pager->RecordCount > 0 && $process_product_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_product_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_product_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_product_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_product_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_product_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_product_f_list->pageUrl() ?>start=<?php echo $process_product_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_product_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_product_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_product_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_product_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_product_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_product_f_list->TotalRecs > 0 && (!$process_product_f_list->AutoHidePageSizeSelector || $process_product_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_product_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_product_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_product_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_product_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_product_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_product_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_product_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_product_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_product_f_list->TotalRecs == 0 && !$process_product_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_product_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_product_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_product_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_product_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_product_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_product_f_list->terminate();
?>