<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_fp_add = new process_table_fp_add();

// Run the page
$process_table_fp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_fp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fprocess_table_fpadd = currentForm = new ew.Form("fprocess_table_fpadd", "add");

// Validate form
fprocess_table_fpadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_table_fp_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->id->caption(), $process_table_fp->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_table_fp->id->errorMessage()) ?>");
		<?php if ($process_table_fp_add->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->ref->caption(), $process_table_fp->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->product_new->Required) { ?>
			elm = this.getElements("x" + infix + "_product_new");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->product_new->caption(), $process_table_fp->product_new->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->batch_no->caption(), $process_table_fp->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_table_fp->batch_no->errorMessage()) ?>");
		<?php if ($process_table_fp_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->process->caption(), $process_table_fp->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->product_code_new->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code_new");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->product_code_new->caption(), $process_table_fp->product_code_new->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->emp_name->Required) { ?>
			elm = this.getElements("x" + infix + "_emp_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->emp_name->caption(), $process_table_fp->emp_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->packets->caption(), $process_table_fp->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->quantity_avg_act->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_avg_act");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->quantity_avg_act->caption(), $process_table_fp->quantity_avg_act->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->quantity->caption(), $process_table_fp->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkRange(elm.value, .001, 1000000))
				return this.onError(elm, "<?php echo JsEncode($process_table_fp->quantity->errorMessage()) ?>");
		<?php if ($process_table_fp_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->packing_type->caption(), $process_table_fp->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->godown->caption(), $process_table_fp->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->dated->caption(), $process_table_fp->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_table_fp->dated->errorMessage()) ?>");
		<?php if ($process_table_fp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->operator->caption(), $process_table_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->datetime->caption(), $process_table_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_fp_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table_fp->remarks->caption(), $process_table_fp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_table_fpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_table_fpadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_table_fpadd.lists["x_ref"] = <?php echo $process_table_fp_add->ref->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_ref"].options = <?php echo JsonEncode($process_table_fp_add->ref->lookupOptions()) ?>;
fprocess_table_fpadd.lists["x_product_new"] = <?php echo $process_table_fp_add->product_new->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_product_new"].options = <?php echo JsonEncode($process_table_fp_add->product_new->lookupOptions()) ?>;
fprocess_table_fpadd.lists["x_process"] = <?php echo $process_table_fp_add->process->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_process"].options = <?php echo JsonEncode($process_table_fp_add->process->lookupOptions()) ?>;
fprocess_table_fpadd.lists["x_product_code_new"] = <?php echo $process_table_fp_add->product_code_new->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_product_code_new"].options = <?php echo JsonEncode($process_table_fp_add->product_code_new->lookupOptions()) ?>;
fprocess_table_fpadd.lists["x_emp_name"] = <?php echo $process_table_fp_add->emp_name->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_emp_name"].options = <?php echo JsonEncode($process_table_fp_add->emp_name->lookupOptions()) ?>;
fprocess_table_fpadd.lists["x_quantity_avg_act"] = <?php echo $process_table_fp_add->quantity_avg_act->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($process_table_fp_add->quantity_avg_act->options(FALSE, TRUE)) ?>;
fprocess_table_fpadd.lists["x_packing_type"] = <?php echo $process_table_fp_add->packing_type->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_fp_add->packing_type->lookupOptions()) ?>;
fprocess_table_fpadd.lists["x_godown"] = <?php echo $process_table_fp_add->godown->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_godown"].options = <?php echo JsonEncode($process_table_fp_add->godown->lookupOptions()) ?>;
fprocess_table_fpadd.lists["x_operator"] = <?php echo $process_table_fp_add->operator->Lookup->toClientList() ?>;
fprocess_table_fpadd.lists["x_operator"].options = <?php echo JsonEncode($process_table_fp_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_table_fp_add->showPageHeader(); ?>
<?php
$process_table_fp_add->showMessage();
?>
<form name="fprocess_table_fpadd" id="fprocess_table_fpadd" class="<?php echo $process_table_fp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_fp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_fp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table_fp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$process_table_fp_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($process_table_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_process_table_fp_id" for="x_id" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->id->caption() ?><?php echo ($process_table_fp->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->id->cellAttributes() ?>><?php echo $process_table_fp->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_process_table_fp_ref" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->ref->caption() ?><?php echo ($process_table_fp->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->ref->cellAttributes() ?>>
<span id="el_process_table_fp_ref">
<?php $process_table_fp->ref->EditAttrs["onclick"] = "ew.autoFill(this); " . @$process_table_fp->ref->EditAttrs["onclick"]; ?>
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table_fp" data-field="x_ref" data-value-separator="<?php echo $process_table_fp->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $process_table_fp->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $process_table_fp->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $process_table_fp->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $process_table_fp->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->product_new->Visible) { // product_new ?>
	<div id="r_product_new" class="form-group row">
		<label id="elh_process_table_fp_product_new" for="x_product_new" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->product_new->caption() ?><?php echo ($process_table_fp->product_new->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->product_new->cellAttributes() ?>>
<span id="el_process_table_fp_product_new">
<?php $process_table_fp->product_new->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_table_fp->product_new->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_product_new" data-value-separator="<?php echo $process_table_fp->product_new->displayValueSeparatorAttribute() ?>" id="x_product_new" name="x_product_new"<?php echo $process_table_fp->product_new->editAttributes() ?>>
		<?php echo $process_table_fp->product_new->selectOptionListHtml("x_product_new") ?>
	</select>
</div>
<?php echo $process_table_fp->product_new->Lookup->getParamTag("p_x_product_new") ?>
</span>
<?php echo $process_table_fp->product_new->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_process_table_fp_batch_no" for="x_batch_no" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->batch_no->caption() ?><?php echo ($process_table_fp->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->batch_no->cellAttributes() ?>>
<span id="el_process_table_fp_batch_no">
<input type="text" data-table="process_table_fp" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($process_table_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->batch_no->EditValue ?>"<?php echo $process_table_fp->batch_no->editAttributes() ?>>
</span>
<?php echo $process_table_fp->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_process_table_fp_process" for="x_process" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->process->caption() ?><?php echo ($process_table_fp->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->process->cellAttributes() ?>>
<span id="el_process_table_fp_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_process" data-value-separator="<?php echo $process_table_fp->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_table_fp->process->editAttributes() ?>>
		<?php echo $process_table_fp->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_table_fp->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $process_table_fp->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->product_code_new->Visible) { // product_code_new ?>
	<div id="r_product_code_new" class="form-group row">
		<label id="elh_process_table_fp_product_code_new" for="x_product_code_new" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->product_code_new->caption() ?><?php echo ($process_table_fp->product_code_new->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->product_code_new->cellAttributes() ?>>
<span id="el_process_table_fp_product_code_new">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_product_code_new" data-value-separator="<?php echo $process_table_fp->product_code_new->displayValueSeparatorAttribute() ?>" id="x_product_code_new" name="x_product_code_new"<?php echo $process_table_fp->product_code_new->editAttributes() ?>>
		<?php echo $process_table_fp->product_code_new->selectOptionListHtml("x_product_code_new") ?>
	</select>
</div>
<?php echo $process_table_fp->product_code_new->Lookup->getParamTag("p_x_product_code_new") ?>
</span>
<?php echo $process_table_fp->product_code_new->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->emp_name->Visible) { // emp_name ?>
	<div id="r_emp_name" class="form-group row">
		<label id="elh_process_table_fp_emp_name" for="x_emp_name" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->emp_name->caption() ?><?php echo ($process_table_fp->emp_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->emp_name->cellAttributes() ?>>
<span id="el_process_table_fp_emp_name">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_emp_name" data-value-separator="<?php echo $process_table_fp->emp_name->displayValueSeparatorAttribute() ?>" id="x_emp_name" name="x_emp_name"<?php echo $process_table_fp->emp_name->editAttributes() ?>>
		<?php echo $process_table_fp->emp_name->selectOptionListHtml("x_emp_name") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "production_employee_fp") && !$process_table_fp->emp_name->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_emp_name" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $process_table_fp->emp_name->caption() ?>" data-title="<?php echo $process_table_fp->emp_name->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_emp_name',url:'production_employee_fpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $process_table_fp->emp_name->Lookup->getParamTag("p_x_emp_name") ?>
</span>
<?php echo $process_table_fp->emp_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_process_table_fp_packets" for="x_packets" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->packets->caption() ?><?php echo ($process_table_fp->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->packets->cellAttributes() ?>>
<span id="el_process_table_fp_packets">
<input type="text" data-table="process_table_fp" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($process_table_fp->packets->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->packets->EditValue ?>"<?php echo $process_table_fp->packets->editAttributes() ?>>
</span>
<?php echo $process_table_fp->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label id="elh_process_table_fp_quantity_avg_act" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->quantity_avg_act->caption() ?><?php echo ($process_table_fp->quantity_avg_act->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->quantity_avg_act->cellAttributes() ?>>
<span id="el_process_table_fp_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table_fp" data-field="x_quantity_avg_act" data-value-separator="<?php echo $process_table_fp->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $process_table_fp->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $process_table_fp->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
<?php echo $process_table_fp->quantity_avg_act->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_process_table_fp_quantity" for="x_quantity" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->quantity->caption() ?><?php echo ($process_table_fp->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->quantity->cellAttributes() ?>>
<span id="el_process_table_fp_quantity">
<input type="text" data-table="process_table_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_table_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->quantity->EditValue ?>"<?php echo $process_table_fp->quantity->editAttributes() ?>>
</span>
<?php echo $process_table_fp->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_process_table_fp_packing_type" for="x_packing_type" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->packing_type->caption() ?><?php echo ($process_table_fp->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->packing_type->cellAttributes() ?>>
<span id="el_process_table_fp_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_packing_type" data-value-separator="<?php echo $process_table_fp->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $process_table_fp->packing_type->editAttributes() ?>>
		<?php echo $process_table_fp->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$process_table_fp->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $process_table_fp->packing_type->caption() ?>" data-title="<?php echo $process_table_fp->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $process_table_fp->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $process_table_fp->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_process_table_fp_godown" for="x_godown" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->godown->caption() ?><?php echo ($process_table_fp->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->godown->cellAttributes() ?>>
<span id="el_process_table_fp_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_godown" data-value-separator="<?php echo $process_table_fp->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_table_fp->godown->editAttributes() ?>>
		<?php echo $process_table_fp->godown->selectOptionListHtml("x_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown") && !$process_table_fp->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $process_table_fp->godown->caption() ?>" data-title="<?php echo $process_table_fp->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_godown',url:'godownaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $process_table_fp->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $process_table_fp->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_process_table_fp_dated" for="x_dated" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->dated->caption() ?><?php echo ($process_table_fp->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->dated->cellAttributes() ?>>
<span id="el_process_table_fp_dated">
<input type="text" data-table="process_table_fp" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($process_table_fp->dated->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->dated->EditValue ?>"<?php echo $process_table_fp->dated->editAttributes() ?>>
<?php if (!$process_table_fp->dated->ReadOnly && !$process_table_fp->dated->Disabled && !isset($process_table_fp->dated->EditAttrs["readonly"]) && !isset($process_table_fp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_table_fpadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $process_table_fp->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_process_table_fp_remarks" for="x_remarks" class="<?php echo $process_table_fp_add->LeftColumnClass ?>"><?php echo $process_table_fp->remarks->caption() ?><?php echo ($process_table_fp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_fp_add->RightColumnClass ?>"><div<?php echo $process_table_fp->remarks->cellAttributes() ?>>
<span id="el_process_table_fp_remarks">
<textarea data-table="process_table_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="31" rows="3" placeholder="<?php echo HtmlEncode($process_table_fp->remarks->getPlaceHolder()) ?>"<?php echo $process_table_fp->remarks->editAttributes() ?>><?php echo $process_table_fp->remarks->EditValue ?></textarea>
</span>
<?php echo $process_table_fp->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_table_fp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_table_fp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $process_table_fp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_table_fp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_table_fp_add->terminate();
?>