<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_fp_list = new process_table_fp_list();

// Run the page
$process_table_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_table_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_table_fplist = currentForm = new ew.Form("fprocess_table_fplist", "list");
fprocess_table_fplist.formKeyCountName = '<?php echo $process_table_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_table_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_table_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_table_fplist.lists["x_ref"] = <?php echo $process_table_fp_list->ref->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_ref"].options = <?php echo JsonEncode($process_table_fp_list->ref->lookupOptions()) ?>;
fprocess_table_fplist.lists["x_process"] = <?php echo $process_table_fp_list->process->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_process"].options = <?php echo JsonEncode($process_table_fp_list->process->lookupOptions()) ?>;
fprocess_table_fplist.lists["x_product_code_new"] = <?php echo $process_table_fp_list->product_code_new->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_product_code_new"].options = <?php echo JsonEncode($process_table_fp_list->product_code_new->lookupOptions()) ?>;
fprocess_table_fplist.lists["x_emp_name"] = <?php echo $process_table_fp_list->emp_name->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_emp_name"].options = <?php echo JsonEncode($process_table_fp_list->emp_name->lookupOptions()) ?>;
fprocess_table_fplist.lists["x_quantity_avg_act"] = <?php echo $process_table_fp_list->quantity_avg_act->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($process_table_fp_list->quantity_avg_act->options(FALSE, TRUE)) ?>;
fprocess_table_fplist.lists["x_packing_type"] = <?php echo $process_table_fp_list->packing_type->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_fp_list->packing_type->lookupOptions()) ?>;
fprocess_table_fplist.lists["x_godown"] = <?php echo $process_table_fp_list->godown->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_godown"].options = <?php echo JsonEncode($process_table_fp_list->godown->lookupOptions()) ?>;
fprocess_table_fplist.lists["x_operator"] = <?php echo $process_table_fp_list->operator->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_operator"].options = <?php echo JsonEncode($process_table_fp_list->operator->lookupOptions()) ?>;
fprocess_table_fplist.lists["x_rid"] = <?php echo $process_table_fp_list->rid->Lookup->toClientList() ?>;
fprocess_table_fplist.lists["x_rid"].options = <?php echo JsonEncode($process_table_fp_list->rid->lookupOptions()) ?>;

// Form object for search
var fprocess_table_fplistsrch = currentSearchForm = new ew.Form("fprocess_table_fplistsrch");

// Filters
fprocess_table_fplistsrch.filterList = <?php echo $process_table_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_table_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_table_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_table_fp_list->TotalRecs > 0 && $process_table_fp_list->ExportOptions->visible()) { ?>
<?php $process_table_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_fp_list->ImportOptions->visible()) { ?>
<?php $process_table_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_fp_list->SearchOptions->visible()) { ?>
<?php $process_table_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_fp_list->FilterOptions->visible()) { ?>
<?php $process_table_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_table_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_table_fp->isExport() && !$process_table_fp->CurrentAction) { ?>
<form name="fprocess_table_fplistsrch" id="fprocess_table_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_table_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_table_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_table_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_table_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_table_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_table_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_table_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_table_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_table_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_table_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_table_fp_list->showPageHeader(); ?>
<?php
$process_table_fp_list->showMessage();
?>
<?php if ($process_table_fp_list->TotalRecs > 0 || $process_table_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_table_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_table_fp">
<?php if (!$process_table_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_table_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_table_fp_list->Pager)) $process_table_fp_list->Pager = new PrevNextPager($process_table_fp_list->StartRec, $process_table_fp_list->DisplayRecs, $process_table_fp_list->TotalRecs, $process_table_fp_list->AutoHidePager) ?>
<?php if ($process_table_fp_list->Pager->RecordCount > 0 && $process_table_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_table_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_table_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_table_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_table_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_table_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_table_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_table_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_table_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_table_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_table_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_table_fp_list->TotalRecs > 0 && (!$process_table_fp_list->AutoHidePageSizeSelector || $process_table_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_table_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_table_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_table_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_table_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_table_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_table_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_table_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_table_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_table_fplist" id="fprocess_table_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table_fp">
<div id="gmp_process_table_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_table_fp_list->TotalRecs > 0 || $process_table_fp->isGridEdit()) { ?>
<table id="tbl_process_table_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_table_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_table_fp_list->renderListOptions();

// Render list options (header, left)
$process_table_fp_list->ListOptions->render("header", "left");
?>
<?php if ($process_table_fp->id->Visible) { // id ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_table_fp->id->headerCellClass() ?>"><div id="elh_process_table_fp_id" class="process_table_fp_id"><div class="ew-table-header-caption"><?php echo $process_table_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_table_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->id) ?>',2);"><div id="elh_process_table_fp_id" class="process_table_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->ref->Visible) { // ref ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $process_table_fp->ref->headerCellClass() ?>"><div id="elh_process_table_fp_ref" class="process_table_fp_ref"><div class="ew-table-header-caption"><?php echo $process_table_fp->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $process_table_fp->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->ref) ?>',2);"><div id="elh_process_table_fp_ref" class="process_table_fp_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->batch_no->Visible) { // batch_no ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $process_table_fp->batch_no->headerCellClass() ?>"><div id="elh_process_table_fp_batch_no" class="process_table_fp_batch_no"><div class="ew-table-header-caption"><?php echo $process_table_fp->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $process_table_fp->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->batch_no) ?>',2);"><div id="elh_process_table_fp_batch_no" class="process_table_fp_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->process->Visible) { // process ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_table_fp->process->headerCellClass() ?>"><div id="elh_process_table_fp_process" class="process_table_fp_process"><div class="ew-table-header-caption"><?php echo $process_table_fp->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_table_fp->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->process) ?>',2);"><div id="elh_process_table_fp_process" class="process_table_fp_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->product_code_new->Visible) { // product_code_new ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->product_code_new) == "") { ?>
		<th data-name="product_code_new" class="<?php echo $process_table_fp->product_code_new->headerCellClass() ?>"><div id="elh_process_table_fp_product_code_new" class="process_table_fp_product_code_new"><div class="ew-table-header-caption"><?php echo $process_table_fp->product_code_new->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code_new" class="<?php echo $process_table_fp->product_code_new->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->product_code_new) ?>',2);"><div id="elh_process_table_fp_product_code_new" class="process_table_fp_product_code_new">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->product_code_new->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->product_code_new->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->product_code_new->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->emp_name->Visible) { // emp_name ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->emp_name) == "") { ?>
		<th data-name="emp_name" class="<?php echo $process_table_fp->emp_name->headerCellClass() ?>"><div id="elh_process_table_fp_emp_name" class="process_table_fp_emp_name"><div class="ew-table-header-caption"><?php echo $process_table_fp->emp_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_name" class="<?php echo $process_table_fp->emp_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->emp_name) ?>',2);"><div id="elh_process_table_fp_emp_name" class="process_table_fp_emp_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->emp_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->emp_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->emp_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->packets->Visible) { // packets ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $process_table_fp->packets->headerCellClass() ?>"><div id="elh_process_table_fp_packets" class="process_table_fp_packets"><div class="ew-table-header-caption"><?php echo $process_table_fp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $process_table_fp->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->packets) ?>',2);"><div id="elh_process_table_fp_packets" class="process_table_fp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $process_table_fp->quantity_avg_act->headerCellClass() ?>"><div id="elh_process_table_fp_quantity_avg_act" class="process_table_fp_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $process_table_fp->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $process_table_fp->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->quantity_avg_act) ?>',2);"><div id="elh_process_table_fp_quantity_avg_act" class="process_table_fp_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->quantity->Visible) { // quantity ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $process_table_fp->quantity->headerCellClass() ?>"><div id="elh_process_table_fp_quantity" class="process_table_fp_quantity"><div class="ew-table-header-caption"><?php echo $process_table_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $process_table_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->quantity) ?>',2);"><div id="elh_process_table_fp_quantity" class="process_table_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->packing_type->Visible) { // packing_type ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $process_table_fp->packing_type->headerCellClass() ?>"><div id="elh_process_table_fp_packing_type" class="process_table_fp_packing_type"><div class="ew-table-header-caption"><?php echo $process_table_fp->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $process_table_fp->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->packing_type) ?>',2);"><div id="elh_process_table_fp_packing_type" class="process_table_fp_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->payment->Visible) { // payment ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_table_fp->payment->headerCellClass() ?>"><div id="elh_process_table_fp_payment" class="process_table_fp_payment"><div class="ew-table-header-caption"><?php echo $process_table_fp->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_table_fp->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->payment) ?>',2);"><div id="elh_process_table_fp_payment" class="process_table_fp_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->godown->Visible) { // godown ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $process_table_fp->godown->headerCellClass() ?>"><div id="elh_process_table_fp_godown" class="process_table_fp_godown"><div class="ew-table-header-caption"><?php echo $process_table_fp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $process_table_fp->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->godown) ?>',2);"><div id="elh_process_table_fp_godown" class="process_table_fp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->dated->Visible) { // dated ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $process_table_fp->dated->headerCellClass() ?>"><div id="elh_process_table_fp_dated" class="process_table_fp_dated"><div class="ew-table-header-caption"><?php echo $process_table_fp->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $process_table_fp->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->dated) ?>',2);"><div id="elh_process_table_fp_dated" class="process_table_fp_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->operator->Visible) { // operator ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_table_fp->operator->headerCellClass() ?>"><div id="elh_process_table_fp_operator" class="process_table_fp_operator"><div class="ew-table-header-caption"><?php echo $process_table_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_table_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->operator) ?>',2);"><div id="elh_process_table_fp_operator" class="process_table_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->datetime->Visible) { // datetime ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_table_fp->datetime->headerCellClass() ?>"><div id="elh_process_table_fp_datetime" class="process_table_fp_datetime"><div class="ew-table-header-caption"><?php echo $process_table_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_table_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->datetime) ?>',2);"><div id="elh_process_table_fp_datetime" class="process_table_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->rid->Visible) { // rid ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $process_table_fp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_table_fp_rid" class="process_table_fp_rid"><div class="ew-table-header-caption"><?php echo $process_table_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $process_table_fp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->rid) ?>',2);"><div id="elh_process_table_fp_rid" class="process_table_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_fp->remarks->Visible) { // remarks ?>
	<?php if ($process_table_fp->sortUrl($process_table_fp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_table_fp->remarks->headerCellClass() ?>"><div id="elh_process_table_fp_remarks" class="process_table_fp_remarks"><div class="ew-table-header-caption"><?php echo $process_table_fp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_table_fp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_fp->SortUrl($process_table_fp->remarks) ?>',2);"><div id="elh_process_table_fp_remarks" class="process_table_fp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_fp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_table_fp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_fp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_table_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_table_fp->ExportAll && $process_table_fp->isExport()) {
	$process_table_fp_list->StopRec = $process_table_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_table_fp_list->TotalRecs > $process_table_fp_list->StartRec + $process_table_fp_list->DisplayRecs - 1)
		$process_table_fp_list->StopRec = $process_table_fp_list->StartRec + $process_table_fp_list->DisplayRecs - 1;
	else
		$process_table_fp_list->StopRec = $process_table_fp_list->TotalRecs;
}
$process_table_fp_list->RecCnt = $process_table_fp_list->StartRec - 1;
if ($process_table_fp_list->Recordset && !$process_table_fp_list->Recordset->EOF) {
	$process_table_fp_list->Recordset->moveFirst();
	$selectLimit = $process_table_fp_list->UseSelectLimit;
	if (!$selectLimit && $process_table_fp_list->StartRec > 1)
		$process_table_fp_list->Recordset->move($process_table_fp_list->StartRec - 1);
} elseif (!$process_table_fp->AllowAddDeleteRow && $process_table_fp_list->StopRec == 0) {
	$process_table_fp_list->StopRec = $process_table_fp->GridAddRowCount;
}

// Initialize aggregate
$process_table_fp->RowType = ROWTYPE_AGGREGATEINIT;
$process_table_fp->resetAttributes();
$process_table_fp_list->renderRow();
while ($process_table_fp_list->RecCnt < $process_table_fp_list->StopRec) {
	$process_table_fp_list->RecCnt++;
	if ($process_table_fp_list->RecCnt >= $process_table_fp_list->StartRec) {
		$process_table_fp_list->RowCnt++;

		// Set up key count
		$process_table_fp_list->KeyCount = $process_table_fp_list->RowIndex;

		// Init row class and style
		$process_table_fp->resetAttributes();
		$process_table_fp->CssClass = "";
		if ($process_table_fp->isGridAdd()) {
		} else {
			$process_table_fp_list->loadRowValues($process_table_fp_list->Recordset); // Load row values
		}
		$process_table_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_table_fp->RowAttrs = array_merge($process_table_fp->RowAttrs, array('data-rowindex'=>$process_table_fp_list->RowCnt, 'id'=>'r' . $process_table_fp_list->RowCnt . '_process_table_fp', 'data-rowtype'=>$process_table_fp->RowType));

		// Render row
		$process_table_fp_list->renderRow();

		// Render list options
		$process_table_fp_list->renderListOptions();
?>
	<tr<?php echo $process_table_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_table_fp_list->ListOptions->render("body", "left", $process_table_fp_list->RowCnt);
?>
	<?php if ($process_table_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_table_fp->id->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_id" class="process_table_fp_id">
<span<?php echo $process_table_fp->id->viewAttributes() ?>>
<?php echo $process_table_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $process_table_fp->ref->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_ref" class="process_table_fp_ref">
<span<?php echo $process_table_fp->ref->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->ref->getViewValue())) && $process_table_fp->ref->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->ref->linkAttributes() ?>><?php echo $process_table_fp->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $process_table_fp->batch_no->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_batch_no" class="process_table_fp_batch_no">
<span<?php echo $process_table_fp->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->batch_no->getViewValue())) && $process_table_fp->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->batch_no->linkAttributes() ?>><?php echo $process_table_fp->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_table_fp->process->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_process" class="process_table_fp_process">
<span<?php echo $process_table_fp->process->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->process->getViewValue())) && $process_table_fp->process->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->process->linkAttributes() ?>><?php echo $process_table_fp->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->product_code_new->Visible) { // product_code_new ?>
		<td data-name="product_code_new"<?php echo $process_table_fp->product_code_new->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_product_code_new" class="process_table_fp_product_code_new">
<span<?php echo $process_table_fp->product_code_new->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->product_code_new->getViewValue())) && $process_table_fp->product_code_new->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->product_code_new->linkAttributes() ?>><?php echo $process_table_fp->product_code_new->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->product_code_new->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name"<?php echo $process_table_fp->emp_name->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_emp_name" class="process_table_fp_emp_name">
<span<?php echo $process_table_fp->emp_name->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->emp_name->getViewValue())) && $process_table_fp->emp_name->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->emp_name->linkAttributes() ?>><?php echo $process_table_fp->emp_name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->emp_name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $process_table_fp->packets->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_packets" class="process_table_fp_packets">
<span<?php echo $process_table_fp->packets->viewAttributes() ?>>
<?php echo $process_table_fp->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $process_table_fp->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_quantity_avg_act" class="process_table_fp_quantity_avg_act">
<span<?php echo $process_table_fp->quantity_avg_act->viewAttributes() ?>>
<?php echo $process_table_fp->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $process_table_fp->quantity->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_quantity" class="process_table_fp_quantity">
<span<?php echo $process_table_fp->quantity->viewAttributes() ?>>
<?php echo $process_table_fp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $process_table_fp->packing_type->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_packing_type" class="process_table_fp_packing_type">
<span<?php echo $process_table_fp->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->packing_type->getViewValue())) && $process_table_fp->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->packing_type->linkAttributes() ?>><?php echo $process_table_fp->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_table_fp->payment->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_payment" class="process_table_fp_payment">
<span<?php echo $process_table_fp->payment->viewAttributes() ?>>
<?php echo $process_table_fp->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $process_table_fp->godown->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_godown" class="process_table_fp_godown">
<span<?php echo $process_table_fp->godown->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->godown->getViewValue())) && $process_table_fp->godown->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->godown->linkAttributes() ?>><?php echo $process_table_fp->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $process_table_fp->dated->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_dated" class="process_table_fp_dated">
<span<?php echo $process_table_fp->dated->viewAttributes() ?>>
<?php echo $process_table_fp->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_table_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_operator" class="process_table_fp_operator">
<span<?php echo $process_table_fp->operator->viewAttributes() ?>>
<?php echo $process_table_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_table_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_datetime" class="process_table_fp_datetime">
<span<?php echo $process_table_fp->datetime->viewAttributes() ?>>
<?php echo $process_table_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $process_table_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_rid" class="process_table_fp_rid">
<span<?php echo $process_table_fp->rid->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_fp->rid->getViewValue())) && $process_table_fp->rid->linkAttributes() <> "") { ?>
<a<?php echo $process_table_fp->rid->linkAttributes() ?>><?php echo $process_table_fp->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_fp->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_table_fp->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_table_fp_list->RowCnt ?>_process_table_fp_remarks" class="process_table_fp_remarks">
<span<?php echo $process_table_fp->remarks->viewAttributes() ?>>
<?php echo $process_table_fp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_table_fp_list->ListOptions->render("body", "right", $process_table_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_table_fp->isGridAdd())
		$process_table_fp_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$process_table_fp->RowType = ROWTYPE_AGGREGATE;
$process_table_fp->resetAttributes();
$process_table_fp_list->renderRow();
?>
<?php if ($process_table_fp_list->TotalRecs > 0 && !$process_table_fp->isGridAdd() && !$process_table_fp->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$process_table_fp_list->renderListOptions();

// Render list options (footer, left)
$process_table_fp_list->ListOptions->render("footer", "left");
?>
	<?php if ($process_table_fp->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $process_table_fp->id->footerCellClass() ?>"><span id="elf_process_table_fp_id" class="process_table_fp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $process_table_fp->ref->footerCellClass() ?>"><span id="elf_process_table_fp_ref" class="process_table_fp_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $process_table_fp->batch_no->footerCellClass() ?>"><span id="elf_process_table_fp_batch_no" class="process_table_fp_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $process_table_fp->process->footerCellClass() ?>"><span id="elf_process_table_fp_process" class="process_table_fp_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->product_code_new->Visible) { // product_code_new ?>
		<td data-name="product_code_new" class="<?php echo $process_table_fp->product_code_new->footerCellClass() ?>"><span id="elf_process_table_fp_product_code_new" class="process_table_fp_product_code_new">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name" class="<?php echo $process_table_fp->emp_name->footerCellClass() ?>"><span id="elf_process_table_fp_emp_name" class="process_table_fp_emp_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $process_table_fp->packets->footerCellClass() ?>"><span id="elf_process_table_fp_packets" class="process_table_fp_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act" class="<?php echo $process_table_fp->quantity_avg_act->footerCellClass() ?>"><span id="elf_process_table_fp_quantity_avg_act" class="process_table_fp_quantity_avg_act">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $process_table_fp->quantity->footerCellClass() ?>"><span id="elf_process_table_fp_quantity" class="process_table_fp_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_table_fp->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $process_table_fp->packing_type->footerCellClass() ?>"><span id="elf_process_table_fp_packing_type" class="process_table_fp_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->payment->Visible) { // payment ?>
		<td data-name="payment" class="<?php echo $process_table_fp->payment->footerCellClass() ?>"><span id="elf_process_table_fp_payment" class="process_table_fp_payment">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $process_table_fp->godown->footerCellClass() ?>"><span id="elf_process_table_fp_godown" class="process_table_fp_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $process_table_fp->dated->footerCellClass() ?>"><span id="elf_process_table_fp_dated" class="process_table_fp_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $process_table_fp->operator->footerCellClass() ?>"><span id="elf_process_table_fp_operator" class="process_table_fp_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $process_table_fp->datetime->footerCellClass() ?>"><span id="elf_process_table_fp_datetime" class="process_table_fp_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $process_table_fp->rid->footerCellClass() ?>"><span id="elf_process_table_fp_rid" class="process_table_fp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $process_table_fp->remarks->footerCellClass() ?>"><span id="elf_process_table_fp_remarks" class="process_table_fp_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$process_table_fp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_table_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_table_fp_list->Recordset)
	$process_table_fp_list->Recordset->Close();
?>
<?php if (!$process_table_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_table_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_table_fp_list->Pager)) $process_table_fp_list->Pager = new PrevNextPager($process_table_fp_list->StartRec, $process_table_fp_list->DisplayRecs, $process_table_fp_list->TotalRecs, $process_table_fp_list->AutoHidePager) ?>
<?php if ($process_table_fp_list->Pager->RecordCount > 0 && $process_table_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_table_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_table_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_table_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_table_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_table_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_table_fp_list->pageUrl() ?>start=<?php echo $process_table_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_table_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_table_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_table_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_table_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_table_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_table_fp_list->TotalRecs > 0 && (!$process_table_fp_list->AutoHidePageSizeSelector || $process_table_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_table_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_table_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_table_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_table_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_table_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_table_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_table_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_table_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_table_fp_list->TotalRecs == 0 && !$process_table_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_table_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_table_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_table_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_table_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_table_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_table_fp_list->terminate();
?>