<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_fp_search = new process_table_fp_search();

// Run the page
$process_table_fp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_fp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_table_fp_search->IsModal) { ?>
var fprocess_table_fpsearch = currentAdvancedSearchForm = new ew.Form("fprocess_table_fpsearch", "search");
<?php } else { ?>
var fprocess_table_fpsearch = currentForm = new ew.Form("fprocess_table_fpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_table_fpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_table_fpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_table_fpsearch.lists["x_ref"] = <?php echo $process_table_fp_search->ref->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_ref"].options = <?php echo JsonEncode($process_table_fp_search->ref->lookupOptions()) ?>;
fprocess_table_fpsearch.lists["x_process"] = <?php echo $process_table_fp_search->process->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_process"].options = <?php echo JsonEncode($process_table_fp_search->process->lookupOptions()) ?>;
fprocess_table_fpsearch.lists["x_product_code_new"] = <?php echo $process_table_fp_search->product_code_new->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_product_code_new"].options = <?php echo JsonEncode($process_table_fp_search->product_code_new->lookupOptions()) ?>;
fprocess_table_fpsearch.lists["x_emp_name"] = <?php echo $process_table_fp_search->emp_name->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_emp_name"].options = <?php echo JsonEncode($process_table_fp_search->emp_name->lookupOptions()) ?>;
fprocess_table_fpsearch.lists["x_quantity_avg_act"] = <?php echo $process_table_fp_search->quantity_avg_act->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($process_table_fp_search->quantity_avg_act->options(FALSE, TRUE)) ?>;
fprocess_table_fpsearch.lists["x_packing_type"] = <?php echo $process_table_fp_search->packing_type->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_fp_search->packing_type->lookupOptions()) ?>;
fprocess_table_fpsearch.lists["x_godown"] = <?php echo $process_table_fp_search->godown->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_godown"].options = <?php echo JsonEncode($process_table_fp_search->godown->lookupOptions()) ?>;
fprocess_table_fpsearch.lists["x_operator"] = <?php echo $process_table_fp_search->operator->Lookup->toClientList() ?>;
fprocess_table_fpsearch.lists["x_operator"].options = <?php echo JsonEncode($process_table_fp_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocess_table_fpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_fp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkRange(elm.value, .001, 1000000))
		return this.onError(elm, "<?php echo JsEncode($process_table_fp->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_fp->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_table_fp_search->showPageHeader(); ?>
<?php
$process_table_fp_search->showMessage();
?>
<form name="fprocess_table_fpsearch" id="fprocess_table_fpsearch" class="<?php echo $process_table_fp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_fp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_fp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table_fp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_table_fp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_table_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_id"><?php echo $process_table_fp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->id->cellAttributes() ?>>
			<span id="el_process_table_fp_id">
<input type="text" data-table="process_table_fp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_table_fp->id->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->id->EditValue ?>"<?php echo $process_table_fp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_ref"><?php echo $process_table_fp->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->ref->cellAttributes() ?>>
			<span id="el_process_table_fp_ref">
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table_fp" data-field="x_ref" data-value-separator="<?php echo $process_table_fp->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $process_table_fp->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $process_table_fp->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $process_table_fp->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_process"><?php echo $process_table_fp->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->process->cellAttributes() ?>>
			<span id="el_process_table_fp_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_process" data-value-separator="<?php echo $process_table_fp->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_table_fp->process->editAttributes() ?>>
		<?php echo $process_table_fp->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_table_fp->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->product_code_new->Visible) { // product_code_new ?>
	<div id="r_product_code_new" class="form-group row">
		<label for="x_product_code_new" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_product_code_new"><?php echo $process_table_fp->product_code_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_code_new" id="z_product_code_new" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->product_code_new->cellAttributes() ?>>
			<span id="el_process_table_fp_product_code_new">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_product_code_new" data-value-separator="<?php echo $process_table_fp->product_code_new->displayValueSeparatorAttribute() ?>" id="x_product_code_new" name="x_product_code_new"<?php echo $process_table_fp->product_code_new->editAttributes() ?>>
		<?php echo $process_table_fp->product_code_new->selectOptionListHtml("x_product_code_new") ?>
	</select>
</div>
<?php echo $process_table_fp->product_code_new->Lookup->getParamTag("p_x_product_code_new") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->emp_name->Visible) { // emp_name ?>
	<div id="r_emp_name" class="form-group row">
		<label for="x_emp_name" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_emp_name"><?php echo $process_table_fp->emp_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_emp_name" id="z_emp_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->emp_name->cellAttributes() ?>>
			<span id="el_process_table_fp_emp_name">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_emp_name" data-value-separator="<?php echo $process_table_fp->emp_name->displayValueSeparatorAttribute() ?>" id="x_emp_name" name="x_emp_name"<?php echo $process_table_fp->emp_name->editAttributes() ?>>
		<?php echo $process_table_fp->emp_name->selectOptionListHtml("x_emp_name") ?>
	</select>
</div>
<?php echo $process_table_fp->emp_name->Lookup->getParamTag("p_x_emp_name") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_packets"><?php echo $process_table_fp->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->packets->cellAttributes() ?>>
			<span id="el_process_table_fp_packets">
<input type="text" data-table="process_table_fp" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($process_table_fp->packets->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->packets->EditValue ?>"<?php echo $process_table_fp->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_quantity_avg_act"><?php echo $process_table_fp->quantity_avg_act->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_avg_act" id="z_quantity_avg_act" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->quantity_avg_act->cellAttributes() ?>>
			<span id="el_process_table_fp_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table_fp" data-field="x_quantity_avg_act" data-value-separator="<?php echo $process_table_fp->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $process_table_fp->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $process_table_fp->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_quantity"><?php echo $process_table_fp->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->quantity->cellAttributes() ?>>
			<span id="el_process_table_fp_quantity">
<input type="text" data-table="process_table_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_table_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->quantity->EditValue ?>"<?php echo $process_table_fp->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_packing_type"><?php echo $process_table_fp->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->packing_type->cellAttributes() ?>>
			<span id="el_process_table_fp_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_packing_type" data-value-separator="<?php echo $process_table_fp->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $process_table_fp->packing_type->editAttributes() ?>>
		<?php echo $process_table_fp->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $process_table_fp->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_godown"><?php echo $process_table_fp->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->godown->cellAttributes() ?>>
			<span id="el_process_table_fp_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_godown" data-value-separator="<?php echo $process_table_fp->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_table_fp->godown->editAttributes() ?>>
		<?php echo $process_table_fp->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $process_table_fp->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_dated"><?php echo $process_table_fp->dated->caption() ?></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_table_fp->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_table_fp_dated">
<input type="text" data-table="process_table_fp" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($process_table_fp->dated->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->dated->EditValue ?>"<?php echo $process_table_fp->dated->editAttributes() ?>>
<?php if (!$process_table_fp->dated->ReadOnly && !$process_table_fp->dated->Disabled && !isset($process_table_fp->dated->EditAttrs["readonly"]) && !isset($process_table_fp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_table_fpsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_table_fp_dated" class="btw1_dated d-none">
<input type="text" data-table="process_table_fp" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($process_table_fp->dated->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->dated->EditValue2 ?>"<?php echo $process_table_fp->dated->editAttributes() ?>>
<?php if (!$process_table_fp->dated->ReadOnly && !$process_table_fp->dated->Disabled && !isset($process_table_fp->dated->EditAttrs["readonly"]) && !isset($process_table_fp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_table_fpsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_operator"><?php echo $process_table_fp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->operator->cellAttributes() ?>>
			<span id="el_process_table_fp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_fp" data-field="x_operator" data-value-separator="<?php echo $process_table_fp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process_table_fp->operator->editAttributes() ?>>
		<?php echo $process_table_fp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process_table_fp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_datetime"><?php echo $process_table_fp->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_table_fp->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_table_fp_datetime">
<input type="text" data-table="process_table_fp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_table_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->datetime->EditValue ?>"<?php echo $process_table_fp->datetime->editAttributes() ?>>
<?php if (!$process_table_fp->datetime->ReadOnly && !$process_table_fp->datetime->Disabled && !isset($process_table_fp->datetime->EditAttrs["readonly"]) && !isset($process_table_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_table_fpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_table_fp_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_table_fp" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_table_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->datetime->EditValue2 ?>"<?php echo $process_table_fp->datetime->editAttributes() ?>>
<?php if (!$process_table_fp->datetime->ReadOnly && !$process_table_fp->datetime->Disabled && !isset($process_table_fp->datetime->EditAttrs["readonly"]) && !isset($process_table_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_table_fpsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $process_table_fp_search->LeftColumnClass ?>"><span id="elh_process_table_fp_remarks"><?php echo $process_table_fp->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_fp_search->RightColumnClass ?>"><div<?php echo $process_table_fp->remarks->cellAttributes() ?>>
			<span id="el_process_table_fp_remarks">
<input type="text" data-table="process_table_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="31" maxlength="255" placeholder="<?php echo HtmlEncode($process_table_fp->remarks->getPlaceHolder()) ?>" value="<?php echo $process_table_fp->remarks->EditValue ?>"<?php echo $process_table_fp->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_table_fp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_table_fp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_table_fp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_table_fp_search->terminate();
?>