<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_hs_list = new process_table_hs_list();

// Run the page
$process_table_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_table_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_table_hslist = currentForm = new ew.Form("fprocess_table_hslist", "list");
fprocess_table_hslist.formKeyCountName = '<?php echo $process_table_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_table_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_table_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_table_hslist.lists["x_grp"] = <?php echo $process_table_hs_list->grp->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_grp"].options = <?php echo JsonEncode($process_table_hs_list->grp->options(FALSE, TRUE)) ?>;
fprocess_table_hslist.lists["x_godown"] = <?php echo $process_table_hs_list->godown->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_godown"].options = <?php echo JsonEncode($process_table_hs_list->godown->lookupOptions()) ?>;
fprocess_table_hslist.lists["x_emp_name"] = <?php echo $process_table_hs_list->emp_name->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_emp_name"].options = <?php echo JsonEncode($process_table_hs_list->emp_name->lookupOptions()) ?>;
fprocess_table_hslist.autoSuggests["x_emp_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_table_hslist.lists["x_ref"] = <?php echo $process_table_hs_list->ref->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_ref"].options = <?php echo JsonEncode($process_table_hs_list->ref->lookupOptions()) ?>;
fprocess_table_hslist.lists["x_rid"] = <?php echo $process_table_hs_list->rid->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_rid"].options = <?php echo JsonEncode($process_table_hs_list->rid->lookupOptions()) ?>;
fprocess_table_hslist.lists["x_twist"] = <?php echo $process_table_hs_list->twist->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_twist"].options = <?php echo JsonEncode($process_table_hs_list->twist->options(FALSE, TRUE)) ?>;
fprocess_table_hslist.lists["x_status"] = <?php echo $process_table_hs_list->status->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_status"].options = <?php echo JsonEncode($process_table_hs_list->status->options(FALSE, TRUE)) ?>;
fprocess_table_hslist.lists["x_std_rate"] = <?php echo $process_table_hs_list->std_rate->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_std_rate"].options = <?php echo JsonEncode($process_table_hs_list->std_rate->lookupOptions()) ?>;
fprocess_table_hslist.lists["x_operator"] = <?php echo $process_table_hs_list->operator->Lookup->toClientList() ?>;
fprocess_table_hslist.lists["x_operator"].options = <?php echo JsonEncode($process_table_hs_list->operator->lookupOptions()) ?>;

// Form object for search
var fprocess_table_hslistsrch = currentSearchForm = new ew.Form("fprocess_table_hslistsrch");

// Validate function for search
fprocess_table_hslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->batch_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_table_hslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_table_hslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_table_hslistsrch.lists["x_ref"] = <?php echo $process_table_hs_list->ref->Lookup->toClientList() ?>;
fprocess_table_hslistsrch.lists["x_ref"].options = <?php echo JsonEncode($process_table_hs_list->ref->lookupOptions()) ?>;
fprocess_table_hslistsrch.lists["x_rid"] = <?php echo $process_table_hs_list->rid->Lookup->toClientList() ?>;
fprocess_table_hslistsrch.lists["x_rid"].options = <?php echo JsonEncode($process_table_hs_list->rid->lookupOptions()) ?>;

// Filters
fprocess_table_hslistsrch.filterList = <?php echo $process_table_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_table_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_table_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_table_hs_list->TotalRecs > 0 && $process_table_hs_list->ExportOptions->visible()) { ?>
<?php $process_table_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_hs_list->ImportOptions->visible()) { ?>
<?php $process_table_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_hs_list->SearchOptions->visible()) { ?>
<?php $process_table_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_hs_list->FilterOptions->visible()) { ?>
<?php $process_table_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_table_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_table_hs->isExport() && !$process_table_hs->CurrentAction) { ?>
<form name="fprocess_table_hslistsrch" id="fprocess_table_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_table_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_table_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_table_hs">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_table_hs_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_table_hs->RowType = ROWTYPE_SEARCH;

// Render row
$process_table_hs->resetAttributes();
$process_table_hs_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_table_hs->ref->Visible) { // ref ?>
	<div id="xsc_ref" class="ew-cell form-group">
		<label for="x_ref" class="ew-search-caption ew-label"><?php echo $process_table_hs->ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_ref" data-value-separator="<?php echo $process_table_hs->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $process_table_hs->ref->editAttributes() ?>>
		<?php echo $process_table_hs->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $process_table_hs->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_table_hs->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $process_table_hs->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_rid" data-value-separator="<?php echo $process_table_hs->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $process_table_hs->rid->editAttributes() ?>>
		<?php echo $process_table_hs->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $process_table_hs->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_table_hs->batch_no->Visible) { // batch_no ?>
	<div id="xsc_batch_no" class="ew-cell form-group">
		<label for="x_batch_no" class="ew-search-caption ew-label"><?php echo $process_table_hs->batch_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="process_table_hs" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->batch_no->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->batch_no->EditValue ?>"<?php echo $process_table_hs->batch_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_table_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_table_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_table_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_table_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_table_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_table_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_table_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_table_hs_list->showPageHeader(); ?>
<?php
$process_table_hs_list->showMessage();
?>
<?php if ($process_table_hs_list->TotalRecs > 0 || $process_table_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_table_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_table_hs">
<?php if (!$process_table_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_table_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_table_hs_list->Pager)) $process_table_hs_list->Pager = new PrevNextPager($process_table_hs_list->StartRec, $process_table_hs_list->DisplayRecs, $process_table_hs_list->TotalRecs, $process_table_hs_list->AutoHidePager) ?>
<?php if ($process_table_hs_list->Pager->RecordCount > 0 && $process_table_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_table_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_table_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_table_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_table_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_table_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_table_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_table_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_table_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_table_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_table_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_table_hs_list->TotalRecs > 0 && (!$process_table_hs_list->AutoHidePageSizeSelector || $process_table_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_table_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_table_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_table_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_table_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_table_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_table_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_table_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_table_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_table_hslist" id="fprocess_table_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table_hs">
<div id="gmp_process_table_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_table_hs_list->TotalRecs > 0 || $process_table_hs->isGridEdit()) { ?>
<table id="tbl_process_table_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_table_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_table_hs_list->renderListOptions();

// Render list options (header, left)
$process_table_hs_list->ListOptions->render("header", "left");
?>
<?php if ($process_table_hs->id->Visible) { // id ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_table_hs->id->headerCellClass() ?>"><div id="elh_process_table_hs_id" class="process_table_hs_id"><div class="ew-table-header-caption"><?php echo $process_table_hs->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_table_hs->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->id) ?>',2);"><div id="elh_process_table_hs_id" class="process_table_hs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->grp->Visible) { // grp ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $process_table_hs->grp->headerCellClass() ?>"><div id="elh_process_table_hs_grp" class="process_table_hs_grp"><div class="ew-table-header-caption"><?php echo $process_table_hs->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $process_table_hs->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->grp) ?>',2);"><div id="elh_process_table_hs_grp" class="process_table_hs_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->godown->Visible) { // godown ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $process_table_hs->godown->headerCellClass() ?>"><div id="elh_process_table_hs_godown" class="process_table_hs_godown"><div class="ew-table-header-caption"><?php echo $process_table_hs->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $process_table_hs->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->godown) ?>',2);"><div id="elh_process_table_hs_godown" class="process_table_hs_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->emp_name->Visible) { // emp_name ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->emp_name) == "") { ?>
		<th data-name="emp_name" class="<?php echo $process_table_hs->emp_name->headerCellClass() ?>"><div id="elh_process_table_hs_emp_name" class="process_table_hs_emp_name"><div class="ew-table-header-caption"><?php echo $process_table_hs->emp_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_name" class="<?php echo $process_table_hs->emp_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->emp_name) ?>',2);"><div id="elh_process_table_hs_emp_name" class="process_table_hs_emp_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->emp_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->emp_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->emp_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->ref->Visible) { // ref ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $process_table_hs->ref->headerCellClass() ?>"><div id="elh_process_table_hs_ref" class="process_table_hs_ref"><div class="ew-table-header-caption"><?php echo $process_table_hs->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $process_table_hs->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->ref) ?>',2);"><div id="elh_process_table_hs_ref" class="process_table_hs_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->rid->Visible) { // rid ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $process_table_hs->rid->headerCellClass() ?>"><div id="elh_process_table_hs_rid" class="process_table_hs_rid"><div class="ew-table-header-caption"><?php echo $process_table_hs->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $process_table_hs->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->rid) ?>',2);"><div id="elh_process_table_hs_rid" class="process_table_hs_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->batch_no->Visible) { // batch_no ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $process_table_hs->batch_no->headerCellClass() ?>"><div id="elh_process_table_hs_batch_no" class="process_table_hs_batch_no"><div class="ew-table-header-caption"><?php echo $process_table_hs->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $process_table_hs->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->batch_no) ?>',2);"><div id="elh_process_table_hs_batch_no" class="process_table_hs_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->count->Visible) { // count ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->count) == "") { ?>
		<th data-name="count" class="<?php echo $process_table_hs->count->headerCellClass() ?>"><div id="elh_process_table_hs_count" class="process_table_hs_count"><div class="ew-table-header-caption"><?php echo $process_table_hs->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $process_table_hs->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->count) ?>',2);"><div id="elh_process_table_hs_count" class="process_table_hs_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->count->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->count_received->Visible) { // count_received ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->count_received) == "") { ?>
		<th data-name="count_received" class="<?php echo $process_table_hs->count_received->headerCellClass() ?>"><div id="elh_process_table_hs_count_received" class="process_table_hs_count_received"><div class="ew-table-header-caption"><?php echo $process_table_hs->count_received->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count_received" class="<?php echo $process_table_hs->count_received->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->count_received) ?>',2);"><div id="elh_process_table_hs_count_received" class="process_table_hs_count_received">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->count_received->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->count_received->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->count_received->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->twist->Visible) { // twist ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->twist) == "") { ?>
		<th data-name="twist" class="<?php echo $process_table_hs->twist->headerCellClass() ?>"><div id="elh_process_table_hs_twist" class="process_table_hs_twist"><div class="ew-table-header-caption"><?php echo $process_table_hs->twist->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="twist" class="<?php echo $process_table_hs->twist->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->twist) ?>',2);"><div id="elh_process_table_hs_twist" class="process_table_hs_twist">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->twist->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->twist->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->twist->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $process_table_hs->quantity_avg_act->headerCellClass() ?>"><div id="elh_process_table_hs_quantity_avg_act" class="process_table_hs_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $process_table_hs->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $process_table_hs->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->quantity_avg_act) ?>',2);"><div id="elh_process_table_hs_quantity_avg_act" class="process_table_hs_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->quantity->Visible) { // quantity ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $process_table_hs->quantity->headerCellClass() ?>"><div id="elh_process_table_hs_quantity" class="process_table_hs_quantity"><div class="ew-table-header-caption"><?php echo $process_table_hs->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $process_table_hs->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->quantity) ?>',2);"><div id="elh_process_table_hs_quantity" class="process_table_hs_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->status->Visible) { // status ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->status) == "") { ?>
		<th data-name="status" class="<?php echo $process_table_hs->status->headerCellClass() ?>"><div id="elh_process_table_hs_status" class="process_table_hs_status"><div class="ew-table-header-caption"><?php echo $process_table_hs->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $process_table_hs->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->status) ?>',2);"><div id="elh_process_table_hs_status" class="process_table_hs_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->std_rate->Visible) { // std_rate ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->std_rate) == "") { ?>
		<th data-name="std_rate" class="<?php echo $process_table_hs->std_rate->headerCellClass() ?>"><div id="elh_process_table_hs_std_rate" class="process_table_hs_std_rate"><div class="ew-table-header-caption"><?php echo $process_table_hs->std_rate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="std_rate" class="<?php echo $process_table_hs->std_rate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->std_rate) ?>',2);"><div id="elh_process_table_hs_std_rate" class="process_table_hs_std_rate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->std_rate->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->std_rate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->std_rate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->_40->Visible) { // @ ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $process_table_hs->_40->headerCellClass() ?>"><div id="elh_process_table_hs__40" class="process_table_hs__40"><div class="ew-table-header-caption"><?php echo $process_table_hs->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $process_table_hs->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->_40) ?>',2);"><div id="elh_process_table_hs__40" class="process_table_hs__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->total_amount->Visible) { // total_amount ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $process_table_hs->total_amount->headerCellClass() ?>"><div id="elh_process_table_hs_total_amount" class="process_table_hs_total_amount"><div class="ew-table-header-caption"><?php echo $process_table_hs->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $process_table_hs->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->total_amount) ?>',2);"><div id="elh_process_table_hs_total_amount" class="process_table_hs_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->payment->Visible) { // payment ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_table_hs->payment->headerCellClass() ?>"><div id="elh_process_table_hs_payment" class="process_table_hs_payment"><div class="ew-table-header-caption"><?php echo $process_table_hs->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_table_hs->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->payment) ?>',2);"><div id="elh_process_table_hs_payment" class="process_table_hs_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->remarks->Visible) { // remarks ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_table_hs->remarks->headerCellClass() ?>"><div id="elh_process_table_hs_remarks" class="process_table_hs_remarks"><div class="ew-table-header-caption"><?php echo $process_table_hs->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_table_hs->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->remarks) ?>',2);"><div id="elh_process_table_hs_remarks" class="process_table_hs_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->remarks->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->operator->Visible) { // operator ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_table_hs->operator->headerCellClass() ?>"><div id="elh_process_table_hs_operator" class="process_table_hs_operator"><div class="ew-table-header-caption"><?php echo $process_table_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_table_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->operator) ?>',2);"><div id="elh_process_table_hs_operator" class="process_table_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->datetime->Visible) { // datetime ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_table_hs->datetime->headerCellClass() ?>"><div id="elh_process_table_hs_datetime" class="process_table_hs_datetime"><div class="ew-table-header-caption"><?php echo $process_table_hs->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_table_hs->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->datetime) ?>',2);"><div id="elh_process_table_hs_datetime" class="process_table_hs_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table_hs->dated->Visible) { // dated ?>
	<?php if ($process_table_hs->sortUrl($process_table_hs->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $process_table_hs->dated->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_table_hs_dated" class="process_table_hs_dated"><div class="ew-table-header-caption"><?php echo $process_table_hs->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $process_table_hs->dated->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table_hs->SortUrl($process_table_hs->dated) ?>',2);"><div id="elh_process_table_hs_dated" class="process_table_hs_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table_hs->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table_hs->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table_hs->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_table_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_table_hs->ExportAll && $process_table_hs->isExport()) {
	$process_table_hs_list->StopRec = $process_table_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_table_hs_list->TotalRecs > $process_table_hs_list->StartRec + $process_table_hs_list->DisplayRecs - 1)
		$process_table_hs_list->StopRec = $process_table_hs_list->StartRec + $process_table_hs_list->DisplayRecs - 1;
	else
		$process_table_hs_list->StopRec = $process_table_hs_list->TotalRecs;
}
$process_table_hs_list->RecCnt = $process_table_hs_list->StartRec - 1;
if ($process_table_hs_list->Recordset && !$process_table_hs_list->Recordset->EOF) {
	$process_table_hs_list->Recordset->moveFirst();
	$selectLimit = $process_table_hs_list->UseSelectLimit;
	if (!$selectLimit && $process_table_hs_list->StartRec > 1)
		$process_table_hs_list->Recordset->move($process_table_hs_list->StartRec - 1);
} elseif (!$process_table_hs->AllowAddDeleteRow && $process_table_hs_list->StopRec == 0) {
	$process_table_hs_list->StopRec = $process_table_hs->GridAddRowCount;
}

// Initialize aggregate
$process_table_hs->RowType = ROWTYPE_AGGREGATEINIT;
$process_table_hs->resetAttributes();
$process_table_hs_list->renderRow();
while ($process_table_hs_list->RecCnt < $process_table_hs_list->StopRec) {
	$process_table_hs_list->RecCnt++;
	if ($process_table_hs_list->RecCnt >= $process_table_hs_list->StartRec) {
		$process_table_hs_list->RowCnt++;

		// Set up key count
		$process_table_hs_list->KeyCount = $process_table_hs_list->RowIndex;

		// Init row class and style
		$process_table_hs->resetAttributes();
		$process_table_hs->CssClass = "";
		if ($process_table_hs->isGridAdd()) {
		} else {
			$process_table_hs_list->loadRowValues($process_table_hs_list->Recordset); // Load row values
		}
		$process_table_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_table_hs->RowAttrs = array_merge($process_table_hs->RowAttrs, array('data-rowindex'=>$process_table_hs_list->RowCnt, 'id'=>'r' . $process_table_hs_list->RowCnt . '_process_table_hs', 'data-rowtype'=>$process_table_hs->RowType));

		// Render row
		$process_table_hs_list->renderRow();

		// Render list options
		$process_table_hs_list->renderListOptions();
?>
	<tr<?php echo $process_table_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_table_hs_list->ListOptions->render("body", "left", $process_table_hs_list->RowCnt);
?>
	<?php if ($process_table_hs->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_table_hs->id->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_id" class="process_table_hs_id">
<span<?php echo $process_table_hs->id->viewAttributes() ?>>
<?php echo $process_table_hs->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $process_table_hs->grp->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_grp" class="process_table_hs_grp">
<span<?php echo $process_table_hs->grp->viewAttributes() ?>>
<?php echo $process_table_hs->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $process_table_hs->godown->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_godown" class="process_table_hs_godown">
<span<?php echo $process_table_hs->godown->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_hs->godown->getViewValue())) && $process_table_hs->godown->linkAttributes() <> "") { ?>
<a<?php echo $process_table_hs->godown->linkAttributes() ?>><?php echo $process_table_hs->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_hs->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name"<?php echo $process_table_hs->emp_name->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_emp_name" class="process_table_hs_emp_name">
<span<?php echo $process_table_hs->emp_name->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_hs->emp_name->getViewValue())) && $process_table_hs->emp_name->linkAttributes() <> "") { ?>
<a<?php echo $process_table_hs->emp_name->linkAttributes() ?>><?php echo $process_table_hs->emp_name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_hs->emp_name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $process_table_hs->ref->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_ref" class="process_table_hs_ref">
<span<?php echo $process_table_hs->ref->viewAttributes() ?>>
<?php echo $process_table_hs->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $process_table_hs->rid->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_rid" class="process_table_hs_rid">
<span<?php echo $process_table_hs->rid->viewAttributes() ?>>
<?php if ((!EmptyString($process_table_hs->rid->getViewValue())) && $process_table_hs->rid->linkAttributes() <> "") { ?>
<a<?php echo $process_table_hs->rid->linkAttributes() ?>><?php echo $process_table_hs->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table_hs->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $process_table_hs->batch_no->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_batch_no" class="process_table_hs_batch_no">
<span<?php echo $process_table_hs->batch_no->viewAttributes() ?>>
<?php echo $process_table_hs->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->count->Visible) { // count ?>
		<td data-name="count"<?php echo $process_table_hs->count->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_count" class="process_table_hs_count">
<span<?php echo $process_table_hs->count->viewAttributes() ?>>
<?php echo $process_table_hs->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->count_received->Visible) { // count_received ?>
		<td data-name="count_received"<?php echo $process_table_hs->count_received->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_count_received" class="process_table_hs_count_received">
<span<?php echo $process_table_hs->count_received->viewAttributes() ?>>
<?php echo $process_table_hs->count_received->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->twist->Visible) { // twist ?>
		<td data-name="twist"<?php echo $process_table_hs->twist->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_twist" class="process_table_hs_twist">
<span<?php echo $process_table_hs->twist->viewAttributes() ?>>
<?php echo $process_table_hs->twist->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $process_table_hs->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_quantity_avg_act" class="process_table_hs_quantity_avg_act">
<span<?php echo $process_table_hs->quantity_avg_act->viewAttributes() ?>>
<?php echo $process_table_hs->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $process_table_hs->quantity->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_quantity" class="process_table_hs_quantity">
<span<?php echo $process_table_hs->quantity->viewAttributes() ?>>
<?php echo $process_table_hs->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->status->Visible) { // status ?>
		<td data-name="status"<?php echo $process_table_hs->status->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_status" class="process_table_hs_status">
<span<?php echo $process_table_hs->status->viewAttributes() ?>>
<?php echo $process_table_hs->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->std_rate->Visible) { // std_rate ?>
		<td data-name="std_rate"<?php echo $process_table_hs->std_rate->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_std_rate" class="process_table_hs_std_rate">
<span<?php echo $process_table_hs->std_rate->viewAttributes() ?>>
<?php echo $process_table_hs->std_rate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $process_table_hs->_40->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs__40" class="process_table_hs__40">
<span<?php echo $process_table_hs->_40->viewAttributes() ?>>
<?php echo $process_table_hs->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $process_table_hs->total_amount->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_total_amount" class="process_table_hs_total_amount">
<span<?php echo $process_table_hs->total_amount->viewAttributes() ?>>
<?php echo $process_table_hs->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_table_hs->payment->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_payment" class="process_table_hs_payment">
<span<?php echo $process_table_hs->payment->viewAttributes() ?>>
<?php echo $process_table_hs->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_table_hs->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_remarks" class="process_table_hs_remarks">
<span<?php echo $process_table_hs->remarks->viewAttributes() ?>>
<?php echo $process_table_hs->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_table_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_operator" class="process_table_hs_operator">
<span<?php echo $process_table_hs->operator->viewAttributes() ?>>
<?php echo $process_table_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_table_hs->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_datetime" class="process_table_hs_datetime">
<span<?php echo $process_table_hs->datetime->viewAttributes() ?>>
<?php echo $process_table_hs->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table_hs->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $process_table_hs->dated->cellAttributes() ?>>
<span id="el<?php echo $process_table_hs_list->RowCnt ?>_process_table_hs_dated" class="process_table_hs_dated">
<span<?php echo $process_table_hs->dated->viewAttributes() ?>>
<?php echo $process_table_hs->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_table_hs_list->ListOptions->render("body", "right", $process_table_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_table_hs->isGridAdd())
		$process_table_hs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_table_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_table_hs_list->Recordset)
	$process_table_hs_list->Recordset->Close();
?>
<?php if (!$process_table_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_table_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_table_hs_list->Pager)) $process_table_hs_list->Pager = new PrevNextPager($process_table_hs_list->StartRec, $process_table_hs_list->DisplayRecs, $process_table_hs_list->TotalRecs, $process_table_hs_list->AutoHidePager) ?>
<?php if ($process_table_hs_list->Pager->RecordCount > 0 && $process_table_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_table_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_table_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_table_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_table_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_table_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_table_hs_list->pageUrl() ?>start=<?php echo $process_table_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_table_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_table_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_table_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_table_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_table_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_table_hs_list->TotalRecs > 0 && (!$process_table_hs_list->AutoHidePageSizeSelector || $process_table_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_table_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_table_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_table_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_table_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_table_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_table_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_table_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_table_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_table_hs_list->TotalRecs == 0 && !$process_table_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_table_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_table_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_table_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_table_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_table_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_table_hs_list->terminate();
?>