<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_hs_search = new process_table_hs_search();

// Run the page
$process_table_hs_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_hs_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_table_hs_search->IsModal) { ?>
var fprocess_table_hssearch = currentAdvancedSearchForm = new ew.Form("fprocess_table_hssearch", "search");
<?php } else { ?>
var fprocess_table_hssearch = currentForm = new ew.Form("fprocess_table_hssearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_table_hssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_table_hssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_table_hssearch.lists["x_grp"] = <?php echo $process_table_hs_search->grp->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_grp"].options = <?php echo JsonEncode($process_table_hs_search->grp->options(FALSE, TRUE)) ?>;
fprocess_table_hssearch.lists["x_godown"] = <?php echo $process_table_hs_search->godown->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_godown"].options = <?php echo JsonEncode($process_table_hs_search->godown->lookupOptions()) ?>;
fprocess_table_hssearch.lists["x_emp_name"] = <?php echo $process_table_hs_search->emp_name->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_emp_name"].options = <?php echo JsonEncode($process_table_hs_search->emp_name->lookupOptions()) ?>;
fprocess_table_hssearch.autoSuggests["x_emp_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_table_hssearch.lists["x_ref"] = <?php echo $process_table_hs_search->ref->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_ref"].options = <?php echo JsonEncode($process_table_hs_search->ref->lookupOptions()) ?>;
fprocess_table_hssearch.lists["x_rid"] = <?php echo $process_table_hs_search->rid->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_rid"].options = <?php echo JsonEncode($process_table_hs_search->rid->lookupOptions()) ?>;
fprocess_table_hssearch.lists["x_twist"] = <?php echo $process_table_hs_search->twist->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_twist"].options = <?php echo JsonEncode($process_table_hs_search->twist->options(FALSE, TRUE)) ?>;
fprocess_table_hssearch.lists["x_status"] = <?php echo $process_table_hs_search->status->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_status"].options = <?php echo JsonEncode($process_table_hs_search->status->options(FALSE, TRUE)) ?>;
fprocess_table_hssearch.lists["x_std_rate"] = <?php echo $process_table_hs_search->std_rate->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_std_rate"].options = <?php echo JsonEncode($process_table_hs_search->std_rate->lookupOptions()) ?>;
fprocess_table_hssearch.lists["x_operator"] = <?php echo $process_table_hs_search->operator->Lookup->toClientList() ?>;
fprocess_table_hssearch.lists["x_operator"].options = <?php echo JsonEncode($process_table_hs_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocess_table_hssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->batch_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_count");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->count->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_count_received");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->count_received->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity_avg_act");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->quantity_avg_act->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_payment");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->payment->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table_hs->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_table_hs_search->showPageHeader(); ?>
<?php
$process_table_hs_search->showMessage();
?>
<form name="fprocess_table_hssearch" id="fprocess_table_hssearch" class="<?php echo $process_table_hs_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_hs_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_hs_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table_hs">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_table_hs_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_table_hs->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_id"><?php echo $process_table_hs->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->id->cellAttributes() ?>>
			<span id="el_process_table_hs_id">
<input type="text" data-table="process_table_hs" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_table_hs->id->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->id->EditValue ?>"<?php echo $process_table_hs->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_grp"><?php echo $process_table_hs->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->grp->cellAttributes() ?>>
			<span id="el_process_table_hs_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_grp" data-value-separator="<?php echo $process_table_hs->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_table_hs->grp->editAttributes() ?>>
		<?php echo $process_table_hs->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_godown"><?php echo $process_table_hs->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->godown->cellAttributes() ?>>
			<span id="el_process_table_hs_godown">
<?php $process_table_hs->godown->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_table_hs->godown->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_godown" data-value-separator="<?php echo $process_table_hs->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_table_hs->godown->editAttributes() ?>>
		<?php echo $process_table_hs->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $process_table_hs->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->emp_name->Visible) { // emp_name ?>
	<div id="r_emp_name" class="form-group row">
		<label class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_emp_name"><?php echo $process_table_hs->emp_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_emp_name" id="z_emp_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->emp_name->cellAttributes() ?>>
			<span id="el_process_table_hs_emp_name">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$process_table_hs->emp_name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_table_hs->emp_name->EditAttrs["onchange"] = "";
?>
<span id="as_x_emp_name" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_emp_name" id="sv_x_emp_name" value="<?php echo RemoveHtml($process_table_hs->emp_name->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->emp_name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_table_hs->emp_name->getPlaceHolder()) ?>"<?php echo $process_table_hs->emp_name->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_table_hs->emp_name->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_emp_name',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($process_table_hs->emp_name->ReadOnly || $process_table_hs->emp_name->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_table_hs" data-field="x_emp_name" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_table_hs->emp_name->displayValueSeparatorAttribute() ?>" name="x_emp_name" id="x_emp_name" value="<?php echo HtmlEncode($process_table_hs->emp_name->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_table_hssearch.createAutoSuggest({"id":"x_emp_name","forceSelect":false});
</script>
<?php echo $process_table_hs->emp_name->Lookup->getParamTag("p_x_emp_name") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_ref"><?php echo $process_table_hs->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->ref->cellAttributes() ?>>
			<span id="el_process_table_hs_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_ref" data-value-separator="<?php echo $process_table_hs->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $process_table_hs->ref->editAttributes() ?>>
		<?php echo $process_table_hs->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $process_table_hs->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_rid"><?php echo $process_table_hs->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->rid->cellAttributes() ?>>
			<span id="el_process_table_hs_rid">
<?php $process_table_hs->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_table_hs->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_rid" data-value-separator="<?php echo $process_table_hs->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $process_table_hs->rid->editAttributes() ?>>
		<?php echo $process_table_hs->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $process_table_hs->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->count->Visible) { // count ?>
	<div id="r_count" class="form-group row">
		<label for="x_count" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_count"><?php echo $process_table_hs->count->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_count" id="z_count" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->count->cellAttributes() ?>>
			<span id="el_process_table_hs_count">
<input type="text" data-table="process_table_hs" data-field="x_count" name="x_count" id="x_count" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->count->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->count->EditValue ?>"<?php echo $process_table_hs->count->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->count_received->Visible) { // count_received ?>
	<div id="r_count_received" class="form-group row">
		<label for="x_count_received" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_count_received"><?php echo $process_table_hs->count_received->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_count_received" id="z_count_received" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->count_received->cellAttributes() ?>>
			<span id="el_process_table_hs_count_received">
<input type="text" data-table="process_table_hs" data-field="x_count_received" name="x_count_received" id="x_count_received" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->count_received->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->count_received->EditValue ?>"<?php echo $process_table_hs->count_received->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->twist->Visible) { // twist ?>
	<div id="r_twist" class="form-group row">
		<label for="x_twist" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_twist"><?php echo $process_table_hs->twist->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_twist" id="z_twist" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->twist->cellAttributes() ?>>
			<span id="el_process_table_hs_twist">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_twist" data-value-separator="<?php echo $process_table_hs->twist->displayValueSeparatorAttribute() ?>" id="x_twist" name="x_twist"<?php echo $process_table_hs->twist->editAttributes() ?>>
		<?php echo $process_table_hs->twist->selectOptionListHtml("x_twist") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label for="x_quantity_avg_act" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_quantity_avg_act"><?php echo $process_table_hs->quantity_avg_act->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_avg_act" id="z_quantity_avg_act" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->quantity_avg_act->cellAttributes() ?>>
			<span id="el_process_table_hs_quantity_avg_act">
<input type="text" data-table="process_table_hs" data-field="x_quantity_avg_act" name="x_quantity_avg_act" id="x_quantity_avg_act" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->quantity_avg_act->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->quantity_avg_act->EditValue ?>"<?php echo $process_table_hs->quantity_avg_act->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_quantity"><?php echo $process_table_hs->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->quantity->cellAttributes() ?>>
			<span id="el_process_table_hs_quantity">
<input type="text" data-table="process_table_hs" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->quantity->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->quantity->EditValue ?>"<?php echo $process_table_hs->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_status"><?php echo $process_table_hs->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->status->cellAttributes() ?>>
			<span id="el_process_table_hs_status">
<div id="tp_x_status" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table_hs" data-field="x_status" data-value-separator="<?php echo $process_table_hs->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="{value}"<?php echo $process_table_hs->status->editAttributes() ?>></div>
<div id="dsl_x_status" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $process_table_hs->status->radioButtonListHtml(FALSE, "x_status") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->std_rate->Visible) { // std_rate ?>
	<div id="r_std_rate" class="form-group row">
		<label for="x_std_rate" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_std_rate"><?php echo $process_table_hs->std_rate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_std_rate" id="z_std_rate" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->std_rate->cellAttributes() ?>>
			<span id="el_process_table_hs_std_rate">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_std_rate" data-value-separator="<?php echo $process_table_hs->std_rate->displayValueSeparatorAttribute() ?>" id="x_std_rate" name="x_std_rate"<?php echo $process_table_hs->std_rate->editAttributes() ?>>
		<?php echo $process_table_hs->std_rate->selectOptionListHtml("x_std_rate") ?>
	</select>
</div>
<?php echo $process_table_hs->std_rate->Lookup->getParamTag("p_x_std_rate") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs__40"><?php echo $process_table_hs->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->_40->cellAttributes() ?>>
			<span id="el_process_table_hs__40">
<input type="text" data-table="process_table_hs" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->_40->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->_40->EditValue ?>"<?php echo $process_table_hs->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_total_amount"><?php echo $process_table_hs->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->total_amount->cellAttributes() ?>>
			<span id="el_process_table_hs_total_amount">
<input type="text" data-table="process_table_hs" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->total_amount->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->total_amount->EditValue ?>"<?php echo $process_table_hs->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label for="x_payment" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_payment"><?php echo $process_table_hs->payment->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment" id="z_payment" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->payment->cellAttributes() ?>>
			<span id="el_process_table_hs_payment">
<input type="text" data-table="process_table_hs" data-field="x_payment" name="x_payment" id="x_payment" size="30" placeholder="<?php echo HtmlEncode($process_table_hs->payment->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->payment->EditValue ?>"<?php echo $process_table_hs->payment->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_remarks"><?php echo $process_table_hs->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->remarks->cellAttributes() ?>>
			<span id="el_process_table_hs_remarks">
<input type="text" data-table="process_table_hs" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="40" placeholder="<?php echo HtmlEncode($process_table_hs->remarks->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->remarks->EditValue ?>"<?php echo $process_table_hs->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_operator"><?php echo $process_table_hs->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->operator->cellAttributes() ?>>
			<span id="el_process_table_hs_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table_hs" data-field="x_operator" data-value-separator="<?php echo $process_table_hs->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process_table_hs->operator->editAttributes() ?>>
		<?php echo $process_table_hs->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process_table_hs->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_datetime"><?php echo $process_table_hs->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->datetime->cellAttributes() ?>>
			<span id="el_process_table_hs_datetime">
<input type="text" data-table="process_table_hs" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_table_hs->datetime->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->datetime->EditValue ?>"<?php echo $process_table_hs->datetime->editAttributes() ?>>
<?php if (!$process_table_hs->datetime->ReadOnly && !$process_table_hs->datetime->Disabled && !isset($process_table_hs->datetime->EditAttrs["readonly"]) && !isset($process_table_hs->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_table_hssearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table_hs->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $process_table_hs_search->LeftColumnClass ?>"><span id="elh_process_table_hs_dated"><?php echo $process_table_hs->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $process_table_hs_search->RightColumnClass ?>"><div<?php echo $process_table_hs->dated->cellAttributes() ?>>
			<span id="el_process_table_hs_dated">
<input type="text" data-table="process_table_hs" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($process_table_hs->dated->getPlaceHolder()) ?>" value="<?php echo $process_table_hs->dated->EditValue ?>"<?php echo $process_table_hs->dated->editAttributes() ?>>
<?php if (!$process_table_hs->dated->ReadOnly && !$process_table_hs->dated->Disabled && !isset($process_table_hs->dated->EditAttrs["readonly"]) && !isset($process_table_hs->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_table_hssearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_table_hs_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_table_hs_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_table_hs_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_table_hs_search->terminate();
?>