<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_add = new process_table_add();

// Run the page
$process_table_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fprocess_tableadd = currentForm = new ew.Form("fprocess_tableadd", "add");

// Validate form
fprocess_tableadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_table_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->type->caption(), $process_table->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->company_id->caption(), $process_table->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->partner->Required) { ?>
			elm = this.getElements("x" + infix + "_partner");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->partner->caption(), $process_table->partner->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->ref_internal->Required) { ?>
			elm = this.getElements("x" + infix + "_ref_internal");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->ref_internal->caption(), $process_table->ref_internal->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->ref->caption(), $process_table->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->rid->caption(), $process_table->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->packets->caption(), $process_table->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_table->packets->errorMessage()) ?>");
		<?php if ($process_table_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->quantity->caption(), $process_table->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_table->quantity->errorMessage()) ?>");
		<?php if ($process_table_add->tmp_lot->Required) { ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->tmp_lot->caption(), $process_table->tmp_lot->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->par_com->Required) { ?>
			elm = this.getElements("x" + infix + "_par_com");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->par_com->caption(), $process_table->par_com->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->packing_type->caption(), $process_table->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->godown->caption(), $process_table->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->dated->caption(), $process_table->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_table->dated->errorMessage()) ?>");
		<?php if ($process_table_add->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->employee_id->caption(), $process_table->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->operator->caption(), $process_table->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->datetime->caption(), $process_table->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_table_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_table->remarks->caption(), $process_table->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_tableadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_tableadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_tableadd.lists["x_type"] = <?php echo $process_table_add->type->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_type"].options = <?php echo JsonEncode($process_table_add->type->options(FALSE, TRUE)) ?>;
fprocess_tableadd.lists["x_company_id"] = <?php echo $process_table_add->company_id->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_company_id"].options = <?php echo JsonEncode($process_table_add->company_id->lookupOptions()) ?>;
fprocess_tableadd.lists["x_partner"] = <?php echo $process_table_add->partner->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_partner"].options = <?php echo JsonEncode($process_table_add->partner->lookupOptions()) ?>;
fprocess_tableadd.lists["x_ref_internal"] = <?php echo $process_table_add->ref_internal->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_ref_internal"].options = <?php echo JsonEncode($process_table_add->ref_internal->lookupOptions()) ?>;
fprocess_tableadd.lists["x_ref"] = <?php echo $process_table_add->ref->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_ref"].options = <?php echo JsonEncode($process_table_add->ref->lookupOptions()) ?>;
fprocess_tableadd.lists["x_rid"] = <?php echo $process_table_add->rid->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_rid"].options = <?php echo JsonEncode($process_table_add->rid->lookupOptions()) ?>;
fprocess_tableadd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_tableadd.lists["x_par_com"] = <?php echo $process_table_add->par_com->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_par_com"].options = <?php echo JsonEncode($process_table_add->par_com->options(FALSE, TRUE)) ?>;
fprocess_tableadd.lists["x_packing_type"] = <?php echo $process_table_add->packing_type->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_add->packing_type->lookupOptions()) ?>;
fprocess_tableadd.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_tableadd.lists["x_godown"] = <?php echo $process_table_add->godown->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_godown"].options = <?php echo JsonEncode($process_table_add->godown->lookupOptions()) ?>;
fprocess_tableadd.lists["x_employee_id[]"] = <?php echo $process_table_add->employee_id->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_table_add->employee_id->lookupOptions()) ?>;
fprocess_tableadd.lists["x_operator"] = <?php echo $process_table_add->operator->Lookup->toClientList() ?>;
fprocess_tableadd.lists["x_operator"].options = <?php echo JsonEncode($process_table_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_table_add->showPageHeader(); ?>
<?php
$process_table_add->showMessage();
?>
<form name="fprocess_tableadd" id="fprocess_tableadd" class="<?php echo $process_table_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$process_table_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($process_table->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_process_table_type" for="x_type" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->type->caption() ?><?php echo ($process_table->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->type->cellAttributes() ?>>
<span id="el_process_table_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_type" data-value-separator="<?php echo $process_table->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $process_table->type->editAttributes() ?>>
		<?php echo $process_table->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $process_table->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_process_table_company_id" for="x_company_id" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->company_id->caption() ?><?php echo ($process_table->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->company_id->cellAttributes() ?>>
<span id="el_process_table_company_id">
<?php $process_table->company_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_table->company_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_company_id" data-value-separator="<?php echo $process_table->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $process_table->company_id->editAttributes() ?>>
		<?php echo $process_table->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $process_table->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $process_table->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->partner->Visible) { // partner ?>
	<div id="r_partner" class="form-group row">
		<label id="elh_process_table_partner" for="x_partner" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->partner->caption() ?><?php echo ($process_table->partner->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->partner->cellAttributes() ?>>
<span id="el_process_table_partner">
<?php $process_table->partner->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_table->partner->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_partner" data-value-separator="<?php echo $process_table->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $process_table->partner->editAttributes() ?>>
		<?php echo $process_table->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $process_table->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
<?php echo $process_table->partner->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->ref_internal->Visible) { // ref_internal ?>
	<div id="r_ref_internal" class="form-group row">
		<label id="elh_process_table_ref_internal" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->ref_internal->caption() ?><?php echo ($process_table->ref_internal->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->ref_internal->cellAttributes() ?>>
<span id="el_process_table_ref_internal">
<?php $process_table->ref_internal->EditAttrs["onclick"] = "ew.autoFill(this); " . @$process_table->ref_internal->EditAttrs["onclick"]; ?>
<div id="tp_x_ref_internal" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table" data-field="x_ref_internal" data-value-separator="<?php echo $process_table->ref_internal->displayValueSeparatorAttribute() ?>" name="x_ref_internal" id="x_ref_internal" value="{value}"<?php echo $process_table->ref_internal->editAttributes() ?>></div>
<div id="dsl_x_ref_internal" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $process_table->ref_internal->radioButtonListHtml(FALSE, "x_ref_internal") ?>
</div></div>
<?php echo $process_table->ref_internal->Lookup->getParamTag("p_x_ref_internal") ?>
</span>
<?php echo $process_table->ref_internal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_process_table_ref" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->ref->caption() ?><?php echo ($process_table->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->ref->cellAttributes() ?>>
<span id="el_process_table_ref">
<?php $process_table->ref->EditAttrs["onclick"] = "ew.autoFill(this); " . @$process_table->ref->EditAttrs["onclick"]; ?>
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table" data-field="x_ref" data-value-separator="<?php echo $process_table->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $process_table->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $process_table->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $process_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $process_table->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_process_table_rid" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->rid->caption() ?><?php echo ($process_table->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->rid->cellAttributes() ?>>
<span id="el_process_table_rid">
<?php
$wrkonchange = "" . trim(@$process_table->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_table->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8880">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($process_table->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_table->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_table->rid->getPlaceHolder()) ?>"<?php echo $process_table->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_table" data-field="x_rid" data-value-separator="<?php echo $process_table->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($process_table->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_tableadd.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $process_table->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $process_table->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_process_table_packets" for="x_packets" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->packets->caption() ?><?php echo ($process_table->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->packets->cellAttributes() ?>>
<span id="el_process_table_packets">
<input type="text" data-table="process_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($process_table->packets->getPlaceHolder()) ?>" value="<?php echo $process_table->packets->EditValue ?>"<?php echo $process_table->packets->editAttributes() ?>>
</span>
<?php echo $process_table->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_process_table_quantity" for="x_quantity" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->quantity->caption() ?><?php echo ($process_table->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->quantity->cellAttributes() ?>>
<span id="el_process_table_quantity">
<input type="text" data-table="process_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_table->quantity->getPlaceHolder()) ?>" value="<?php echo $process_table->quantity->EditValue ?>"<?php echo $process_table->quantity->editAttributes() ?>>
</span>
<?php echo $process_table->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label id="elh_process_table_tmp_lot" for="x_tmp_lot" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->tmp_lot->caption() ?><?php echo ($process_table->tmp_lot->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->tmp_lot->cellAttributes() ?>>
<span id="el_process_table_tmp_lot">
<input type="text" data-table="process_table" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_table->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $process_table->tmp_lot->EditValue ?>"<?php echo $process_table->tmp_lot->editAttributes() ?>>
</span>
<?php echo $process_table->tmp_lot->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->par_com->Visible) { // par_com ?>
	<div id="r_par_com" class="form-group row">
		<label id="elh_process_table_par_com" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->par_com->caption() ?><?php echo ($process_table->par_com->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->par_com->cellAttributes() ?>>
<span id="el_process_table_par_com">
<div id="tp_x_par_com" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table" data-field="x_par_com" data-value-separator="<?php echo $process_table->par_com->displayValueSeparatorAttribute() ?>" name="x_par_com" id="x_par_com" value="{value}"<?php echo $process_table->par_com->editAttributes() ?>></div>
<div id="dsl_x_par_com" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $process_table->par_com->radioButtonListHtml(FALSE, "x_par_com") ?>
</div></div>
</span>
<?php echo $process_table->par_com->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_process_table_packing_type" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->packing_type->caption() ?><?php echo ($process_table->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->packing_type->cellAttributes() ?>>
<span id="el_process_table_packing_type">
<?php
$wrkonchange = "" . trim(@$process_table->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_table->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8830">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($process_table->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_table->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_table->packing_type->getPlaceHolder()) ?>"<?php echo $process_table->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_table" data-field="x_packing_type" data-value-separator="<?php echo $process_table->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($process_table->packing_type->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_tableadd.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $process_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $process_table->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_process_table_godown" for="x_godown" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->godown->caption() ?><?php echo ($process_table->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->godown->cellAttributes() ?>>
<span id="el_process_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_godown" data-value-separator="<?php echo $process_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_table->godown->editAttributes() ?>>
		<?php echo $process_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $process_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $process_table->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_process_table_dated" for="x_dated" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->dated->caption() ?><?php echo ($process_table->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->dated->cellAttributes() ?>>
<span id="el_process_table_dated">
<input type="text" data-table="process_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($process_table->dated->getPlaceHolder()) ?>" value="<?php echo $process_table->dated->EditValue ?>"<?php echo $process_table->dated->editAttributes() ?>>
<?php if (!$process_table->dated->ReadOnly && !$process_table->dated->Disabled && !isset($process_table->dated->EditAttrs["readonly"]) && !isset($process_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_tableadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $process_table->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_process_table_employee_id" for="x_employee_id" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->employee_id->caption() ?><?php echo ($process_table->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->employee_id->cellAttributes() ?>>
<span id="el_process_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($process_table->employee_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_table->employee_id->ViewValue) : $process_table->employee_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_table->employee_id->ReadOnly || $process_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="process_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $process_table->employee_id->CurrentValue ?>"<?php echo $process_table->employee_id->editAttributes() ?>>
</span>
<?php echo $process_table->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_process_table_remarks" for="x_remarks" class="<?php echo $process_table_add->LeftColumnClass ?>"><?php echo $process_table->remarks->caption() ?><?php echo ($process_table->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_table_add->RightColumnClass ?>"><div<?php echo $process_table->remarks->cellAttributes() ?>>
<span id="el_process_table_remarks">
<textarea data-table="process_table" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($process_table->remarks->getPlaceHolder()) ?>"<?php echo $process_table->remarks->editAttributes() ?>><?php echo $process_table->remarks->EditValue ?></textarea>
</span>
<?php echo $process_table->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_table_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_table_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $process_table_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_table_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_table_add->terminate();
?>