<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_list = new process_table_list();

// Run the page
$process_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_tablelist = currentForm = new ew.Form("fprocess_tablelist", "list");
fprocess_tablelist.formKeyCountName = '<?php echo $process_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_tablelist.lists["x_type"] = <?php echo $process_table_list->type->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_type"].options = <?php echo JsonEncode($process_table_list->type->options(FALSE, TRUE)) ?>;
fprocess_tablelist.lists["x_company_id"] = <?php echo $process_table_list->company_id->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_company_id"].options = <?php echo JsonEncode($process_table_list->company_id->lookupOptions()) ?>;
fprocess_tablelist.lists["x_partner"] = <?php echo $process_table_list->partner->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_partner"].options = <?php echo JsonEncode($process_table_list->partner->lookupOptions()) ?>;
fprocess_tablelist.lists["x_ref_internal"] = <?php echo $process_table_list->ref_internal->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_ref_internal"].options = <?php echo JsonEncode($process_table_list->ref_internal->lookupOptions()) ?>;
fprocess_tablelist.lists["x_ref"] = <?php echo $process_table_list->ref->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_ref"].options = <?php echo JsonEncode($process_table_list->ref->lookupOptions()) ?>;
fprocess_tablelist.lists["x_par_com"] = <?php echo $process_table_list->par_com->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_par_com"].options = <?php echo JsonEncode($process_table_list->par_com->options(FALSE, TRUE)) ?>;
fprocess_tablelist.lists["x_packing_type"] = <?php echo $process_table_list->packing_type->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_list->packing_type->lookupOptions()) ?>;
fprocess_tablelist.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_tablelist.lists["x_godown"] = <?php echo $process_table_list->godown->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_godown"].options = <?php echo JsonEncode($process_table_list->godown->lookupOptions()) ?>;
fprocess_tablelist.lists["x_employee_id[]"] = <?php echo $process_table_list->employee_id->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_table_list->employee_id->lookupOptions()) ?>;
fprocess_tablelist.lists["x_operator"] = <?php echo $process_table_list->operator->Lookup->toClientList() ?>;
fprocess_tablelist.lists["x_operator"].options = <?php echo JsonEncode($process_table_list->operator->lookupOptions()) ?>;

// Form object for search
var fprocess_tablelistsrch = currentSearchForm = new ew.Form("fprocess_tablelistsrch");

// Validate function for search
fprocess_tablelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_tablelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_tablelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_tablelistsrch.lists["x_ref"] = <?php echo $process_table_list->ref->Lookup->toClientList() ?>;
fprocess_tablelistsrch.lists["x_ref"].options = <?php echo JsonEncode($process_table_list->ref->lookupOptions()) ?>;
fprocess_tablelistsrch.lists["x_packing_type"] = <?php echo $process_table_list->packing_type->Lookup->toClientList() ?>;
fprocess_tablelistsrch.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_list->packing_type->lookupOptions()) ?>;
fprocess_tablelistsrch.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_tablelistsrch.lists["x_godown"] = <?php echo $process_table_list->godown->Lookup->toClientList() ?>;
fprocess_tablelistsrch.lists["x_godown"].options = <?php echo JsonEncode($process_table_list->godown->lookupOptions()) ?>;

// Filters
fprocess_tablelistsrch.filterList = <?php echo $process_table_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_tablelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_table_list->TotalRecs > 0 && $process_table_list->ExportOptions->visible()) { ?>
<?php $process_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_list->ImportOptions->visible()) { ?>
<?php $process_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_list->SearchOptions->visible()) { ?>
<?php $process_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_table_list->FilterOptions->visible()) { ?>
<?php $process_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_table->isExport() && !$process_table->CurrentAction) { ?>
<form name="fprocess_tablelistsrch" id="fprocess_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_table">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_table_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_table->RowType = ROWTYPE_SEARCH;

// Render row
$process_table->resetAttributes();
$process_table_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_table->ref->Visible) { // ref ?>
	<div id="xsc_ref" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_table->ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="process_table" data-field="x_ref" name="x_ref" id="x_ref" size="30" placeholder="<?php echo HtmlEncode($process_table->ref->getPlaceHolder()) ?>" value="<?php echo $process_table->ref->EditValue ?>"<?php echo $process_table->ref->editAttributes() ?>>
<?php echo $process_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_table->packing_type->Visible) { // packing_type ?>
	<div id="xsc_packing_type" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_table->packing_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$process_table->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_table->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8830">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($process_table->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_table->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_table->packing_type->getPlaceHolder()) ?>"<?php echo $process_table->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_table" data-field="x_packing_type" data-value-separator="<?php echo $process_table->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($process_table->packing_type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_tablelistsrch.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $process_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_table->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $process_table->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_godown" data-value-separator="<?php echo $process_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_table->godown->editAttributes() ?>>
		<?php echo $process_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $process_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_table_list->showPageHeader(); ?>
<?php
$process_table_list->showMessage();
?>
<?php if ($process_table_list->TotalRecs > 0 || $process_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_table">
<?php if (!$process_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_table_list->Pager)) $process_table_list->Pager = new PrevNextPager($process_table_list->StartRec, $process_table_list->DisplayRecs, $process_table_list->TotalRecs, $process_table_list->AutoHidePager) ?>
<?php if ($process_table_list->Pager->RecordCount > 0 && $process_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_table_list->TotalRecs > 0 && (!$process_table_list->AutoHidePageSizeSelector || $process_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_tablelist" id="fprocess_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table">
<div id="gmp_process_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_table_list->TotalRecs > 0 || $process_table->isGridEdit()) { ?>
<table id="tbl_process_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_table_list->renderListOptions();

// Render list options (header, left)
$process_table_list->ListOptions->render("header", "left");
?>
<?php if ($process_table->id->Visible) { // id ?>
	<?php if ($process_table->sortUrl($process_table->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_table->id->headerCellClass() ?>"><div id="elh_process_table_id" class="process_table_id"><div class="ew-table-header-caption"><?php echo $process_table->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_table->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->id) ?>',2);"><div id="elh_process_table_id" class="process_table_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->type->Visible) { // type ?>
	<?php if ($process_table->sortUrl($process_table->type) == "") { ?>
		<th data-name="type" class="<?php echo $process_table->type->headerCellClass() ?>"><div id="elh_process_table_type" class="process_table_type"><div class="ew-table-header-caption"><?php echo $process_table->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $process_table->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->type) ?>',2);"><div id="elh_process_table_type" class="process_table_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->company_id->Visible) { // company_id ?>
	<?php if ($process_table->sortUrl($process_table->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $process_table->company_id->headerCellClass() ?>"><div id="elh_process_table_company_id" class="process_table_company_id"><div class="ew-table-header-caption"><?php echo $process_table->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $process_table->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->company_id) ?>',2);"><div id="elh_process_table_company_id" class="process_table_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->partner->Visible) { // partner ?>
	<?php if ($process_table->sortUrl($process_table->partner) == "") { ?>
		<th data-name="partner" class="<?php echo $process_table->partner->headerCellClass() ?>"><div id="elh_process_table_partner" class="process_table_partner"><div class="ew-table-header-caption"><?php echo $process_table->partner->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner" class="<?php echo $process_table->partner->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->partner) ?>',2);"><div id="elh_process_table_partner" class="process_table_partner">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->partner->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->partner->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->partner->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->ref_internal->Visible) { // ref_internal ?>
	<?php if ($process_table->sortUrl($process_table->ref_internal) == "") { ?>
		<th data-name="ref_internal" class="<?php echo $process_table->ref_internal->headerCellClass() ?>"><div id="elh_process_table_ref_internal" class="process_table_ref_internal"><div class="ew-table-header-caption"><?php echo $process_table->ref_internal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref_internal" class="<?php echo $process_table->ref_internal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->ref_internal) ?>',2);"><div id="elh_process_table_ref_internal" class="process_table_ref_internal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->ref_internal->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->ref_internal->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->ref_internal->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->ref->Visible) { // ref ?>
	<?php if ($process_table->sortUrl($process_table->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $process_table->ref->headerCellClass() ?>"><div id="elh_process_table_ref" class="process_table_ref"><div class="ew-table-header-caption"><?php echo $process_table->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $process_table->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->ref) ?>',2);"><div id="elh_process_table_ref" class="process_table_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->packets->Visible) { // packets ?>
	<?php if ($process_table->sortUrl($process_table->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $process_table->packets->headerCellClass() ?>"><div id="elh_process_table_packets" class="process_table_packets"><div class="ew-table-header-caption"><?php echo $process_table->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $process_table->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->packets) ?>',2);"><div id="elh_process_table_packets" class="process_table_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->quantity->Visible) { // quantity ?>
	<?php if ($process_table->sortUrl($process_table->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $process_table->quantity->headerCellClass() ?>"><div id="elh_process_table_quantity" class="process_table_quantity"><div class="ew-table-header-caption"><?php echo $process_table->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $process_table->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->quantity) ?>',2);"><div id="elh_process_table_quantity" class="process_table_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($process_table->sortUrl($process_table->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $process_table->tmp_lot->headerCellClass() ?>"><div id="elh_process_table_tmp_lot" class="process_table_tmp_lot"><div class="ew-table-header-caption"><?php echo $process_table->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $process_table->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->tmp_lot) ?>',2);"><div id="elh_process_table_tmp_lot" class="process_table_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_table->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->par_com->Visible) { // par_com ?>
	<?php if ($process_table->sortUrl($process_table->par_com) == "") { ?>
		<th data-name="par_com" class="<?php echo $process_table->par_com->headerCellClass() ?>"><div id="elh_process_table_par_com" class="process_table_par_com"><div class="ew-table-header-caption"><?php echo $process_table->par_com->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="par_com" class="<?php echo $process_table->par_com->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->par_com) ?>',2);"><div id="elh_process_table_par_com" class="process_table_par_com">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->par_com->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->par_com->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->par_com->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->packing_type->Visible) { // packing_type ?>
	<?php if ($process_table->sortUrl($process_table->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $process_table->packing_type->headerCellClass() ?>"><div id="elh_process_table_packing_type" class="process_table_packing_type"><div class="ew-table-header-caption"><?php echo $process_table->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $process_table->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->packing_type) ?>',2);"><div id="elh_process_table_packing_type" class="process_table_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->godown->Visible) { // godown ?>
	<?php if ($process_table->sortUrl($process_table->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $process_table->godown->headerCellClass() ?>"><div id="elh_process_table_godown" class="process_table_godown"><div class="ew-table-header-caption"><?php echo $process_table->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $process_table->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->godown) ?>',2);"><div id="elh_process_table_godown" class="process_table_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->dated->Visible) { // dated ?>
	<?php if ($process_table->sortUrl($process_table->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $process_table->dated->headerCellClass() ?>"><div id="elh_process_table_dated" class="process_table_dated"><div class="ew-table-header-caption"><?php echo $process_table->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $process_table->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->dated) ?>',2);"><div id="elh_process_table_dated" class="process_table_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->employee_id->Visible) { // employee_id ?>
	<?php if ($process_table->sortUrl($process_table->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $process_table->employee_id->headerCellClass() ?>"><div id="elh_process_table_employee_id" class="process_table_employee_id"><div class="ew-table-header-caption"><?php echo $process_table->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $process_table->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->employee_id) ?>',2);"><div id="elh_process_table_employee_id" class="process_table_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->operator->Visible) { // operator ?>
	<?php if ($process_table->sortUrl($process_table->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_table->operator->headerCellClass() ?>"><div id="elh_process_table_operator" class="process_table_operator"><div class="ew-table-header-caption"><?php echo $process_table->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_table->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->operator) ?>',2);"><div id="elh_process_table_operator" class="process_table_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->datetime->Visible) { // datetime ?>
	<?php if ($process_table->sortUrl($process_table->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_table->datetime->headerCellClass() ?>"><div id="elh_process_table_datetime" class="process_table_datetime"><div class="ew-table-header-caption"><?php echo $process_table->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_table->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->datetime) ?>',2);"><div id="elh_process_table_datetime" class="process_table_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_table->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_table->remarks->Visible) { // remarks ?>
	<?php if ($process_table->sortUrl($process_table->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_table->remarks->headerCellClass() ?>"><div id="elh_process_table_remarks" class="process_table_remarks"><div class="ew-table-header-caption"><?php echo $process_table->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_table->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_table->SortUrl($process_table->remarks) ?>',2);"><div id="elh_process_table_remarks" class="process_table_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_table->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_table->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_table->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_table->ExportAll && $process_table->isExport()) {
	$process_table_list->StopRec = $process_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_table_list->TotalRecs > $process_table_list->StartRec + $process_table_list->DisplayRecs - 1)
		$process_table_list->StopRec = $process_table_list->StartRec + $process_table_list->DisplayRecs - 1;
	else
		$process_table_list->StopRec = $process_table_list->TotalRecs;
}
$process_table_list->RecCnt = $process_table_list->StartRec - 1;
if ($process_table_list->Recordset && !$process_table_list->Recordset->EOF) {
	$process_table_list->Recordset->moveFirst();
	$selectLimit = $process_table_list->UseSelectLimit;
	if (!$selectLimit && $process_table_list->StartRec > 1)
		$process_table_list->Recordset->move($process_table_list->StartRec - 1);
} elseif (!$process_table->AllowAddDeleteRow && $process_table_list->StopRec == 0) {
	$process_table_list->StopRec = $process_table->GridAddRowCount;
}

// Initialize aggregate
$process_table->RowType = ROWTYPE_AGGREGATEINIT;
$process_table->resetAttributes();
$process_table_list->renderRow();
while ($process_table_list->RecCnt < $process_table_list->StopRec) {
	$process_table_list->RecCnt++;
	if ($process_table_list->RecCnt >= $process_table_list->StartRec) {
		$process_table_list->RowCnt++;

		// Set up key count
		$process_table_list->KeyCount = $process_table_list->RowIndex;

		// Init row class and style
		$process_table->resetAttributes();
		$process_table->CssClass = "";
		if ($process_table->isGridAdd()) {
		} else {
			$process_table_list->loadRowValues($process_table_list->Recordset); // Load row values
		}
		$process_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_table->RowAttrs = array_merge($process_table->RowAttrs, array('data-rowindex'=>$process_table_list->RowCnt, 'id'=>'r' . $process_table_list->RowCnt . '_process_table', 'data-rowtype'=>$process_table->RowType));

		// Render row
		$process_table_list->renderRow();

		// Render list options
		$process_table_list->renderListOptions();
?>
	<tr<?php echo $process_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_table_list->ListOptions->render("body", "left", $process_table_list->RowCnt);
?>
	<?php if ($process_table->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_table->id->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_id" class="process_table_id">
<span<?php echo $process_table->id->viewAttributes() ?>>
<?php echo $process_table->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->type->Visible) { // type ?>
		<td data-name="type"<?php echo $process_table->type->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_type" class="process_table_type">
<span<?php echo $process_table->type->viewAttributes() ?>>
<?php echo $process_table->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $process_table->company_id->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_company_id" class="process_table_company_id">
<span<?php echo $process_table->company_id->viewAttributes() ?>>
<?php echo $process_table->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->partner->Visible) { // partner ?>
		<td data-name="partner"<?php echo $process_table->partner->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_partner" class="process_table_partner">
<span<?php echo $process_table->partner->viewAttributes() ?>>
<?php echo $process_table->partner->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->ref_internal->Visible) { // ref_internal ?>
		<td data-name="ref_internal"<?php echo $process_table->ref_internal->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_ref_internal" class="process_table_ref_internal">
<span<?php echo $process_table->ref_internal->viewAttributes() ?>>
<?php echo $process_table->ref_internal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $process_table->ref->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_ref" class="process_table_ref">
<span<?php echo $process_table->ref->viewAttributes() ?>>
<?php echo $process_table->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $process_table->packets->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_packets" class="process_table_packets">
<span<?php echo $process_table->packets->viewAttributes() ?>>
<?php echo $process_table->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $process_table->quantity->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_quantity" class="process_table_quantity">
<span<?php echo $process_table->quantity->viewAttributes() ?>>
<?php echo $process_table->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $process_table->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_tmp_lot" class="process_table_tmp_lot">
<span<?php echo $process_table->tmp_lot->viewAttributes() ?>>
<?php echo $process_table->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->par_com->Visible) { // par_com ?>
		<td data-name="par_com"<?php echo $process_table->par_com->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_par_com" class="process_table_par_com">
<span<?php echo $process_table->par_com->viewAttributes() ?>>
<?php echo $process_table->par_com->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $process_table->packing_type->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_packing_type" class="process_table_packing_type">
<span<?php echo $process_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($process_table->packing_type->getViewValue())) && $process_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $process_table->packing_type->linkAttributes() ?>><?php echo $process_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $process_table->godown->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_godown" class="process_table_godown">
<span<?php echo $process_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($process_table->godown->getViewValue())) && $process_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $process_table->godown->linkAttributes() ?>><?php echo $process_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $process_table->dated->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_dated" class="process_table_dated">
<span<?php echo $process_table->dated->viewAttributes() ?>>
<?php echo $process_table->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $process_table->employee_id->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_employee_id" class="process_table_employee_id">
<span<?php echo $process_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($process_table->employee_id->getViewValue())) && $process_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $process_table->employee_id->linkAttributes() ?>><?php echo $process_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_table->operator->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_operator" class="process_table_operator">
<span<?php echo $process_table->operator->viewAttributes() ?>>
<?php echo $process_table->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_table->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_datetime" class="process_table_datetime">
<span<?php echo $process_table->datetime->viewAttributes() ?>>
<?php echo $process_table->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_table->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_table_list->RowCnt ?>_process_table_remarks" class="process_table_remarks">
<span<?php echo $process_table->remarks->viewAttributes() ?>>
<?php echo $process_table->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_table_list->ListOptions->render("body", "right", $process_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_table->isGridAdd())
		$process_table_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$process_table->RowType = ROWTYPE_AGGREGATE;
$process_table->resetAttributes();
$process_table_list->renderRow();
?>
<?php if ($process_table_list->TotalRecs > 0 && !$process_table->isGridAdd() && !$process_table->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$process_table_list->renderListOptions();

// Render list options (footer, left)
$process_table_list->ListOptions->render("footer", "left");
?>
	<?php if ($process_table->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $process_table->id->footerCellClass() ?>"><span id="elf_process_table_id" class="process_table_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $process_table->type->footerCellClass() ?>"><span id="elf_process_table_type" class="process_table_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $process_table->company_id->footerCellClass() ?>"><span id="elf_process_table_company_id" class="process_table_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->partner->Visible) { // partner ?>
		<td data-name="partner" class="<?php echo $process_table->partner->footerCellClass() ?>"><span id="elf_process_table_partner" class="process_table_partner">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->ref_internal->Visible) { // ref_internal ?>
		<td data-name="ref_internal" class="<?php echo $process_table->ref_internal->footerCellClass() ?>"><span id="elf_process_table_ref_internal" class="process_table_ref_internal">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $process_table->ref->footerCellClass() ?>"><span id="elf_process_table_ref" class="process_table_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $process_table->packets->footerCellClass() ?>"><span id="elf_process_table_packets" class="process_table_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_table->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $process_table->quantity->footerCellClass() ?>"><span id="elf_process_table_quantity" class="process_table_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_table->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_table->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $process_table->tmp_lot->footerCellClass() ?>"><span id="elf_process_table_tmp_lot" class="process_table_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->par_com->Visible) { // par_com ?>
		<td data-name="par_com" class="<?php echo $process_table->par_com->footerCellClass() ?>"><span id="elf_process_table_par_com" class="process_table_par_com">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $process_table->packing_type->footerCellClass() ?>"><span id="elf_process_table_packing_type" class="process_table_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $process_table->godown->footerCellClass() ?>"><span id="elf_process_table_godown" class="process_table_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $process_table->dated->footerCellClass() ?>"><span id="elf_process_table_dated" class="process_table_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id" class="<?php echo $process_table->employee_id->footerCellClass() ?>"><span id="elf_process_table_employee_id" class="process_table_employee_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $process_table->operator->footerCellClass() ?>"><span id="elf_process_table_operator" class="process_table_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $process_table->datetime->footerCellClass() ?>"><span id="elf_process_table_datetime" class="process_table_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $process_table->remarks->footerCellClass() ?>"><span id="elf_process_table_remarks" class="process_table_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$process_table_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_table_list->Recordset)
	$process_table_list->Recordset->Close();
?>
<?php if (!$process_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_table_list->Pager)) $process_table_list->Pager = new PrevNextPager($process_table_list->StartRec, $process_table_list->DisplayRecs, $process_table_list->TotalRecs, $process_table_list->AutoHidePager) ?>
<?php if ($process_table_list->Pager->RecordCount > 0 && $process_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_table_list->pageUrl() ?>start=<?php echo $process_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_table_list->TotalRecs > 0 && (!$process_table_list->AutoHidePageSizeSelector || $process_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_table_list->TotalRecs == 0 && !$process_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_table_list->terminate();
?>