<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_search = new process_table_search();

// Run the page
$process_table_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_table_search->IsModal) { ?>
var fprocess_tablesearch = currentAdvancedSearchForm = new ew.Form("fprocess_tablesearch", "search");
<?php } else { ?>
var fprocess_tablesearch = currentForm = new ew.Form("fprocess_tablesearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_tablesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_tablesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_tablesearch.lists["x_type"] = <?php echo $process_table_search->type->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_type"].options = <?php echo JsonEncode($process_table_search->type->options(FALSE, TRUE)) ?>;
fprocess_tablesearch.lists["x_company_id"] = <?php echo $process_table_search->company_id->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_company_id"].options = <?php echo JsonEncode($process_table_search->company_id->lookupOptions()) ?>;
fprocess_tablesearch.lists["x_partner"] = <?php echo $process_table_search->partner->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_partner"].options = <?php echo JsonEncode($process_table_search->partner->lookupOptions()) ?>;
fprocess_tablesearch.lists["x_ref_internal"] = <?php echo $process_table_search->ref_internal->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_ref_internal"].options = <?php echo JsonEncode($process_table_search->ref_internal->lookupOptions()) ?>;
fprocess_tablesearch.lists["x_ref"] = <?php echo $process_table_search->ref->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_ref"].options = <?php echo JsonEncode($process_table_search->ref->lookupOptions()) ?>;
fprocess_tablesearch.lists["x_par_com"] = <?php echo $process_table_search->par_com->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_par_com"].options = <?php echo JsonEncode($process_table_search->par_com->options(FALSE, TRUE)) ?>;
fprocess_tablesearch.lists["x_packing_type"] = <?php echo $process_table_search->packing_type->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_search->packing_type->lookupOptions()) ?>;
fprocess_tablesearch.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_tablesearch.lists["x_godown"] = <?php echo $process_table_search->godown->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_godown"].options = <?php echo JsonEncode($process_table_search->godown->lookupOptions()) ?>;
fprocess_tablesearch.lists["x_employee_id[]"] = <?php echo $process_table_search->employee_id->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_table_search->employee_id->lookupOptions()) ?>;
fprocess_tablesearch.lists["x_operator"] = <?php echo $process_table_search->operator->Lookup->toClientList() ?>;
fprocess_tablesearch.lists["x_operator"].options = <?php echo JsonEncode($process_table_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocess_tablesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_table->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_table_search->showPageHeader(); ?>
<?php
$process_table_search->showMessage();
?>
<form name="fprocess_tablesearch" id="fprocess_tablesearch" class="<?php echo $process_table_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_table_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_table->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_id"><?php echo $process_table->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->id->cellAttributes() ?>>
			<span id="el_process_table_id">
<input type="text" data-table="process_table" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_table->id->getPlaceHolder()) ?>" value="<?php echo $process_table->id->EditValue ?>"<?php echo $process_table->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_type"><?php echo $process_table->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->type->cellAttributes() ?>>
			<span id="el_process_table_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_type" data-value-separator="<?php echo $process_table->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $process_table->type->editAttributes() ?>>
		<?php echo $process_table->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_company_id"><?php echo $process_table->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->company_id->cellAttributes() ?>>
			<span id="el_process_table_company_id">
<?php $process_table->company_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_table->company_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_company_id" data-value-separator="<?php echo $process_table->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $process_table->company_id->editAttributes() ?>>
		<?php echo $process_table->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $process_table->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->partner->Visible) { // partner ?>
	<div id="r_partner" class="form-group row">
		<label for="x_partner" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_partner"><?php echo $process_table->partner->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner" id="z_partner" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->partner->cellAttributes() ?>>
			<span id="el_process_table_partner">
<?php $process_table->partner->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_table->partner->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_partner" data-value-separator="<?php echo $process_table->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $process_table->partner->editAttributes() ?>>
		<?php echo $process_table->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $process_table->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->ref_internal->Visible) { // ref_internal ?>
	<div id="r_ref_internal" class="form-group row">
		<label class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_ref_internal"><?php echo $process_table->ref_internal->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref_internal" id="z_ref_internal" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->ref_internal->cellAttributes() ?>>
			<span id="el_process_table_ref_internal">
<div id="tp_x_ref_internal" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table" data-field="x_ref_internal" data-value-separator="<?php echo $process_table->ref_internal->displayValueSeparatorAttribute() ?>" name="x_ref_internal" id="x_ref_internal" value="{value}"<?php echo $process_table->ref_internal->editAttributes() ?>></div>
<div id="dsl_x_ref_internal" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $process_table->ref_internal->radioButtonListHtml(FALSE, "x_ref_internal") ?>
</div></div>
<?php echo $process_table->ref_internal->Lookup->getParamTag("p_x_ref_internal") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_ref"><?php echo $process_table->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->ref->cellAttributes() ?>>
			<span id="el_process_table_ref">
<input type="text" data-table="process_table" data-field="x_ref" name="x_ref" id="x_ref" size="30" placeholder="<?php echo HtmlEncode($process_table->ref->getPlaceHolder()) ?>" value="<?php echo $process_table->ref->EditValue ?>"<?php echo $process_table->ref->editAttributes() ?>>
<?php echo $process_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_packets"><?php echo $process_table->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->packets->cellAttributes() ?>>
			<span id="el_process_table_packets">
<input type="text" data-table="process_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($process_table->packets->getPlaceHolder()) ?>" value="<?php echo $process_table->packets->EditValue ?>"<?php echo $process_table->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_quantity"><?php echo $process_table->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->quantity->cellAttributes() ?>>
			<span id="el_process_table_quantity">
<input type="text" data-table="process_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_table->quantity->getPlaceHolder()) ?>" value="<?php echo $process_table->quantity->EditValue ?>"<?php echo $process_table->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_tmp_lot"><?php echo $process_table->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->tmp_lot->cellAttributes() ?>>
			<span id="el_process_table_tmp_lot">
<input type="text" data-table="process_table" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_table->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $process_table->tmp_lot->EditValue ?>"<?php echo $process_table->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->par_com->Visible) { // par_com ?>
	<div id="r_par_com" class="form-group row">
		<label class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_par_com"><?php echo $process_table->par_com->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_par_com" id="z_par_com" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->par_com->cellAttributes() ?>>
			<span id="el_process_table_par_com">
<div id="tp_x_par_com" class="ew-template"><input type="radio" class="form-check-input" data-table="process_table" data-field="x_par_com" data-value-separator="<?php echo $process_table->par_com->displayValueSeparatorAttribute() ?>" name="x_par_com" id="x_par_com" value="{value}"<?php echo $process_table->par_com->editAttributes() ?>></div>
<div id="dsl_x_par_com" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $process_table->par_com->radioButtonListHtml(FALSE, "x_par_com") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_packing_type"><?php echo $process_table->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->packing_type->cellAttributes() ?>>
			<span id="el_process_table_packing_type">
<?php
$wrkonchange = "" . trim(@$process_table->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_table->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8830">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($process_table->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_table->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_table->packing_type->getPlaceHolder()) ?>"<?php echo $process_table->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_table" data-field="x_packing_type" data-value-separator="<?php echo $process_table->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($process_table->packing_type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_tablesearch.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $process_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_godown"><?php echo $process_table->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->godown->cellAttributes() ?>>
			<span id="el_process_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_godown" data-value-separator="<?php echo $process_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $process_table->godown->editAttributes() ?>>
		<?php echo $process_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $process_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_dated"><?php echo $process_table->dated->caption() ?></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_table->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_table_dated">
<input type="text" data-table="process_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($process_table->dated->getPlaceHolder()) ?>" value="<?php echo $process_table->dated->EditValue ?>"<?php echo $process_table->dated->editAttributes() ?>>
<?php if (!$process_table->dated->ReadOnly && !$process_table->dated->Disabled && !isset($process_table->dated->EditAttrs["readonly"]) && !isset($process_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_tablesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_table_dated" class="btw1_dated d-none">
<input type="text" data-table="process_table" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($process_table->dated->getPlaceHolder()) ?>" value="<?php echo $process_table->dated->EditValue2 ?>"<?php echo $process_table->dated->editAttributes() ?>>
<?php if (!$process_table->dated->ReadOnly && !$process_table->dated->Disabled && !isset($process_table->dated->EditAttrs["readonly"]) && !isset($process_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_tablesearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_employee_id"><?php echo $process_table->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->employee_id->cellAttributes() ?>>
			<span id="el_process_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($process_table->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_table->employee_id->AdvancedSearch->ViewValue) : $process_table->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_table->employee_id->ReadOnly || $process_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="process_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $process_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $process_table->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $process_table->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_operator"><?php echo $process_table->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->operator->cellAttributes() ?>>
			<span id="el_process_table_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_table" data-field="x_operator" data-value-separator="<?php echo $process_table->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process_table->operator->editAttributes() ?>>
		<?php echo $process_table->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process_table->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_datetime"><?php echo $process_table->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_table->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_table_datetime">
<input type="text" data-table="process_table" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_table->datetime->getPlaceHolder()) ?>" value="<?php echo $process_table->datetime->EditValue ?>"<?php echo $process_table->datetime->editAttributes() ?>>
<?php if (!$process_table->datetime->ReadOnly && !$process_table->datetime->Disabled && !isset($process_table->datetime->EditAttrs["readonly"]) && !isset($process_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_tablesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_table_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_table" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_table->datetime->getPlaceHolder()) ?>" value="<?php echo $process_table->datetime->EditValue2 ?>"<?php echo $process_table->datetime->editAttributes() ?>>
<?php if (!$process_table->datetime->ReadOnly && !$process_table->datetime->Disabled && !isset($process_table->datetime->EditAttrs["readonly"]) && !isset($process_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_tablesearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $process_table_search->LeftColumnClass ?>"><span id="elh_process_table_remarks"><?php echo $process_table->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_table_search->RightColumnClass ?>"><div<?php echo $process_table->remarks->cellAttributes() ?>>
			<span id="el_process_table_remarks">
<input type="text" data-table="process_table" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="40" placeholder="<?php echo HtmlEncode($process_table->remarks->getPlaceHolder()) ?>" value="<?php echo $process_table->remarks->EditValue ?>"<?php echo $process_table->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_table_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_table_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_table_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_table_search->terminate();
?>