<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_table_view = new process_table_view();

// Run the page
$process_table_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_table_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fprocess_tableview = currentForm = new ew.Form("fprocess_tableview", "view");

// Form_CustomValidate event
fprocess_tableview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_tableview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_tableview.lists["x_type"] = <?php echo $process_table_view->type->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_type"].options = <?php echo JsonEncode($process_table_view->type->options(FALSE, TRUE)) ?>;
fprocess_tableview.lists["x_company_id"] = <?php echo $process_table_view->company_id->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_company_id"].options = <?php echo JsonEncode($process_table_view->company_id->lookupOptions()) ?>;
fprocess_tableview.lists["x_partner"] = <?php echo $process_table_view->partner->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_partner"].options = <?php echo JsonEncode($process_table_view->partner->lookupOptions()) ?>;
fprocess_tableview.lists["x_ref_internal"] = <?php echo $process_table_view->ref_internal->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_ref_internal"].options = <?php echo JsonEncode($process_table_view->ref_internal->lookupOptions()) ?>;
fprocess_tableview.lists["x_ref"] = <?php echo $process_table_view->ref->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_ref"].options = <?php echo JsonEncode($process_table_view->ref->lookupOptions()) ?>;
fprocess_tableview.lists["x_rid"] = <?php echo $process_table_view->rid->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_rid"].options = <?php echo JsonEncode($process_table_view->rid->lookupOptions()) ?>;
fprocess_tableview.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_tableview.lists["x_par_com"] = <?php echo $process_table_view->par_com->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_par_com"].options = <?php echo JsonEncode($process_table_view->par_com->options(FALSE, TRUE)) ?>;
fprocess_tableview.lists["x_packing_type"] = <?php echo $process_table_view->packing_type->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_packing_type"].options = <?php echo JsonEncode($process_table_view->packing_type->lookupOptions()) ?>;
fprocess_tableview.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_tableview.lists["x_godown"] = <?php echo $process_table_view->godown->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_godown"].options = <?php echo JsonEncode($process_table_view->godown->lookupOptions()) ?>;
fprocess_tableview.lists["x_employee_id[]"] = <?php echo $process_table_view->employee_id->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_employee_id[]"].options = <?php echo JsonEncode($process_table_view->employee_id->lookupOptions()) ?>;
fprocess_tableview.lists["x_operator"] = <?php echo $process_table_view->operator->Lookup->toClientList() ?>;
fprocess_tableview.lists["x_operator"].options = <?php echo JsonEncode($process_table_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $process_table_view->ExportOptions->render("body") ?>
<?php $process_table_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $process_table_view->showPageHeader(); ?>
<?php
$process_table_view->showMessage();
?>
<form name="fprocess_tableview" id="fprocess_tableview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_table_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_table_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_table">
<input type="hidden" name="modal" value="<?php echo (int)$process_table_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($process_table->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_id"><?php echo $process_table->id->caption() ?></span></td>
		<td data-name="id"<?php echo $process_table->id->cellAttributes() ?>>
<span id="el_process_table_id">
<span<?php echo $process_table->id->viewAttributes() ?>>
<?php echo $process_table->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_type"><?php echo $process_table->type->caption() ?></span></td>
		<td data-name="type"<?php echo $process_table->type->cellAttributes() ?>>
<span id="el_process_table_type">
<span<?php echo $process_table->type->viewAttributes() ?>>
<?php echo $process_table->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_company_id"><?php echo $process_table->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $process_table->company_id->cellAttributes() ?>>
<span id="el_process_table_company_id">
<span<?php echo $process_table->company_id->viewAttributes() ?>>
<?php echo $process_table->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->partner->Visible) { // partner ?>
	<tr id="r_partner">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_partner"><?php echo $process_table->partner->caption() ?></span></td>
		<td data-name="partner"<?php echo $process_table->partner->cellAttributes() ?>>
<span id="el_process_table_partner">
<span<?php echo $process_table->partner->viewAttributes() ?>>
<?php echo $process_table->partner->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->ref_internal->Visible) { // ref_internal ?>
	<tr id="r_ref_internal">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_ref_internal"><?php echo $process_table->ref_internal->caption() ?></span></td>
		<td data-name="ref_internal"<?php echo $process_table->ref_internal->cellAttributes() ?>>
<span id="el_process_table_ref_internal">
<span<?php echo $process_table->ref_internal->viewAttributes() ?>>
<?php echo $process_table->ref_internal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_ref"><?php echo $process_table->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $process_table->ref->cellAttributes() ?>>
<span id="el_process_table_ref">
<span<?php echo $process_table->ref->viewAttributes() ?>>
<?php echo $process_table->ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_rid"><?php echo $process_table->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $process_table->rid->cellAttributes() ?>>
<span id="el_process_table_rid">
<span<?php echo $process_table->rid->viewAttributes() ?>>
<?php if ((!EmptyString($process_table->rid->getViewValue())) && $process_table->rid->linkAttributes() <> "") { ?>
<a<?php echo $process_table->rid->linkAttributes() ?>><?php echo $process_table->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_packets"><?php echo $process_table->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $process_table->packets->cellAttributes() ?>>
<span id="el_process_table_packets">
<span<?php echo $process_table->packets->viewAttributes() ?>>
<?php echo $process_table->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_quantity"><?php echo $process_table->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $process_table->quantity->cellAttributes() ?>>
<span id="el_process_table_quantity">
<span<?php echo $process_table->quantity->viewAttributes() ?>>
<?php echo $process_table->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->tmp_lot->Visible) { // tmp_lot ?>
	<tr id="r_tmp_lot">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_tmp_lot"><?php echo $process_table->tmp_lot->caption() ?></span></td>
		<td data-name="tmp_lot"<?php echo $process_table->tmp_lot->cellAttributes() ?>>
<span id="el_process_table_tmp_lot">
<span<?php echo $process_table->tmp_lot->viewAttributes() ?>>
<?php echo $process_table->tmp_lot->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->par_com->Visible) { // par_com ?>
	<tr id="r_par_com">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_par_com"><?php echo $process_table->par_com->caption() ?></span></td>
		<td data-name="par_com"<?php echo $process_table->par_com->cellAttributes() ?>>
<span id="el_process_table_par_com">
<span<?php echo $process_table->par_com->viewAttributes() ?>>
<?php echo $process_table->par_com->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_packing_type"><?php echo $process_table->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $process_table->packing_type->cellAttributes() ?>>
<span id="el_process_table_packing_type">
<span<?php echo $process_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($process_table->packing_type->getViewValue())) && $process_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $process_table->packing_type->linkAttributes() ?>><?php echo $process_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_godown"><?php echo $process_table->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $process_table->godown->cellAttributes() ?>>
<span id="el_process_table_godown">
<span<?php echo $process_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($process_table->godown->getViewValue())) && $process_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $process_table->godown->linkAttributes() ?>><?php echo $process_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_dated"><?php echo $process_table->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $process_table->dated->cellAttributes() ?>>
<span id="el_process_table_dated">
<span<?php echo $process_table->dated->viewAttributes() ?>>
<?php echo $process_table->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->employee_id->Visible) { // employee_id ?>
	<tr id="r_employee_id">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_employee_id"><?php echo $process_table->employee_id->caption() ?></span></td>
		<td data-name="employee_id"<?php echo $process_table->employee_id->cellAttributes() ?>>
<span id="el_process_table_employee_id">
<span<?php echo $process_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($process_table->employee_id->getViewValue())) && $process_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $process_table->employee_id->linkAttributes() ?>><?php echo $process_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_operator"><?php echo $process_table->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $process_table->operator->cellAttributes() ?>>
<span id="el_process_table_operator">
<span<?php echo $process_table->operator->viewAttributes() ?>>
<?php echo $process_table->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_datetime"><?php echo $process_table->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $process_table->datetime->cellAttributes() ?>>
<span id="el_process_table_datetime">
<span<?php echo $process_table->datetime->viewAttributes() ?>>
<?php echo $process_table->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_table->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $process_table_view->TableLeftColumnClass ?>"><span id="elh_process_table_remarks"><?php echo $process_table->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $process_table->remarks->cellAttributes() ?>>
<span id="el_process_table_remarks">
<span<?php echo $process_table->remarks->viewAttributes() ?>>
<?php echo $process_table->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$process_table_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_table_view->terminate();
?>