<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_f_addopt = new process_type_f_addopt();

// Run the page
$process_type_f_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_f_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fprocess_type_faddopt = currentForm = new ew.Form("fprocess_type_faddopt", "addopt");

// Validate form
fprocess_type_faddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_type_f_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->grp->caption(), $process_type_f->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_f_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->product->caption(), $process_type_f->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_f_addopt->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->process->caption(), $process_type_f->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_f_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->name->caption(), $process_type_f->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_f_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->code->caption(), $process_type_f->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9-]){4,4}$/))
				return this.onError(elm, "<?php echo JsEncode($process_type_f->code->errorMessage()) ?>");
		<?php if ($process_type_f_addopt->avg_yield->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_yield");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->avg_yield->caption(), $process_type_f->avg_yield->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_yield");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_type_f->avg_yield->errorMessage()) ?>");
		<?php if ($process_type_f_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->status->caption(), $process_type_f->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_f_addopt->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->remarks->caption(), $process_type_f->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_f_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->operator->caption(), $process_type_f->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_f_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type_f->datetime->caption(), $process_type_f->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_type_faddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_type_faddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_type_faddopt.lists["x_grp"] = <?php echo $process_type_f_addopt->grp->Lookup->toClientList() ?>;
fprocess_type_faddopt.lists["x_grp"].options = <?php echo JsonEncode($process_type_f_addopt->grp->options(FALSE, TRUE)) ?>;
fprocess_type_faddopt.lists["x_product"] = <?php echo $process_type_f_addopt->product->Lookup->toClientList() ?>;
fprocess_type_faddopt.lists["x_product"].options = <?php echo JsonEncode($process_type_f_addopt->product->lookupOptions()) ?>;
fprocess_type_faddopt.lists["x_process"] = <?php echo $process_type_f_addopt->process->Lookup->toClientList() ?>;
fprocess_type_faddopt.lists["x_process"].options = <?php echo JsonEncode($process_type_f_addopt->process->lookupOptions()) ?>;
fprocess_type_faddopt.lists["x_status"] = <?php echo $process_type_f_addopt->status->Lookup->toClientList() ?>;
fprocess_type_faddopt.lists["x_status"].options = <?php echo JsonEncode($process_type_f_addopt->status->options(FALSE, TRUE)) ?>;
fprocess_type_faddopt.lists["x_operator"] = <?php echo $process_type_f_addopt->operator->Lookup->toClientList() ?>;
fprocess_type_faddopt.lists["x_operator"].options = <?php echo JsonEncode($process_type_f_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_type_f_addopt->showPageHeader(); ?>
<?php
$process_type_f_addopt->showMessage();
?>
<form name="fprocess_type_faddopt" id="fprocess_type_faddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($process_type_f_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_f_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $process_type_f_addopt->TableVar ?>">
<?php if ($process_type_f->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $process_type_f->grp->caption() ?><?php echo ($process_type_f->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_grp" data-value-separator="<?php echo $process_type_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_type_f->grp->editAttributes() ?>>
		<?php echo $process_type_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $process_type_f->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $process_type_f->product->caption() ?><?php echo ($process_type_f->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_product" data-value-separator="<?php echo $process_type_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_type_f->product->editAttributes() ?>>
		<?php echo $process_type_f->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_type_f->product->Lookup->getParamTag("p_x_product") ?>
<?php echo $process_type_f->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->process->Visible) { // process ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_process"><?php echo $process_type_f->process->caption() ?><?php echo ($process_type_f->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_process" data-value-separator="<?php echo $process_type_f->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_type_f->process->editAttributes() ?>>
		<?php echo $process_type_f->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_type_f->process->Lookup->getParamTag("p_x_process") ?>
<?php echo $process_type_f->process->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $process_type_f->name->caption() ?><?php echo ($process_type_f->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process_type_f" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($process_type_f->name->getPlaceHolder()) ?>" value="<?php echo $process_type_f->name->EditValue ?>"<?php echo $process_type_f->name->editAttributes() ?>>
<?php echo $process_type_f->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $process_type_f->code->caption() ?><?php echo ($process_type_f->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process_type_f" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($process_type_f->code->getPlaceHolder()) ?>" value="<?php echo $process_type_f->code->EditValue ?>"<?php echo $process_type_f->code->editAttributes() ?>>
<?php echo $process_type_f->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->avg_yield->Visible) { // avg_yield ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_avg_yield"><?php echo $process_type_f->avg_yield->caption() ?><?php echo ($process_type_f->avg_yield->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process_type_f" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($process_type_f->avg_yield->getPlaceHolder()) ?>" value="<?php echo $process_type_f->avg_yield->EditValue ?>"<?php echo $process_type_f->avg_yield->editAttributes() ?>>
<?php echo $process_type_f->avg_yield->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $process_type_f->status->caption() ?><?php echo ($process_type_f->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_status" data-value-separator="<?php echo $process_type_f->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process_type_f->status->editAttributes() ?>>
		<?php echo $process_type_f->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $process_type_f->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->remarks->Visible) { // remarks ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remarks"><?php echo $process_type_f->remarks->caption() ?><?php echo ($process_type_f->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="process_type_f" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="31" rows="3" placeholder="<?php echo HtmlEncode($process_type_f->remarks->getPlaceHolder()) ?>"<?php echo $process_type_f->remarks->editAttributes() ?>><?php echo $process_type_f->remarks->EditValue ?></textarea>
<?php echo $process_type_f->remarks->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type_f->operator->Visible) { // operator ?>
	<input type="hidden" data-table="process_type_f" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($process_type_f->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($process_type_f->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="process_type_f" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($process_type_f->datetime->CurrentValue) ?>">
	<?php if (!$process_type_f->datetime->ReadOnly && !$process_type_f->datetime->Disabled && !isset($process_type_f->datetime->EditAttrs["readonly"]) && !isset($process_type_f->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fprocess_type_faddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$process_type_f_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$process_type_f_addopt->terminate();
?>