<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_f_list = new process_type_f_list();

// Run the page
$process_type_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_type_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_type_flist = currentForm = new ew.Form("fprocess_type_flist", "list");
fprocess_type_flist.formKeyCountName = '<?php echo $process_type_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_type_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_type_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_type_flist.lists["x_grp"] = <?php echo $process_type_f_list->grp->Lookup->toClientList() ?>;
fprocess_type_flist.lists["x_grp"].options = <?php echo JsonEncode($process_type_f_list->grp->options(FALSE, TRUE)) ?>;
fprocess_type_flist.lists["x_product"] = <?php echo $process_type_f_list->product->Lookup->toClientList() ?>;
fprocess_type_flist.lists["x_product"].options = <?php echo JsonEncode($process_type_f_list->product->lookupOptions()) ?>;
fprocess_type_flist.lists["x_process"] = <?php echo $process_type_f_list->process->Lookup->toClientList() ?>;
fprocess_type_flist.lists["x_process"].options = <?php echo JsonEncode($process_type_f_list->process->lookupOptions()) ?>;
fprocess_type_flist.lists["x_status"] = <?php echo $process_type_f_list->status->Lookup->toClientList() ?>;
fprocess_type_flist.lists["x_status"].options = <?php echo JsonEncode($process_type_f_list->status->options(FALSE, TRUE)) ?>;
fprocess_type_flist.lists["x_operator"] = <?php echo $process_type_f_list->operator->Lookup->toClientList() ?>;
fprocess_type_flist.lists["x_operator"].options = <?php echo JsonEncode($process_type_f_list->operator->lookupOptions()) ?>;

// Form object for search
var fprocess_type_flistsrch = currentSearchForm = new ew.Form("fprocess_type_flistsrch");

// Validate function for search
fprocess_type_flistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9-]){4,4}$/))
		return this.onError(elm, "<?php echo JsEncode($process_type_f->code->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_type_flistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_type_flistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_type_flistsrch.lists["x_product"] = <?php echo $process_type_f_list->product->Lookup->toClientList() ?>;
fprocess_type_flistsrch.lists["x_product"].options = <?php echo JsonEncode($process_type_f_list->product->lookupOptions()) ?>;
fprocess_type_flistsrch.lists["x_process"] = <?php echo $process_type_f_list->process->Lookup->toClientList() ?>;
fprocess_type_flistsrch.lists["x_process"].options = <?php echo JsonEncode($process_type_f_list->process->lookupOptions()) ?>;

// Filters
fprocess_type_flistsrch.filterList = <?php echo $process_type_f_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_type_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_type_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_type_f_list->TotalRecs > 0 && $process_type_f_list->ExportOptions->visible()) { ?>
<?php $process_type_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_type_f_list->ImportOptions->visible()) { ?>
<?php $process_type_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_type_f_list->SearchOptions->visible()) { ?>
<?php $process_type_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_type_f_list->FilterOptions->visible()) { ?>
<?php $process_type_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_type_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_type_f->isExport() && !$process_type_f->CurrentAction) { ?>
<form name="fprocess_type_flistsrch" id="fprocess_type_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_type_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_type_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_type_f">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_type_f_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_type_f->RowType = ROWTYPE_SEARCH;

// Render row
$process_type_f->resetAttributes();
$process_type_f_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_type_f->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $process_type_f->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_product" data-value-separator="<?php echo $process_type_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_type_f->product->editAttributes() ?>>
		<?php echo $process_type_f->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_type_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_type_f->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_type_f->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_process" data-value-separator="<?php echo $process_type_f->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_type_f->process->editAttributes() ?>>
		<?php echo $process_type_f->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_type_f->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_type_f->code->Visible) { // code ?>
	<div id="xsc_code" class="ew-cell form-group">
		<label for="x_code" class="ew-search-caption ew-label"><?php echo $process_type_f->code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="process_type_f" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($process_type_f->code->getPlaceHolder()) ?>" value="<?php echo $process_type_f->code->EditValue ?>"<?php echo $process_type_f->code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_type_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_type_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_type_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_type_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_type_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_type_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_type_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_type_f_list->showPageHeader(); ?>
<?php
$process_type_f_list->showMessage();
?>
<?php if ($process_type_f_list->TotalRecs > 0 || $process_type_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_type_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_type_f">
<?php if (!$process_type_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_type_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_type_f_list->Pager)) $process_type_f_list->Pager = new PrevNextPager($process_type_f_list->StartRec, $process_type_f_list->DisplayRecs, $process_type_f_list->TotalRecs, $process_type_f_list->AutoHidePager) ?>
<?php if ($process_type_f_list->Pager->RecordCount > 0 && $process_type_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_type_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_type_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_type_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_type_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_type_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_type_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_type_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_type_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_type_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_type_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_type_f_list->TotalRecs > 0 && (!$process_type_f_list->AutoHidePageSizeSelector || $process_type_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_type_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_type_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_type_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_type_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_type_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_type_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_type_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_type_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_type_flist" id="fprocess_type_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_type_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_type_f">
<div id="gmp_process_type_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_type_f_list->TotalRecs > 0 || $process_type_f->isGridEdit()) { ?>
<table id="tbl_process_type_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_type_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_type_f_list->renderListOptions();

// Render list options (header, left)
$process_type_f_list->ListOptions->render("header", "left");
?>
<?php if ($process_type_f->id->Visible) { // id ?>
	<?php if ($process_type_f->sortUrl($process_type_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_type_f->id->headerCellClass() ?>"><div id="elh_process_type_f_id" class="process_type_f_id"><div class="ew-table-header-caption"><?php echo $process_type_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_type_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->id) ?>',2);"><div id="elh_process_type_f_id" class="process_type_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->grp->Visible) { // grp ?>
	<?php if ($process_type_f->sortUrl($process_type_f->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $process_type_f->grp->headerCellClass() ?>"><div id="elh_process_type_f_grp" class="process_type_f_grp"><div class="ew-table-header-caption"><?php echo $process_type_f->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $process_type_f->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->grp) ?>',2);"><div id="elh_process_type_f_grp" class="process_type_f_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->product->Visible) { // product ?>
	<?php if ($process_type_f->sortUrl($process_type_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $process_type_f->product->headerCellClass() ?>"><div id="elh_process_type_f_product" class="process_type_f_product"><div class="ew-table-header-caption"><?php echo $process_type_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $process_type_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->product) ?>',2);"><div id="elh_process_type_f_product" class="process_type_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->process->Visible) { // process ?>
	<?php if ($process_type_f->sortUrl($process_type_f->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_type_f->process->headerCellClass() ?>"><div id="elh_process_type_f_process" class="process_type_f_process"><div class="ew-table-header-caption"><?php echo $process_type_f->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_type_f->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->process) ?>',2);"><div id="elh_process_type_f_process" class="process_type_f_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->name->Visible) { // name ?>
	<?php if ($process_type_f->sortUrl($process_type_f->name) == "") { ?>
		<th data-name="name" class="<?php echo $process_type_f->name->headerCellClass() ?>"><div id="elh_process_type_f_name" class="process_type_f_name"><div class="ew-table-header-caption"><?php echo $process_type_f->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $process_type_f->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->name) ?>',2);"><div id="elh_process_type_f_name" class="process_type_f_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->code->Visible) { // code ?>
	<?php if ($process_type_f->sortUrl($process_type_f->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_type_f->code->headerCellClass() ?>"><div id="elh_process_type_f_code" class="process_type_f_code"><div class="ew-table-header-caption"><?php echo $process_type_f->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_type_f->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->code) ?>',2);"><div id="elh_process_type_f_code" class="process_type_f_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->avg_yield->Visible) { // avg_yield ?>
	<?php if ($process_type_f->sortUrl($process_type_f->avg_yield) == "") { ?>
		<th data-name="avg_yield" class="<?php echo $process_type_f->avg_yield->headerCellClass() ?>"><div id="elh_process_type_f_avg_yield" class="process_type_f_avg_yield"><div class="ew-table-header-caption"><?php echo $process_type_f->avg_yield->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_yield" class="<?php echo $process_type_f->avg_yield->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->avg_yield) ?>',2);"><div id="elh_process_type_f_avg_yield" class="process_type_f_avg_yield">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->avg_yield->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->avg_yield->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->avg_yield->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->status->Visible) { // status ?>
	<?php if ($process_type_f->sortUrl($process_type_f->status) == "") { ?>
		<th data-name="status" class="<?php echo $process_type_f->status->headerCellClass() ?>"><div id="elh_process_type_f_status" class="process_type_f_status"><div class="ew-table-header-caption"><?php echo $process_type_f->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $process_type_f->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->status) ?>',2);"><div id="elh_process_type_f_status" class="process_type_f_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->remarks->Visible) { // remarks ?>
	<?php if ($process_type_f->sortUrl($process_type_f->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_type_f->remarks->headerCellClass() ?>"><div id="elh_process_type_f_remarks" class="process_type_f_remarks"><div class="ew-table-header-caption"><?php echo $process_type_f->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_type_f->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->remarks) ?>',2);"><div id="elh_process_type_f_remarks" class="process_type_f_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->operator->Visible) { // operator ?>
	<?php if ($process_type_f->sortUrl($process_type_f->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_type_f->operator->headerCellClass() ?>"><div id="elh_process_type_f_operator" class="process_type_f_operator"><div class="ew-table-header-caption"><?php echo $process_type_f->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_type_f->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->operator) ?>',2);"><div id="elh_process_type_f_operator" class="process_type_f_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type_f->datetime->Visible) { // datetime ?>
	<?php if ($process_type_f->sortUrl($process_type_f->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_type_f->datetime->headerCellClass() ?>"><div id="elh_process_type_f_datetime" class="process_type_f_datetime"><div class="ew-table-header-caption"><?php echo $process_type_f->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_type_f->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type_f->SortUrl($process_type_f->datetime) ?>',2);"><div id="elh_process_type_f_datetime" class="process_type_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type_f->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type_f->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type_f->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_type_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_type_f->ExportAll && $process_type_f->isExport()) {
	$process_type_f_list->StopRec = $process_type_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_type_f_list->TotalRecs > $process_type_f_list->StartRec + $process_type_f_list->DisplayRecs - 1)
		$process_type_f_list->StopRec = $process_type_f_list->StartRec + $process_type_f_list->DisplayRecs - 1;
	else
		$process_type_f_list->StopRec = $process_type_f_list->TotalRecs;
}
$process_type_f_list->RecCnt = $process_type_f_list->StartRec - 1;
if ($process_type_f_list->Recordset && !$process_type_f_list->Recordset->EOF) {
	$process_type_f_list->Recordset->moveFirst();
	$selectLimit = $process_type_f_list->UseSelectLimit;
	if (!$selectLimit && $process_type_f_list->StartRec > 1)
		$process_type_f_list->Recordset->move($process_type_f_list->StartRec - 1);
} elseif (!$process_type_f->AllowAddDeleteRow && $process_type_f_list->StopRec == 0) {
	$process_type_f_list->StopRec = $process_type_f->GridAddRowCount;
}

// Initialize aggregate
$process_type_f->RowType = ROWTYPE_AGGREGATEINIT;
$process_type_f->resetAttributes();
$process_type_f_list->renderRow();
while ($process_type_f_list->RecCnt < $process_type_f_list->StopRec) {
	$process_type_f_list->RecCnt++;
	if ($process_type_f_list->RecCnt >= $process_type_f_list->StartRec) {
		$process_type_f_list->RowCnt++;

		// Set up key count
		$process_type_f_list->KeyCount = $process_type_f_list->RowIndex;

		// Init row class and style
		$process_type_f->resetAttributes();
		$process_type_f->CssClass = "";
		if ($process_type_f->isGridAdd()) {
		} else {
			$process_type_f_list->loadRowValues($process_type_f_list->Recordset); // Load row values
		}
		$process_type_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_type_f->RowAttrs = array_merge($process_type_f->RowAttrs, array('data-rowindex'=>$process_type_f_list->RowCnt, 'id'=>'r' . $process_type_f_list->RowCnt . '_process_type_f', 'data-rowtype'=>$process_type_f->RowType));

		// Render row
		$process_type_f_list->renderRow();

		// Render list options
		$process_type_f_list->renderListOptions();
?>
	<tr<?php echo $process_type_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_type_f_list->ListOptions->render("body", "left", $process_type_f_list->RowCnt);
?>
	<?php if ($process_type_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_type_f->id->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_id" class="process_type_f_id">
<span<?php echo $process_type_f->id->viewAttributes() ?>>
<?php echo $process_type_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $process_type_f->grp->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_grp" class="process_type_f_grp">
<span<?php echo $process_type_f->grp->viewAttributes() ?>>
<?php echo $process_type_f->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $process_type_f->product->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_product" class="process_type_f_product">
<span<?php echo $process_type_f->product->viewAttributes() ?>>
<?php echo $process_type_f->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_type_f->process->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_process" class="process_type_f_process">
<span<?php echo $process_type_f->process->viewAttributes() ?>>
<?php echo $process_type_f->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->name->Visible) { // name ?>
		<td data-name="name"<?php echo $process_type_f->name->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_name" class="process_type_f_name">
<span<?php echo $process_type_f->name->viewAttributes() ?>>
<?php echo $process_type_f->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_type_f->code->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_code" class="process_type_f_code">
<span<?php echo $process_type_f->code->viewAttributes() ?>>
<?php echo $process_type_f->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->avg_yield->Visible) { // avg_yield ?>
		<td data-name="avg_yield"<?php echo $process_type_f->avg_yield->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_avg_yield" class="process_type_f_avg_yield">
<span<?php echo $process_type_f->avg_yield->viewAttributes() ?>>
<?php echo $process_type_f->avg_yield->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->status->Visible) { // status ?>
		<td data-name="status"<?php echo $process_type_f->status->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_status" class="process_type_f_status">
<span<?php echo $process_type_f->status->viewAttributes() ?>>
<?php echo $process_type_f->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_type_f->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_remarks" class="process_type_f_remarks">
<span<?php echo $process_type_f->remarks->viewAttributes() ?>>
<?php echo $process_type_f->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_type_f->operator->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_operator" class="process_type_f_operator">
<span<?php echo $process_type_f->operator->viewAttributes() ?>>
<?php echo $process_type_f->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_type_f->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_type_f_list->RowCnt ?>_process_type_f_datetime" class="process_type_f_datetime">
<span<?php echo $process_type_f->datetime->viewAttributes() ?>>
<?php echo $process_type_f->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_type_f_list->ListOptions->render("body", "right", $process_type_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_type_f->isGridAdd())
		$process_type_f_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_type_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_type_f_list->Recordset)
	$process_type_f_list->Recordset->Close();
?>
<?php if (!$process_type_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_type_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_type_f_list->Pager)) $process_type_f_list->Pager = new PrevNextPager($process_type_f_list->StartRec, $process_type_f_list->DisplayRecs, $process_type_f_list->TotalRecs, $process_type_f_list->AutoHidePager) ?>
<?php if ($process_type_f_list->Pager->RecordCount > 0 && $process_type_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_type_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_type_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_type_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_type_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_type_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_type_f_list->pageUrl() ?>start=<?php echo $process_type_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_type_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_type_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_type_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_type_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_type_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_type_f_list->TotalRecs > 0 && (!$process_type_f_list->AutoHidePageSizeSelector || $process_type_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_type_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_type_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_type_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_type_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_type_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_type_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_type_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_type_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_type_f_list->TotalRecs == 0 && !$process_type_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_type_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_type_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_type_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_type_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_type_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_type_f_list->terminate();
?>