<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_fp_view = new process_type_fp_view();

// Run the page
$process_type_fp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_fp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_type_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fprocess_type_fpview = currentForm = new ew.Form("fprocess_type_fpview", "view");

// Form_CustomValidate event
fprocess_type_fpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_type_fpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_type_fpview.lists["x_grp"] = <?php echo $process_type_fp_view->grp->Lookup->toClientList() ?>;
fprocess_type_fpview.lists["x_grp"].options = <?php echo JsonEncode($process_type_fp_view->grp->options(FALSE, TRUE)) ?>;
fprocess_type_fpview.lists["x_status"] = <?php echo $process_type_fp_view->status->Lookup->toClientList() ?>;
fprocess_type_fpview.lists["x_status"].options = <?php echo JsonEncode($process_type_fp_view->status->options(FALSE, TRUE)) ?>;
fprocess_type_fpview.lists["x_operator"] = <?php echo $process_type_fp_view->operator->Lookup->toClientList() ?>;
fprocess_type_fpview.lists["x_operator"].options = <?php echo JsonEncode($process_type_fp_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_type_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $process_type_fp_view->ExportOptions->render("body") ?>
<?php $process_type_fp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $process_type_fp_view->showPageHeader(); ?>
<?php
$process_type_fp_view->showMessage();
?>
<form name="fprocess_type_fpview" id="fprocess_type_fpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_type_fp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_fp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_type_fp">
<input type="hidden" name="modal" value="<?php echo (int)$process_type_fp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($process_type_fp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $process_type_fp_view->TableLeftColumnClass ?>"><span id="elh_process_type_fp_id"><?php echo $process_type_fp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $process_type_fp->id->cellAttributes() ?>>
<span id="el_process_type_fp_id">
<span<?php echo $process_type_fp->id->viewAttributes() ?>>
<?php echo $process_type_fp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type_fp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $process_type_fp_view->TableLeftColumnClass ?>"><span id="elh_process_type_fp_grp"><?php echo $process_type_fp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $process_type_fp->grp->cellAttributes() ?>>
<span id="el_process_type_fp_grp">
<span<?php echo $process_type_fp->grp->viewAttributes() ?>>
<?php echo $process_type_fp->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type_fp->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $process_type_fp_view->TableLeftColumnClass ?>"><span id="elh_process_type_fp_name"><?php echo $process_type_fp->name->caption() ?></span></td>
		<td data-name="name"<?php echo $process_type_fp->name->cellAttributes() ?>>
<span id="el_process_type_fp_name">
<span<?php echo $process_type_fp->name->viewAttributes() ?>>
<?php echo $process_type_fp->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type_fp->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $process_type_fp_view->TableLeftColumnClass ?>"><span id="elh_process_type_fp_status"><?php echo $process_type_fp->status->caption() ?></span></td>
		<td data-name="status"<?php echo $process_type_fp->status->cellAttributes() ?>>
<span id="el_process_type_fp_status">
<span<?php echo $process_type_fp->status->viewAttributes() ?>>
<?php echo $process_type_fp->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type_fp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $process_type_fp_view->TableLeftColumnClass ?>"><span id="elh_process_type_fp_operator"><?php echo $process_type_fp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $process_type_fp->operator->cellAttributes() ?>>
<span id="el_process_type_fp_operator">
<span<?php echo $process_type_fp->operator->viewAttributes() ?>>
<?php echo $process_type_fp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type_fp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $process_type_fp_view->TableLeftColumnClass ?>"><span id="elh_process_type_fp_datetime"><?php echo $process_type_fp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $process_type_fp->datetime->cellAttributes() ?>>
<span id="el_process_type_fp_datetime">
<span<?php echo $process_type_fp->datetime->viewAttributes() ?>>
<?php echo $process_type_fp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$process_type_fp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_type_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_type_fp_view->terminate();
?>