<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_f_search = new process_type_f_search();

// Run the page
$process_type_f_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_f_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_type_f_search->IsModal) { ?>
var fprocess_type_fsearch = currentAdvancedSearchForm = new ew.Form("fprocess_type_fsearch", "search");
<?php } else { ?>
var fprocess_type_fsearch = currentForm = new ew.Form("fprocess_type_fsearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_type_fsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_type_fsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_type_fsearch.lists["x_grp"] = <?php echo $process_type_f_search->grp->Lookup->toClientList() ?>;
fprocess_type_fsearch.lists["x_grp"].options = <?php echo JsonEncode($process_type_f_search->grp->options(FALSE, TRUE)) ?>;
fprocess_type_fsearch.lists["x_product"] = <?php echo $process_type_f_search->product->Lookup->toClientList() ?>;
fprocess_type_fsearch.lists["x_product"].options = <?php echo JsonEncode($process_type_f_search->product->lookupOptions()) ?>;
fprocess_type_fsearch.lists["x_process"] = <?php echo $process_type_f_search->process->Lookup->toClientList() ?>;
fprocess_type_fsearch.lists["x_process"].options = <?php echo JsonEncode($process_type_f_search->process->lookupOptions()) ?>;
fprocess_type_fsearch.lists["x_status"] = <?php echo $process_type_f_search->status->Lookup->toClientList() ?>;
fprocess_type_fsearch.lists["x_status"].options = <?php echo JsonEncode($process_type_f_search->status->options(FALSE, TRUE)) ?>;
fprocess_type_fsearch.lists["x_operator"] = <?php echo $process_type_f_search->operator->Lookup->toClientList() ?>;
fprocess_type_fsearch.lists["x_operator"].options = <?php echo JsonEncode($process_type_f_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocess_type_fsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_type_f->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9-]){4,4}$/))
		return this.onError(elm, "<?php echo JsEncode($process_type_f->code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_yield");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_type_f->avg_yield->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_type_f_search->showPageHeader(); ?>
<?php
$process_type_f_search->showMessage();
?>
<form name="fprocess_type_fsearch" id="fprocess_type_fsearch" class="<?php echo $process_type_f_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_type_f_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_f_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_type_f">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_type_f_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_type_f->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_id"><?php echo $process_type_f->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->id->cellAttributes() ?>>
			<span id="el_process_type_f_id">
<input type="text" data-table="process_type_f" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_type_f->id->getPlaceHolder()) ?>" value="<?php echo $process_type_f->id->EditValue ?>"<?php echo $process_type_f->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_grp"><?php echo $process_type_f->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->grp->cellAttributes() ?>>
			<span id="el_process_type_f_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_grp" data-value-separator="<?php echo $process_type_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_type_f->grp->editAttributes() ?>>
		<?php echo $process_type_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_product"><?php echo $process_type_f->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->product->cellAttributes() ?>>
			<span id="el_process_type_f_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_product" data-value-separator="<?php echo $process_type_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_type_f->product->editAttributes() ?>>
		<?php echo $process_type_f->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_type_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_process"><?php echo $process_type_f->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->process->cellAttributes() ?>>
			<span id="el_process_type_f_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_process" data-value-separator="<?php echo $process_type_f->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_type_f->process->editAttributes() ?>>
		<?php echo $process_type_f->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_type_f->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_name"><?php echo $process_type_f->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->name->cellAttributes() ?>>
			<span id="el_process_type_f_name">
<input type="text" data-table="process_type_f" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($process_type_f->name->getPlaceHolder()) ?>" value="<?php echo $process_type_f->name->EditValue ?>"<?php echo $process_type_f->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_code"><?php echo $process_type_f->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->code->cellAttributes() ?>>
			<span id="el_process_type_f_code">
<input type="text" data-table="process_type_f" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($process_type_f->code->getPlaceHolder()) ?>" value="<?php echo $process_type_f->code->EditValue ?>"<?php echo $process_type_f->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label for="x_avg_yield" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_avg_yield"><?php echo $process_type_f->avg_yield->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_yield" id="z_avg_yield" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->avg_yield->cellAttributes() ?>>
			<span id="el_process_type_f_avg_yield">
<input type="text" data-table="process_type_f" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($process_type_f->avg_yield->getPlaceHolder()) ?>" value="<?php echo $process_type_f->avg_yield->EditValue ?>"<?php echo $process_type_f->avg_yield->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_status"><?php echo $process_type_f->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->status->cellAttributes() ?>>
			<span id="el_process_type_f_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_status" data-value-separator="<?php echo $process_type_f->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process_type_f->status->editAttributes() ?>>
		<?php echo $process_type_f->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_remarks"><?php echo $process_type_f->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->remarks->cellAttributes() ?>>
			<span id="el_process_type_f_remarks">
<input type="text" data-table="process_type_f" data-field="x_remarks" name="x_remarks" id="x_remarks" size="31" maxlength="255" placeholder="<?php echo HtmlEncode($process_type_f->remarks->getPlaceHolder()) ?>" value="<?php echo $process_type_f->remarks->EditValue ?>"<?php echo $process_type_f->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_operator"><?php echo $process_type_f->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->operator->cellAttributes() ?>>
			<span id="el_process_type_f_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type_f" data-field="x_operator" data-value-separator="<?php echo $process_type_f->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process_type_f->operator->editAttributes() ?>>
		<?php echo $process_type_f->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process_type_f->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type_f->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_type_f_search->LeftColumnClass ?>"><span id="elh_process_type_f_datetime"><?php echo $process_type_f->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_type_f_search->RightColumnClass ?>"><div<?php echo $process_type_f->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_type_f->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_type_f_datetime">
<input type="text" data-table="process_type_f" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_type_f->datetime->getPlaceHolder()) ?>" value="<?php echo $process_type_f->datetime->EditValue ?>"<?php echo $process_type_f->datetime->editAttributes() ?>>
<?php if (!$process_type_f->datetime->ReadOnly && !$process_type_f->datetime->Disabled && !isset($process_type_f->datetime->EditAttrs["readonly"]) && !isset($process_type_f->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_type_fsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_type_f_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_type_f" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_type_f->datetime->getPlaceHolder()) ?>" value="<?php echo $process_type_f->datetime->EditValue2 ?>"<?php echo $process_type_f->datetime->editAttributes() ?>>
<?php if (!$process_type_f->datetime->ReadOnly && !$process_type_f->datetime->Disabled && !isset($process_type_f->datetime->EditAttrs["readonly"]) && !isset($process_type_f->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_type_fsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_type_f_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_type_f_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_type_f_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_type_f_search->terminate();
?>