<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_addopt = new process_type_addopt();

// Run the page
$process_type_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fprocess_typeaddopt = currentForm = new ew.Form("fprocess_typeaddopt", "addopt");

// Validate form
fprocess_typeaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_type_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->grp->caption(), $process_type->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_addopt->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->process->caption(), $process_type->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->product->caption(), $process_type->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->name->caption(), $process_type->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->code->caption(), $process_type->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){4,4}$/))
				return this.onError(elm, "<?php echo JsEncode($process_type->code->errorMessage()) ?>");
		<?php if ($process_type_addopt->avg_yield->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_yield");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->avg_yield->caption(), $process_type->avg_yield->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_yield");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_type->avg_yield->errorMessage()) ?>");
		<?php if ($process_type_addopt->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->remarks->caption(), $process_type->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->status->caption(), $process_type->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->operator->caption(), $process_type->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->datetime->caption(), $process_type->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_typeaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_typeaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_typeaddopt.lists["x_grp"] = <?php echo $process_type_addopt->grp->Lookup->toClientList() ?>;
fprocess_typeaddopt.lists["x_grp"].options = <?php echo JsonEncode($process_type_addopt->grp->options(FALSE, TRUE)) ?>;
fprocess_typeaddopt.lists["x_process"] = <?php echo $process_type_addopt->process->Lookup->toClientList() ?>;
fprocess_typeaddopt.lists["x_process"].options = <?php echo JsonEncode($process_type_addopt->process->lookupOptions()) ?>;
fprocess_typeaddopt.lists["x_product"] = <?php echo $process_type_addopt->product->Lookup->toClientList() ?>;
fprocess_typeaddopt.lists["x_product"].options = <?php echo JsonEncode($process_type_addopt->product->lookupOptions()) ?>;
fprocess_typeaddopt.lists["x_status"] = <?php echo $process_type_addopt->status->Lookup->toClientList() ?>;
fprocess_typeaddopt.lists["x_status"].options = <?php echo JsonEncode($process_type_addopt->status->options(FALSE, TRUE)) ?>;
fprocess_typeaddopt.lists["x_operator"] = <?php echo $process_type_addopt->operator->Lookup->toClientList() ?>;
fprocess_typeaddopt.lists["x_operator"].options = <?php echo JsonEncode($process_type_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_type_addopt->showPageHeader(); ?>
<?php
$process_type_addopt->showMessage();
?>
<form name="fprocess_typeaddopt" id="fprocess_typeaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($process_type_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $process_type_addopt->TableVar ?>">
<?php if ($process_type->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $process_type->grp->caption() ?><?php echo ($process_type->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_grp" data-value-separator="<?php echo $process_type->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_type->grp->editAttributes() ?>>
		<?php echo $process_type->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $process_type->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->process->Visible) { // process ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_process"><?php echo $process_type->process->caption() ?><?php echo ($process_type->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_process" data-value-separator="<?php echo $process_type->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_type->process->editAttributes() ?>>
		<?php echo $process_type->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_type->process->Lookup->getParamTag("p_x_process") ?>
<?php echo $process_type->process->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $process_type->product->caption() ?><?php echo ($process_type->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_product" data-value-separator="<?php echo $process_type->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_type->product->editAttributes() ?>>
		<?php echo $process_type->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_type->product->Lookup->getParamTag("p_x_product") ?>
<?php echo $process_type->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $process_type->name->caption() ?><?php echo ($process_type->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process_type" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($process_type->name->getPlaceHolder()) ?>" value="<?php echo $process_type->name->EditValue ?>"<?php echo $process_type->name->editAttributes() ?>>
<?php echo $process_type->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $process_type->code->caption() ?><?php echo ($process_type->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process_type" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($process_type->code->getPlaceHolder()) ?>" value="<?php echo $process_type->code->EditValue ?>"<?php echo $process_type->code->editAttributes() ?>>
<?php echo $process_type->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->avg_yield->Visible) { // avg_yield ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_avg_yield"><?php echo $process_type->avg_yield->caption() ?><?php echo ($process_type->avg_yield->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process_type" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($process_type->avg_yield->getPlaceHolder()) ?>" value="<?php echo $process_type->avg_yield->EditValue ?>"<?php echo $process_type->avg_yield->editAttributes() ?>>
<?php echo $process_type->avg_yield->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->remarks->Visible) { // remarks ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remarks"><?php echo $process_type->remarks->caption() ?><?php echo ($process_type->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="process_type" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="31" rows="3" placeholder="<?php echo HtmlEncode($process_type->remarks->getPlaceHolder()) ?>"<?php echo $process_type->remarks->editAttributes() ?>><?php echo $process_type->remarks->EditValue ?></textarea>
<?php echo $process_type->remarks->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $process_type->status->caption() ?><?php echo ($process_type->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_status" data-value-separator="<?php echo $process_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process_type->status->editAttributes() ?>>
		<?php echo $process_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $process_type->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process_type->operator->Visible) { // operator ?>
	<input type="hidden" data-table="process_type" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($process_type->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($process_type->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="process_type" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($process_type->datetime->CurrentValue) ?>">
	<?php if (!$process_type->datetime->ReadOnly && !$process_type->datetime->Disabled && !isset($process_type->datetime->EditAttrs["readonly"]) && !isset($process_type->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fprocess_typeaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$process_type_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$process_type_addopt->terminate();
?>