<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_edit = new process_type_edit();

// Run the page
$process_type_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fprocess_typeedit = currentForm = new ew.Form("fprocess_typeedit", "edit");

// Validate form
fprocess_typeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_type_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->id->caption(), $process_type->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_type->id->errorMessage()) ?>");
		<?php if ($process_type_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->grp->caption(), $process_type->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->process->caption(), $process_type->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->product->caption(), $process_type->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->name->caption(), $process_type->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->code->caption(), $process_type->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){4,4}$/))
				return this.onError(elm, "<?php echo JsEncode($process_type->code->errorMessage()) ?>");
		<?php if ($process_type_edit->avg_yield->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_yield");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->avg_yield->caption(), $process_type->avg_yield->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_yield");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_type->avg_yield->errorMessage()) ?>");
		<?php if ($process_type_edit->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->ref->caption(), $process_type->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->remarks->caption(), $process_type->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->status->caption(), $process_type->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->operator->caption(), $process_type->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_type_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_type->datetime->caption(), $process_type->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_typeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_typeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_typeedit.lists["x_grp"] = <?php echo $process_type_edit->grp->Lookup->toClientList() ?>;
fprocess_typeedit.lists["x_grp"].options = <?php echo JsonEncode($process_type_edit->grp->options(FALSE, TRUE)) ?>;
fprocess_typeedit.lists["x_process"] = <?php echo $process_type_edit->process->Lookup->toClientList() ?>;
fprocess_typeedit.lists["x_process"].options = <?php echo JsonEncode($process_type_edit->process->lookupOptions()) ?>;
fprocess_typeedit.lists["x_product"] = <?php echo $process_type_edit->product->Lookup->toClientList() ?>;
fprocess_typeedit.lists["x_product"].options = <?php echo JsonEncode($process_type_edit->product->lookupOptions()) ?>;
fprocess_typeedit.lists["x_ref"] = <?php echo $process_type_edit->ref->Lookup->toClientList() ?>;
fprocess_typeedit.lists["x_ref"].options = <?php echo JsonEncode($process_type_edit->ref->lookupOptions()) ?>;
fprocess_typeedit.lists["x_status"] = <?php echo $process_type_edit->status->Lookup->toClientList() ?>;
fprocess_typeedit.lists["x_status"].options = <?php echo JsonEncode($process_type_edit->status->options(FALSE, TRUE)) ?>;
fprocess_typeedit.lists["x_operator"] = <?php echo $process_type_edit->operator->Lookup->toClientList() ?>;
fprocess_typeedit.lists["x_operator"].options = <?php echo JsonEncode($process_type_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_type_edit->showPageHeader(); ?>
<?php
$process_type_edit->showMessage();
?>
<form name="fprocess_typeedit" id="fprocess_typeedit" class="<?php echo $process_type_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_type_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_type">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$process_type_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($process_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_process_type_id" for="x_id" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->id->caption() ?><?php echo ($process_type->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->id->cellAttributes() ?>>
<span id="el_process_type_id">
<span<?php echo $process_type->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($process_type->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="process_type" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($process_type->id->CurrentValue) ?>">
<?php echo $process_type->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_process_type_grp" for="x_grp" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->grp->caption() ?><?php echo ($process_type->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->grp->cellAttributes() ?>>
<span id="el_process_type_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_grp" data-value-separator="<?php echo $process_type->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_type->grp->editAttributes() ?>>
		<?php echo $process_type->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $process_type->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_process_type_process" for="x_process" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->process->caption() ?><?php echo ($process_type->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->process->cellAttributes() ?>>
<span id="el_process_type_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_process" data-value-separator="<?php echo $process_type->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_type->process->editAttributes() ?>>
		<?php echo $process_type->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_type->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $process_type->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_process_type_product" for="x_product" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->product->caption() ?><?php echo ($process_type->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->product->cellAttributes() ?>>
<span id="el_process_type_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_product" data-value-separator="<?php echo $process_type->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_type->product->editAttributes() ?>>
		<?php echo $process_type->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_type->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $process_type->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_process_type_name" for="x_name" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->name->caption() ?><?php echo ($process_type->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->name->cellAttributes() ?>>
<span id="el_process_type_name">
<input type="text" data-table="process_type" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($process_type->name->getPlaceHolder()) ?>" value="<?php echo $process_type->name->EditValue ?>"<?php echo $process_type->name->editAttributes() ?>>
</span>
<?php echo $process_type->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_process_type_code" for="x_code" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->code->caption() ?><?php echo ($process_type->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->code->cellAttributes() ?>>
<span id="el_process_type_code">
<input type="text" data-table="process_type" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($process_type->code->getPlaceHolder()) ?>" value="<?php echo $process_type->code->EditValue ?>"<?php echo $process_type->code->editAttributes() ?>>
</span>
<?php echo $process_type->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label id="elh_process_type_avg_yield" for="x_avg_yield" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->avg_yield->caption() ?><?php echo ($process_type->avg_yield->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->avg_yield->cellAttributes() ?>>
<span id="el_process_type_avg_yield">
<input type="text" data-table="process_type" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($process_type->avg_yield->getPlaceHolder()) ?>" value="<?php echo $process_type->avg_yield->EditValue ?>"<?php echo $process_type->avg_yield->editAttributes() ?>>
</span>
<?php echo $process_type->avg_yield->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_process_type_ref" for="x_ref" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->ref->caption() ?><?php echo ($process_type->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->ref->cellAttributes() ?>>
<span id="el_process_type_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_ref" data-value-separator="<?php echo $process_type->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $process_type->ref->editAttributes() ?>>
		<?php echo $process_type->ref->selectOptionListHtml("x_ref") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$process_type->ref->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ref" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $process_type->ref->caption() ?>" data-title="<?php echo $process_type->ref->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ref',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $process_type->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $process_type->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_process_type_remarks" for="x_remarks" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->remarks->caption() ?><?php echo ($process_type->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->remarks->cellAttributes() ?>>
<span id="el_process_type_remarks">
<textarea data-table="process_type" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="31" rows="3" placeholder="<?php echo HtmlEncode($process_type->remarks->getPlaceHolder()) ?>"<?php echo $process_type->remarks->editAttributes() ?>><?php echo $process_type->remarks->EditValue ?></textarea>
</span>
<?php echo $process_type->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_process_type_status" for="x_status" class="<?php echo $process_type_edit->LeftColumnClass ?>"><?php echo $process_type->status->caption() ?><?php echo ($process_type->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_type_edit->RightColumnClass ?>"><div<?php echo $process_type->status->cellAttributes() ?>>
<span id="el_process_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_status" data-value-separator="<?php echo $process_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process_type->status->editAttributes() ?>>
		<?php echo $process_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $process_type->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_type_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_type_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $process_type_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_type_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_type_edit->terminate();
?>