<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_list = new process_type_list();

// Run the page
$process_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_typelist = currentForm = new ew.Form("fprocess_typelist", "list");
fprocess_typelist.formKeyCountName = '<?php echo $process_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_typelist.lists["x_grp"] = <?php echo $process_type_list->grp->Lookup->toClientList() ?>;
fprocess_typelist.lists["x_grp"].options = <?php echo JsonEncode($process_type_list->grp->options(FALSE, TRUE)) ?>;
fprocess_typelist.lists["x_process"] = <?php echo $process_type_list->process->Lookup->toClientList() ?>;
fprocess_typelist.lists["x_process"].options = <?php echo JsonEncode($process_type_list->process->lookupOptions()) ?>;
fprocess_typelist.lists["x_product"] = <?php echo $process_type_list->product->Lookup->toClientList() ?>;
fprocess_typelist.lists["x_product"].options = <?php echo JsonEncode($process_type_list->product->lookupOptions()) ?>;
fprocess_typelist.lists["x_ref"] = <?php echo $process_type_list->ref->Lookup->toClientList() ?>;
fprocess_typelist.lists["x_ref"].options = <?php echo JsonEncode($process_type_list->ref->lookupOptions()) ?>;
fprocess_typelist.lists["x_status"] = <?php echo $process_type_list->status->Lookup->toClientList() ?>;
fprocess_typelist.lists["x_status"].options = <?php echo JsonEncode($process_type_list->status->options(FALSE, TRUE)) ?>;
fprocess_typelist.lists["x_operator"] = <?php echo $process_type_list->operator->Lookup->toClientList() ?>;
fprocess_typelist.lists["x_operator"].options = <?php echo JsonEncode($process_type_list->operator->lookupOptions()) ?>;

// Form object for search
var fprocess_typelistsrch = currentSearchForm = new ew.Form("fprocess_typelistsrch");

// Validate function for search
fprocess_typelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){4,4}$/))
		return this.onError(elm, "<?php echo JsEncode($process_type->code->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_typelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_typelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_typelistsrch.lists["x_process"] = <?php echo $process_type_list->process->Lookup->toClientList() ?>;
fprocess_typelistsrch.lists["x_process"].options = <?php echo JsonEncode($process_type_list->process->lookupOptions()) ?>;
fprocess_typelistsrch.lists["x_product"] = <?php echo $process_type_list->product->Lookup->toClientList() ?>;
fprocess_typelistsrch.lists["x_product"].options = <?php echo JsonEncode($process_type_list->product->lookupOptions()) ?>;

// Filters
fprocess_typelistsrch.filterList = <?php echo $process_type_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_type_list->TotalRecs > 0 && $process_type_list->ExportOptions->visible()) { ?>
<?php $process_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_type_list->ImportOptions->visible()) { ?>
<?php $process_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_type_list->SearchOptions->visible()) { ?>
<?php $process_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_type_list->FilterOptions->visible()) { ?>
<?php $process_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_type->isExport() && !$process_type->CurrentAction) { ?>
<form name="fprocess_typelistsrch" id="fprocess_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_type">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_type_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_type->RowType = ROWTYPE_SEARCH;

// Render row
$process_type->resetAttributes();
$process_type_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_type->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_type->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_process" data-value-separator="<?php echo $process_type->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_type->process->editAttributes() ?>>
		<?php echo $process_type->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_type->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_type->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $process_type->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_product" data-value-separator="<?php echo $process_type->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_type->product->editAttributes() ?>>
		<?php echo $process_type->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_type->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_type->code->Visible) { // code ?>
	<div id="xsc_code" class="ew-cell form-group">
		<label for="x_code" class="ew-search-caption ew-label"><?php echo $process_type->code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="process_type" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($process_type->code->getPlaceHolder()) ?>" value="<?php echo $process_type->code->EditValue ?>"<?php echo $process_type->code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_type_list->showPageHeader(); ?>
<?php
$process_type_list->showMessage();
?>
<?php if ($process_type_list->TotalRecs > 0 || $process_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_type">
<?php if (!$process_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_type_list->Pager)) $process_type_list->Pager = new PrevNextPager($process_type_list->StartRec, $process_type_list->DisplayRecs, $process_type_list->TotalRecs, $process_type_list->AutoHidePager) ?>
<?php if ($process_type_list->Pager->RecordCount > 0 && $process_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_type_list->TotalRecs > 0 && (!$process_type_list->AutoHidePageSizeSelector || $process_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_typelist" id="fprocess_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_type">
<div id="gmp_process_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_type_list->TotalRecs > 0 || $process_type->isGridEdit()) { ?>
<table id="tbl_process_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_type_list->renderListOptions();

// Render list options (header, left)
$process_type_list->ListOptions->render("header", "left");
?>
<?php if ($process_type->id->Visible) { // id ?>
	<?php if ($process_type->sortUrl($process_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_type->id->headerCellClass() ?>"><div id="elh_process_type_id" class="process_type_id"><div class="ew-table-header-caption"><?php echo $process_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->id) ?>',2);"><div id="elh_process_type_id" class="process_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->grp->Visible) { // grp ?>
	<?php if ($process_type->sortUrl($process_type->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $process_type->grp->headerCellClass() ?>"><div id="elh_process_type_grp" class="process_type_grp"><div class="ew-table-header-caption"><?php echo $process_type->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $process_type->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->grp) ?>',2);"><div id="elh_process_type_grp" class="process_type_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->process->Visible) { // process ?>
	<?php if ($process_type->sortUrl($process_type->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_type->process->headerCellClass() ?>"><div id="elh_process_type_process" class="process_type_process"><div class="ew-table-header-caption"><?php echo $process_type->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_type->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->process) ?>',2);"><div id="elh_process_type_process" class="process_type_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->product->Visible) { // product ?>
	<?php if ($process_type->sortUrl($process_type->product) == "") { ?>
		<th data-name="product" class="<?php echo $process_type->product->headerCellClass() ?>"><div id="elh_process_type_product" class="process_type_product"><div class="ew-table-header-caption"><?php echo $process_type->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $process_type->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->product) ?>',2);"><div id="elh_process_type_product" class="process_type_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->name->Visible) { // name ?>
	<?php if ($process_type->sortUrl($process_type->name) == "") { ?>
		<th data-name="name" class="<?php echo $process_type->name->headerCellClass() ?>"><div id="elh_process_type_name" class="process_type_name"><div class="ew-table-header-caption"><?php echo $process_type->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $process_type->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->name) ?>',2);"><div id="elh_process_type_name" class="process_type_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->code->Visible) { // code ?>
	<?php if ($process_type->sortUrl($process_type->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_type->code->headerCellClass() ?>"><div id="elh_process_type_code" class="process_type_code"><div class="ew-table-header-caption"><?php echo $process_type->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_type->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->code) ?>',2);"><div id="elh_process_type_code" class="process_type_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->avg_yield->Visible) { // avg_yield ?>
	<?php if ($process_type->sortUrl($process_type->avg_yield) == "") { ?>
		<th data-name="avg_yield" class="<?php echo $process_type->avg_yield->headerCellClass() ?>"><div id="elh_process_type_avg_yield" class="process_type_avg_yield"><div class="ew-table-header-caption"><?php echo $process_type->avg_yield->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_yield" class="<?php echo $process_type->avg_yield->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->avg_yield) ?>',2);"><div id="elh_process_type_avg_yield" class="process_type_avg_yield">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->avg_yield->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type->avg_yield->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->avg_yield->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->ref->Visible) { // ref ?>
	<?php if ($process_type->sortUrl($process_type->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $process_type->ref->headerCellClass() ?>"><div id="elh_process_type_ref" class="process_type_ref"><div class="ew-table-header-caption"><?php echo $process_type->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $process_type->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->ref) ?>',2);"><div id="elh_process_type_ref" class="process_type_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->remarks->Visible) { // remarks ?>
	<?php if ($process_type->sortUrl($process_type->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_type->remarks->headerCellClass() ?>"><div id="elh_process_type_remarks" class="process_type_remarks"><div class="ew-table-header-caption"><?php echo $process_type->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_type->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->remarks) ?>',2);"><div id="elh_process_type_remarks" class="process_type_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_type->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->status->Visible) { // status ?>
	<?php if ($process_type->sortUrl($process_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $process_type->status->headerCellClass() ?>"><div id="elh_process_type_status" class="process_type_status"><div class="ew-table-header-caption"><?php echo $process_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $process_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->status) ?>',2);"><div id="elh_process_type_status" class="process_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->UID->Visible) { // UID ?>
	<?php if ($process_type->sortUrl($process_type->UID) == "") { ?>
		<th data-name="UID" class="<?php echo $process_type->UID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_type_UID" class="process_type_UID"><div class="ew-table-header-caption"><?php echo $process_type->UID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UID" class="<?php echo $process_type->UID->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->UID) ?>',2);"><div id="elh_process_type_UID" class="process_type_UID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->UID->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->UID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->UID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->operator->Visible) { // operator ?>
	<?php if ($process_type->sortUrl($process_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process_type->operator->headerCellClass() ?>"><div id="elh_process_type_operator" class="process_type_operator"><div class="ew-table-header-caption"><?php echo $process_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->operator) ?>',2);"><div id="elh_process_type_operator" class="process_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_type->datetime->Visible) { // datetime ?>
	<?php if ($process_type->sortUrl($process_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_type->datetime->headerCellClass() ?>"><div id="elh_process_type_datetime" class="process_type_datetime"><div class="ew-table-header-caption"><?php echo $process_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_type->SortUrl($process_type->datetime) ?>',2);"><div id="elh_process_type_datetime" class="process_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_type->ExportAll && $process_type->isExport()) {
	$process_type_list->StopRec = $process_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_type_list->TotalRecs > $process_type_list->StartRec + $process_type_list->DisplayRecs - 1)
		$process_type_list->StopRec = $process_type_list->StartRec + $process_type_list->DisplayRecs - 1;
	else
		$process_type_list->StopRec = $process_type_list->TotalRecs;
}
$process_type_list->RecCnt = $process_type_list->StartRec - 1;
if ($process_type_list->Recordset && !$process_type_list->Recordset->EOF) {
	$process_type_list->Recordset->moveFirst();
	$selectLimit = $process_type_list->UseSelectLimit;
	if (!$selectLimit && $process_type_list->StartRec > 1)
		$process_type_list->Recordset->move($process_type_list->StartRec - 1);
} elseif (!$process_type->AllowAddDeleteRow && $process_type_list->StopRec == 0) {
	$process_type_list->StopRec = $process_type->GridAddRowCount;
}

// Initialize aggregate
$process_type->RowType = ROWTYPE_AGGREGATEINIT;
$process_type->resetAttributes();
$process_type_list->renderRow();
while ($process_type_list->RecCnt < $process_type_list->StopRec) {
	$process_type_list->RecCnt++;
	if ($process_type_list->RecCnt >= $process_type_list->StartRec) {
		$process_type_list->RowCnt++;

		// Set up key count
		$process_type_list->KeyCount = $process_type_list->RowIndex;

		// Init row class and style
		$process_type->resetAttributes();
		$process_type->CssClass = "";
		if ($process_type->isGridAdd()) {
		} else {
			$process_type_list->loadRowValues($process_type_list->Recordset); // Load row values
		}
		$process_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_type->RowAttrs = array_merge($process_type->RowAttrs, array('data-rowindex'=>$process_type_list->RowCnt, 'id'=>'r' . $process_type_list->RowCnt . '_process_type', 'data-rowtype'=>$process_type->RowType));

		// Render row
		$process_type_list->renderRow();

		// Render list options
		$process_type_list->renderListOptions();
?>
	<tr<?php echo $process_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_type_list->ListOptions->render("body", "left", $process_type_list->RowCnt);
?>
	<?php if ($process_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_type->id->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_id" class="process_type_id">
<span<?php echo $process_type->id->viewAttributes() ?>>
<?php echo $process_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $process_type->grp->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_grp" class="process_type_grp">
<span<?php echo $process_type->grp->viewAttributes() ?>>
<?php echo $process_type->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_type->process->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_process" class="process_type_process">
<span<?php echo $process_type->process->viewAttributes() ?>>
<?php echo $process_type->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->product->Visible) { // product ?>
		<td data-name="product"<?php echo $process_type->product->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_product" class="process_type_product">
<span<?php echo $process_type->product->viewAttributes() ?>>
<?php echo $process_type->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->name->Visible) { // name ?>
		<td data-name="name"<?php echo $process_type->name->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_name" class="process_type_name">
<span<?php echo $process_type->name->viewAttributes() ?>>
<?php echo $process_type->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_type->code->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_code" class="process_type_code">
<span<?php echo $process_type->code->viewAttributes() ?>>
<?php echo $process_type->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->avg_yield->Visible) { // avg_yield ?>
		<td data-name="avg_yield"<?php echo $process_type->avg_yield->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_avg_yield" class="process_type_avg_yield">
<span<?php echo $process_type->avg_yield->viewAttributes() ?>>
<?php echo $process_type->avg_yield->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $process_type->ref->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_ref" class="process_type_ref">
<span<?php echo $process_type->ref->viewAttributes() ?>>
<?php echo $process_type->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_type->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_remarks" class="process_type_remarks">
<span<?php echo $process_type->remarks->viewAttributes() ?>>
<?php echo $process_type->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $process_type->status->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_status" class="process_type_status">
<span<?php echo $process_type->status->viewAttributes() ?>>
<?php echo $process_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->UID->Visible) { // UID ?>
		<td data-name="UID"<?php echo $process_type->UID->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_UID" class="process_type_UID">
<span<?php echo $process_type->UID->viewAttributes() ?>>
<?php echo $process_type->UID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process_type->operator->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_operator" class="process_type_operator">
<span<?php echo $process_type->operator->viewAttributes() ?>>
<?php echo $process_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_type_list->RowCnt ?>_process_type_datetime" class="process_type_datetime">
<span<?php echo $process_type->datetime->viewAttributes() ?>>
<?php echo $process_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_type_list->ListOptions->render("body", "right", $process_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_type->isGridAdd())
		$process_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_type_list->Recordset)
	$process_type_list->Recordset->Close();
?>
<?php if (!$process_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_type_list->Pager)) $process_type_list->Pager = new PrevNextPager($process_type_list->StartRec, $process_type_list->DisplayRecs, $process_type_list->TotalRecs, $process_type_list->AutoHidePager) ?>
<?php if ($process_type_list->Pager->RecordCount > 0 && $process_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_type_list->pageUrl() ?>start=<?php echo $process_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_type_list->TotalRecs > 0 && (!$process_type_list->AutoHidePageSizeSelector || $process_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_type_list->TotalRecs == 0 && !$process_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_type_list->terminate();
?>