<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_search = new process_type_search();

// Run the page
$process_type_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_type_search->IsModal) { ?>
var fprocess_typesearch = currentAdvancedSearchForm = new ew.Form("fprocess_typesearch", "search");
<?php } else { ?>
var fprocess_typesearch = currentForm = new ew.Form("fprocess_typesearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_typesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_typesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_typesearch.lists["x_grp"] = <?php echo $process_type_search->grp->Lookup->toClientList() ?>;
fprocess_typesearch.lists["x_grp"].options = <?php echo JsonEncode($process_type_search->grp->options(FALSE, TRUE)) ?>;
fprocess_typesearch.lists["x_process"] = <?php echo $process_type_search->process->Lookup->toClientList() ?>;
fprocess_typesearch.lists["x_process"].options = <?php echo JsonEncode($process_type_search->process->lookupOptions()) ?>;
fprocess_typesearch.lists["x_product"] = <?php echo $process_type_search->product->Lookup->toClientList() ?>;
fprocess_typesearch.lists["x_product"].options = <?php echo JsonEncode($process_type_search->product->lookupOptions()) ?>;
fprocess_typesearch.lists["x_ref"] = <?php echo $process_type_search->ref->Lookup->toClientList() ?>;
fprocess_typesearch.lists["x_ref"].options = <?php echo JsonEncode($process_type_search->ref->lookupOptions()) ?>;
fprocess_typesearch.lists["x_status"] = <?php echo $process_type_search->status->Lookup->toClientList() ?>;
fprocess_typesearch.lists["x_status"].options = <?php echo JsonEncode($process_type_search->status->options(FALSE, TRUE)) ?>;
fprocess_typesearch.lists["x_operator"] = <?php echo $process_type_search->operator->Lookup->toClientList() ?>;
fprocess_typesearch.lists["x_operator"].options = <?php echo JsonEncode($process_type_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocess_typesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_type->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){4,4}$/))
		return this.onError(elm, "<?php echo JsEncode($process_type->code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_yield");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_type->avg_yield->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_type_search->showPageHeader(); ?>
<?php
$process_type_search->showMessage();
?>
<form name="fprocess_typesearch" id="fprocess_typesearch" class="<?php echo $process_type_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_type_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_type">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_type_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_id"><?php echo $process_type->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->id->cellAttributes() ?>>
			<span id="el_process_type_id">
<input type="text" data-table="process_type" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_type->id->getPlaceHolder()) ?>" value="<?php echo $process_type->id->EditValue ?>"<?php echo $process_type->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_grp"><?php echo $process_type->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->grp->cellAttributes() ?>>
			<span id="el_process_type_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_grp" data-value-separator="<?php echo $process_type->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_type->grp->editAttributes() ?>>
		<?php echo $process_type->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_process"><?php echo $process_type->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->process->cellAttributes() ?>>
			<span id="el_process_type_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_process" data-value-separator="<?php echo $process_type->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_type->process->editAttributes() ?>>
		<?php echo $process_type->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_type->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_product"><?php echo $process_type->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->product->cellAttributes() ?>>
			<span id="el_process_type_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_product" data-value-separator="<?php echo $process_type->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_type->product->editAttributes() ?>>
		<?php echo $process_type->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_type->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_name"><?php echo $process_type->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->name->cellAttributes() ?>>
			<span id="el_process_type_name">
<input type="text" data-table="process_type" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($process_type->name->getPlaceHolder()) ?>" value="<?php echo $process_type->name->EditValue ?>"<?php echo $process_type->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_code"><?php echo $process_type->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->code->cellAttributes() ?>>
			<span id="el_process_type_code">
<input type="text" data-table="process_type" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($process_type->code->getPlaceHolder()) ?>" value="<?php echo $process_type->code->EditValue ?>"<?php echo $process_type->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label for="x_avg_yield" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_avg_yield"><?php echo $process_type->avg_yield->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_yield" id="z_avg_yield" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->avg_yield->cellAttributes() ?>>
			<span id="el_process_type_avg_yield">
<input type="text" data-table="process_type" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($process_type->avg_yield->getPlaceHolder()) ?>" value="<?php echo $process_type->avg_yield->EditValue ?>"<?php echo $process_type->avg_yield->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_ref"><?php echo $process_type->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->ref->cellAttributes() ?>>
			<span id="el_process_type_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_ref" data-value-separator="<?php echo $process_type->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $process_type->ref->editAttributes() ?>>
		<?php echo $process_type->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $process_type->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_remarks"><?php echo $process_type->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->remarks->cellAttributes() ?>>
			<span id="el_process_type_remarks">
<input type="text" data-table="process_type" data-field="x_remarks" name="x_remarks" id="x_remarks" size="31" maxlength="255" placeholder="<?php echo HtmlEncode($process_type->remarks->getPlaceHolder()) ?>" value="<?php echo $process_type->remarks->EditValue ?>"<?php echo $process_type->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_status"><?php echo $process_type->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->status->cellAttributes() ?>>
			<span id="el_process_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_status" data-value-separator="<?php echo $process_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process_type->status->editAttributes() ?>>
		<?php echo $process_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_operator"><?php echo $process_type->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->operator->cellAttributes() ?>>
			<span id="el_process_type_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_type" data-field="x_operator" data-value-separator="<?php echo $process_type->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process_type->operator->editAttributes() ?>>
		<?php echo $process_type->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process_type->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_type->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_type_search->LeftColumnClass ?>"><span id="elh_process_type_datetime"><?php echo $process_type->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_type_search->RightColumnClass ?>"><div<?php echo $process_type->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_type->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_type_datetime">
<input type="text" data-table="process_type" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_type->datetime->getPlaceHolder()) ?>" value="<?php echo $process_type->datetime->EditValue ?>"<?php echo $process_type->datetime->editAttributes() ?>>
<?php if (!$process_type->datetime->ReadOnly && !$process_type->datetime->Disabled && !isset($process_type->datetime->EditAttrs["readonly"]) && !isset($process_type->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_typesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_type_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_type" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_type->datetime->getPlaceHolder()) ?>" value="<?php echo $process_type->datetime->EditValue2 ?>"<?php echo $process_type->datetime->editAttributes() ?>>
<?php if (!$process_type->datetime->ReadOnly && !$process_type->datetime->Disabled && !isset($process_type->datetime->EditAttrs["readonly"]) && !isset($process_type->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_typesearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_type_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_type_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_type_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_type_search->terminate();
?>