<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_type_view = new process_type_view();

// Run the page
$process_type_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_type_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fprocess_typeview = currentForm = new ew.Form("fprocess_typeview", "view");

// Form_CustomValidate event
fprocess_typeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_typeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_typeview.lists["x_grp"] = <?php echo $process_type_view->grp->Lookup->toClientList() ?>;
fprocess_typeview.lists["x_grp"].options = <?php echo JsonEncode($process_type_view->grp->options(FALSE, TRUE)) ?>;
fprocess_typeview.lists["x_process"] = <?php echo $process_type_view->process->Lookup->toClientList() ?>;
fprocess_typeview.lists["x_process"].options = <?php echo JsonEncode($process_type_view->process->lookupOptions()) ?>;
fprocess_typeview.lists["x_product"] = <?php echo $process_type_view->product->Lookup->toClientList() ?>;
fprocess_typeview.lists["x_product"].options = <?php echo JsonEncode($process_type_view->product->lookupOptions()) ?>;
fprocess_typeview.lists["x_ref"] = <?php echo $process_type_view->ref->Lookup->toClientList() ?>;
fprocess_typeview.lists["x_ref"].options = <?php echo JsonEncode($process_type_view->ref->lookupOptions()) ?>;
fprocess_typeview.lists["x_status"] = <?php echo $process_type_view->status->Lookup->toClientList() ?>;
fprocess_typeview.lists["x_status"].options = <?php echo JsonEncode($process_type_view->status->options(FALSE, TRUE)) ?>;
fprocess_typeview.lists["x_operator"] = <?php echo $process_type_view->operator->Lookup->toClientList() ?>;
fprocess_typeview.lists["x_operator"].options = <?php echo JsonEncode($process_type_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $process_type_view->ExportOptions->render("body") ?>
<?php $process_type_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $process_type_view->showPageHeader(); ?>
<?php
$process_type_view->showMessage();
?>
<form name="fprocess_typeview" id="fprocess_typeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_type_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_type_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_type">
<input type="hidden" name="modal" value="<?php echo (int)$process_type_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($process_type->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_id"><?php echo $process_type->id->caption() ?></span></td>
		<td data-name="id"<?php echo $process_type->id->cellAttributes() ?>>
<span id="el_process_type_id">
<span<?php echo $process_type->id->viewAttributes() ?>>
<?php echo $process_type->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_grp"><?php echo $process_type->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $process_type->grp->cellAttributes() ?>>
<span id="el_process_type_grp">
<span<?php echo $process_type->grp->viewAttributes() ?>>
<?php echo $process_type->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_process"><?php echo $process_type->process->caption() ?></span></td>
		<td data-name="process"<?php echo $process_type->process->cellAttributes() ?>>
<span id="el_process_type_process">
<span<?php echo $process_type->process->viewAttributes() ?>>
<?php echo $process_type->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_product"><?php echo $process_type->product->caption() ?></span></td>
		<td data-name="product"<?php echo $process_type->product->cellAttributes() ?>>
<span id="el_process_type_product">
<span<?php echo $process_type->product->viewAttributes() ?>>
<?php echo $process_type->product->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_name"><?php echo $process_type->name->caption() ?></span></td>
		<td data-name="name"<?php echo $process_type->name->cellAttributes() ?>>
<span id="el_process_type_name">
<span<?php echo $process_type->name->viewAttributes() ?>>
<?php echo $process_type->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_code"><?php echo $process_type->code->caption() ?></span></td>
		<td data-name="code"<?php echo $process_type->code->cellAttributes() ?>>
<span id="el_process_type_code">
<span<?php echo $process_type->code->viewAttributes() ?>>
<?php echo $process_type->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->avg_yield->Visible) { // avg_yield ?>
	<tr id="r_avg_yield">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_avg_yield"><?php echo $process_type->avg_yield->caption() ?></span></td>
		<td data-name="avg_yield"<?php echo $process_type->avg_yield->cellAttributes() ?>>
<span id="el_process_type_avg_yield">
<span<?php echo $process_type->avg_yield->viewAttributes() ?>>
<?php echo $process_type->avg_yield->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_ref"><?php echo $process_type->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $process_type->ref->cellAttributes() ?>>
<span id="el_process_type_ref">
<span<?php echo $process_type->ref->viewAttributes() ?>>
<?php echo $process_type->ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_remarks"><?php echo $process_type->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $process_type->remarks->cellAttributes() ?>>
<span id="el_process_type_remarks">
<span<?php echo $process_type->remarks->viewAttributes() ?>>
<?php echo $process_type->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_status"><?php echo $process_type->status->caption() ?></span></td>
		<td data-name="status"<?php echo $process_type->status->cellAttributes() ?>>
<span id="el_process_type_status">
<span<?php echo $process_type->status->viewAttributes() ?>>
<?php echo $process_type->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_operator"><?php echo $process_type->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $process_type->operator->cellAttributes() ?>>
<span id="el_process_type_operator">
<span<?php echo $process_type->operator->viewAttributes() ?>>
<?php echo $process_type->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process_type->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $process_type_view->TableLeftColumnClass ?>"><span id="elh_process_type_datetime"><?php echo $process_type->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $process_type->datetime->cellAttributes() ?>>
<span id="el_process_type_datetime">
<span<?php echo $process_type->datetime->viewAttributes() ?>>
<?php echo $process_type->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$process_type_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_type_view->terminate();
?>