<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_addopt = new process_addopt();

// Run the page
$process_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fprocessaddopt = currentForm = new ew.Form("fprocessaddopt", "addopt");

// Validate form
fprocessaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process->grp->caption(), $process->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process->name->caption(), $process->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process->status->caption(), $process->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process->operator->caption(), $process->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process->datetime->caption(), $process->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_addopt->_table->Required) { ?>
			elm = this.getElements("x" + infix + "__table");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process->_table->caption(), $process->_table->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_addopt->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process->type->caption(), $process->type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process->type->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocessaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocessaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocessaddopt.lists["x_grp"] = <?php echo $process_addopt->grp->Lookup->toClientList() ?>;
fprocessaddopt.lists["x_grp"].options = <?php echo JsonEncode($process_addopt->grp->lookupOptions()) ?>;
fprocessaddopt.lists["x_status"] = <?php echo $process_addopt->status->Lookup->toClientList() ?>;
fprocessaddopt.lists["x_status"].options = <?php echo JsonEncode($process_addopt->status->options(FALSE, TRUE)) ?>;
fprocessaddopt.lists["x_operator"] = <?php echo $process_addopt->operator->Lookup->toClientList() ?>;
fprocessaddopt.lists["x_operator"].options = <?php echo JsonEncode($process_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_addopt->showPageHeader(); ?>
<?php
$process_addopt->showMessage();
?>
<form name="fprocessaddopt" id="fprocessaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($process_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $process_addopt->TableVar ?>">
<?php if ($process->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $process->grp->caption() ?><?php echo ($process->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process" data-field="x_grp" data-value-separator="<?php echo $process->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process->grp->editAttributes() ?>>
		<?php echo $process->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $process->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $process->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $process->name->caption() ?><?php echo ($process->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($process->name->getPlaceHolder()) ?>" value="<?php echo $process->name->EditValue ?>"<?php echo $process->name->editAttributes() ?>>
<?php echo $process->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $process->status->caption() ?><?php echo ($process->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process" data-field="x_status" data-value-separator="<?php echo $process->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process->status->editAttributes() ?>>
		<?php echo $process->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $process->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process->operator->Visible) { // operator ?>
	<input type="hidden" data-table="process" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($process->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($process->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="process" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($process->datetime->CurrentValue) ?>">
	<?php if (!$process->datetime->ReadOnly && !$process->datetime->Disabled && !isset($process->datetime->EditAttrs["readonly"]) && !isset($process->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fprocessaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($process->_table->Visible) { // table ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__table"><?php echo $process->_table->caption() ?><?php echo ($process->_table->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process" data-field="x__table" name="x__table" id="x__table" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($process->_table->getPlaceHolder()) ?>" value="<?php echo $process->_table->EditValue ?>"<?php echo $process->_table->editAttributes() ?>>
<?php echo $process->_table->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($process->type->Visible) { // type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_type"><?php echo $process->type->caption() ?><?php echo ($process->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="process" data-field="x_type" name="x_type" id="x_type" size="30" placeholder="<?php echo HtmlEncode($process->type->getPlaceHolder()) ?>" value="<?php echo $process->type->EditValue ?>"<?php echo $process->type->editAttributes() ?>>
<?php echo $process->type->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$process_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$process_addopt->terminate();
?>