<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_list = new process_list();

// Run the page
$process_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocesslist = currentForm = new ew.Form("fprocesslist", "list");
fprocesslist.formKeyCountName = '<?php echo $process_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocesslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocesslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocesslist.lists["x_grp"] = <?php echo $process_list->grp->Lookup->toClientList() ?>;
fprocesslist.lists["x_grp"].options = <?php echo JsonEncode($process_list->grp->lookupOptions()) ?>;
fprocesslist.lists["x_status"] = <?php echo $process_list->status->Lookup->toClientList() ?>;
fprocesslist.lists["x_status"].options = <?php echo JsonEncode($process_list->status->options(FALSE, TRUE)) ?>;
fprocesslist.lists["x_operator"] = <?php echo $process_list->operator->Lookup->toClientList() ?>;
fprocesslist.lists["x_operator"].options = <?php echo JsonEncode($process_list->operator->lookupOptions()) ?>;

// Form object for search
var fprocesslistsrch = currentSearchForm = new ew.Form("fprocesslistsrch");

// Filters
fprocesslistsrch.filterList = <?php echo $process_list->getFilterList() ?>;

// Init search panel as collapsed
fprocesslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_list->TotalRecs > 0 && $process_list->ExportOptions->visible()) { ?>
<?php $process_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_list->ImportOptions->visible()) { ?>
<?php $process_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_list->SearchOptions->visible()) { ?>
<?php $process_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_list->FilterOptions->visible()) { ?>
<?php $process_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process->isExport() && !$process->CurrentAction) { ?>
<form name="fprocesslistsrch" id="fprocesslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocesslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_list->showPageHeader(); ?>
<?php
$process_list->showMessage();
?>
<?php if ($process_list->TotalRecs > 0 || $process->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process">
<?php if (!$process->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_list->Pager)) $process_list->Pager = new PrevNextPager($process_list->StartRec, $process_list->DisplayRecs, $process_list->TotalRecs, $process_list->AutoHidePager) ?>
<?php if ($process_list->Pager->RecordCount > 0 && $process_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_list->TotalRecs > 0 && (!$process_list->AutoHidePageSizeSelector || $process_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocesslist" id="fprocesslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process">
<div id="gmp_process" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_list->TotalRecs > 0 || $process->isGridEdit()) { ?>
<table id="tbl_processlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_list->renderListOptions();

// Render list options (header, left)
$process_list->ListOptions->render("header", "left");
?>
<?php if ($process->id->Visible) { // id ?>
	<?php if ($process->sortUrl($process->id) == "") { ?>
		<th data-name="id" class="<?php echo $process->id->headerCellClass() ?>"><div id="elh_process_id" class="process_id"><div class="ew-table-header-caption"><?php echo $process->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process->SortUrl($process->id) ?>',2);"><div id="elh_process_id" class="process_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process->grp->Visible) { // grp ?>
	<?php if ($process->sortUrl($process->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $process->grp->headerCellClass() ?>"><div id="elh_process_grp" class="process_grp"><div class="ew-table-header-caption"><?php echo $process->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $process->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process->SortUrl($process->grp) ?>',2);"><div id="elh_process_grp" class="process_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process->name->Visible) { // name ?>
	<?php if ($process->sortUrl($process->name) == "") { ?>
		<th data-name="name" class="<?php echo $process->name->headerCellClass() ?>"><div id="elh_process_name" class="process_name"><div class="ew-table-header-caption"><?php echo $process->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $process->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process->SortUrl($process->name) ?>',2);"><div id="elh_process_name" class="process_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process->status->Visible) { // status ?>
	<?php if ($process->sortUrl($process->status) == "") { ?>
		<th data-name="status" class="<?php echo $process->status->headerCellClass() ?>"><div id="elh_process_status" class="process_status"><div class="ew-table-header-caption"><?php echo $process->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $process->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process->SortUrl($process->status) ?>',2);"><div id="elh_process_status" class="process_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($process->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process->operator->Visible) { // operator ?>
	<?php if ($process->sortUrl($process->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $process->operator->headerCellClass() ?>"><div id="elh_process_operator" class="process_operator"><div class="ew-table-header-caption"><?php echo $process->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $process->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process->SortUrl($process->operator) ?>',2);"><div id="elh_process_operator" class="process_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($process->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process->datetime->Visible) { // datetime ?>
	<?php if ($process->sortUrl($process->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process->datetime->headerCellClass() ?>"><div id="elh_process_datetime" class="process_datetime"><div class="ew-table-header-caption"><?php echo $process->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process->SortUrl($process->datetime) ?>',2);"><div id="elh_process_datetime" class="process_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process->ExportAll && $process->isExport()) {
	$process_list->StopRec = $process_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_list->TotalRecs > $process_list->StartRec + $process_list->DisplayRecs - 1)
		$process_list->StopRec = $process_list->StartRec + $process_list->DisplayRecs - 1;
	else
		$process_list->StopRec = $process_list->TotalRecs;
}
$process_list->RecCnt = $process_list->StartRec - 1;
if ($process_list->Recordset && !$process_list->Recordset->EOF) {
	$process_list->Recordset->moveFirst();
	$selectLimit = $process_list->UseSelectLimit;
	if (!$selectLimit && $process_list->StartRec > 1)
		$process_list->Recordset->move($process_list->StartRec - 1);
} elseif (!$process->AllowAddDeleteRow && $process_list->StopRec == 0) {
	$process_list->StopRec = $process->GridAddRowCount;
}

// Initialize aggregate
$process->RowType = ROWTYPE_AGGREGATEINIT;
$process->resetAttributes();
$process_list->renderRow();
while ($process_list->RecCnt < $process_list->StopRec) {
	$process_list->RecCnt++;
	if ($process_list->RecCnt >= $process_list->StartRec) {
		$process_list->RowCnt++;

		// Set up key count
		$process_list->KeyCount = $process_list->RowIndex;

		// Init row class and style
		$process->resetAttributes();
		$process->CssClass = "";
		if ($process->isGridAdd()) {
		} else {
			$process_list->loadRowValues($process_list->Recordset); // Load row values
		}
		$process->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process->RowAttrs = array_merge($process->RowAttrs, array('data-rowindex'=>$process_list->RowCnt, 'id'=>'r' . $process_list->RowCnt . '_process', 'data-rowtype'=>$process->RowType));

		// Render row
		$process_list->renderRow();

		// Render list options
		$process_list->renderListOptions();
?>
	<tr<?php echo $process->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_list->ListOptions->render("body", "left", $process_list->RowCnt);
?>
	<?php if ($process->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process->id->cellAttributes() ?>>
<span id="el<?php echo $process_list->RowCnt ?>_process_id" class="process_id">
<span<?php echo $process->id->viewAttributes() ?>>
<?php echo $process->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $process->grp->cellAttributes() ?>>
<span id="el<?php echo $process_list->RowCnt ?>_process_grp" class="process_grp">
<span<?php echo $process->grp->viewAttributes() ?>>
<?php echo $process->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process->name->Visible) { // name ?>
		<td data-name="name"<?php echo $process->name->cellAttributes() ?>>
<span id="el<?php echo $process_list->RowCnt ?>_process_name" class="process_name">
<span<?php echo $process->name->viewAttributes() ?>>
<?php echo $process->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process->status->Visible) { // status ?>
		<td data-name="status"<?php echo $process->status->cellAttributes() ?>>
<span id="el<?php echo $process_list->RowCnt ?>_process_status" class="process_status">
<span<?php echo $process->status->viewAttributes() ?>>
<?php echo $process->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $process->operator->cellAttributes() ?>>
<span id="el<?php echo $process_list->RowCnt ?>_process_operator" class="process_operator">
<span<?php echo $process->operator->viewAttributes() ?>>
<?php echo $process->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_list->RowCnt ?>_process_datetime" class="process_datetime">
<span<?php echo $process->datetime->viewAttributes() ?>>
<?php echo $process->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_list->ListOptions->render("body", "right", $process_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process->isGridAdd())
		$process_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_list->Recordset)
	$process_list->Recordset->Close();
?>
<?php if (!$process->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_list->Pager)) $process_list->Pager = new PrevNextPager($process_list->StartRec, $process_list->DisplayRecs, $process_list->TotalRecs, $process_list->AutoHidePager) ?>
<?php if ($process_list->Pager->RecordCount > 0 && $process_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_list->pageUrl() ?>start=<?php echo $process_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_list->TotalRecs > 0 && (!$process_list->AutoHidePageSizeSelector || $process_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_list->TotalRecs == 0 && !$process->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_list->terminate();
?>