<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_search = new process_search();

// Run the page
$process_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_search->IsModal) { ?>
var fprocesssearch = currentAdvancedSearchForm = new ew.Form("fprocesssearch", "search");
<?php } else { ?>
var fprocesssearch = currentForm = new ew.Form("fprocesssearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocesssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocesssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocesssearch.lists["x_grp"] = <?php echo $process_search->grp->Lookup->toClientList() ?>;
fprocesssearch.lists["x_grp"].options = <?php echo JsonEncode($process_search->grp->lookupOptions()) ?>;
fprocesssearch.lists["x_status"] = <?php echo $process_search->status->Lookup->toClientList() ?>;
fprocesssearch.lists["x_status"].options = <?php echo JsonEncode($process_search->status->options(FALSE, TRUE)) ?>;
fprocesssearch.lists["x_operator"] = <?php echo $process_search->operator->Lookup->toClientList() ?>;
fprocesssearch.lists["x_operator"].options = <?php echo JsonEncode($process_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocesssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_search->showPageHeader(); ?>
<?php
$process_search->showMessage();
?>
<form name="fprocesssearch" id="fprocesssearch" class="<?php echo $process_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_search->LeftColumnClass ?>"><span id="elh_process_id"><?php echo $process->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_search->RightColumnClass ?>"><div<?php echo $process->id->cellAttributes() ?>>
			<span id="el_process_id">
<input type="text" data-table="process" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process->id->getPlaceHolder()) ?>" value="<?php echo $process->id->EditValue ?>"<?php echo $process->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $process_search->LeftColumnClass ?>"><span id="elh_process_grp"><?php echo $process->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $process_search->RightColumnClass ?>"><div<?php echo $process->grp->cellAttributes() ?>>
			<span id="el_process_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process" data-field="x_grp" data-value-separator="<?php echo $process->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process->grp->editAttributes() ?>>
		<?php echo $process->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $process->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $process_search->LeftColumnClass ?>"><span id="elh_process_name"><?php echo $process->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_search->RightColumnClass ?>"><div<?php echo $process->name->cellAttributes() ?>>
			<span id="el_process_name">
<input type="text" data-table="process" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($process->name->getPlaceHolder()) ?>" value="<?php echo $process->name->EditValue ?>"<?php echo $process->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $process_search->LeftColumnClass ?>"><span id="elh_process_status"><?php echo $process->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $process_search->RightColumnClass ?>"><div<?php echo $process->status->cellAttributes() ?>>
			<span id="el_process_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process" data-field="x_status" data-value-separator="<?php echo $process->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $process->status->editAttributes() ?>>
		<?php echo $process->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $process_search->LeftColumnClass ?>"><span id="elh_process_operator"><?php echo $process->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $process_search->RightColumnClass ?>"><div<?php echo $process->operator->cellAttributes() ?>>
			<span id="el_process_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process" data-field="x_operator" data-value-separator="<?php echo $process->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $process->operator->editAttributes() ?>>
		<?php echo $process->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $process->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_search->LeftColumnClass ?>"><span id="elh_process_datetime"><?php echo $process->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $process_search->RightColumnClass ?>"><div<?php echo $process->datetime->cellAttributes() ?>>
			<span id="el_process_datetime">
<input type="text" data-table="process" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process->datetime->getPlaceHolder()) ?>" value="<?php echo $process->datetime->EditValue ?>"<?php echo $process->datetime->editAttributes() ?>>
<?php if (!$process->datetime->ReadOnly && !$process->datetime->Disabled && !isset($process->datetime->EditAttrs["readonly"]) && !isset($process->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocesssearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_search->terminate();
?>