<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_view = new process_view();

// Run the page
$process_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fprocessview = currentForm = new ew.Form("fprocessview", "view");

// Form_CustomValidate event
fprocessview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocessview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocessview.lists["x_grp"] = <?php echo $process_view->grp->Lookup->toClientList() ?>;
fprocessview.lists["x_grp"].options = <?php echo JsonEncode($process_view->grp->lookupOptions()) ?>;
fprocessview.lists["x_status"] = <?php echo $process_view->status->Lookup->toClientList() ?>;
fprocessview.lists["x_status"].options = <?php echo JsonEncode($process_view->status->options(FALSE, TRUE)) ?>;
fprocessview.lists["x_operator"] = <?php echo $process_view->operator->Lookup->toClientList() ?>;
fprocessview.lists["x_operator"].options = <?php echo JsonEncode($process_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $process_view->ExportOptions->render("body") ?>
<?php $process_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $process_view->showPageHeader(); ?>
<?php
$process_view->showMessage();
?>
<form name="fprocessview" id="fprocessview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process">
<input type="hidden" name="modal" value="<?php echo (int)$process_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($process->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $process_view->TableLeftColumnClass ?>"><span id="elh_process_id"><?php echo $process->id->caption() ?></span></td>
		<td data-name="id"<?php echo $process->id->cellAttributes() ?>>
<span id="el_process_id">
<span<?php echo $process->id->viewAttributes() ?>>
<?php echo $process->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $process_view->TableLeftColumnClass ?>"><span id="elh_process_grp"><?php echo $process->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $process->grp->cellAttributes() ?>>
<span id="el_process_grp">
<span<?php echo $process->grp->viewAttributes() ?>>
<?php echo $process->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $process_view->TableLeftColumnClass ?>"><span id="elh_process_name"><?php echo $process->name->caption() ?></span></td>
		<td data-name="name"<?php echo $process->name->cellAttributes() ?>>
<span id="el_process_name">
<span<?php echo $process->name->viewAttributes() ?>>
<?php echo $process->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $process_view->TableLeftColumnClass ?>"><span id="elh_process_status"><?php echo $process->status->caption() ?></span></td>
		<td data-name="status"<?php echo $process->status->cellAttributes() ?>>
<span id="el_process_status">
<span<?php echo $process->status->viewAttributes() ?>>
<?php echo $process->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $process_view->TableLeftColumnClass ?>"><span id="elh_process_operator"><?php echo $process->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $process->operator->cellAttributes() ?>>
<span id="el_process_operator">
<span<?php echo $process->operator->viewAttributes() ?>>
<?php echo $process->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($process->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $process_view->TableLeftColumnClass ?>"><span id="elh_process_datetime"><?php echo $process->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $process->datetime->cellAttributes() ?>>
<span id="el_process_datetime">
<span<?php echo $process->datetime->viewAttributes() ?>>
<?php echo $process->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$process_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_view->terminate();
?>