<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_b_sample_search = new product_cart_b_sample_search();

// Run the page
$product_cart_b_sample_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_b_sample_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_cart_b_sample_search->IsModal) { ?>
var fproduct_cart_b_samplesearch = currentAdvancedSearchForm = new ew.Form("fproduct_cart_b_samplesearch", "search");
<?php } else { ?>
var fproduct_cart_b_samplesearch = currentForm = new ew.Form("fproduct_cart_b_samplesearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduct_cart_b_samplesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_b_samplesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_b_samplesearch.lists["x_po_id"] = <?php echo $product_cart_b_sample_search->po_id->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_b_sample_search->po_id->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_company_id"] = <?php echo $product_cart_b_sample_search->company_id->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_b_sample_search->company_id->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_partner_id"] = <?php echo $product_cart_b_sample_search->partner_id->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_b_sample_search->partner_id->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_product_type"] = <?php echo $product_cart_b_sample_search->product_type->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_b_sample_search->product_type->options(FALSE, TRUE)) ?>;
fproduct_cart_b_samplesearch.lists["x_grp"] = <?php echo $product_cart_b_sample_search->grp->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_grp"].options = <?php echo JsonEncode($product_cart_b_sample_search->grp->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_s_grp"] = <?php echo $product_cart_b_sample_search->s_grp->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_b_sample_search->s_grp->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_product"] = <?php echo $product_cart_b_sample_search->product->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_product"].options = <?php echo JsonEncode($product_cart_b_sample_search->product->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_rid"] = <?php echo $product_cart_b_sample_search->rid->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_rid"].options = <?php echo JsonEncode($product_cart_b_sample_search->rid->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_shape"] = <?php echo $product_cart_b_sample_search->shape->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_shape"].options = <?php echo JsonEncode($product_cart_b_sample_search->shape->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_unit"] = <?php echo $product_cart_b_sample_search->unit->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_unit"].options = <?php echo JsonEncode($product_cart_b_sample_search->unit->options(FALSE, TRUE)) ?>;
fproduct_cart_b_samplesearch.lists["x_currency"] = <?php echo $product_cart_b_sample_search->currency->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_currency"].options = <?php echo JsonEncode($product_cart_b_sample_search->currency->lookupOptions()) ?>;
fproduct_cart_b_samplesearch.lists["x_status"] = <?php echo $product_cart_b_sample_search->status->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_status"].options = <?php echo JsonEncode($product_cart_b_sample_search->status->options(FALSE, TRUE)) ?>;
fproduct_cart_b_samplesearch.lists["x_operator"] = <?php echo $product_cart_b_sample_search->operator->Lookup->toClientList() ?>;
fproduct_cart_b_samplesearch.lists["x_operator"].options = <?php echo JsonEncode($product_cart_b_sample_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproduct_cart_b_samplesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_sample->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_w_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_sample->w_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_l_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_sample->l_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_sample->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_sample->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_sample->price->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_cart_b_sample_search->showPageHeader(); ?>
<?php
$product_cart_b_sample_search->showMessage();
?>
<form name="fproduct_cart_b_samplesearch" id="fproduct_cart_b_samplesearch" class="<?php echo $product_cart_b_sample_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_b_sample_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_b_sample_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_b_sample">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_cart_b_sample_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($product_cart_b_sample->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_id"><?php echo $product_cart_b_sample->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->id->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_id">
<input type="text" data-table="product_cart_b_sample" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($product_cart_b_sample->id->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->id->EditValue ?>"<?php echo $product_cart_b_sample->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group row">
		<label for="x_po_id" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_po_id"><?php echo $product_cart_b_sample->po_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_id" id="z_po_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->po_id->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_po_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_po_id" data-value-separator="<?php echo $product_cart_b_sample->po_id->displayValueSeparatorAttribute() ?>" id="x_po_id" name="x_po_id"<?php echo $product_cart_b_sample->po_id->editAttributes() ?>>
		<?php echo $product_cart_b_sample->po_id->selectOptionListHtml("x_po_id") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->po_id->Lookup->getParamTag("p_x_po_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_company_id"><?php echo $product_cart_b_sample->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->company_id->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_company_id" data-value-separator="<?php echo $product_cart_b_sample->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $product_cart_b_sample->company_id->editAttributes() ?>>
		<?php echo $product_cart_b_sample->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label for="x_partner_id" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_partner_id"><?php echo $product_cart_b_sample->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->partner_id->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_partner_id">
<input type="text" data-table="product_cart_b_sample" data-field="x_partner_id" name="x_partner_id" id="x_partner_id" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->partner_id->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->partner_id->EditValue ?>"<?php echo $product_cart_b_sample->partner_id->editAttributes() ?>>
<?php echo $product_cart_b_sample->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_product_type"><?php echo $product_cart_b_sample->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->product_type->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_product_type" data-value-separator="<?php echo $product_cart_b_sample->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $product_cart_b_sample->product_type->editAttributes() ?>>
		<?php echo $product_cart_b_sample->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_grp"><?php echo $product_cart_b_sample->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->grp->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_grp">
<?php $product_cart_b_sample->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_b_sample->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_grp" data-value-separator="<?php echo $product_cart_b_sample->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_cart_b_sample->grp->editAttributes() ?>>
		<?php echo $product_cart_b_sample->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_s_grp"><?php echo $product_cart_b_sample->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->s_grp->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_s_grp">
<?php $product_cart_b_sample->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_b_sample->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_s_grp" data-value-separator="<?php echo $product_cart_b_sample->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_cart_b_sample->s_grp->editAttributes() ?>>
		<?php echo $product_cart_b_sample->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_product"><?php echo $product_cart_b_sample->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->product->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_product">
<?php $product_cart_b_sample->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_b_sample->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_product" data-value-separator="<?php echo $product_cart_b_sample->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $product_cart_b_sample->product->editAttributes() ?>>
		<?php echo $product_cart_b_sample->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_rid"><?php echo $product_cart_b_sample->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->rid->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_rid" data-value-separator="<?php echo $product_cart_b_sample->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $product_cart_b_sample->rid->editAttributes() ?>>
		<?php echo $product_cart_b_sample->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label for="x_rid_1" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_rid_1"><?php echo $product_cart_b_sample->rid_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_1" id="z_rid_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->rid_1->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_rid_1">
<input type="text" data-table="product_cart_b_sample" data-field="x_rid_1" name="x_rid_1" id="x_rid_1" size="35" placeholder="<?php echo HtmlEncode($product_cart_b_sample->rid_1->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->rid_1->EditValue ?>"<?php echo $product_cart_b_sample->rid_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_shape"><?php echo $product_cart_b_sample->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->shape->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_shape" data-value-separator="<?php echo $product_cart_b_sample->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $product_cart_b_sample->shape->editAttributes() ?>>
		<?php echo $product_cart_b_sample->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_unit"><?php echo $product_cart_b_sample->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->unit->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_unit" data-value-separator="<?php echo $product_cart_b_sample->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $product_cart_b_sample->unit->editAttributes() ?>>
		<?php echo $product_cart_b_sample->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->w->Visible) { // w ?>
	<div id="r_w" class="form-group row">
		<label for="x_w" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_w"><?php echo $product_cart_b_sample->w->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_w" id="z_w" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->w->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_w">
<input type="text" data-table="product_cart_b_sample" data-field="x_w" name="x_w" id="x_w" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_b_sample->w->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->w->EditValue ?>"<?php echo $product_cart_b_sample->w->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label for="x_w_cm" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_w_cm"><?php echo $product_cart_b_sample->w_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_w_cm" id="z_w_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->w_cm->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_w_cm">
<input type="text" data-table="product_cart_b_sample" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->w_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->w_cm->EditValue ?>"<?php echo $product_cart_b_sample->w_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->l->Visible) { // l ?>
	<div id="r_l" class="form-group row">
		<label for="x_l" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_l"><?php echo $product_cart_b_sample->l->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_l" id="z_l" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->l->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_l">
<input type="text" data-table="product_cart_b_sample" data-field="x_l" name="x_l" id="x_l" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_b_sample->l->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->l->EditValue ?>"<?php echo $product_cart_b_sample->l->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label for="x_l_cm" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_l_cm"><?php echo $product_cart_b_sample->l_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_l_cm" id="z_l_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->l_cm->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_l_cm">
<input type="text" data-table="product_cart_b_sample" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->l_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->l_cm->EditValue ?>"<?php echo $product_cart_b_sample->l_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->partner_size->Visible) { // partner_size ?>
	<div id="r_partner_size" class="form-group row">
		<label for="x_partner_size" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_partner_size"><?php echo $product_cart_b_sample->partner_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_size" id="z_partner_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->partner_size->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_partner_size">
<input type="text" data-table="product_cart_b_sample" data-field="x_partner_size" name="x_partner_size" id="x_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_b_sample->partner_size->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->partner_size->EditValue ?>"<?php echo $product_cart_b_sample->partner_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_sqm"><?php echo $product_cart_b_sample->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->sqm->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_sqm">
<input type="text" data-table="product_cart_b_sample" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->sqm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->sqm->EditValue ?>"<?php echo $product_cart_b_sample->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_quantity"><?php echo $product_cart_b_sample->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->quantity->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_quantity">
<input type="text" data-table="product_cart_b_sample" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->quantity->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->quantity->EditValue ?>"<?php echo $product_cart_b_sample->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_price"><?php echo $product_cart_b_sample->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->price->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_price">
<input type="text" data-table="product_cart_b_sample" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->price->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->price->EditValue ?>"<?php echo $product_cart_b_sample->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_currency"><?php echo $product_cart_b_sample->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->currency->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_currency" data-value-separator="<?php echo $product_cart_b_sample->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $product_cart_b_sample->currency->editAttributes() ?>>
		<?php echo $product_cart_b_sample->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->_9->Visible) { // 9 ?>
	<div id="r__9" class="form-group row">
		<label for="x__9" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__9"><?php echo $product_cart_b_sample->_9->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__9" id="z__9" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->_9->cellAttributes() ?>>
			<span id="el_product_cart_b_sample__9">
<input type="text" data-table="product_cart_b_sample" data-field="x__9" name="x__9" id="x__9" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->_9->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->_9->EditValue ?>"<?php echo $product_cart_b_sample->_9->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->_10->Visible) { // 10 ?>
	<div id="r__10" class="form-group row">
		<label for="x__10" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__10"><?php echo $product_cart_b_sample->_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__10" id="z__10" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->_10->cellAttributes() ?>>
			<span id="el_product_cart_b_sample__10">
<input type="text" data-table="product_cart_b_sample" data-field="x__10" name="x__10" id="x__10" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->_10->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->_10->EditValue ?>"<?php echo $product_cart_b_sample->_10->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->_11->Visible) { // 11 ?>
	<div id="r__11" class="form-group row">
		<label for="x__11" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__11"><?php echo $product_cart_b_sample->_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__11" id="z__11" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->_11->cellAttributes() ?>>
			<span id="el_product_cart_b_sample__11">
<input type="text" data-table="product_cart_b_sample" data-field="x__11" name="x__11" id="x__11" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->_11->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->_11->EditValue ?>"<?php echo $product_cart_b_sample->_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->_12->Visible) { // 12 ?>
	<div id="r__12" class="form-group row">
		<label for="x__12" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample__12"><?php echo $product_cart_b_sample->_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__12" id="z__12" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->_12->cellAttributes() ?>>
			<span id="el_product_cart_b_sample__12">
<input type="text" data-table="product_cart_b_sample" data-field="x__12" name="x__12" id="x__12" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_sample->_12->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->_12->EditValue ?>"<?php echo $product_cart_b_sample->_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_remarks"><?php echo $product_cart_b_sample->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->remarks->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_remarks">
<input type="text" data-table="product_cart_b_sample" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="255" placeholder="<?php echo HtmlEncode($product_cart_b_sample->remarks->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->remarks->EditValue ?>"<?php echo $product_cart_b_sample->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_image"><?php echo $product_cart_b_sample->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->image->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_image">
<input type="text" data-table="product_cart_b_sample" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($product_cart_b_sample->image->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->image->EditValue ?>"<?php echo $product_cart_b_sample->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_buyer_uid"><?php echo $product_cart_b_sample->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->buyer_uid->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_buyer_uid">
<input type="text" data-table="product_cart_b_sample" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="35" placeholder="<?php echo HtmlEncode($product_cart_b_sample->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->buyer_uid->EditValue ?>"<?php echo $product_cart_b_sample->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_status"><?php echo $product_cart_b_sample->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->status->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_status" data-value-separator="<?php echo $product_cart_b_sample->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_cart_b_sample->status->editAttributes() ?>>
		<?php echo $product_cart_b_sample->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_operator"><?php echo $product_cart_b_sample->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->operator->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b_sample" data-field="x_operator" data-value-separator="<?php echo $product_cart_b_sample->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $product_cart_b_sample->operator->editAttributes() ?>>
		<?php echo $product_cart_b_sample->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $product_cart_b_sample->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b_sample->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $product_cart_b_sample_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sample_datetime"><?php echo $product_cart_b_sample->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_sample_search->RightColumnClass ?>"><div<?php echo $product_cart_b_sample->datetime->cellAttributes() ?>>
			<span id="el_product_cart_b_sample_datetime">
<input type="text" data-table="product_cart_b_sample" data-field="x_datetime" data-format="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($product_cart_b_sample->datetime->getPlaceHolder()) ?>" value="<?php echo $product_cart_b_sample->datetime->EditValue ?>"<?php echo $product_cart_b_sample->datetime->editAttributes() ?>>
<?php if (!$product_cart_b_sample->datetime->ReadOnly && !$product_cart_b_sample->datetime->Disabled && !isset($product_cart_b_sample->datetime->EditAttrs["readonly"]) && !isset($product_cart_b_sample->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduct_cart_b_samplesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_cart_b_sample_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_cart_b_sample_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_cart_b_sample_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var SGrp = $("#x_s_grp").val();
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
					if (data.calculation_method == '1') {
					$("#elh_product_cart_b_sample_price").html('Price / SQM');}
					else if (data.calculation_method == '11') {
					$("#elh_product_cart_b_sample_price").html('Price / SKU');}
					else if (data.calculation_method == '21') {
					$("#elh_product_cart_b_sample_price").html('Price / KG');}
			 		if (data.pc_shape == '--NA--') {
					$("#x_shape").val('');
					$("#r_shape").hide(); } else {
					$("#r_shape").show();}
			 		if (data.pc_unit == '--NA--') {
					$("#x_unit").val(1);
					$("#r_unit").hide(); } else {
					$("#r_unit").show();}			 		
					if (data.pc_w == '--NA--') {
					$("#x_w").val(0);
					$("#x_w_cm").val(0);
					$("#r_w").hide();					
					$("#r_w_cm").hide();
					} else {
					$("#r_w").show();
					$("#r_w_cm").show();}
					if (data.pc_l == '--NA--') {
					$("#x_l").val(0);
					$("#x_l_cm").val(0);
					$("#r_l").hide();					
					$("#r_l_cm").hide();
					} else {
					$("#r_l").show();
					$("#r_l_cm").show();}					
					if (data.pc_h == '--NA--') {
					$("#x_h").val(0);
					$("#x_h_cm").val(0);
					$("#r_h").hide();					
					$("#r_h_cm").hide();
					} else {
					$("#r_h").show();
					$("#r_h_cm").show();}
			 		if (data.pc_partner_size == '--NA--') {
					$("#x_partner_size").val('');
					$("#r_partner_size").hide(); } else {
					$("#r_partner_size").show();}
			 		if (data.pc_sqm == '--NA--') {
					$("#x_sqm").val(0);
					$("#r_sqm").hide(); } else {
					$("#r_sqm").show();}
			 		if (data.pc_01_head == '--NA--') {
					$("#x__1").val('');
					$("#r__1").hide(); } else {
					$("#r__1").show();					
					$("#elh_product_cart_b_sample__1").html(data.pc_01_head);}
			 		if (data.pc_02_head == '--NA--') {
					$("#x__2").val('');
					$("#r__2").hide(); } else {
					$("#r__2").show();					
					$("#elh_product_cart_b_sample__2").html(data.pc_02_head);}
			 		if (data.pc_03_head == '--NA--') {
					$("#x__3").val('');
					$("#r__3").hide(); } else {
					$("#r__3").show();					
					$("#elh_product_cart_b_sample__3").html(data.pc_03_head);}
			 		if (data.pc_04_head == '--NA--') {
					$("#x__4").val('');
					$("#r__4").hide(); } else {
					$("#r__4").show();					
					$("#elh_product_cart_b_sample__4").html(data.pc_04_head);}
			 		if (data.pc_05_head == '--NA--') {
					$("#x__5").val('');
					$("#r__5").hide(); } else {
					$("#r__5").show();					
					$("#elh_product_cart_b_sample__5").html(data.pc_05_head);}
			 		if (data.pc_06_head == '--NA--') {
					$("#x__6").val('');
					$("#r__6").hide(); } else {
					$("#r__6").show();					
					$("#elh_product_cart_b_sample__6").html(data.pc_06_head);}
			 		if (data.pc_07_head == '--NA--') {
					$("#x__7").val('');
					$("#r__7").hide(); } else {
					$("#r__7").show();					
					$("#elh_product_cart_b_sample__7").html(data.pc_07_head);}
			 		if (data.pc_08_head == '--NA--') {
					$("#x__8").val('');
					$("#r__8").hide(); } else {
					$("#r__8").show();					
					$("#elh_product_cart_b_sample__8").html(data.pc_08_head);}
					if (data.pc_09_head == '--NA--') {
					$("#x__9").val('');
					$("#r__9").hide(); } else {
					$("#r__9").show();					
					$("#elh_product_cart_b_sample__9").html(data.pc_09_head);}
			 		if (data.pc_10_head == '--NA--') {
					$("#x__10").val('');
					$("#r__10").hide(); } else {
					$("#r__10").show();					
					$("#elh_product_cart_b_sample__10").html(data.pc_10_head);}
			 		if (data.pc_11_head == '--NA--') {
					$("#x__11").val('');
					$("#r__11").hide(); } else {
					$("#r__11").show();					
					$("#elh_product_cart_b_sample__11").html(data.pc_11_head);}
			 		if (data.pc_12_head == '--NA--') {
					$("#x__12").val('');
					$("#r__12").hide(); } else {
					$("#r__12").show();					
					$("#elh_product_cart_b_sample__12").html(data.pc_12_head);}
			});
		}
</script>
<?php include_once "footer.php" ?>
<?php
$product_cart_b_sample_search->terminate();
?>