<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_b_wbc_list = new product_cart_b_wbc_list();

// Run the page
$product_cart_b_wbc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_b_wbc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_cart_b_wbc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_cart_b_wbclist = currentForm = new ew.Form("fproduct_cart_b_wbclist", "list");
fproduct_cart_b_wbclist.formKeyCountName = '<?php echo $product_cart_b_wbc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_cart_b_wbclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_b_wbclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_b_wbclist.lists["x_company_id"] = <?php echo $product_cart_b_wbc_list->company_id->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_b_wbc_list->company_id->lookupOptions()) ?>;
fproduct_cart_b_wbclist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclist.lists["x_po_id"] = <?php echo $product_cart_b_wbc_list->po_id->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_b_wbc_list->po_id->lookupOptions()) ?>;
fproduct_cart_b_wbclist.lists["x_partner_id"] = <?php echo $product_cart_b_wbc_list->partner_id->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_b_wbc_list->partner_id->lookupOptions()) ?>;
fproduct_cart_b_wbclist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclist.lists["x_partner_rid"] = <?php echo $product_cart_b_wbc_list->partner_rid->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_partner_rid"].options = <?php echo JsonEncode($product_cart_b_wbc_list->partner_rid->lookupOptions()) ?>;
fproduct_cart_b_wbclist.autoSuggests["x_partner_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclist.lists["x_product_type"] = <?php echo $product_cart_b_wbc_list->product_type->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_b_wbc_list->product_type->lookupOptions()) ?>;
fproduct_cart_b_wbclist.lists["x_grp"] = <?php echo $product_cart_b_wbc_list->grp->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_grp"].options = <?php echo JsonEncode($product_cart_b_wbc_list->grp->lookupOptions()) ?>;
fproduct_cart_b_wbclist.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclist.lists["x_s_grp"] = <?php echo $product_cart_b_wbc_list->s_grp->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_b_wbc_list->s_grp->lookupOptions()) ?>;
fproduct_cart_b_wbclist.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclist.lists["x_product"] = <?php echo $product_cart_b_wbc_list->product->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_product"].options = <?php echo JsonEncode($product_cart_b_wbc_list->product->lookupOptions()) ?>;
fproduct_cart_b_wbclist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclist.lists["x_rid"] = <?php echo $product_cart_b_wbc_list->rid->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_rid"].options = <?php echo JsonEncode($product_cart_b_wbc_list->rid->lookupOptions()) ?>;
fproduct_cart_b_wbclist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclist.lists["x_packing_type"] = <?php echo $product_cart_b_wbc_list->packing_type->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_packing_type"].options = <?php echo JsonEncode($product_cart_b_wbc_list->packing_type->lookupOptions()) ?>;
fproduct_cart_b_wbclist.lists["x_status"] = <?php echo $product_cart_b_wbc_list->status->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_status"].options = <?php echo JsonEncode($product_cart_b_wbc_list->status->options(FALSE, TRUE)) ?>;
fproduct_cart_b_wbclist.lists["x_operator"] = <?php echo $product_cart_b_wbc_list->operator->Lookup->toClientList() ?>;
fproduct_cart_b_wbclist.lists["x_operator"].options = <?php echo JsonEncode($product_cart_b_wbc_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduct_cart_b_wbclistsrch = currentSearchForm = new ew.Form("fproduct_cart_b_wbclistsrch");

// Validate function for search
fproduct_cart_b_wbclistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_wbc->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b_wbc->grp->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_cart_b_wbclistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_b_wbclistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_b_wbclistsrch.lists["x_company_id"] = <?php echo $product_cart_b_wbc_list->company_id->Lookup->toClientList() ?>;
fproduct_cart_b_wbclistsrch.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_b_wbc_list->company_id->lookupOptions()) ?>;
fproduct_cart_b_wbclistsrch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclistsrch.lists["x_partner_id"] = <?php echo $product_cart_b_wbc_list->partner_id->Lookup->toClientList() ?>;
fproduct_cart_b_wbclistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_b_wbc_list->partner_id->lookupOptions()) ?>;
fproduct_cart_b_wbclistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclistsrch.lists["x_grp"] = <?php echo $product_cart_b_wbc_list->grp->Lookup->toClientList() ?>;
fproduct_cart_b_wbclistsrch.lists["x_grp"].options = <?php echo JsonEncode($product_cart_b_wbc_list->grp->lookupOptions()) ?>;
fproduct_cart_b_wbclistsrch.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclistsrch.lists["x_s_grp"] = <?php echo $product_cart_b_wbc_list->s_grp->Lookup->toClientList() ?>;
fproduct_cart_b_wbclistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_b_wbc_list->s_grp->lookupOptions()) ?>;
fproduct_cart_b_wbclistsrch.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclistsrch.lists["x_product"] = <?php echo $product_cart_b_wbc_list->product->Lookup->toClientList() ?>;
fproduct_cart_b_wbclistsrch.lists["x_product"].options = <?php echo JsonEncode($product_cart_b_wbc_list->product->lookupOptions()) ?>;
fproduct_cart_b_wbclistsrch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_b_wbclistsrch.lists["x_rid"] = <?php echo $product_cart_b_wbc_list->rid->Lookup->toClientList() ?>;
fproduct_cart_b_wbclistsrch.lists["x_rid"].options = <?php echo JsonEncode($product_cart_b_wbc_list->rid->lookupOptions()) ?>;
fproduct_cart_b_wbclistsrch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fproduct_cart_b_wbclistsrch.filterList = <?php echo $product_cart_b_wbc_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_cart_b_wbclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
var CreateOrder = function(CID, PID){
	  var CAID =[];
	  $("#tbl_product_cart_b_wbclist tbody input[type='checkbox']:checked").each(function(){
	  		 CAID.push($(this).val());	  		 
	  });
	  if(CAID.length>0)
	  {
	  	$.getJSON("apcajax.php?t=product_cart_b&getCIDPID=" + CAID,function(data) {
	  	location.href='po_b_wbcadd.php?GRP='+data[2]+'&CID='+ data[0] + '&PID=' + data[1] + '&CAID=' + CAID.toString();
	  	});
	  }
	  else
	  {
	  	ew.alert("Please Select atleast a row to Update");
	  }
}
</script>
<?php } ?>
<?php if (!$product_cart_b_wbc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_cart_b_wbc_list->TotalRecs > 0 && $product_cart_b_wbc_list->ExportOptions->visible()) { ?>
<?php $product_cart_b_wbc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_b_wbc_list->ImportOptions->visible()) { ?>
<?php $product_cart_b_wbc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_b_wbc_list->SearchOptions->visible()) { ?>
<?php $product_cart_b_wbc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_b_wbc_list->FilterOptions->visible()) { ?>
<?php $product_cart_b_wbc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_cart_b_wbc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_cart_b_wbc->isExport() && !$product_cart_b_wbc->CurrentAction) { ?>
<form name="fproduct_cart_b_wbclistsrch" id="fproduct_cart_b_wbclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_cart_b_wbc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_cart_b_wbclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_cart_b_wbc">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_cart_b_wbc_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_cart_b_wbc->RowType = ROWTYPE_SEARCH;

// Render row
$product_cart_b_wbc->resetAttributes();
$product_cart_b_wbc_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_cart_b_wbc->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_b_wbc->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$product_cart_b_wbc->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b_wbc->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($product_cart_b_wbc->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_wbc->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b_wbc->company_id->getPlaceHolder()) ?>"<?php echo $product_cart_b_wbc->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b_wbc->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b_wbc->company_id->ReadOnly || $product_cart_b_wbc->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b_wbc" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b_wbc->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($product_cart_b_wbc->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_b_wbclistsrch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $product_cart_b_wbc->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_b_wbc->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_b_wbc->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$product_cart_b_wbc->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b_wbc->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($product_cart_b_wbc->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_wbc->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b_wbc->partner_id->getPlaceHolder()) ?>"<?php echo $product_cart_b_wbc->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="product_cart_b_wbc" data-field="x_partner_id" data-value-separator="<?php echo $product_cart_b_wbc->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($product_cart_b_wbc->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_b_wbclistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $product_cart_b_wbc->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_b_wbc->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_b_wbc->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b_wbc->grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b_wbc->grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_grp" class="text-nowrap" style="z-index: 8880">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_grp" id="sv_x_grp" value="<?php echo RemoveHtml($product_cart_b_wbc->grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_wbc->grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b_wbc->grp->getPlaceHolder()) ?>"<?php echo $product_cart_b_wbc->grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b_wbc->grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b_wbc->grp->ReadOnly || $product_cart_b_wbc->grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b_wbc" data-field="x_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b_wbc->grp->displayValueSeparatorAttribute() ?>" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($product_cart_b_wbc->grp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_b_wbclistsrch.createAutoSuggest({"id":"x_grp","forceSelect":true});
</script>
<?php echo $product_cart_b_wbc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($product_cart_b_wbc->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_b_wbc->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b_wbc->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b_wbc->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_s_grp" class="text-nowrap" style="z-index: 8870">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_s_grp" id="sv_x_s_grp" value="<?php echo RemoveHtml($product_cart_b_wbc->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_wbc->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b_wbc->s_grp->getPlaceHolder()) ?>"<?php echo $product_cart_b_wbc->s_grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b_wbc->s_grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_s_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b_wbc->s_grp->ReadOnly || $product_cart_b_wbc->s_grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b_wbc" data-field="x_s_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b_wbc->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($product_cart_b_wbc->s_grp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_b_wbclistsrch.createAutoSuggest({"id":"x_s_grp","forceSelect":true});
</script>
<?php echo $product_cart_b_wbc->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_b_wbc->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_b_wbc->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b_wbc->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b_wbc->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($product_cart_b_wbc->product->EditValue) ?>" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($product_cart_b_wbc->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b_wbc->product->getPlaceHolder()) ?>"<?php echo $product_cart_b_wbc->product->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b_wbc->product->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_product',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b_wbc->product->ReadOnly || $product_cart_b_wbc->product->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b_wbc" data-field="x_product" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b_wbc->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($product_cart_b_wbc->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_b_wbclistsrch.createAutoSuggest({"id":"x_product","forceSelect":true});
</script>
<?php echo $product_cart_b_wbc->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_b_wbc->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_b_wbc->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$product_cart_b_wbc->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b_wbc->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8850">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($product_cart_b_wbc->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b_wbc->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b_wbc->rid->getPlaceHolder()) ?>"<?php echo $product_cart_b_wbc->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b_wbc->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b_wbc->rid->ReadOnly || $product_cart_b_wbc->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b_wbc" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b_wbc->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($product_cart_b_wbc->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_b_wbclistsrch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $product_cart_b_wbc->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_cart_b_wbc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_cart_b_wbc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_cart_b_wbc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_cart_b_wbc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_cart_b_wbc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_cart_b_wbc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_cart_b_wbc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_cart_b_wbc_list->showPageHeader(); ?>
<?php
$product_cart_b_wbc_list->showMessage();
?>
<?php if ($product_cart_b_wbc_list->TotalRecs > 0 || $product_cart_b_wbc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_cart_b_wbc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_cart_b_wbc">
<?php if (!$product_cart_b_wbc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_cart_b_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_b_wbc_list->Pager)) $product_cart_b_wbc_list->Pager = new PrevNextPager($product_cart_b_wbc_list->StartRec, $product_cart_b_wbc_list->DisplayRecs, $product_cart_b_wbc_list->TotalRecs, $product_cart_b_wbc_list->AutoHidePager) ?>
<?php if ($product_cart_b_wbc_list->Pager->RecordCount > 0 && $product_cart_b_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_b_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_b_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_b_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_b_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_b_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_b_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_b_wbc_list->TotalRecs > 0 && (!$product_cart_b_wbc_list->AutoHidePageSizeSelector || $product_cart_b_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_b_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_b_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_b_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_b_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_b_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_b_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_cart_b_wbclist" id="fproduct_cart_b_wbclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_b_wbc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_b_wbc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_b_wbc">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_product_cart_b_wbc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_cart_b_wbc_list->TotalRecs > 0 || $product_cart_b_wbc->isGridEdit()) { ?>
<table id="tbl_product_cart_b_wbclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_cart_b_wbc_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_cart_b_wbc_list->renderListOptions();

// Render list options (header, left)
$product_cart_b_wbc_list->ListOptions->render("header", "left");
?>
<?php if ($product_cart_b_wbc->id->Visible) { // id ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_cart_b_wbc->id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_id" class="product_cart_b_wbc_id"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_cart_b_wbc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->id) ?>',1);"><div id="elh_product_cart_b_wbc_id" class="product_cart_b_wbc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->company_id->Visible) { // company_id ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $product_cart_b_wbc->company_id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_company_id" class="product_cart_b_wbc_company_id"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $product_cart_b_wbc->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->company_id) ?>',1);"><div id="elh_product_cart_b_wbc_company_id" class="product_cart_b_wbc_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->company_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->partner_order_no->Visible) { // partner_order_no ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->partner_order_no) == "") { ?>
		<th data-name="partner_order_no" class="<?php echo $product_cart_b_wbc->partner_order_no->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_order_no" class="product_cart_b_wbc_partner_order_no"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_order_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_order_no" class="<?php echo $product_cart_b_wbc->partner_order_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->partner_order_no) ?>',1);"><div id="elh_product_cart_b_wbc_partner_order_no" class="product_cart_b_wbc_partner_order_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_order_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->partner_order_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->partner_order_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->po_id->Visible) { // po_id ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->po_id) == "") { ?>
		<th data-name="po_id" class="<?php echo $product_cart_b_wbc->po_id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_po_id" class="product_cart_b_wbc_po_id"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->po_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_id" class="<?php echo $product_cart_b_wbc->po_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->po_id) ?>',1);"><div id="elh_product_cart_b_wbc_po_id" class="product_cart_b_wbc_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->po_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->po_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->partner_id->Visible) { // partner_id ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_b_wbc->partner_id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_id" class="product_cart_b_wbc_partner_id"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_b_wbc->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->partner_id) ?>',1);"><div id="elh_product_cart_b_wbc_partner_id" class="product_cart_b_wbc_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->partner_rid->Visible) { // partner_rid ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->partner_rid) == "") { ?>
		<th data-name="partner_rid" class="<?php echo $product_cart_b_wbc->partner_rid->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_rid" class="product_cart_b_wbc_partner_rid"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_rid" class="<?php echo $product_cart_b_wbc->partner_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->partner_rid) ?>',1);"><div id="elh_product_cart_b_wbc_partner_rid" class="product_cart_b_wbc_partner_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->partner_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->partner_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->partner_code->Visible) { // partner_code ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->partner_code) == "") { ?>
		<th data-name="partner_code" class="<?php echo $product_cart_b_wbc->partner_code->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_code" class="product_cart_b_wbc_partner_code"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_code" class="<?php echo $product_cart_b_wbc->partner_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->partner_code) ?>',1);"><div id="elh_product_cart_b_wbc_partner_code" class="product_cart_b_wbc_partner_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->partner_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->partner_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->partner_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->product_type->Visible) { // product_type ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $product_cart_b_wbc->product_type->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_product_type" class="product_cart_b_wbc_product_type"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $product_cart_b_wbc->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->product_type) ?>',1);"><div id="elh_product_cart_b_wbc_product_type" class="product_cart_b_wbc_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->grp->Visible) { // grp ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product_cart_b_wbc->grp->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_grp" class="product_cart_b_wbc_grp"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product_cart_b_wbc->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->grp) ?>',1);"><div id="elh_product_cart_b_wbc_grp" class="product_cart_b_wbc_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->grp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->s_grp->Visible) { // s_grp ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_b_wbc->s_grp->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_s_grp" class="product_cart_b_wbc_s_grp"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_b_wbc->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->s_grp) ?>',1);"><div id="elh_product_cart_b_wbc_s_grp" class="product_cart_b_wbc_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->s_grp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->product->Visible) { // product ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->product) == "") { ?>
		<th data-name="product" class="<?php echo $product_cart_b_wbc->product->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_product" class="product_cart_b_wbc_product"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $product_cart_b_wbc->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->product) ?>',1);"><div id="elh_product_cart_b_wbc_product" class="product_cart_b_wbc_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->rid->Visible) { // rid ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $product_cart_b_wbc->rid->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_rid" class="product_cart_b_wbc_rid"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $product_cart_b_wbc->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->rid) ?>',1);"><div id="elh_product_cart_b_wbc_rid" class="product_cart_b_wbc_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->packing_type->Visible) { // packing_type ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $product_cart_b_wbc->packing_type->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_packing_type" class="product_cart_b_wbc_packing_type"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $product_cart_b_wbc->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->packing_type) ?>',1);"><div id="elh_product_cart_b_wbc_packing_type" class="product_cart_b_wbc_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->quantity->Visible) { // quantity ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $product_cart_b_wbc->quantity->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_quantity" class="product_cart_b_wbc_quantity"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $product_cart_b_wbc->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->quantity) ?>',1);"><div id="elh_product_cart_b_wbc_quantity" class="product_cart_b_wbc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->price->Visible) { // price ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->price) == "") { ?>
		<th data-name="price" class="<?php echo $product_cart_b_wbc->price->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_price" class="product_cart_b_wbc_price"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $product_cart_b_wbc->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->price) ?>',1);"><div id="elh_product_cart_b_wbc_price" class="product_cart_b_wbc_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->amount->Visible) { // amount ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $product_cart_b_wbc->amount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_b_wbc_amount" class="product_cart_b_wbc_amount"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $product_cart_b_wbc->amount->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->amount) ?>',1);"><div id="elh_product_cart_b_wbc_amount" class="product_cart_b_wbc_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->status->Visible) { // status ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_cart_b_wbc->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_b_wbc_status" class="product_cart_b_wbc_status"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_cart_b_wbc->status->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->status) ?>',1);"><div id="elh_product_cart_b_wbc_status" class="product_cart_b_wbc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->operator->Visible) { // operator ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_cart_b_wbc->operator->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_operator" class="product_cart_b_wbc_operator"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_cart_b_wbc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->operator) ?>',1);"><div id="elh_product_cart_b_wbc_operator" class="product_cart_b_wbc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->datetime->Visible) { // datetime ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_cart_b_wbc->datetime->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_datetime" class="product_cart_b_wbc_datetime"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_cart_b_wbc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->datetime) ?>',1);"><div id="elh_product_cart_b_wbc_datetime" class="product_cart_b_wbc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b_wbc->level->Visible) { // level ?>
	<?php if ($product_cart_b_wbc->sortUrl($product_cart_b_wbc->level) == "") { ?>
		<th data-name="level" class="<?php echo $product_cart_b_wbc->level->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_level" class="product_cart_b_wbc_level"><div class="ew-table-header-caption"><?php echo $product_cart_b_wbc->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $product_cart_b_wbc->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b_wbc->SortUrl($product_cart_b_wbc->level) ?>',1);"><div id="elh_product_cart_b_wbc_level" class="product_cart_b_wbc_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b_wbc->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_wbc->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_wbc->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_cart_b_wbc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_cart_b_wbc->ExportAll && $product_cart_b_wbc->isExport()) {
	$product_cart_b_wbc_list->StopRec = $product_cart_b_wbc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_cart_b_wbc_list->TotalRecs > $product_cart_b_wbc_list->StartRec + $product_cart_b_wbc_list->DisplayRecs - 1)
		$product_cart_b_wbc_list->StopRec = $product_cart_b_wbc_list->StartRec + $product_cart_b_wbc_list->DisplayRecs - 1;
	else
		$product_cart_b_wbc_list->StopRec = $product_cart_b_wbc_list->TotalRecs;
}
$product_cart_b_wbc_list->RecCnt = $product_cart_b_wbc_list->StartRec - 1;
if ($product_cart_b_wbc_list->Recordset && !$product_cart_b_wbc_list->Recordset->EOF) {
	$product_cart_b_wbc_list->Recordset->moveFirst();
	$selectLimit = $product_cart_b_wbc_list->UseSelectLimit;
	if (!$selectLimit && $product_cart_b_wbc_list->StartRec > 1)
		$product_cart_b_wbc_list->Recordset->move($product_cart_b_wbc_list->StartRec - 1);
} elseif (!$product_cart_b_wbc->AllowAddDeleteRow && $product_cart_b_wbc_list->StopRec == 0) {
	$product_cart_b_wbc_list->StopRec = $product_cart_b_wbc->GridAddRowCount;
}

// Initialize aggregate
$product_cart_b_wbc->RowType = ROWTYPE_AGGREGATEINIT;
$product_cart_b_wbc->resetAttributes();
$product_cart_b_wbc_list->renderRow();
while ($product_cart_b_wbc_list->RecCnt < $product_cart_b_wbc_list->StopRec) {
	$product_cart_b_wbc_list->RecCnt++;
	if ($product_cart_b_wbc_list->RecCnt >= $product_cart_b_wbc_list->StartRec) {
		$product_cart_b_wbc_list->RowCnt++;

		// Set up key count
		$product_cart_b_wbc_list->KeyCount = $product_cart_b_wbc_list->RowIndex;

		// Init row class and style
		$product_cart_b_wbc->resetAttributes();
		$product_cart_b_wbc->CssClass = "";
		if ($product_cart_b_wbc->isGridAdd()) {
		} else {
			$product_cart_b_wbc_list->loadRowValues($product_cart_b_wbc_list->Recordset); // Load row values
		}
		$product_cart_b_wbc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_cart_b_wbc->RowAttrs = array_merge($product_cart_b_wbc->RowAttrs, array('data-rowindex'=>$product_cart_b_wbc_list->RowCnt, 'id'=>'r' . $product_cart_b_wbc_list->RowCnt . '_product_cart_b_wbc', 'data-rowtype'=>$product_cart_b_wbc->RowType));

		// Render row
		$product_cart_b_wbc_list->renderRow();

		// Render list options
		$product_cart_b_wbc_list->renderListOptions();
?>
	<tr<?php echo $product_cart_b_wbc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_cart_b_wbc_list->ListOptions->render("body", "left", $product_cart_b_wbc_list->RowCnt);
?>
	<?php if ($product_cart_b_wbc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_cart_b_wbc->id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_id" class="product_cart_b_wbc_id">
<span<?php echo $product_cart_b_wbc->id->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $product_cart_b_wbc->company_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_company_id" class="product_cart_b_wbc_company_id">
<span<?php echo $product_cart_b_wbc->company_id->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_order_no->Visible) { // partner_order_no ?>
		<td data-name="partner_order_no"<?php echo $product_cart_b_wbc->partner_order_no->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_partner_order_no" class="product_cart_b_wbc_partner_order_no">
<span<?php echo $product_cart_b_wbc->partner_order_no->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->partner_order_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->po_id->Visible) { // po_id ?>
		<td data-name="po_id"<?php echo $product_cart_b_wbc->po_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_po_id" class="product_cart_b_wbc_po_id">
<span<?php echo $product_cart_b_wbc->po_id->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b_wbc->po_id->getViewValue())) && $product_cart_b_wbc->po_id->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b_wbc->po_id->linkAttributes() ?>><?php echo $product_cart_b_wbc->po_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b_wbc->po_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $product_cart_b_wbc->partner_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_partner_id" class="product_cart_b_wbc_partner_id">
<span<?php echo $product_cart_b_wbc->partner_id->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_rid->Visible) { // partner_rid ?>
		<td data-name="partner_rid"<?php echo $product_cart_b_wbc->partner_rid->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_partner_rid" class="product_cart_b_wbc_partner_rid">
<span<?php echo $product_cart_b_wbc->partner_rid->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->partner_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_code->Visible) { // partner_code ?>
		<td data-name="partner_code"<?php echo $product_cart_b_wbc->partner_code->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_partner_code" class="product_cart_b_wbc_partner_code">
<span<?php echo $product_cart_b_wbc->partner_code->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->partner_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $product_cart_b_wbc->product_type->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_product_type" class="product_cart_b_wbc_product_type">
<span<?php echo $product_cart_b_wbc->product_type->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product_cart_b_wbc->grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_grp" class="product_cart_b_wbc_grp">
<span<?php echo $product_cart_b_wbc->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b_wbc->grp->getViewValue())) && $product_cart_b_wbc->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b_wbc->grp->linkAttributes() ?>><?php echo $product_cart_b_wbc->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b_wbc->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product_cart_b_wbc->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_s_grp" class="product_cart_b_wbc_s_grp">
<span<?php echo $product_cart_b_wbc->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b_wbc->s_grp->getViewValue())) && $product_cart_b_wbc->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b_wbc->s_grp->linkAttributes() ?>><?php echo $product_cart_b_wbc->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b_wbc->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->product->Visible) { // product ?>
		<td data-name="product"<?php echo $product_cart_b_wbc->product->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_product" class="product_cart_b_wbc_product">
<span<?php echo $product_cart_b_wbc->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b_wbc->product->getViewValue())) && $product_cart_b_wbc->product->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b_wbc->product->linkAttributes() ?>><?php echo $product_cart_b_wbc->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b_wbc->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $product_cart_b_wbc->rid->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_rid" class="product_cart_b_wbc_rid">
<span<?php echo $product_cart_b_wbc->rid->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $product_cart_b_wbc->packing_type->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_packing_type" class="product_cart_b_wbc_packing_type">
<span<?php echo $product_cart_b_wbc->packing_type->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $product_cart_b_wbc->quantity->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_quantity" class="product_cart_b_wbc_quantity">
<span<?php echo $product_cart_b_wbc->quantity->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->price->Visible) { // price ?>
		<td data-name="price"<?php echo $product_cart_b_wbc->price->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_price" class="product_cart_b_wbc_price">
<span<?php echo $product_cart_b_wbc->price->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $product_cart_b_wbc->amount->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_amount" class="product_cart_b_wbc_amount">
<span<?php echo $product_cart_b_wbc->amount->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_cart_b_wbc->status->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_status" class="product_cart_b_wbc_status">
<span<?php echo $product_cart_b_wbc->status->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_cart_b_wbc->operator->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_operator" class="product_cart_b_wbc_operator">
<span<?php echo $product_cart_b_wbc->operator->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_cart_b_wbc->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_datetime" class="product_cart_b_wbc_datetime">
<span<?php echo $product_cart_b_wbc->datetime->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->level->Visible) { // level ?>
		<td data-name="level"<?php echo $product_cart_b_wbc->level->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_wbc_list->RowCnt ?>_product_cart_b_wbc_level" class="product_cart_b_wbc_level">
<span<?php echo $product_cart_b_wbc->level->viewAttributes() ?>>
<?php echo $product_cart_b_wbc->level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_cart_b_wbc_list->ListOptions->render("body", "right", $product_cart_b_wbc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_cart_b_wbc->isGridAdd())
		$product_cart_b_wbc_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$product_cart_b_wbc->RowType = ROWTYPE_AGGREGATE;
$product_cart_b_wbc->resetAttributes();
$product_cart_b_wbc_list->renderRow();
?>
<?php if ($product_cart_b_wbc_list->TotalRecs > 0 && !$product_cart_b_wbc->isGridAdd() && !$product_cart_b_wbc->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$product_cart_b_wbc_list->renderListOptions();

// Render list options (footer, left)
$product_cart_b_wbc_list->ListOptions->render("footer", "left");
?>
	<?php if ($product_cart_b_wbc->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $product_cart_b_wbc->id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_id" class="product_cart_b_wbc_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $product_cart_b_wbc->company_id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_company_id" class="product_cart_b_wbc_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_order_no->Visible) { // partner_order_no ?>
		<td data-name="partner_order_no" class="<?php echo $product_cart_b_wbc->partner_order_no->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_order_no" class="product_cart_b_wbc_partner_order_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->po_id->Visible) { // po_id ?>
		<td data-name="po_id" class="<?php echo $product_cart_b_wbc->po_id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_po_id" class="product_cart_b_wbc_po_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id" class="<?php echo $product_cart_b_wbc->partner_id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_id" class="product_cart_b_wbc_partner_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_rid->Visible) { // partner_rid ?>
		<td data-name="partner_rid" class="<?php echo $product_cart_b_wbc->partner_rid->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_rid" class="product_cart_b_wbc_partner_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->partner_code->Visible) { // partner_code ?>
		<td data-name="partner_code" class="<?php echo $product_cart_b_wbc->partner_code->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_code" class="product_cart_b_wbc_partner_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->product_type->Visible) { // product_type ?>
		<td data-name="product_type" class="<?php echo $product_cart_b_wbc->product_type->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_product_type" class="product_cart_b_wbc_product_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $product_cart_b_wbc->grp->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_grp" class="product_cart_b_wbc_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $product_cart_b_wbc->s_grp->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_s_grp" class="product_cart_b_wbc_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $product_cart_b_wbc->product->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_product" class="product_cart_b_wbc_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $product_cart_b_wbc->rid->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_rid" class="product_cart_b_wbc_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $product_cart_b_wbc->packing_type->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_packing_type" class="product_cart_b_wbc_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $product_cart_b_wbc->quantity->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_quantity" class="product_cart_b_wbc_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $product_cart_b_wbc->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->price->Visible) { // price ?>
		<td data-name="price" class="<?php echo $product_cart_b_wbc->price->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_price" class="product_cart_b_wbc_price">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $product_cart_b_wbc->amount->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_amount" class="product_cart_b_wbc_amount">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $product_cart_b_wbc->status->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_status" class="product_cart_b_wbc_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $product_cart_b_wbc->operator->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_operator" class="product_cart_b_wbc_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $product_cart_b_wbc->datetime->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_datetime" class="product_cart_b_wbc_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($product_cart_b_wbc->level->Visible) { // level ?>
		<td data-name="level" class="<?php echo $product_cart_b_wbc->level->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_level" class="product_cart_b_wbc_level">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$product_cart_b_wbc_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_cart_b_wbc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_cart_b_wbc_list->Recordset)
	$product_cart_b_wbc_list->Recordset->Close();
?>
<?php if (!$product_cart_b_wbc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_cart_b_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_b_wbc_list->Pager)) $product_cart_b_wbc_list->Pager = new PrevNextPager($product_cart_b_wbc_list->StartRec, $product_cart_b_wbc_list->DisplayRecs, $product_cart_b_wbc_list->TotalRecs, $product_cart_b_wbc_list->AutoHidePager) ?>
<?php if ($product_cart_b_wbc_list->Pager->RecordCount > 0 && $product_cart_b_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_b_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_b_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_b_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_b_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_b_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_b_wbc_list->pageUrl() ?>start=<?php echo $product_cart_b_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_b_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_b_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_b_wbc_list->TotalRecs > 0 && (!$product_cart_b_wbc_list->AutoHidePageSizeSelector || $product_cart_b_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_b_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_b_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_b_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_b_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_b_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_b_wbc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_cart_b_wbc_list->TotalRecs == 0 && !$product_cart_b_wbc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_cart_b_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_cart_b_wbc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_cart_b_wbc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_cart_b_wbc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_cart_b_wbc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_cart_b_wbc_list->terminate();
?>