<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_b_list = new product_cart_b_list();

// Run the page
$product_cart_b_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_b_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_cart_b->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_cart_blist = currentForm = new ew.Form("fproduct_cart_blist", "list");
fproduct_cart_blist.formKeyCountName = '<?php echo $product_cart_b_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_cart_blist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_blist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_blist.lists["x_po_id"] = <?php echo $product_cart_b_list->po_id->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_b_list->po_id->lookupOptions()) ?>;
fproduct_cart_blist.lists["x_company_id"] = <?php echo $product_cart_b_list->company_id->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_b_list->company_id->lookupOptions()) ?>;
fproduct_cart_blist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_blist.lists["x_partner_id"] = <?php echo $product_cart_b_list->partner_id->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_b_list->partner_id->lookupOptions()) ?>;
fproduct_cart_blist.lists["x_partner_rid"] = <?php echo $product_cart_b_list->partner_rid->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_partner_rid"].options = <?php echo JsonEncode($product_cart_b_list->partner_rid->lookupOptions()) ?>;
fproduct_cart_blist.autoSuggests["x_partner_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_blist.lists["x_grp"] = <?php echo $product_cart_b_list->grp->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_grp"].options = <?php echo JsonEncode($product_cart_b_list->grp->lookupOptions()) ?>;
fproduct_cart_blist.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_blist.lists["x_s_grp"] = <?php echo $product_cart_b_list->s_grp->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_b_list->s_grp->lookupOptions()) ?>;
fproduct_cart_blist.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_blist.lists["x_product"] = <?php echo $product_cart_b_list->product->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_product"].options = <?php echo JsonEncode($product_cart_b_list->product->lookupOptions()) ?>;
fproduct_cart_blist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_blist.lists["x_rid"] = <?php echo $product_cart_b_list->rid->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_rid"].options = <?php echo JsonEncode($product_cart_b_list->rid->lookupOptions()) ?>;
fproduct_cart_blist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_blist.lists["x_packing_type"] = <?php echo $product_cart_b_list->packing_type->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_packing_type"].options = <?php echo JsonEncode($product_cart_b_list->packing_type->lookupOptions()) ?>;
fproduct_cart_blist.lists["x_product_type"] = <?php echo $product_cart_b_list->product_type->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_b_list->product_type->lookupOptions()) ?>;
fproduct_cart_blist.lists["x_status"] = <?php echo $product_cart_b_list->status->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_status"].options = <?php echo JsonEncode($product_cart_b_list->status->options(FALSE, TRUE)) ?>;
fproduct_cart_blist.lists["x_operator"] = <?php echo $product_cart_b_list->operator->Lookup->toClientList() ?>;
fproduct_cart_blist.lists["x_operator"].options = <?php echo JsonEncode($product_cart_b_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduct_cart_blistsrch = currentSearchForm = new ew.Form("fproduct_cart_blistsrch");

// Validate function for search
fproduct_cart_blistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_additional_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->additional_discount->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_cart_blistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_blistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_blistsrch.lists["x_company_id"] = <?php echo $product_cart_b_list->company_id->Lookup->toClientList() ?>;
fproduct_cart_blistsrch.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_b_list->company_id->lookupOptions()) ?>;
fproduct_cart_blistsrch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_blistsrch.lists["x_partner_id"] = <?php echo $product_cart_b_list->partner_id->Lookup->toClientList() ?>;
fproduct_cart_blistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_b_list->partner_id->lookupOptions()) ?>;

// Filters
fproduct_cart_blistsrch.filterList = <?php echo $product_cart_b_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_cart_blistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
var CreateOrder = function(CID, PID){
	  var CAID =[];
	  $("#tbl_product_cart_blist tbody input[type='checkbox']:checked").each(function(){
	  		 CAID.push($(this).val());	  		 
	  });
	  if(CAID.length>0)
	  {
	  	$.getJSON("apcajax.php?t=product_cart_b&getCIDPID=" + CAID,function(data) {
	  	location.href='po_badd.php?GRP='+data[2]+'&CID='+ data[0] + '&PID=' + data[1] + '&CAID=' + CAID.toString();
	  	});
	  }
	  else
	  {
	  	ew.alert("Please Select atleast a row to Update");
	  }
}
					$.getJSON("apcajax.php?pdbyepass=9",function(data) {
			 		if (data == '2') {$("#r_batch_no").hide();}});
</script>
<?php } ?>
<?php if (!$product_cart_b->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_cart_b_list->TotalRecs > 0 && $product_cart_b_list->ExportOptions->visible()) { ?>
<?php $product_cart_b_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_b_list->ImportOptions->visible()) { ?>
<?php $product_cart_b_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_b_list->SearchOptions->visible()) { ?>
<?php $product_cart_b_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_b_list->FilterOptions->visible()) { ?>
<?php $product_cart_b_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$product_cart_b->isExport() || EXPORT_MASTER_RECORD && $product_cart_b->isExport("print")) { ?>
<?php
if ($product_cart_b_list->DbMasterFilter <> "" && $product_cart_b->getCurrentMasterTable() == "po_b") {
	if ($product_cart_b_list->MasterRecordExists) {
		include_once "po_bmaster.php";
	}
}
?>
<?php } ?>
<?php
$product_cart_b_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_cart_b->isExport() && !$product_cart_b->CurrentAction) { ?>
<form name="fproduct_cart_blistsrch" id="fproduct_cart_blistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_cart_b_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_cart_blistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_cart_b">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_cart_b_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_cart_b->RowType = ROWTYPE_SEARCH;

// Render row
$product_cart_b->resetAttributes();
$product_cart_b_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_cart_b->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_b->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$product_cart_b->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($product_cart_b->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b->company_id->getPlaceHolder()) ?>"<?php echo $product_cart_b->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->company_id->ReadOnly || $product_cart_b->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($product_cart_b->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_blistsrch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $product_cart_b->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_b->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label for="x_partner_id" class="ew-search-caption ew-label"><?php echo $product_cart_b->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_partner_id" data-value-separator="<?php echo $product_cart_b->partner_id->displayValueSeparatorAttribute() ?>" id="x_partner_id" name="x_partner_id"<?php echo $product_cart_b->partner_id->editAttributes() ?>>
		<?php echo $product_cart_b->partner_id->selectOptionListHtml("x_partner_id") ?>
	</select>
</div>
<?php echo $product_cart_b->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_b->partner_code->Visible) { // partner_code ?>
	<div id="xsc_partner_code" class="ew-cell form-group">
		<label for="x_partner_code" class="ew-search-caption ew-label"><?php echo $product_cart_b->partner_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="product_cart_b" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_b->partner_code->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->partner_code->EditValue ?>"<?php echo $product_cart_b->partner_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($product_cart_b->price->Visible) { // price ?>
	<div id="xsc_price" class="ew-cell form-group">
		<label for="x_price" class="ew-search-caption ew-label"><?php echo $product_cart_b->price->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="product_cart_b" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->price->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->price->EditValue ?>"<?php echo $product_cart_b->price->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_b->additional_discount->Visible) { // additional_discount ?>
	<div id="xsc_additional_discount" class="ew-cell form-group">
		<label for="x_additional_discount" class="ew-search-caption ew-label"><?php echo $product_cart_b->additional_discount->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_additional_discount" id="z_additional_discount" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="product_cart_b" data-field="x_additional_discount" name="x_additional_discount" id="x_additional_discount" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->additional_discount->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->additional_discount->EditValue ?>"<?php echo $product_cart_b->additional_discount->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_cart_b_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_cart_b_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_cart_b_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_cart_b_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_cart_b_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_cart_b_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_cart_b_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_cart_b_list->showPageHeader(); ?>
<?php
$product_cart_b_list->showMessage();
?>
<?php if ($product_cart_b_list->TotalRecs > 0 || $product_cart_b->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_cart_b_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_cart_b">
<?php if (!$product_cart_b->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_cart_b->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_b_list->Pager)) $product_cart_b_list->Pager = new PrevNextPager($product_cart_b_list->StartRec, $product_cart_b_list->DisplayRecs, $product_cart_b_list->TotalRecs, $product_cart_b_list->AutoHidePager) ?>
<?php if ($product_cart_b_list->Pager->RecordCount > 0 && $product_cart_b_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_b_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_b_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_b_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_b_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_b_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_b_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_b_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_b_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_b_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_b_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_b_list->TotalRecs > 0 && (!$product_cart_b_list->AutoHidePageSizeSelector || $product_cart_b_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_b">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_b_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_b_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_b_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_b->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_b_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_cart_blist" id="fproduct_cart_blist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_b_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_b_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_b">
<input type="hidden" name="exporttype" id="exporttype" value="">
<?php if ($product_cart_b->getCurrentMasterTable() == "po_b" && $product_cart_b->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="po_b">
<input type="hidden" name="fk_id" value="<?php echo $product_cart_b->po_id->getSessionValue() ?>">
<?php } ?>
<div id="gmp_product_cart_b" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_cart_b_list->TotalRecs > 0 || $product_cart_b->isGridEdit()) { ?>
<table id="tbl_product_cart_blist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_cart_b_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_cart_b_list->renderListOptions();

// Render list options (header, left)
$product_cart_b_list->ListOptions->render("header", "left");
?>
<?php if ($product_cart_b->id->Visible) { // id ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_cart_b->id->headerCellClass() ?>"><div id="elh_product_cart_b_id" class="product_cart_b_id"><div class="ew-table-header-caption"><?php echo $product_cart_b->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_cart_b->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->id) ?>',1);"><div id="elh_product_cart_b_id" class="product_cart_b_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->po_id->Visible) { // po_id ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->po_id) == "") { ?>
		<th data-name="po_id" class="<?php echo $product_cart_b->po_id->headerCellClass() ?>"><div id="elh_product_cart_b_po_id" class="product_cart_b_po_id"><div class="ew-table-header-caption"><?php echo $product_cart_b->po_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_id" class="<?php echo $product_cart_b->po_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->po_id) ?>',1);"><div id="elh_product_cart_b_po_id" class="product_cart_b_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->po_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->po_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->company_id->Visible) { // company_id ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $product_cart_b->company_id->headerCellClass() ?>"><div id="elh_product_cart_b_company_id" class="product_cart_b_company_id"><div class="ew-table-header-caption"><?php echo $product_cart_b->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $product_cart_b->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->company_id) ?>',1);"><div id="elh_product_cart_b_company_id" class="product_cart_b_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_order_no->Visible) { // partner_order_no ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->partner_order_no) == "") { ?>
		<th data-name="partner_order_no" class="<?php echo $product_cart_b->partner_order_no->headerCellClass() ?>"><div id="elh_product_cart_b_partner_order_no" class="product_cart_b_partner_order_no"><div class="ew-table-header-caption"><?php echo $product_cart_b->partner_order_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_order_no" class="<?php echo $product_cart_b->partner_order_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->partner_order_no) ?>',1);"><div id="elh_product_cart_b_partner_order_no" class="product_cart_b_partner_order_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_order_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->partner_order_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->partner_order_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_id->Visible) { // partner_id ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_b->partner_id->headerCellClass() ?>"><div id="elh_product_cart_b_partner_id" class="product_cart_b_partner_id"><div class="ew-table-header-caption"><?php echo $product_cart_b->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_b->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->partner_id) ?>',1);"><div id="elh_product_cart_b_partner_id" class="product_cart_b_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_rid->Visible) { // partner_rid ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->partner_rid) == "") { ?>
		<th data-name="partner_rid" class="<?php echo $product_cart_b->partner_rid->headerCellClass() ?>"><div id="elh_product_cart_b_partner_rid" class="product_cart_b_partner_rid"><div class="ew-table-header-caption"><?php echo $product_cart_b->partner_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_rid" class="<?php echo $product_cart_b->partner_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->partner_rid) ?>',1);"><div id="elh_product_cart_b_partner_rid" class="product_cart_b_partner_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->partner_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->partner_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_code->Visible) { // partner_code ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->partner_code) == "") { ?>
		<th data-name="partner_code" class="<?php echo $product_cart_b->partner_code->headerCellClass() ?>"><div id="elh_product_cart_b_partner_code" class="product_cart_b_partner_code"><div class="ew-table-header-caption"><?php echo $product_cart_b->partner_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_code" class="<?php echo $product_cart_b->partner_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->partner_code) ?>',1);"><div id="elh_product_cart_b_partner_code" class="product_cart_b_partner_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->partner_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->partner_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->grp->Visible) { // grp ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product_cart_b->grp->headerCellClass() ?>"><div id="elh_product_cart_b_grp" class="product_cart_b_grp"><div class="ew-table-header-caption"><?php echo $product_cart_b->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product_cart_b->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->grp) ?>',1);"><div id="elh_product_cart_b_grp" class="product_cart_b_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->s_grp->Visible) { // s_grp ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_b->s_grp->headerCellClass() ?>"><div id="elh_product_cart_b_s_grp" class="product_cart_b_s_grp"><div class="ew-table-header-caption"><?php echo $product_cart_b->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_b->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->s_grp) ?>',1);"><div id="elh_product_cart_b_s_grp" class="product_cart_b_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->product->Visible) { // product ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->product) == "") { ?>
		<th data-name="product" class="<?php echo $product_cart_b->product->headerCellClass() ?>"><div id="elh_product_cart_b_product" class="product_cart_b_product"><div class="ew-table-header-caption"><?php echo $product_cart_b->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $product_cart_b->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->product) ?>',1);"><div id="elh_product_cart_b_product" class="product_cart_b_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->rid->Visible) { // rid ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $product_cart_b->rid->headerCellClass() ?>"><div id="elh_product_cart_b_rid" class="product_cart_b_rid"><div class="ew-table-header-caption"><?php echo $product_cart_b->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $product_cart_b->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->rid) ?>',1);"><div id="elh_product_cart_b_rid" class="product_cart_b_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->packing_type->Visible) { // packing_type ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $product_cart_b->packing_type->headerCellClass() ?>"><div id="elh_product_cart_b_packing_type" class="product_cart_b_packing_type"><div class="ew-table-header-caption"><?php echo $product_cart_b->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $product_cart_b->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->packing_type) ?>',1);"><div id="elh_product_cart_b_packing_type" class="product_cart_b_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->product_type->Visible) { // product_type ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $product_cart_b->product_type->headerCellClass() ?>"><div id="elh_product_cart_b_product_type" class="product_cart_b_product_type"><div class="ew-table-header-caption"><?php echo $product_cart_b->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $product_cart_b->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->product_type) ?>',1);"><div id="elh_product_cart_b_product_type" class="product_cart_b_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->size->Visible) { // size ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->size) == "") { ?>
		<th data-name="size" class="<?php echo $product_cart_b->size->headerCellClass() ?>"><div id="elh_product_cart_b_size" class="product_cart_b_size"><div class="ew-table-header-caption"><?php echo $product_cart_b->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $product_cart_b->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->size) ?>',1);"><div id="elh_product_cart_b_size" class="product_cart_b_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->quantity->Visible) { // quantity ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $product_cart_b->quantity->headerCellClass() ?>"><div id="elh_product_cart_b_quantity" class="product_cart_b_quantity"><div class="ew-table-header-caption"><?php echo $product_cart_b->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $product_cart_b->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->quantity) ?>',1);"><div id="elh_product_cart_b_quantity" class="product_cart_b_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->price->Visible) { // price ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->price) == "") { ?>
		<th data-name="price" class="<?php echo $product_cart_b->price->headerCellClass() ?>"><div id="elh_product_cart_b_price" class="product_cart_b_price"><div class="ew-table-header-caption"><?php echo $product_cart_b->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $product_cart_b->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->price) ?>',1);"><div id="elh_product_cart_b_price" class="product_cart_b_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->amount->Visible) { // amount ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $product_cart_b->amount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_b_amount" class="product_cart_b_amount"><div class="ew-table-header-caption"><?php echo $product_cart_b->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $product_cart_b->amount->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->amount) ?>',1);"><div id="elh_product_cart_b_amount" class="product_cart_b_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->status->Visible) { // status ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_cart_b->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_b_status" class="product_cart_b_status"><div class="ew-table-header-caption"><?php echo $product_cart_b->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_cart_b->status->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->status) ?>',1);"><div id="elh_product_cart_b_status" class="product_cart_b_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->additional_discount->Visible) { // additional_discount ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->additional_discount) == "") { ?>
		<th data-name="additional_discount" class="<?php echo $product_cart_b->additional_discount->headerCellClass() ?>"><div id="elh_product_cart_b_additional_discount" class="product_cart_b_additional_discount"><div class="ew-table-header-caption"><?php echo $product_cart_b->additional_discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="additional_discount" class="<?php echo $product_cart_b->additional_discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->additional_discount) ?>',1);"><div id="elh_product_cart_b_additional_discount" class="product_cart_b_additional_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->additional_discount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->additional_discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->additional_discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->buyer_loc->Visible) { // buyer_loc ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->buyer_loc) == "") { ?>
		<th data-name="buyer_loc" class="<?php echo $product_cart_b->buyer_loc->headerCellClass() ?>"><div id="elh_product_cart_b_buyer_loc" class="product_cart_b_buyer_loc"><div class="ew-table-header-caption"><?php echo $product_cart_b->buyer_loc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_loc" class="<?php echo $product_cart_b->buyer_loc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->buyer_loc) ?>',1);"><div id="elh_product_cart_b_buyer_loc" class="product_cart_b_buyer_loc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->buyer_loc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->buyer_loc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->buyer_loc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->operator->Visible) { // operator ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_cart_b->operator->headerCellClass() ?>"><div id="elh_product_cart_b_operator" class="product_cart_b_operator"><div class="ew-table-header-caption"><?php echo $product_cart_b->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_cart_b->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->operator) ?>',1);"><div id="elh_product_cart_b_operator" class="product_cart_b_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->datetime->Visible) { // datetime ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_cart_b->datetime->headerCellClass() ?>"><div id="elh_product_cart_b_datetime" class="product_cart_b_datetime"><div class="ew-table-header-caption"><?php echo $product_cart_b->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_cart_b->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->datetime) ?>',1);"><div id="elh_product_cart_b_datetime" class="product_cart_b_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->level->Visible) { // level ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->level) == "") { ?>
		<th data-name="level" class="<?php echo $product_cart_b->level->headerCellClass() ?>"><div id="elh_product_cart_b_level" class="product_cart_b_level"><div class="ew-table-header-caption"><?php echo $product_cart_b->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $product_cart_b->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->level) ?>',1);"><div id="elh_product_cart_b_level" class="product_cart_b_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->dispatch_week->Visible) { // dispatch_week ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->dispatch_week) == "") { ?>
		<th data-name="dispatch_week" class="<?php echo $product_cart_b->dispatch_week->headerCellClass() ?>"><div id="elh_product_cart_b_dispatch_week" class="product_cart_b_dispatch_week"><div class="ew-table-header-caption"><?php echo $product_cart_b->dispatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch_week" class="<?php echo $product_cart_b->dispatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->dispatch_week) ?>',1);"><div id="elh_product_cart_b_dispatch_week" class="product_cart_b_dispatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->dispatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->dispatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->dispatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->sale_id->Visible) { // sale_id ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->sale_id) == "") { ?>
		<th data-name="sale_id" class="<?php echo $product_cart_b->sale_id->headerCellClass() ?>"><div id="elh_product_cart_b_sale_id" class="product_cart_b_sale_id"><div class="ew-table-header-caption"><?php echo $product_cart_b->sale_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sale_id" class="<?php echo $product_cart_b->sale_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->sale_id) ?>',1);"><div id="elh_product_cart_b_sale_id" class="product_cart_b_sale_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->sale_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->sale_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->sale_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->sale_qty->Visible) { // sale_qty ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->sale_qty) == "") { ?>
		<th data-name="sale_qty" class="<?php echo $product_cart_b->sale_qty->headerCellClass() ?>"><div id="elh_product_cart_b_sale_qty" class="product_cart_b_sale_qty"><div class="ew-table-header-caption"><?php echo $product_cart_b->sale_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sale_qty" class="<?php echo $product_cart_b->sale_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->sale_qty) ?>',1);"><div id="elh_product_cart_b_sale_qty" class="product_cart_b_sale_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->sale_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->sale_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->sale_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->balance->Visible) { // balance ?>
	<?php if ($product_cart_b->sortUrl($product_cart_b->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $product_cart_b->balance->headerCellClass() ?>"><div id="elh_product_cart_b_balance" class="product_cart_b_balance"><div class="ew-table-header-caption"><?php echo $product_cart_b->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $product_cart_b->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_b->SortUrl($product_cart_b->balance) ?>',1);"><div id="elh_product_cart_b_balance" class="product_cart_b_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_cart_b_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_cart_b->ExportAll && $product_cart_b->isExport()) {
	$product_cart_b_list->StopRec = $product_cart_b_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_cart_b_list->TotalRecs > $product_cart_b_list->StartRec + $product_cart_b_list->DisplayRecs - 1)
		$product_cart_b_list->StopRec = $product_cart_b_list->StartRec + $product_cart_b_list->DisplayRecs - 1;
	else
		$product_cart_b_list->StopRec = $product_cart_b_list->TotalRecs;
}
$product_cart_b_list->RecCnt = $product_cart_b_list->StartRec - 1;
if ($product_cart_b_list->Recordset && !$product_cart_b_list->Recordset->EOF) {
	$product_cart_b_list->Recordset->moveFirst();
	$selectLimit = $product_cart_b_list->UseSelectLimit;
	if (!$selectLimit && $product_cart_b_list->StartRec > 1)
		$product_cart_b_list->Recordset->move($product_cart_b_list->StartRec - 1);
} elseif (!$product_cart_b->AllowAddDeleteRow && $product_cart_b_list->StopRec == 0) {
	$product_cart_b_list->StopRec = $product_cart_b->GridAddRowCount;
}

// Initialize aggregate
$product_cart_b->RowType = ROWTYPE_AGGREGATEINIT;
$product_cart_b->resetAttributes();
$product_cart_b_list->renderRow();
while ($product_cart_b_list->RecCnt < $product_cart_b_list->StopRec) {
	$product_cart_b_list->RecCnt++;
	if ($product_cart_b_list->RecCnt >= $product_cart_b_list->StartRec) {
		$product_cart_b_list->RowCnt++;

		// Set up key count
		$product_cart_b_list->KeyCount = $product_cart_b_list->RowIndex;

		// Init row class and style
		$product_cart_b->resetAttributes();
		$product_cart_b->CssClass = "";
		if ($product_cart_b->isGridAdd()) {
		} else {
			$product_cart_b_list->loadRowValues($product_cart_b_list->Recordset); // Load row values
		}
		$product_cart_b->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_cart_b->RowAttrs = array_merge($product_cart_b->RowAttrs, array('data-rowindex'=>$product_cart_b_list->RowCnt, 'id'=>'r' . $product_cart_b_list->RowCnt . '_product_cart_b', 'data-rowtype'=>$product_cart_b->RowType));

		// Render row
		$product_cart_b_list->renderRow();

		// Render list options
		$product_cart_b_list->renderListOptions();
?>
	<tr<?php echo $product_cart_b->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_cart_b_list->ListOptions->render("body", "left", $product_cart_b_list->RowCnt);
?>
	<?php if ($product_cart_b->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_cart_b->id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_id" class="product_cart_b_id">
<span<?php echo $product_cart_b->id->viewAttributes() ?>>
<?php echo $product_cart_b->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->po_id->Visible) { // po_id ?>
		<td data-name="po_id"<?php echo $product_cart_b->po_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_po_id" class="product_cart_b_po_id">
<span<?php echo $product_cart_b->po_id->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->po_id->getViewValue())) && $product_cart_b->po_id->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->po_id->linkAttributes() ?>><?php echo $product_cart_b->po_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->po_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $product_cart_b->company_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_company_id" class="product_cart_b_company_id">
<span<?php echo $product_cart_b->company_id->viewAttributes() ?>>
<?php echo $product_cart_b->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->partner_order_no->Visible) { // partner_order_no ?>
		<td data-name="partner_order_no"<?php echo $product_cart_b->partner_order_no->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_partner_order_no" class="product_cart_b_partner_order_no">
<span<?php echo $product_cart_b->partner_order_no->viewAttributes() ?>>
<?php echo $product_cart_b->partner_order_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $product_cart_b->partner_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_partner_id" class="product_cart_b_partner_id">
<span<?php echo $product_cart_b->partner_id->viewAttributes() ?>>
<?php echo $product_cart_b->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->partner_rid->Visible) { // partner_rid ?>
		<td data-name="partner_rid"<?php echo $product_cart_b->partner_rid->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_partner_rid" class="product_cart_b_partner_rid">
<span<?php echo $product_cart_b->partner_rid->viewAttributes() ?>>
<?php echo $product_cart_b->partner_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->partner_code->Visible) { // partner_code ?>
		<td data-name="partner_code"<?php echo $product_cart_b->partner_code->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_partner_code" class="product_cart_b_partner_code">
<span<?php echo $product_cart_b->partner_code->viewAttributes() ?>>
<?php echo $product_cart_b->partner_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product_cart_b->grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_grp" class="product_cart_b_grp">
<span<?php echo $product_cart_b->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->grp->getViewValue())) && $product_cart_b->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->grp->linkAttributes() ?>><?php echo $product_cart_b->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product_cart_b->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_s_grp" class="product_cart_b_s_grp">
<span<?php echo $product_cart_b->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->s_grp->getViewValue())) && $product_cart_b->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->s_grp->linkAttributes() ?>><?php echo $product_cart_b->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->product->Visible) { // product ?>
		<td data-name="product"<?php echo $product_cart_b->product->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_product" class="product_cart_b_product">
<span<?php echo $product_cart_b->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->product->getViewValue())) && $product_cart_b->product->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->product->linkAttributes() ?>><?php echo $product_cart_b->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $product_cart_b->rid->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_rid" class="product_cart_b_rid">
<span<?php echo $product_cart_b->rid->viewAttributes() ?>>
<?php echo $product_cart_b->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $product_cart_b->packing_type->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_packing_type" class="product_cart_b_packing_type">
<span<?php echo $product_cart_b->packing_type->viewAttributes() ?>>
<?php echo $product_cart_b->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $product_cart_b->product_type->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_product_type" class="product_cart_b_product_type">
<span<?php echo $product_cart_b->product_type->viewAttributes() ?>>
<?php echo $product_cart_b->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->size->Visible) { // size ?>
		<td data-name="size"<?php echo $product_cart_b->size->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_size" class="product_cart_b_size">
<span<?php echo $product_cart_b->size->viewAttributes() ?>>
<?php echo $product_cart_b->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $product_cart_b->quantity->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_quantity" class="product_cart_b_quantity">
<span<?php echo $product_cart_b->quantity->viewAttributes() ?>>
<?php echo $product_cart_b->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->price->Visible) { // price ?>
		<td data-name="price"<?php echo $product_cart_b->price->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_price" class="product_cart_b_price">
<span<?php echo $product_cart_b->price->viewAttributes() ?>>
<?php echo $product_cart_b->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $product_cart_b->amount->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_amount" class="product_cart_b_amount">
<span<?php echo $product_cart_b->amount->viewAttributes() ?>>
<?php echo $product_cart_b->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_cart_b->status->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_status" class="product_cart_b_status">
<span<?php echo $product_cart_b->status->viewAttributes() ?>>
<?php echo $product_cart_b->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->additional_discount->Visible) { // additional_discount ?>
		<td data-name="additional_discount"<?php echo $product_cart_b->additional_discount->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_additional_discount" class="product_cart_b_additional_discount">
<span<?php echo $product_cart_b->additional_discount->viewAttributes() ?>>
<?php echo $product_cart_b->additional_discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->buyer_loc->Visible) { // buyer_loc ?>
		<td data-name="buyer_loc"<?php echo $product_cart_b->buyer_loc->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_buyer_loc" class="product_cart_b_buyer_loc">
<span<?php echo $product_cart_b->buyer_loc->viewAttributes() ?>>
<?php echo $product_cart_b->buyer_loc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_cart_b->operator->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_operator" class="product_cart_b_operator">
<span<?php echo $product_cart_b->operator->viewAttributes() ?>>
<?php echo $product_cart_b->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_cart_b->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_datetime" class="product_cart_b_datetime">
<span<?php echo $product_cart_b->datetime->viewAttributes() ?>>
<?php echo $product_cart_b->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->level->Visible) { // level ?>
		<td data-name="level"<?php echo $product_cart_b->level->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_level" class="product_cart_b_level">
<span<?php echo $product_cart_b->level->viewAttributes() ?>>
<?php echo $product_cart_b->level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->dispatch_week->Visible) { // dispatch_week ?>
		<td data-name="dispatch_week"<?php echo $product_cart_b->dispatch_week->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_dispatch_week" class="product_cart_b_dispatch_week">
<span<?php echo $product_cart_b->dispatch_week->viewAttributes() ?>>
<?php echo $product_cart_b->dispatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->sale_id->Visible) { // sale_id ?>
		<td data-name="sale_id"<?php echo $product_cart_b->sale_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_sale_id" class="product_cart_b_sale_id">
<span<?php echo $product_cart_b->sale_id->viewAttributes() ?>>
<?php echo $product_cart_b->sale_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->sale_qty->Visible) { // sale_qty ?>
		<td data-name="sale_qty"<?php echo $product_cart_b->sale_qty->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_sale_qty" class="product_cart_b_sale_qty">
<span<?php echo $product_cart_b->sale_qty->viewAttributes() ?>>
<?php echo $product_cart_b->sale_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_b->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $product_cart_b->balance->cellAttributes() ?>>
<span id="el<?php echo $product_cart_b_list->RowCnt ?>_product_cart_b_balance" class="product_cart_b_balance">
<span<?php echo $product_cart_b->balance->viewAttributes() ?>>
<?php echo $product_cart_b->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_cart_b_list->ListOptions->render("body", "right", $product_cart_b_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_cart_b->isGridAdd())
		$product_cart_b_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_cart_b->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_cart_b_list->Recordset)
	$product_cart_b_list->Recordset->Close();
?>
<?php if (!$product_cart_b->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_cart_b->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_b_list->Pager)) $product_cart_b_list->Pager = new PrevNextPager($product_cart_b_list->StartRec, $product_cart_b_list->DisplayRecs, $product_cart_b_list->TotalRecs, $product_cart_b_list->AutoHidePager) ?>
<?php if ($product_cart_b_list->Pager->RecordCount > 0 && $product_cart_b_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_b_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_b_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_b_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_b_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_b_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_b_list->pageUrl() ?>start=<?php echo $product_cart_b_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_b_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_b_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_b_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_b_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_b_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_b_list->TotalRecs > 0 && (!$product_cart_b_list->AutoHidePageSizeSelector || $product_cart_b_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_b">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_b_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_b_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_b_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_b->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_b_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_cart_b_list->TotalRecs == 0 && !$product_cart_b->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_cart_b_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_cart_b_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_cart_b->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_cart_b->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_cart_b", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_cart_b_list->terminate();
?>