<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$product_cart_b_preview = new product_cart_b_preview();

// Run the page
$product_cart_b_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_b_preview->Page_Render();
?>
<?php $product_cart_b_preview->showPageHeader(); ?>
<div class="card ew-grid product_cart_b"><!-- .card -->
<?php if ($product_cart_b_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$product_cart_b_preview->renderListOptions();

// Render list options (header, left)
$product_cart_b_preview->ListOptions->render("header", "left");
?>
<?php if ($product_cart_b->id->Visible) { // id ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->id) == "") { ?>
		<th class="<?php echo $product_cart_b->id->headerCellClass() ?>"><?php echo $product_cart_b->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->id->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->id->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->id->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->po_id->Visible) { // po_id ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->po_id) == "") { ?>
		<th class="<?php echo $product_cart_b->po_id->headerCellClass() ?>"><?php echo $product_cart_b->po_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->po_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->po_id->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->po_id->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->po_id->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->company_id->Visible) { // company_id ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->company_id) == "") { ?>
		<th class="<?php echo $product_cart_b->company_id->headerCellClass() ?>"><?php echo $product_cart_b->company_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->company_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->company_id->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->company_id->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->company_id->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_order_no->Visible) { // partner_order_no ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->partner_order_no) == "") { ?>
		<th class="<?php echo $product_cart_b->partner_order_no->headerCellClass() ?>"><?php echo $product_cart_b->partner_order_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->partner_order_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->partner_order_no->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->partner_order_no->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_order_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->partner_order_no->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_id->Visible) { // partner_id ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->partner_id) == "") { ?>
		<th class="<?php echo $product_cart_b->partner_id->headerCellClass() ?>"><?php echo $product_cart_b->partner_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->partner_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->partner_id->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->partner_id->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->partner_id->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_rid->Visible) { // partner_rid ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->partner_rid) == "") { ?>
		<th class="<?php echo $product_cart_b->partner_rid->headerCellClass() ?>"><?php echo $product_cart_b->partner_rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->partner_rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->partner_rid->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->partner_rid->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->partner_rid->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->partner_code->Visible) { // partner_code ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->partner_code) == "") { ?>
		<th class="<?php echo $product_cart_b->partner_code->headerCellClass() ?>"><?php echo $product_cart_b->partner_code->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->partner_code->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->partner_code->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->partner_code->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->partner_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->partner_code->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->grp->Visible) { // grp ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->grp) == "") { ?>
		<th class="<?php echo $product_cart_b->grp->headerCellClass() ?>"><?php echo $product_cart_b->grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->grp->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->grp->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->grp->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->s_grp->Visible) { // s_grp ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->s_grp) == "") { ?>
		<th class="<?php echo $product_cart_b->s_grp->headerCellClass() ?>"><?php echo $product_cart_b->s_grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->s_grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->s_grp->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->s_grp->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->s_grp->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->product->Visible) { // product ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->product) == "") { ?>
		<th class="<?php echo $product_cart_b->product->headerCellClass() ?>"><?php echo $product_cart_b->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->product->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->product->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->product->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->rid->Visible) { // rid ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->rid) == "") { ?>
		<th class="<?php echo $product_cart_b->rid->headerCellClass() ?>"><?php echo $product_cart_b->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->rid->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->rid->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->rid->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->packing_type->Visible) { // packing_type ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->packing_type) == "") { ?>
		<th class="<?php echo $product_cart_b->packing_type->headerCellClass() ?>"><?php echo $product_cart_b->packing_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->packing_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->packing_type->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->packing_type->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->packing_type->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->product_type->Visible) { // product_type ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->product_type) == "") { ?>
		<th class="<?php echo $product_cart_b->product_type->headerCellClass() ?>"><?php echo $product_cart_b->product_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->product_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->product_type->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->product_type->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->product_type->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->size->Visible) { // size ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->size) == "") { ?>
		<th class="<?php echo $product_cart_b->size->headerCellClass() ?>"><?php echo $product_cart_b->size->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->size->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->size->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->size->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->size->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->size->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->quantity->Visible) { // quantity ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->quantity) == "") { ?>
		<th class="<?php echo $product_cart_b->quantity->headerCellClass() ?>"><?php echo $product_cart_b->quantity->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->quantity->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->quantity->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->quantity->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->quantity->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->price->Visible) { // price ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->price) == "") { ?>
		<th class="<?php echo $product_cart_b->price->headerCellClass() ?>"><?php echo $product_cart_b->price->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->price->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->price->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->price->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->price->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->amount->Visible) { // amount ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->amount) == "") { ?>
		<th class="<?php echo $product_cart_b->amount->headerCellClass() ?>"><?php echo $product_cart_b->amount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->amount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->amount->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->amount->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->amount->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->status->Visible) { // status ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->status) == "") { ?>
		<th class="<?php echo $product_cart_b->status->headerCellClass() ?>"><?php echo $product_cart_b->status->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->status->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->status->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->status->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->status->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->additional_discount->Visible) { // additional_discount ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->additional_discount) == "") { ?>
		<th class="<?php echo $product_cart_b->additional_discount->headerCellClass() ?>"><?php echo $product_cart_b->additional_discount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->additional_discount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->additional_discount->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->additional_discount->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->additional_discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->additional_discount->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->buyer_loc->Visible) { // buyer_loc ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->buyer_loc) == "") { ?>
		<th class="<?php echo $product_cart_b->buyer_loc->headerCellClass() ?>"><?php echo $product_cart_b->buyer_loc->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->buyer_loc->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->buyer_loc->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->buyer_loc->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->buyer_loc->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->buyer_loc->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->operator->Visible) { // operator ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->operator) == "") { ?>
		<th class="<?php echo $product_cart_b->operator->headerCellClass() ?>"><?php echo $product_cart_b->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->operator->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->operator->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->operator->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->datetime->Visible) { // datetime ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->datetime) == "") { ?>
		<th class="<?php echo $product_cart_b->datetime->headerCellClass() ?>"><?php echo $product_cart_b->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->datetime->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->datetime->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->datetime->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->level->Visible) { // level ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->level) == "") { ?>
		<th class="<?php echo $product_cart_b->level->headerCellClass() ?>"><?php echo $product_cart_b->level->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->level->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->level->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->level->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->level->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->dispatch_week->Visible) { // dispatch_week ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->dispatch_week) == "") { ?>
		<th class="<?php echo $product_cart_b->dispatch_week->headerCellClass() ?>"><?php echo $product_cart_b->dispatch_week->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->dispatch_week->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->dispatch_week->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->dispatch_week->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->dispatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->dispatch_week->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->sale_id->Visible) { // sale_id ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->sale_id) == "") { ?>
		<th class="<?php echo $product_cart_b->sale_id->headerCellClass() ?>"><?php echo $product_cart_b->sale_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->sale_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->sale_id->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->sale_id->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->sale_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->sale_id->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->sale_qty->Visible) { // sale_qty ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->sale_qty) == "") { ?>
		<th class="<?php echo $product_cart_b->sale_qty->headerCellClass() ?>"><?php echo $product_cart_b->sale_qty->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->sale_qty->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->sale_qty->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->sale_qty->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->sale_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->sale_qty->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_b->balance->Visible) { // balance ?>
	<?php if ($product_cart_b->SortUrl($product_cart_b->balance) == "") { ?>
		<th class="<?php echo $product_cart_b->balance->headerCellClass() ?>"><?php echo $product_cart_b->balance->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_b->balance->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_b->balance->Name) ?>" data-sort-order="<?php echo $product_cart_b_preview->SortField == $product_cart_b->balance->Name && $product_cart_b_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_b->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_b_preview->SortField == $product_cart_b->balance->Name) { ?><?php if ($product_cart_b_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_b_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_cart_b_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$product_cart_b_preview->RecCount = 0;
$product_cart_b_preview->RowCnt = 0;
while ($product_cart_b_preview->Recordset && !$product_cart_b_preview->Recordset->EOF) {

	// Init row class and style
	$product_cart_b_preview->RecCount++;
	$product_cart_b_preview->RowCnt++;
	$product_cart_b_preview->CssStyle = "";
	$product_cart_b_preview->loadListRowValues($product_cart_b_preview->Recordset);

	// Render row
	$product_cart_b_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$product_cart_b_preview->resetAttributes();
	$product_cart_b_preview->renderListRow();

	// Render list options
	$product_cart_b_preview->renderListOptions();
?>
	<tr<?php echo $product_cart_b_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_cart_b_preview->ListOptions->render("body", "left", $product_cart_b_preview->RowCnt);
?>
<?php if ($product_cart_b->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $product_cart_b->id->cellAttributes() ?>>
<span<?php echo $product_cart_b->id->viewAttributes() ?>>
<?php echo $product_cart_b->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->po_id->Visible) { // po_id ?>
		<!-- po_id -->
		<td<?php echo $product_cart_b->po_id->cellAttributes() ?>>
<span<?php echo $product_cart_b->po_id->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->po_id->getViewValue())) && $product_cart_b->po_id->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->po_id->linkAttributes() ?>><?php echo $product_cart_b->po_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->po_id->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_b->company_id->Visible) { // company_id ?>
		<!-- company_id -->
		<td<?php echo $product_cart_b->company_id->cellAttributes() ?>>
<span<?php echo $product_cart_b->company_id->viewAttributes() ?>>
<?php echo $product_cart_b->company_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->partner_order_no->Visible) { // partner_order_no ?>
		<!-- partner_order_no -->
		<td<?php echo $product_cart_b->partner_order_no->cellAttributes() ?>>
<span<?php echo $product_cart_b->partner_order_no->viewAttributes() ?>>
<?php echo $product_cart_b->partner_order_no->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->partner_id->Visible) { // partner_id ?>
		<!-- partner_id -->
		<td<?php echo $product_cart_b->partner_id->cellAttributes() ?>>
<span<?php echo $product_cart_b->partner_id->viewAttributes() ?>>
<?php echo $product_cart_b->partner_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->partner_rid->Visible) { // partner_rid ?>
		<!-- partner_rid -->
		<td<?php echo $product_cart_b->partner_rid->cellAttributes() ?>>
<span<?php echo $product_cart_b->partner_rid->viewAttributes() ?>>
<?php echo $product_cart_b->partner_rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->partner_code->Visible) { // partner_code ?>
		<!-- partner_code -->
		<td<?php echo $product_cart_b->partner_code->cellAttributes() ?>>
<span<?php echo $product_cart_b->partner_code->viewAttributes() ?>>
<?php echo $product_cart_b->partner_code->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->grp->Visible) { // grp ?>
		<!-- grp -->
		<td<?php echo $product_cart_b->grp->cellAttributes() ?>>
<span<?php echo $product_cart_b->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->grp->getViewValue())) && $product_cart_b->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->grp->linkAttributes() ?>><?php echo $product_cart_b->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_b->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td<?php echo $product_cart_b->s_grp->cellAttributes() ?>>
<span<?php echo $product_cart_b->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->s_grp->getViewValue())) && $product_cart_b->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->s_grp->linkAttributes() ?>><?php echo $product_cart_b->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->s_grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_b->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $product_cart_b->product->cellAttributes() ?>>
<span<?php echo $product_cart_b->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->product->getViewValue())) && $product_cart_b->product->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->product->linkAttributes() ?>><?php echo $product_cart_b->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_b->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $product_cart_b->rid->cellAttributes() ?>>
<span<?php echo $product_cart_b->rid->viewAttributes() ?>>
<?php echo $product_cart_b->rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td<?php echo $product_cart_b->packing_type->cellAttributes() ?>>
<span<?php echo $product_cart_b->packing_type->viewAttributes() ?>>
<?php echo $product_cart_b->packing_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->product_type->Visible) { // product_type ?>
		<!-- product_type -->
		<td<?php echo $product_cart_b->product_type->cellAttributes() ?>>
<span<?php echo $product_cart_b->product_type->viewAttributes() ?>>
<?php echo $product_cart_b->product_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->size->Visible) { // size ?>
		<!-- size -->
		<td<?php echo $product_cart_b->size->cellAttributes() ?>>
<span<?php echo $product_cart_b->size->viewAttributes() ?>>
<?php echo $product_cart_b->size->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td<?php echo $product_cart_b->quantity->cellAttributes() ?>>
<span<?php echo $product_cart_b->quantity->viewAttributes() ?>>
<?php echo $product_cart_b->quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->price->Visible) { // price ?>
		<!-- price -->
		<td<?php echo $product_cart_b->price->cellAttributes() ?>>
<span<?php echo $product_cart_b->price->viewAttributes() ?>>
<?php echo $product_cart_b->price->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->amount->Visible) { // amount ?>
		<!-- amount -->
		<td<?php echo $product_cart_b->amount->cellAttributes() ?>>
<span<?php echo $product_cart_b->amount->viewAttributes() ?>>
<?php echo $product_cart_b->amount->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->status->Visible) { // status ?>
		<!-- status -->
		<td<?php echo $product_cart_b->status->cellAttributes() ?>>
<span<?php echo $product_cart_b->status->viewAttributes() ?>>
<?php echo $product_cart_b->status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->additional_discount->Visible) { // additional_discount ?>
		<!-- additional_discount -->
		<td<?php echo $product_cart_b->additional_discount->cellAttributes() ?>>
<span<?php echo $product_cart_b->additional_discount->viewAttributes() ?>>
<?php echo $product_cart_b->additional_discount->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->buyer_loc->Visible) { // buyer_loc ?>
		<!-- buyer_loc -->
		<td<?php echo $product_cart_b->buyer_loc->cellAttributes() ?>>
<span<?php echo $product_cart_b->buyer_loc->viewAttributes() ?>>
<?php echo $product_cart_b->buyer_loc->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $product_cart_b->operator->cellAttributes() ?>>
<span<?php echo $product_cart_b->operator->viewAttributes() ?>>
<?php echo $product_cart_b->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $product_cart_b->datetime->cellAttributes() ?>>
<span<?php echo $product_cart_b->datetime->viewAttributes() ?>>
<?php echo $product_cart_b->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->level->Visible) { // level ?>
		<!-- level -->
		<td<?php echo $product_cart_b->level->cellAttributes() ?>>
<span<?php echo $product_cart_b->level->viewAttributes() ?>>
<?php echo $product_cart_b->level->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->dispatch_week->Visible) { // dispatch_week ?>
		<!-- dispatch_week -->
		<td<?php echo $product_cart_b->dispatch_week->cellAttributes() ?>>
<span<?php echo $product_cart_b->dispatch_week->viewAttributes() ?>>
<?php echo $product_cart_b->dispatch_week->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->sale_id->Visible) { // sale_id ?>
		<!-- sale_id -->
		<td<?php echo $product_cart_b->sale_id->cellAttributes() ?>>
<span<?php echo $product_cart_b->sale_id->viewAttributes() ?>>
<?php echo $product_cart_b->sale_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->sale_qty->Visible) { // sale_qty ?>
		<!-- sale_qty -->
		<td<?php echo $product_cart_b->sale_qty->cellAttributes() ?>>
<span<?php echo $product_cart_b->sale_qty->viewAttributes() ?>>
<?php echo $product_cart_b->sale_qty->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_b->balance->Visible) { // balance ?>
		<!-- balance -->
		<td<?php echo $product_cart_b->balance->cellAttributes() ?>>
<span<?php echo $product_cart_b->balance->viewAttributes() ?>>
<?php echo $product_cart_b->balance->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$product_cart_b_preview->ListOptions->render("body", "right", $product_cart_b_preview->RowCnt);
?>
	</tr>
<?php
	$product_cart_b_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($product_cart_b_preview->TotalRecs > 0) { ?>
<?php if (!isset($product_cart_b_preview->Pager)) $product_cart_b_preview->Pager = new PrevNextPager($product_cart_b_preview->StartRec, $product_cart_b_preview->DisplayRecs, $product_cart_b_preview->TotalRecs) ?>
<?php if ($product_cart_b_preview->Pager->RecordCount > 0 && $product_cart_b_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($product_cart_b_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $product_cart_b_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($product_cart_b_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $product_cart_b_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($product_cart_b_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $product_cart_b_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($product_cart_b_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $product_cart_b_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $product_cart_b_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $product_cart_b_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $product_cart_b_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($product_cart_b_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$product_cart_b_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($product_cart_b_preview->Recordset)
	$product_cart_b_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$product_cart_b_preview->terminate();
?>