<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_b_search = new product_cart_b_search();

// Run the page
$product_cart_b_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_b_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_cart_b_search->IsModal) { ?>
var fproduct_cart_bsearch = currentAdvancedSearchForm = new ew.Form("fproduct_cart_bsearch", "search");
<?php } else { ?>
var fproduct_cart_bsearch = currentForm = new ew.Form("fproduct_cart_bsearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduct_cart_bsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_bsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_bsearch.lists["x_po_id"] = <?php echo $product_cart_b_search->po_id->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_b_search->po_id->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_location"] = <?php echo $product_cart_b_search->location->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_location"].options = <?php echo JsonEncode($product_cart_b_search->location->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_company_id"] = <?php echo $product_cart_b_search->company_id->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_b_search->company_id->lookupOptions()) ?>;
fproduct_cart_bsearch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bsearch.lists["x_partner_id"] = <?php echo $product_cart_b_search->partner_id->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_b_search->partner_id->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_partner_rid"] = <?php echo $product_cart_b_search->partner_rid->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_partner_rid"].options = <?php echo JsonEncode($product_cart_b_search->partner_rid->lookupOptions()) ?>;
fproduct_cart_bsearch.autoSuggests["x_partner_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bsearch.lists["x_grp"] = <?php echo $product_cart_b_search->grp->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_grp"].options = <?php echo JsonEncode($product_cart_b_search->grp->lookupOptions()) ?>;
fproduct_cart_bsearch.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bsearch.lists["x_s_grp"] = <?php echo $product_cart_b_search->s_grp->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_b_search->s_grp->lookupOptions()) ?>;
fproduct_cart_bsearch.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bsearch.lists["x_product"] = <?php echo $product_cart_b_search->product->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_product"].options = <?php echo JsonEncode($product_cart_b_search->product->lookupOptions()) ?>;
fproduct_cart_bsearch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bsearch.lists["x_rid"] = <?php echo $product_cart_b_search->rid->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_rid"].options = <?php echo JsonEncode($product_cart_b_search->rid->lookupOptions()) ?>;
fproduct_cart_bsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bsearch.lists["x_packing_type"] = <?php echo $product_cart_b_search->packing_type->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_packing_type"].options = <?php echo JsonEncode($product_cart_b_search->packing_type->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_batch_no"] = <?php echo $product_cart_b_search->batch_no->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_batch_no"].options = <?php echo JsonEncode($product_cart_b_search->batch_no->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_shape"] = <?php echo $product_cart_b_search->shape->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_shape"].options = <?php echo JsonEncode($product_cart_b_search->shape->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_product_type"] = <?php echo $product_cart_b_search->product_type->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_b_search->product_type->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_unit"] = <?php echo $product_cart_b_search->unit->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_unit"].options = <?php echo JsonEncode($product_cart_b_search->unit->options(FALSE, TRUE)) ?>;
fproduct_cart_bsearch.lists["x_currency"] = <?php echo $product_cart_b_search->currency->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_currency"].options = <?php echo JsonEncode($product_cart_b_search->currency->lookupOptions()) ?>;
fproduct_cart_bsearch.lists["x_operator"] = <?php echo $product_cart_b_search->operator->Lookup->toClientList() ?>;
fproduct_cart_bsearch.lists["x_operator"].options = <?php echo JsonEncode($product_cart_b_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproduct_cart_bsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_w_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->w_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_l_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->l_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_h_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->h_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->cbm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_additional_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->additional_discount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->jc_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_level");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->level->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dispatch_week");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->dispatch_week->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sale_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->sale_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_b->balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_cart_b_search->showPageHeader(); ?>
<?php
$product_cart_b_search->showMessage();
?>
<form name="fproduct_cart_bsearch" id="fproduct_cart_bsearch" class="<?php echo $product_cart_b_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_b_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_b_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_b">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_cart_b_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($product_cart_b->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_id"><?php echo $product_cart_b->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->id->cellAttributes() ?>>
			<span id="el_product_cart_b_id">
<input type="text" data-table="product_cart_b" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($product_cart_b->id->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->id->EditValue ?>"<?php echo $product_cart_b->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group row">
		<label for="x_po_id" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_po_id"><?php echo $product_cart_b->po_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_id" id="z_po_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->po_id->cellAttributes() ?>>
			<span id="el_product_cart_b_po_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_po_id" data-value-separator="<?php echo $product_cart_b->po_id->displayValueSeparatorAttribute() ?>" id="x_po_id" name="x_po_id"<?php echo $product_cart_b->po_id->editAttributes() ?>>
		<?php echo $product_cart_b->po_id->selectOptionListHtml("x_po_id") ?>
	</select>
</div>
<?php echo $product_cart_b->po_id->Lookup->getParamTag("p_x_po_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_location"><?php echo $product_cart_b->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->location->cellAttributes() ?>>
			<span id="el_product_cart_b_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_location" data-value-separator="<?php echo $product_cart_b->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $product_cart_b->location->editAttributes() ?>>
		<?php echo $product_cart_b->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $product_cart_b->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_company_id"><?php echo $product_cart_b->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->company_id->cellAttributes() ?>>
			<span id="el_product_cart_b_company_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($product_cart_b->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b->company_id->getPlaceHolder()) ?>"<?php echo $product_cart_b->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->company_id->ReadOnly || $product_cart_b->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($product_cart_b->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_bsearch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $product_cart_b->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->partner_order_no->Visible) { // partner_order_no ?>
	<div id="r_partner_order_no" class="form-group row">
		<label for="x_partner_order_no" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_order_no"><?php echo $product_cart_b->partner_order_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->partner_order_no->cellAttributes() ?>>
			<span id="el_product_cart_b_partner_order_no">
<input type="text" data-table="product_cart_b" data-field="x_partner_order_no" name="x_partner_order_no" id="x_partner_order_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_b->partner_order_no->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->partner_order_no->EditValue ?>"<?php echo $product_cart_b->partner_order_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label for="x_partner_id" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_id"><?php echo $product_cart_b->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->partner_id->cellAttributes() ?>>
			<span id="el_product_cart_b_partner_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_partner_id" data-value-separator="<?php echo $product_cart_b->partner_id->displayValueSeparatorAttribute() ?>" id="x_partner_id" name="x_partner_id"<?php echo $product_cart_b->partner_id->editAttributes() ?>>
		<?php echo $product_cart_b->partner_id->selectOptionListHtml("x_partner_id") ?>
	</select>
</div>
<?php echo $product_cart_b->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->partner_rid->Visible) { // partner_rid ?>
	<div id="r_partner_rid" class="form-group row">
		<label class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_rid"><?php echo $product_cart_b->partner_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_rid" id="z_partner_rid" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->partner_rid->cellAttributes() ?>>
			<span id="el_product_cart_b_partner_rid">
<?php
$wrkonchange = "" . trim(@$product_cart_b->partner_rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b->partner_rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_rid" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_rid" id="sv_x_partner_rid" value="<?php echo RemoveHtml($product_cart_b->partner_rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->partner_rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b->partner_rid->getPlaceHolder()) ?>"<?php echo $product_cart_b->partner_rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->partner_rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_rid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->partner_rid->ReadOnly || $product_cart_b->partner_rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b" data-field="x_partner_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->partner_rid->displayValueSeparatorAttribute() ?>" name="x_partner_rid" id="x_partner_rid" value="<?php echo HtmlEncode($product_cart_b->partner_rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_bsearch.createAutoSuggest({"id":"x_partner_rid","forceSelect":false});
</script>
<?php echo $product_cart_b->partner_rid->Lookup->getParamTag("p_x_partner_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->partner_code->Visible) { // partner_code ?>
	<div id="r_partner_code" class="form-group row">
		<label for="x_partner_code" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_code"><?php echo $product_cart_b->partner_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->partner_code->cellAttributes() ?>>
			<span id="el_product_cart_b_partner_code">
<input type="text" data-table="product_cart_b" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_b->partner_code->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->partner_code->EditValue ?>"<?php echo $product_cart_b->partner_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_grp"><?php echo $product_cart_b->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->grp->cellAttributes() ?>>
			<span id="el_product_cart_b_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b->grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b->grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_grp" class="text-nowrap" style="z-index: 8910">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_grp" id="sv_x_grp" value="<?php echo RemoveHtml($product_cart_b->grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b->grp->getPlaceHolder()) ?>"<?php echo $product_cart_b->grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->grp->ReadOnly || $product_cart_b->grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b" data-field="x_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->grp->displayValueSeparatorAttribute() ?>" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($product_cart_b->grp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_bsearch.createAutoSuggest({"id":"x_grp","forceSelect":true});
</script>
<?php echo $product_cart_b->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_s_grp"><?php echo $product_cart_b->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->s_grp->cellAttributes() ?>>
			<span id="el_product_cart_b_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_s_grp" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_s_grp" id="sv_x_s_grp" value="<?php echo RemoveHtml($product_cart_b->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b->s_grp->getPlaceHolder()) ?>"<?php echo $product_cart_b->s_grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->s_grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_s_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->s_grp->ReadOnly || $product_cart_b->s_grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b" data-field="x_s_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($product_cart_b->s_grp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_bsearch.createAutoSuggest({"id":"x_s_grp","forceSelect":true});
</script>
<?php echo $product_cart_b->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_product"><?php echo $product_cart_b->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->product->cellAttributes() ?>>
			<span id="el_product_cart_b_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8890">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($product_cart_b->product->EditValue) ?>" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($product_cart_b->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b->product->getPlaceHolder()) ?>"<?php echo $product_cart_b->product->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->product->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_product',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->product->ReadOnly || $product_cart_b->product->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b" data-field="x_product" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($product_cart_b->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_bsearch.createAutoSuggest({"id":"x_product","forceSelect":true});
</script>
<?php echo $product_cart_b->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_rid"><?php echo $product_cart_b->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->rid->cellAttributes() ?>>
			<span id="el_product_cart_b_rid">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_b->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_b->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8880">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($product_cart_b->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_b->rid->getPlaceHolder()) ?>"<?php echo $product_cart_b->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->rid->ReadOnly || $product_cart_b->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_b" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($product_cart_b->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_bsearch.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $product_cart_b->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_packing_type"><?php echo $product_cart_b->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->packing_type->cellAttributes() ?>>
			<span id="el_product_cart_b_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_packing_type" data-value-separator="<?php echo $product_cart_b->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $product_cart_b->packing_type->editAttributes() ?>>
		<?php echo $product_cart_b->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $product_cart_b->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_batch_no"><?php echo $product_cart_b->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->batch_no->cellAttributes() ?>>
			<span id="el_product_cart_b_batch_no">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_batch_no"><?php echo strval($product_cart_b->batch_no->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_b->batch_no->AdvancedSearch->ViewValue) : $product_cart_b->batch_no->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_b->batch_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_b->batch_no->ReadOnly || $product_cart_b->batch_no->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_batch_no',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_b->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<input type="hidden" data-table="product_cart_b" data-field="x_batch_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_b->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?php echo $product_cart_b->batch_no->AdvancedSearch->SearchValue ?>"<?php echo $product_cart_b->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_shape"><?php echo $product_cart_b->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->shape->cellAttributes() ?>>
			<span id="el_product_cart_b_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_shape" data-value-separator="<?php echo $product_cart_b->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $product_cart_b->shape->editAttributes() ?>>
		<?php echo $product_cart_b->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $product_cart_b->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_product_type"><?php echo $product_cart_b->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->product_type->cellAttributes() ?>>
			<span id="el_product_cart_b_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_product_type" data-value-separator="<?php echo $product_cart_b->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $product_cart_b->product_type->editAttributes() ?>>
		<?php echo $product_cart_b->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $product_cart_b->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_unit"><?php echo $product_cart_b->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->unit->cellAttributes() ?>>
			<span id="el_product_cart_b_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_unit" data-value-separator="<?php echo $product_cart_b->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $product_cart_b->unit->editAttributes() ?>>
		<?php echo $product_cart_b->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->w->Visible) { // w ?>
	<div id="r_w" class="form-group row">
		<label for="x_w" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_w"><?php echo $product_cart_b->w->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_w" id="z_w" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->w->cellAttributes() ?>>
			<span id="el_product_cart_b_w">
<input type="text" data-table="product_cart_b" data-field="x_w" name="x_w" id="x_w" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_b->w->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->w->EditValue ?>"<?php echo $product_cart_b->w->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label for="x_w_cm" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_w_cm"><?php echo $product_cart_b->w_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_w_cm" id="z_w_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->w_cm->cellAttributes() ?>>
			<span id="el_product_cart_b_w_cm">
<input type="text" data-table="product_cart_b" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->w_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->w_cm->EditValue ?>"<?php echo $product_cart_b->w_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->l->Visible) { // l ?>
	<div id="r_l" class="form-group row">
		<label for="x_l" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_l"><?php echo $product_cart_b->l->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_l" id="z_l" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->l->cellAttributes() ?>>
			<span id="el_product_cart_b_l">
<input type="text" data-table="product_cart_b" data-field="x_l" name="x_l" id="x_l" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_b->l->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->l->EditValue ?>"<?php echo $product_cart_b->l->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label for="x_l_cm" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_l_cm"><?php echo $product_cart_b->l_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_l_cm" id="z_l_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->l_cm->cellAttributes() ?>>
			<span id="el_product_cart_b_l_cm">
<input type="text" data-table="product_cart_b" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->l_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->l_cm->EditValue ?>"<?php echo $product_cart_b->l_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->h->Visible) { // h ?>
	<div id="r_h" class="form-group row">
		<label for="x_h" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_h"><?php echo $product_cart_b->h->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_h" id="z_h" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->h->cellAttributes() ?>>
			<span id="el_product_cart_b_h">
<input type="text" data-table="product_cart_b" data-field="x_h" name="x_h" id="x_h" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_b->h->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->h->EditValue ?>"<?php echo $product_cart_b->h->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->h_cm->Visible) { // h_cm ?>
	<div id="r_h_cm" class="form-group row">
		<label for="x_h_cm" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_h_cm"><?php echo $product_cart_b->h_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_h_cm" id="z_h_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->h_cm->cellAttributes() ?>>
			<span id="el_product_cart_b_h_cm">
<input type="text" data-table="product_cart_b" data-field="x_h_cm" name="x_h_cm" id="x_h_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->h_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->h_cm->EditValue ?>"<?php echo $product_cart_b->h_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->partner_size->Visible) { // partner_size ?>
	<div id="r_partner_size" class="form-group row">
		<label for="x_partner_size" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_partner_size"><?php echo $product_cart_b->partner_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_size" id="z_partner_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->partner_size->cellAttributes() ?>>
			<span id="el_product_cart_b_partner_size">
<input type="text" data-table="product_cart_b" data-field="x_partner_size" name="x_partner_size" id="x_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_b->partner_size->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->partner_size->EditValue ?>"<?php echo $product_cart_b->partner_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_size"><?php echo $product_cart_b->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->size->cellAttributes() ?>>
			<span id="el_product_cart_b_size">
<input type="text" data-table="product_cart_b" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_cart_b->size->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->size->EditValue ?>"<?php echo $product_cart_b->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sqm"><?php echo $product_cart_b->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->sqm->cellAttributes() ?>>
			<span id="el_product_cart_b_sqm">
<input type="text" data-table="product_cart_b" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->sqm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->sqm->EditValue ?>"<?php echo $product_cart_b->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_quantity"><?php echo $product_cart_b->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->quantity->cellAttributes() ?>>
			<span id="el_product_cart_b_quantity">
<input type="text" data-table="product_cart_b" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->quantity->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->quantity->EditValue ?>"<?php echo $product_cart_b->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_price"><?php echo $product_cart_b->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->price->cellAttributes() ?>>
			<span id="el_product_cart_b_price">
<input type="text" data-table="product_cart_b" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->price->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->price->EditValue ?>"<?php echo $product_cart_b->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_currency"><?php echo $product_cart_b->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->currency->cellAttributes() ?>>
			<span id="el_product_cart_b_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_currency" data-value-separator="<?php echo $product_cart_b->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $product_cart_b->currency->editAttributes() ?>>
		<?php echo $product_cart_b->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $product_cart_b->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_cbm"><?php echo $product_cart_b->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->cbm->cellAttributes() ?>>
			<span id="el_product_cart_b_cbm">
<input type="text" data-table="product_cart_b" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->cbm->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->cbm->EditValue ?>"<?php echo $product_cart_b->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_buyer_uid"><?php echo $product_cart_b->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->buyer_uid->cellAttributes() ?>>
			<span id="el_product_cart_b_buyer_uid">
<input type="text" data-table="product_cart_b" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="35" placeholder="<?php echo HtmlEncode($product_cart_b->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->buyer_uid->EditValue ?>"<?php echo $product_cart_b->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->buyer_loc->Visible) { // buyer_loc ?>
	<div id="r_buyer_loc" class="form-group row">
		<label for="x_buyer_loc" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_buyer_loc"><?php echo $product_cart_b->buyer_loc->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->buyer_loc->cellAttributes() ?>>
			<span id="el_product_cart_b_buyer_loc">
<input type="text" data-table="product_cart_b" data-field="x_buyer_loc" name="x_buyer_loc" id="x_buyer_loc" size="35" maxlength="250" placeholder="<?php echo HtmlEncode($product_cart_b->buyer_loc->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->buyer_loc->EditValue ?>"<?php echo $product_cart_b->buyer_loc->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->label->Visible) { // label ?>
	<div id="r_label" class="form-group row">
		<label for="x_label" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_label"><?php echo $product_cart_b->label->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_label" id="z_label" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->label->cellAttributes() ?>>
			<span id="el_product_cart_b_label">
<input type="text" data-table="product_cart_b" data-field="x_label" name="x_label" id="x_label" maxlength="96" placeholder="<?php echo HtmlEncode($product_cart_b->label->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->label->EditValue ?>"<?php echo $product_cart_b->label->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_remarks"><?php echo $product_cart_b->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->remarks->cellAttributes() ?>>
			<span id="el_product_cart_b_remarks">
<input type="text" data-table="product_cart_b" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="255" placeholder="<?php echo HtmlEncode($product_cart_b->remarks->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->remarks->EditValue ?>"<?php echo $product_cart_b->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_operator"><?php echo $product_cart_b->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->operator->cellAttributes() ?>>
			<span id="el_product_cart_b_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_b" data-field="x_operator" data-value-separator="<?php echo $product_cart_b->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $product_cart_b->operator->editAttributes() ?>>
		<?php echo $product_cart_b->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $product_cart_b->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_datetime"><?php echo $product_cart_b->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->datetime->cellAttributes() ?>>
			<span id="el_product_cart_b_datetime">
<input type="text" data-table="product_cart_b" data-field="x_datetime" data-format="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($product_cart_b->datetime->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->datetime->EditValue ?>"<?php echo $product_cart_b->datetime->editAttributes() ?>>
<?php if (!$product_cart_b->datetime->ReadOnly && !$product_cart_b->datetime->Disabled && !isset($product_cart_b->datetime->EditAttrs["readonly"]) && !isset($product_cart_b->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduct_cart_bsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->jc_qty->Visible) { // jc_qty ?>
	<div id="r_jc_qty" class="form-group row">
		<label for="x_jc_qty" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_jc_qty"><?php echo $product_cart_b->jc_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_qty" id="z_jc_qty" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->jc_qty->cellAttributes() ?>>
			<span id="el_product_cart_b_jc_qty">
<input type="text" data-table="product_cart_b" data-field="x_jc_qty" name="x_jc_qty" id="x_jc_qty" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->jc_qty->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->jc_qty->EditValue ?>"<?php echo $product_cart_b->jc_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->d_remarks->Visible) { // d_remarks ?>
	<div id="r_d_remarks" class="form-group row">
		<label for="x_d_remarks" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_d_remarks"><?php echo $product_cart_b->d_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_remarks" id="z_d_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->d_remarks->cellAttributes() ?>>
			<span id="el_product_cart_b_d_remarks">
<input type="text" data-table="product_cart_b" data-field="x_d_remarks" name="x_d_remarks" id="x_d_remarks" size="35" placeholder="<?php echo HtmlEncode($product_cart_b->d_remarks->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->d_remarks->EditValue ?>"<?php echo $product_cart_b->d_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->level->Visible) { // level ?>
	<div id="r_level" class="form-group row">
		<label for="x_level" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_level"><?php echo $product_cart_b->level->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_level" id="z_level" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->level->cellAttributes() ?>>
			<span id="el_product_cart_b_level">
<input type="text" data-table="product_cart_b" data-field="x_level" name="x_level" id="x_level" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->level->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->level->EditValue ?>"<?php echo $product_cart_b->level->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->dispatch_week->Visible) { // dispatch_week ?>
	<div id="r_dispatch_week" class="form-group row">
		<label for="x_dispatch_week" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_dispatch_week"><?php echo $product_cart_b->dispatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dispatch_week" id="z_dispatch_week" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->dispatch_week->cellAttributes() ?>>
			<span id="el_product_cart_b_dispatch_week">
<input type="text" data-table="product_cart_b" data-field="x_dispatch_week" name="x_dispatch_week" id="x_dispatch_week" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->dispatch_week->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->dispatch_week->EditValue ?>"<?php echo $product_cart_b->dispatch_week->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->sale_id->Visible) { // sale_id ?>
	<div id="r_sale_id" class="form-group row">
		<label for="x_sale_id" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sale_id"><?php echo $product_cart_b->sale_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sale_id" id="z_sale_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->sale_id->cellAttributes() ?>>
			<span id="el_product_cart_b_sale_id">
<input type="text" data-table="product_cart_b" data-field="x_sale_id" name="x_sale_id" id="x_sale_id" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($product_cart_b->sale_id->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->sale_id->EditValue ?>"<?php echo $product_cart_b->sale_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->sale_qty->Visible) { // sale_qty ?>
	<div id="r_sale_qty" class="form-group row">
		<label for="x_sale_qty" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_sale_qty"><?php echo $product_cart_b->sale_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sale_qty" id="z_sale_qty" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->sale_qty->cellAttributes() ?>>
			<span id="el_product_cart_b_sale_qty">
<input type="text" data-table="product_cart_b" data-field="x_sale_qty" name="x_sale_qty" id="x_sale_qty" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->sale_qty->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->sale_qty->EditValue ?>"<?php echo $product_cart_b->sale_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_b->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $product_cart_b_search->LeftColumnClass ?>"><span id="elh_product_cart_b_balance"><?php echo $product_cart_b->balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance" id="z_balance" value="="></span>
		</label>
		<div class="<?php echo $product_cart_b_search->RightColumnClass ?>"><div<?php echo $product_cart_b->balance->cellAttributes() ?>>
			<span id="el_product_cart_b_balance">
<input type="text" data-table="product_cart_b" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($product_cart_b->balance->getPlaceHolder()) ?>" value="<?php echo $product_cart_b->balance->EditValue ?>"<?php echo $product_cart_b->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_cart_b_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_cart_b_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_cart_b_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_cart_b_search->terminate();
?>