<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_b_view = new product_cart_b_view();

// Run the page
$product_cart_b_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_b_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_cart_b->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fproduct_cart_bview = currentForm = new ew.Form("fproduct_cart_bview", "view");

// Form_CustomValidate event
fproduct_cart_bview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_bview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_bview.lists["x_po_id"] = <?php echo $product_cart_b_view->po_id->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_b_view->po_id->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_location"] = <?php echo $product_cart_b_view->location->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_location"].options = <?php echo JsonEncode($product_cart_b_view->location->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_company_id"] = <?php echo $product_cart_b_view->company_id->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_b_view->company_id->lookupOptions()) ?>;
fproduct_cart_bview.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bview.lists["x_partner_id"] = <?php echo $product_cart_b_view->partner_id->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_b_view->partner_id->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_partner_rid"] = <?php echo $product_cart_b_view->partner_rid->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_partner_rid"].options = <?php echo JsonEncode($product_cart_b_view->partner_rid->lookupOptions()) ?>;
fproduct_cart_bview.autoSuggests["x_partner_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bview.lists["x_grp"] = <?php echo $product_cart_b_view->grp->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_grp"].options = <?php echo JsonEncode($product_cart_b_view->grp->lookupOptions()) ?>;
fproduct_cart_bview.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bview.lists["x_s_grp"] = <?php echo $product_cart_b_view->s_grp->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_b_view->s_grp->lookupOptions()) ?>;
fproduct_cart_bview.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bview.lists["x_product"] = <?php echo $product_cart_b_view->product->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_product"].options = <?php echo JsonEncode($product_cart_b_view->product->lookupOptions()) ?>;
fproduct_cart_bview.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bview.lists["x_rid"] = <?php echo $product_cart_b_view->rid->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_rid"].options = <?php echo JsonEncode($product_cart_b_view->rid->lookupOptions()) ?>;
fproduct_cart_bview.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_bview.lists["x_packing_type"] = <?php echo $product_cart_b_view->packing_type->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_packing_type"].options = <?php echo JsonEncode($product_cart_b_view->packing_type->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_batch_no"] = <?php echo $product_cart_b_view->batch_no->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_batch_no"].options = <?php echo JsonEncode($product_cart_b_view->batch_no->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_shape"] = <?php echo $product_cart_b_view->shape->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_shape"].options = <?php echo JsonEncode($product_cart_b_view->shape->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_product_type"] = <?php echo $product_cart_b_view->product_type->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_b_view->product_type->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_unit"] = <?php echo $product_cart_b_view->unit->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_unit"].options = <?php echo JsonEncode($product_cart_b_view->unit->options(FALSE, TRUE)) ?>;
fproduct_cart_bview.lists["x_currency"] = <?php echo $product_cart_b_view->currency->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_currency"].options = <?php echo JsonEncode($product_cart_b_view->currency->lookupOptions()) ?>;
fproduct_cart_bview.lists["x_operator"] = <?php echo $product_cart_b_view->operator->Lookup->toClientList() ?>;
fproduct_cart_bview.lists["x_operator"].options = <?php echo JsonEncode($product_cart_b_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_cart_b->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $product_cart_b_view->ExportOptions->render("body") ?>
<?php $product_cart_b_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $product_cart_b_view->showPageHeader(); ?>
<?php
$product_cart_b_view->showMessage();
?>
<form name="fproduct_cart_bview" id="fproduct_cart_bview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_b_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_b_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_b">
<input type="hidden" name="modal" value="<?php echo (int)$product_cart_b_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($product_cart_b->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_id"><?php echo $product_cart_b->id->caption() ?></span></td>
		<td data-name="id"<?php echo $product_cart_b->id->cellAttributes() ?>>
<span id="el_product_cart_b_id">
<span<?php echo $product_cart_b->id->viewAttributes() ?>>
<?php echo $product_cart_b->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->po_id->Visible) { // po_id ?>
	<tr id="r_po_id">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_po_id"><?php echo $product_cart_b->po_id->caption() ?></span></td>
		<td data-name="po_id"<?php echo $product_cart_b->po_id->cellAttributes() ?>>
<span id="el_product_cart_b_po_id">
<span<?php echo $product_cart_b->po_id->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->po_id->getViewValue())) && $product_cart_b->po_id->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->po_id->linkAttributes() ?>><?php echo $product_cart_b->po_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->po_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_location"><?php echo $product_cart_b->location->caption() ?></span></td>
		<td data-name="location"<?php echo $product_cart_b->location->cellAttributes() ?>>
<span id="el_product_cart_b_location">
<span<?php echo $product_cart_b->location->viewAttributes() ?>>
<?php echo $product_cart_b->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_company_id"><?php echo $product_cart_b->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $product_cart_b->company_id->cellAttributes() ?>>
<span id="el_product_cart_b_company_id">
<span<?php echo $product_cart_b->company_id->viewAttributes() ?>>
<?php echo $product_cart_b->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->partner_order_no->Visible) { // partner_order_no ?>
	<tr id="r_partner_order_no">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_partner_order_no"><?php echo $product_cart_b->partner_order_no->caption() ?></span></td>
		<td data-name="partner_order_no"<?php echo $product_cart_b->partner_order_no->cellAttributes() ?>>
<span id="el_product_cart_b_partner_order_no">
<span<?php echo $product_cart_b->partner_order_no->viewAttributes() ?>>
<?php echo $product_cart_b->partner_order_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->partner_id->Visible) { // partner_id ?>
	<tr id="r_partner_id">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_partner_id"><?php echo $product_cart_b->partner_id->caption() ?></span></td>
		<td data-name="partner_id"<?php echo $product_cart_b->partner_id->cellAttributes() ?>>
<span id="el_product_cart_b_partner_id">
<span<?php echo $product_cart_b->partner_id->viewAttributes() ?>>
<?php echo $product_cart_b->partner_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->partner_rid->Visible) { // partner_rid ?>
	<tr id="r_partner_rid">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_partner_rid"><?php echo $product_cart_b->partner_rid->caption() ?></span></td>
		<td data-name="partner_rid"<?php echo $product_cart_b->partner_rid->cellAttributes() ?>>
<span id="el_product_cart_b_partner_rid">
<span<?php echo $product_cart_b->partner_rid->viewAttributes() ?>>
<?php echo $product_cart_b->partner_rid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->partner_code->Visible) { // partner_code ?>
	<tr id="r_partner_code">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_partner_code"><?php echo $product_cart_b->partner_code->caption() ?></span></td>
		<td data-name="partner_code"<?php echo $product_cart_b->partner_code->cellAttributes() ?>>
<span id="el_product_cart_b_partner_code">
<span<?php echo $product_cart_b->partner_code->viewAttributes() ?>>
<?php echo $product_cart_b->partner_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_grp"><?php echo $product_cart_b->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $product_cart_b->grp->cellAttributes() ?>>
<span id="el_product_cart_b_grp">
<span<?php echo $product_cart_b->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->grp->getViewValue())) && $product_cart_b->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->grp->linkAttributes() ?>><?php echo $product_cart_b->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_s_grp"><?php echo $product_cart_b->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $product_cart_b->s_grp->cellAttributes() ?>>
<span id="el_product_cart_b_s_grp">
<span<?php echo $product_cart_b->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->s_grp->getViewValue())) && $product_cart_b->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->s_grp->linkAttributes() ?>><?php echo $product_cart_b->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_product"><?php echo $product_cart_b->product->caption() ?></span></td>
		<td data-name="product"<?php echo $product_cart_b->product->cellAttributes() ?>>
<span id="el_product_cart_b_product">
<span<?php echo $product_cart_b->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->product->getViewValue())) && $product_cart_b->product->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->product->linkAttributes() ?>><?php echo $product_cart_b->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_rid"><?php echo $product_cart_b->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $product_cart_b->rid->cellAttributes() ?>>
<span id="el_product_cart_b_rid">
<span<?php echo $product_cart_b->rid->viewAttributes() ?>>
<?php echo $product_cart_b->rid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_packing_type"><?php echo $product_cart_b->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $product_cart_b->packing_type->cellAttributes() ?>>
<span id="el_product_cart_b_packing_type">
<span<?php echo $product_cart_b->packing_type->viewAttributes() ?>>
<?php echo $product_cart_b->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_batch_no"><?php echo $product_cart_b->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $product_cart_b->batch_no->cellAttributes() ?>>
<span id="el_product_cart_b_batch_no">
<span<?php echo $product_cart_b->batch_no->viewAttributes() ?>>
<?php echo $product_cart_b->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->shape->Visible) { // shape ?>
	<tr id="r_shape">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_shape"><?php echo $product_cart_b->shape->caption() ?></span></td>
		<td data-name="shape"<?php echo $product_cart_b->shape->cellAttributes() ?>>
<span id="el_product_cart_b_shape">
<span<?php echo $product_cart_b->shape->viewAttributes() ?>>
<?php echo $product_cart_b->shape->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_product_type"><?php echo $product_cart_b->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $product_cart_b->product_type->cellAttributes() ?>>
<span id="el_product_cart_b_product_type">
<span<?php echo $product_cart_b->product_type->viewAttributes() ?>>
<?php echo $product_cart_b->product_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->unit->Visible) { // unit ?>
	<tr id="r_unit">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_unit"><?php echo $product_cart_b->unit->caption() ?></span></td>
		<td data-name="unit"<?php echo $product_cart_b->unit->cellAttributes() ?>>
<span id="el_product_cart_b_unit">
<span<?php echo $product_cart_b->unit->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_b->unit->getViewValue())) && $product_cart_b->unit->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_b->unit->linkAttributes() ?>><?php echo $product_cart_b->unit->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_b->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->w->Visible) { // w ?>
	<tr id="r_w">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_w"><?php echo $product_cart_b->w->caption() ?></span></td>
		<td data-name="w"<?php echo $product_cart_b->w->cellAttributes() ?>>
<span id="el_product_cart_b_w">
<span<?php echo $product_cart_b->w->viewAttributes() ?>>
<?php echo $product_cart_b->w->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->w_cm->Visible) { // w_cm ?>
	<tr id="r_w_cm">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_w_cm"><?php echo $product_cart_b->w_cm->caption() ?></span></td>
		<td data-name="w_cm"<?php echo $product_cart_b->w_cm->cellAttributes() ?>>
<span id="el_product_cart_b_w_cm">
<span<?php echo $product_cart_b->w_cm->viewAttributes() ?>>
<?php echo $product_cart_b->w_cm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->l->Visible) { // l ?>
	<tr id="r_l">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_l"><?php echo $product_cart_b->l->caption() ?></span></td>
		<td data-name="l"<?php echo $product_cart_b->l->cellAttributes() ?>>
<span id="el_product_cart_b_l">
<span<?php echo $product_cart_b->l->viewAttributes() ?>>
<?php echo $product_cart_b->l->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->l_cm->Visible) { // l_cm ?>
	<tr id="r_l_cm">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_l_cm"><?php echo $product_cart_b->l_cm->caption() ?></span></td>
		<td data-name="l_cm"<?php echo $product_cart_b->l_cm->cellAttributes() ?>>
<span id="el_product_cart_b_l_cm">
<span<?php echo $product_cart_b->l_cm->viewAttributes() ?>>
<?php echo $product_cart_b->l_cm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->h->Visible) { // h ?>
	<tr id="r_h">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_h"><?php echo $product_cart_b->h->caption() ?></span></td>
		<td data-name="h"<?php echo $product_cart_b->h->cellAttributes() ?>>
<span id="el_product_cart_b_h">
<span<?php echo $product_cart_b->h->viewAttributes() ?>>
<?php echo $product_cart_b->h->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->h_cm->Visible) { // h_cm ?>
	<tr id="r_h_cm">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_h_cm"><?php echo $product_cart_b->h_cm->caption() ?></span></td>
		<td data-name="h_cm"<?php echo $product_cart_b->h_cm->cellAttributes() ?>>
<span id="el_product_cart_b_h_cm">
<span<?php echo $product_cart_b->h_cm->viewAttributes() ?>>
<?php echo $product_cart_b->h_cm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->partner_size->Visible) { // partner_size ?>
	<tr id="r_partner_size">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_partner_size"><?php echo $product_cart_b->partner_size->caption() ?></span></td>
		<td data-name="partner_size"<?php echo $product_cart_b->partner_size->cellAttributes() ?>>
<span id="el_product_cart_b_partner_size">
<span<?php echo $product_cart_b->partner_size->viewAttributes() ?>>
<?php echo $product_cart_b->partner_size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_size"><?php echo $product_cart_b->size->caption() ?></span></td>
		<td data-name="size"<?php echo $product_cart_b->size->cellAttributes() ?>>
<span id="el_product_cart_b_size">
<span<?php echo $product_cart_b->size->viewAttributes() ?>>
<?php echo $product_cart_b->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_sqm"><?php echo $product_cart_b->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $product_cart_b->sqm->cellAttributes() ?>>
<span id="el_product_cart_b_sqm">
<span<?php echo $product_cart_b->sqm->viewAttributes() ?>>
<?php echo $product_cart_b->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_quantity"><?php echo $product_cart_b->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $product_cart_b->quantity->cellAttributes() ?>>
<span id="el_product_cart_b_quantity">
<span<?php echo $product_cart_b->quantity->viewAttributes() ?>>
<?php echo $product_cart_b->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->price->Visible) { // price ?>
	<tr id="r_price">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_price"><?php echo $product_cart_b->price->caption() ?></span></td>
		<td data-name="price"<?php echo $product_cart_b->price->cellAttributes() ?>>
<span id="el_product_cart_b_price">
<span<?php echo $product_cart_b->price->viewAttributes() ?>>
<?php echo $product_cart_b->price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->currency->Visible) { // currency ?>
	<tr id="r_currency">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_currency"><?php echo $product_cart_b->currency->caption() ?></span></td>
		<td data-name="currency"<?php echo $product_cart_b->currency->cellAttributes() ?>>
<span id="el_product_cart_b_currency">
<span<?php echo $product_cart_b->currency->viewAttributes() ?>>
<?php echo $product_cart_b->currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->cbm->Visible) { // cbm ?>
	<tr id="r_cbm">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_cbm"><?php echo $product_cart_b->cbm->caption() ?></span></td>
		<td data-name="cbm"<?php echo $product_cart_b->cbm->cellAttributes() ?>>
<span id="el_product_cart_b_cbm">
<span<?php echo $product_cart_b->cbm->viewAttributes() ?>>
<?php echo $product_cart_b->cbm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->additional_discount->Visible) { // additional_discount ?>
	<tr id="r_additional_discount">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_additional_discount"><?php echo $product_cart_b->additional_discount->caption() ?></span></td>
		<td data-name="additional_discount"<?php echo $product_cart_b->additional_discount->cellAttributes() ?>>
<span id="el_product_cart_b_additional_discount">
<span<?php echo $product_cart_b->additional_discount->viewAttributes() ?>>
<?php echo $product_cart_b->additional_discount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->buyer_uid->Visible) { // buyer_uid ?>
	<tr id="r_buyer_uid">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_buyer_uid"><?php echo $product_cart_b->buyer_uid->caption() ?></span></td>
		<td data-name="buyer_uid"<?php echo $product_cart_b->buyer_uid->cellAttributes() ?>>
<span id="el_product_cart_b_buyer_uid">
<span<?php echo $product_cart_b->buyer_uid->viewAttributes() ?>>
<?php echo $product_cart_b->buyer_uid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->buyer_loc->Visible) { // buyer_loc ?>
	<tr id="r_buyer_loc">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_buyer_loc"><?php echo $product_cart_b->buyer_loc->caption() ?></span></td>
		<td data-name="buyer_loc"<?php echo $product_cart_b->buyer_loc->cellAttributes() ?>>
<span id="el_product_cart_b_buyer_loc">
<span<?php echo $product_cart_b->buyer_loc->viewAttributes() ?>>
<?php echo $product_cart_b->buyer_loc->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->label->Visible) { // label ?>
	<tr id="r_label">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_label"><?php echo $product_cart_b->label->caption() ?></span></td>
		<td data-name="label"<?php echo $product_cart_b->label->cellAttributes() ?>>
<span id="el_product_cart_b_label">
<span<?php echo $product_cart_b->label->viewAttributes() ?>>
<?php echo $product_cart_b->label->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_remarks"><?php echo $product_cart_b->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $product_cart_b->remarks->cellAttributes() ?>>
<span id="el_product_cart_b_remarks">
<span<?php echo $product_cart_b->remarks->viewAttributes() ?>>
<?php echo $product_cart_b->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_operator"><?php echo $product_cart_b->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $product_cart_b->operator->cellAttributes() ?>>
<span id="el_product_cart_b_operator">
<span<?php echo $product_cart_b->operator->viewAttributes() ?>>
<?php echo $product_cart_b->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_datetime"><?php echo $product_cart_b->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $product_cart_b->datetime->cellAttributes() ?>>
<span id="el_product_cart_b_datetime">
<span<?php echo $product_cart_b->datetime->viewAttributes() ?>>
<?php echo $product_cart_b->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->t_id->Visible) { // t_id ?>
	<tr id="r_t_id">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_t_id"><?php echo $product_cart_b->t_id->caption() ?></span></td>
		<td data-name="t_id"<?php echo $product_cart_b->t_id->cellAttributes() ?>>
<span id="el_product_cart_b_t_id">
<span<?php echo $product_cart_b->t_id->viewAttributes() ?>>
<?php echo $product_cart_b->t_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->d_remarks->Visible) { // d_remarks ?>
	<tr id="r_d_remarks">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_d_remarks"><?php echo $product_cart_b->d_remarks->caption() ?></span></td>
		<td data-name="d_remarks"<?php echo $product_cart_b->d_remarks->cellAttributes() ?>>
<span id="el_product_cart_b_d_remarks">
<span<?php echo $product_cart_b->d_remarks->viewAttributes() ?>>
<?php echo $product_cart_b->d_remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->level->Visible) { // level ?>
	<tr id="r_level">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_level"><?php echo $product_cart_b->level->caption() ?></span></td>
		<td data-name="level"<?php echo $product_cart_b->level->cellAttributes() ?>>
<span id="el_product_cart_b_level">
<span<?php echo $product_cart_b->level->viewAttributes() ?>>
<?php echo $product_cart_b->level->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->dispatch_week->Visible) { // dispatch_week ?>
	<tr id="r_dispatch_week">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_dispatch_week"><?php echo $product_cart_b->dispatch_week->caption() ?></span></td>
		<td data-name="dispatch_week"<?php echo $product_cart_b->dispatch_week->cellAttributes() ?>>
<span id="el_product_cart_b_dispatch_week">
<span<?php echo $product_cart_b->dispatch_week->viewAttributes() ?>>
<?php echo $product_cart_b->dispatch_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->sale_id->Visible) { // sale_id ?>
	<tr id="r_sale_id">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_sale_id"><?php echo $product_cart_b->sale_id->caption() ?></span></td>
		<td data-name="sale_id"<?php echo $product_cart_b->sale_id->cellAttributes() ?>>
<span id="el_product_cart_b_sale_id">
<span<?php echo $product_cart_b->sale_id->viewAttributes() ?>>
<?php echo $product_cart_b->sale_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->sale_qty->Visible) { // sale_qty ?>
	<tr id="r_sale_qty">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_sale_qty"><?php echo $product_cart_b->sale_qty->caption() ?></span></td>
		<td data-name="sale_qty"<?php echo $product_cart_b->sale_qty->cellAttributes() ?>>
<span id="el_product_cart_b_sale_qty">
<span<?php echo $product_cart_b->sale_qty->viewAttributes() ?>>
<?php echo $product_cart_b->sale_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($product_cart_b->balance->Visible) { // balance ?>
	<tr id="r_balance">
		<td class="<?php echo $product_cart_b_view->TableLeftColumnClass ?>"><span id="elh_product_cart_b_balance"><?php echo $product_cart_b->balance->caption() ?></span></td>
		<td data-name="balance"<?php echo $product_cart_b->balance->cellAttributes() ?>>
<span id="el_product_cart_b_balance">
<span<?php echo $product_cart_b->balance->viewAttributes() ?>>
<?php echo $product_cart_b->balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$product_cart_b_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_cart_b->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var SGrp = $("#x_s_grp").val();
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
					if (data.calculation_method == '1') {
					$("#elh_product_cart_b_price").html('Price / SQM');}
					else if (data.calculation_method == '11') {
					$("#elh_product_cart_b_price").html('Price / SKU');}
					else if (data.calculation_method == '21') {
					$("#elh_product_cart_b_price").html('Price / KG');}
			 		if (data.pc_shape == '--NA--') {
					$("#x_shape").val('');
					$("#r_shape").hide(); } else {
					$("#r_shape").show();}
			 		if (data.pc_unit == '--NA--') {
					$("#x_unit").val(1);
					$("#r_unit").hide(); } else {
					$("#r_unit").show();}			 		
					if (data.pc_w == '--NA--') {
					$("#x_w").val(0);
					$("#x_w_cm").val(0);
					$("#r_w").hide();					
					$("#r_w_cm").hide();
					} else {
					$("#r_w").show();
					$("#r_w_cm").show();}
					if (data.pc_l == '--NA--') {
					$("#x_l").val(0);
					$("#x_l_cm").val(0);
					$("#r_l").hide();					
					$("#r_l_cm").hide();
					} else {
					$("#r_l").show();
					$("#r_l_cm").show();}					
					if (data.pc_h == '--NA--') {
					$("#x_h").val(0);
					$("#x_h_cm").val(0);
					$("#r_h").hide();					
					$("#r_h_cm").hide();
					} else {
					$("#r_h").show();
					$("#r_h_cm").show();}
			 		if (data.pc_partner_size == '--NA--') {
					$("#x_partner_size").val('');
					$("#r_partner_size").hide(); } else {
					$("#r_partner_size").show();}
			 		if (data.pc_sqm == '--NA--') {
					$("#x_sqm").val(0);
					$("#r_sqm").hide(); } else {
					$("#r_sqm").show();}
			 		if (data.pc_01_head == '--NA--') {
					$("#x__1").val('');
					$("#r__1").hide(); } else {
					$("#r__1").show();					
					$("#elh_product_cart_b__1").html(data.pc_01_head);}
			 		if (data.pc_02_head == '--NA--') {
					$("#x__2").val('');
					$("#r__2").hide(); } else {
					$("#r__2").show();					
					$("#elh_product_cart_b__2").html(data.pc_02_head);}
			 		if (data.pc_03_head == '--NA--') {
					$("#x__3").val('');
					$("#r__3").hide(); } else {
					$("#r__3").show();					
					$("#elh_product_cart_b__3").html(data.pc_03_head);}
			 		if (data.pc_04_head == '--NA--') {
					$("#x__4").val('');
					$("#r__4").hide(); } else {
					$("#r__4").show();					
					$("#elh_product_cart_b__4").html(data.pc_04_head);}
			 		if (data.pc_05_head == '--NA--') {
					$("#x__5").val('');
					$("#r__5").hide(); } else {
					$("#r__5").show();					
					$("#elh_product_cart_b__5").html(data.pc_05_head);}
			 		if (data.pc_06_head == '--NA--') {
					$("#x__6").val('');
					$("#r__6").hide(); } else {
					$("#r__6").show();					
					$("#elh_product_cart_b__6").html(data.pc_06_head);}
			 		if (data.pc_07_head == '--NA--') {
					$("#x__7").val('');
					$("#r__7").hide(); } else {
					$("#r__7").show();					
					$("#elh_product_cart_b__7").html(data.pc_07_head);}
			 		if (data.pc_08_head == '--NA--') {
					$("#x__8").val('');
					$("#r__8").hide(); } else {
					$("#r__8").show();					
					$("#elh_product_cart_b__8").html(data.pc_08_head);}
			});
		}
					$.getJSON("apcajax.php?pdbyepass=9",function(data) {
			 		if (data == '2') {$("#r_batch_no").hide();}});
			 	var Shape = $("#x_shape").val();
				var TYPE = $("#x_unit").val();
				var product_type = ($("#x_product_type").val() > 0) ? $("#x_product_type").val() : 0;
				if (product_type == 1) {
				var SW = ' SW';
				} else if (product_type == 2) {
				var SW = ' CC';
				} else if (product_type == 3) {
				var SW = ' DC';
				} else if (product_type == 10) {
				var SW = ' SAMPLE';
				} else  {
				var SW = '';
				}
				var SH = '';
				var wa = (($("#x_w").val()).length > 0) ? $("#x_w").val() : '0 ';
				var la = (($("#x_l").val()).length > 0) ? $("#x_l").val() : '0 ';
				var wArr = wa.split('-');
				var lArr = la.split('-');
				var w = parseFloat(wArr[0]);
				var l = parseFloat(lArr[0]);
				var wd = (parseFloat(wArr[1]) > 0) ? (parseFloat(wArr[1])) : 0;
				var ld = (parseFloat(lArr[1]) > 0) ? (parseFloat(lArr[1])) : 0;
				if (TYPE == 1) {
				var WCM = (w).toFixed(4);
				var LCM = (l).toFixed(4);
				var WO = (w/100).toFixed(4);
				var LO = (l/100).toFixed(4);
				} else 
				if (TYPE == 2) {
				var WCM = (w * 2.54).toFixed(4);
				var LCM = (l * 2.54).toFixed(4);	
				var WO = (w/100 * 2.54).toFixed(4);
				var LO = (l/100 * 2.54).toFixed(4);	
				} else if (TYPE == 3) {
				var WCM = ((w + (wd/12)) * 30.48).toFixed(4);
				var LCM = ((l + (ld/12)) * 30.48).toFixed(4);
				var WO = ((w + (wd/12))).toFixed(4);
				var LO = ((l + (ld/12))).toFixed(4);
				$("#elh_product_cart_b_w").html('Width<BR>Input : 10-6');
				$("#elh_product_cart_b_l").html('Length<BR>Input : 10-6');
				} else if (TYPE == 4) {
				var WCM = ((w + (wd/36)) * 91.44).toFixed(4);
				var LCM = ((l + (ld/36)) * 91.44).toFixed(4);
				var WO = ((w + (wd/36))).toFixed(4);
				var LO = ((l + (ld/36))).toFixed(4);
				$("#elh_product_cart_b_w").html('Width<BR>Input : 10-6');
				$("#elh_product_cart_b_l").html('Length<BR>Input : 10-6');
				} else if (TYPE == 5) {
				var WCM = (w * 100).toFixed(4);
				var LCM = (l * 100).toFixed(4);	
				var WO = (w).toFixed(4);
				var LO = (l).toFixed(4);	
				}
				var AreaCM = (WCM * LCM / 10000).toFixed(2);
				var Area = (WO * LO).toFixed(2);
				if (Shape == 1){var SH = '';}
				if (Shape == 2){var SH = ' R';}
				if (Shape == 3){var SH = ' O';}
				if (Shape == 101){var SH = ' CS';}
				if (Shape == 102){var SH = ' R CS';}
				if (Shape == 103){var SH = ' O CS';}
				if(TYPE == 1)
				  {
				   $("#x_w_cm").val(Math.round(WCM));
				   $("#x_l_cm").val(Math.round(LCM));

				   //$("#x_partner_size").val(Math.round(w) + ' x ' + Math.round(l) + ' CM' + SH + SW);
				   $("#x_sqm").val(Area);
   				   $("#elh_product_cart_b_sqm").html('SQM / Pc.');
				   } else if (TYPE == 2) {
				   $("#x_w_cm").val(Math.round(WCM));
				   $("#x_l_cm").val(Math.round(LCM));

				   //$("#x_partner_size").val(Math.round(w) + '" x ' + Math.round(l) + '"' + SH + SW);
				   $("#x_sqm").val(Area);
				   $("#elh_product_cart_b_sqm").html('SQM / Pc.');
				   } else if (TYPE == 3) {
				   $("#x_w_cm").val(Math.round(WCM));
				   $("#x_l_cm").val(Math.round(LCM));

				  // if ((wd == 0) && (ld == 0))
				  // {
				  // $("#x_partner_size").val(Math.round(w) +"'" + ' x ' + Math.round(l) + "'" + SH + SW);
				  // } else {
				  // $("#x_partner_size").val(Math.round(w) +"'" + Math.round(wd) + '"' + ' x ' + Math.round(l) + "'" + Math.round(ld) + '"' + SH + SW);
				  // }

				   $("#x_sqm").val(Area);
				   $("#elh_product_cart_b_sqm").html('SQF / Pc.<br>SQM : '+AreaCM);
				   $("#elh_product_cart_b_price").html('Price / SQF');
				   } else if (TYPE == 4) {
				   $("#x_w_cm").val(Math.round(WCM));
				   $("#x_l_cm").val(Math.round(LCM));

				   //if ((wd == 0) && (ld == 0))
				  // {
				  // $("#x_partner_size").val(Math.round(w) +"yd" + ' x ' + Math.round(l) + "yd" +  SH + SW);
				  // } else {
				  // $("#x_partner_size").val(Math.round(w) +"yd " + Math.round(wd) + '"' + ' x ' + Math.round(l) + "yd " + Math.round(ld) + '"' + SH + SW);
				   //}

				   $("#x_sqm").val(Area);
				   $("#elh_product_cart_b_sqm").html('SQY / Pc.<br>SQM : '+AreaCM);
				   $("#elh_product_cart_b_price").html('Price / SQY');
				  } else if (TYPE == 5) {
				   $("#x_w_cm").val(Math.round(WCM));
				   $("#x_l_cm").val(Math.round(LCM));

				   //$("#x_partner_size").val(w.toFixed(2) + ' x ' + l.toFixed(2) + ' Meter' + SH + SW);
				   $("#x_sqm").val(Area);
				  }
</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_cart_b_view->terminate();
?>