<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_s_sample_list = new product_cart_s_sample_list();

// Run the page
$product_cart_s_sample_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_s_sample_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_cart_s_sample->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_cart_s_samplelist = currentForm = new ew.Form("fproduct_cart_s_samplelist", "list");
fproduct_cart_s_samplelist.formKeyCountName = '<?php echo $product_cart_s_sample_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_cart_s_samplelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_s_samplelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_s_samplelist.lists["x_po_id"] = <?php echo $product_cart_s_sample_list->po_id->Lookup->toClientList() ?>;
fproduct_cart_s_samplelist.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_s_sample_list->po_id->lookupOptions()) ?>;
fproduct_cart_s_samplelist.lists["x_company_id"] = <?php echo $product_cart_s_sample_list->company_id->Lookup->toClientList() ?>;
fproduct_cart_s_samplelist.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_s_sample_list->company_id->lookupOptions()) ?>;
fproduct_cart_s_samplelist.lists["x_partner_id"] = <?php echo $product_cart_s_sample_list->partner_id->Lookup->toClientList() ?>;
fproduct_cart_s_samplelist.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_s_sample_list->partner_id->lookupOptions()) ?>;
fproduct_cart_s_samplelist.lists["x_grp"] = <?php echo $product_cart_s_sample_list->grp->Lookup->toClientList() ?>;
fproduct_cart_s_samplelist.lists["x_grp"].options = <?php echo JsonEncode($product_cart_s_sample_list->grp->lookupOptions()) ?>;
fproduct_cart_s_samplelist.lists["x_s_grp"] = <?php echo $product_cart_s_sample_list->s_grp->Lookup->toClientList() ?>;
fproduct_cart_s_samplelist.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_s_sample_list->s_grp->lookupOptions()) ?>;
fproduct_cart_s_samplelist.lists["x_status"] = <?php echo $product_cart_s_sample_list->status->Lookup->toClientList() ?>;
fproduct_cart_s_samplelist.lists["x_status"].options = <?php echo JsonEncode($product_cart_s_sample_list->status->options(FALSE, TRUE)) ?>;
fproduct_cart_s_samplelist.lists["x_operator"] = <?php echo $product_cart_s_sample_list->operator->Lookup->toClientList() ?>;
fproduct_cart_s_samplelist.lists["x_operator"].options = <?php echo JsonEncode($product_cart_s_sample_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduct_cart_s_samplelistsrch = currentSearchForm = new ew.Form("fproduct_cart_s_samplelistsrch");

// Validate function for search
fproduct_cart_s_samplelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_cart_s_samplelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_s_samplelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_s_samplelistsrch.lists["x_grp"] = <?php echo $product_cart_s_sample_list->grp->Lookup->toClientList() ?>;
fproduct_cart_s_samplelistsrch.lists["x_grp"].options = <?php echo JsonEncode($product_cart_s_sample_list->grp->lookupOptions()) ?>;
fproduct_cart_s_samplelistsrch.lists["x_s_grp"] = <?php echo $product_cart_s_sample_list->s_grp->Lookup->toClientList() ?>;
fproduct_cart_s_samplelistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_s_sample_list->s_grp->lookupOptions()) ?>;

// Filters
fproduct_cart_s_samplelistsrch.filterList = <?php echo $product_cart_s_sample_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_cart_s_samplelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$product_cart_s_sample->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_cart_s_sample_list->TotalRecs > 0 && $product_cart_s_sample_list->ExportOptions->visible()) { ?>
<?php $product_cart_s_sample_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_s_sample_list->ImportOptions->visible()) { ?>
<?php $product_cart_s_sample_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_s_sample_list->SearchOptions->visible()) { ?>
<?php $product_cart_s_sample_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_s_sample_list->FilterOptions->visible()) { ?>
<?php $product_cart_s_sample_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$product_cart_s_sample_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_cart_s_sample->isExport() && !$product_cart_s_sample->CurrentAction) { ?>
<form name="fproduct_cart_s_samplelistsrch" id="fproduct_cart_s_samplelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_cart_s_sample_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_cart_s_samplelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_cart_s_sample">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_cart_s_sample_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_cart_s_sample->RowType = ROWTYPE_SEARCH;

// Render row
$product_cart_s_sample->resetAttributes();
$product_cart_s_sample_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_cart_s_sample->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $product_cart_s_sample->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $product_cart_s_sample->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_s_sample->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s_sample" data-field="x_grp" data-value-separator="<?php echo $product_cart_s_sample->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_cart_s_sample->grp->editAttributes() ?>>
		<?php echo $product_cart_s_sample->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $product_cart_s_sample->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_s_sample->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $product_cart_s_sample->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<?php $product_cart_s_sample->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_s_sample->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s_sample" data-field="x_s_grp" data-value-separator="<?php echo $product_cart_s_sample->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_cart_s_sample->s_grp->editAttributes() ?>>
		<?php echo $product_cart_s_sample->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_cart_s_sample->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_cart_s_sample_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_cart_s_sample_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_cart_s_sample_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_cart_s_sample_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_cart_s_sample_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_cart_s_sample_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_cart_s_sample_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_cart_s_sample_list->showPageHeader(); ?>
<?php
$product_cart_s_sample_list->showMessage();
?>
<?php if ($product_cart_s_sample_list->TotalRecs > 0 || $product_cart_s_sample->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_cart_s_sample_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_cart_s_sample">
<?php if (!$product_cart_s_sample->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_cart_s_sample->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_s_sample_list->Pager)) $product_cart_s_sample_list->Pager = new PrevNextPager($product_cart_s_sample_list->StartRec, $product_cart_s_sample_list->DisplayRecs, $product_cart_s_sample_list->TotalRecs, $product_cart_s_sample_list->AutoHidePager) ?>
<?php if ($product_cart_s_sample_list->Pager->RecordCount > 0 && $product_cart_s_sample_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_s_sample_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_s_sample_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_s_sample_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_s_sample_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_s_sample_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_s_sample_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_s_sample_list->TotalRecs > 0 && (!$product_cart_s_sample_list->AutoHidePageSizeSelector || $product_cart_s_sample_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_s_sample">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_s_sample_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_s_sample_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_s_sample_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_s_sample->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_s_sample_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_cart_s_samplelist" id="fproduct_cart_s_samplelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_s_sample_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_s_sample_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_s_sample">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_product_cart_s_sample" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_cart_s_sample_list->TotalRecs > 0 || $product_cart_s_sample->isGridEdit()) { ?>
<table id="tbl_product_cart_s_samplelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_cart_s_sample_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_cart_s_sample_list->renderListOptions();

// Render list options (header, left)
$product_cart_s_sample_list->ListOptions->render("header", "left");
?>
<?php if ($product_cart_s_sample->id->Visible) { // id ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_cart_s_sample->id->headerCellClass() ?>"><div id="elh_product_cart_s_sample_id" class="product_cart_s_sample_id"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_cart_s_sample->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->id) ?>',1);"><div id="elh_product_cart_s_sample_id" class="product_cart_s_sample_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->po_id->Visible) { // po_id ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->po_id) == "") { ?>
		<th data-name="po_id" class="<?php echo $product_cart_s_sample->po_id->headerCellClass() ?>"><div id="elh_product_cart_s_sample_po_id" class="product_cart_s_sample_po_id"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->po_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_id" class="<?php echo $product_cart_s_sample->po_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->po_id) ?>',1);"><div id="elh_product_cart_s_sample_po_id" class="product_cart_s_sample_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->po_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->po_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->company_id->Visible) { // company_id ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $product_cart_s_sample->company_id->headerCellClass() ?>"><div id="elh_product_cart_s_sample_company_id" class="product_cart_s_sample_company_id"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $product_cart_s_sample->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->company_id) ?>',1);"><div id="elh_product_cart_s_sample_company_id" class="product_cart_s_sample_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->partner_id->Visible) { // partner_id ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_s_sample->partner_id->headerCellClass() ?>"><div id="elh_product_cart_s_sample_partner_id" class="product_cart_s_sample_partner_id"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_s_sample->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->partner_id) ?>',1);"><div id="elh_product_cart_s_sample_partner_id" class="product_cart_s_sample_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->grp->Visible) { // grp ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product_cart_s_sample->grp->headerCellClass() ?>"><div id="elh_product_cart_s_sample_grp" class="product_cart_s_sample_grp"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product_cart_s_sample->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->grp) ?>',1);"><div id="elh_product_cart_s_sample_grp" class="product_cart_s_sample_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->s_grp->Visible) { // s_grp ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_s_sample->s_grp->headerCellClass() ?>"><div id="elh_product_cart_s_sample_s_grp" class="product_cart_s_sample_s_grp"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_s_sample->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->s_grp) ?>',1);"><div id="elh_product_cart_s_sample_s_grp" class="product_cart_s_sample_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->rid_1->Visible) { // rid_1 ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->rid_1) == "") { ?>
		<th data-name="rid_1" class="<?php echo $product_cart_s_sample->rid_1->headerCellClass() ?>"><div id="elh_product_cart_s_sample_rid_1" class="product_cart_s_sample_rid_1"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->rid_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid_1" class="<?php echo $product_cart_s_sample->rid_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->rid_1) ?>',1);"><div id="elh_product_cart_s_sample_rid_1" class="product_cart_s_sample_rid_1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->rid_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->rid_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->rid_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->partner_size->Visible) { // partner_size ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->partner_size) == "") { ?>
		<th data-name="partner_size" class="<?php echo $product_cart_s_sample->partner_size->headerCellClass() ?>"><div id="elh_product_cart_s_sample_partner_size" class="product_cart_s_sample_partner_size"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->partner_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_size" class="<?php echo $product_cart_s_sample->partner_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->partner_size) ?>',1);"><div id="elh_product_cart_s_sample_partner_size" class="product_cart_s_sample_partner_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->partner_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->partner_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->partner_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->quantity->Visible) { // quantity ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $product_cart_s_sample->quantity->headerCellClass() ?>"><div id="elh_product_cart_s_sample_quantity" class="product_cart_s_sample_quantity"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $product_cart_s_sample->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->quantity) ?>',1);"><div id="elh_product_cart_s_sample_quantity" class="product_cart_s_sample_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->status->Visible) { // status ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_cart_s_sample->status->headerCellClass() ?>"><div id="elh_product_cart_s_sample_status" class="product_cart_s_sample_status"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_cart_s_sample->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->status) ?>',1);"><div id="elh_product_cart_s_sample_status" class="product_cart_s_sample_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->operator->Visible) { // operator ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_cart_s_sample->operator->headerCellClass() ?>"><div id="elh_product_cart_s_sample_operator" class="product_cart_s_sample_operator"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_cart_s_sample->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->operator) ?>',1);"><div id="elh_product_cart_s_sample_operator" class="product_cart_s_sample_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s_sample->datetime->Visible) { // datetime ?>
	<?php if ($product_cart_s_sample->sortUrl($product_cart_s_sample->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_cart_s_sample->datetime->headerCellClass() ?>"><div id="elh_product_cart_s_sample_datetime" class="product_cart_s_sample_datetime"><div class="ew-table-header-caption"><?php echo $product_cart_s_sample->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_cart_s_sample->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s_sample->SortUrl($product_cart_s_sample->datetime) ?>',1);"><div id="elh_product_cart_s_sample_datetime" class="product_cart_s_sample_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s_sample->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_sample->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_sample->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_cart_s_sample_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_cart_s_sample->ExportAll && $product_cart_s_sample->isExport()) {
	$product_cart_s_sample_list->StopRec = $product_cart_s_sample_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_cart_s_sample_list->TotalRecs > $product_cart_s_sample_list->StartRec + $product_cart_s_sample_list->DisplayRecs - 1)
		$product_cart_s_sample_list->StopRec = $product_cart_s_sample_list->StartRec + $product_cart_s_sample_list->DisplayRecs - 1;
	else
		$product_cart_s_sample_list->StopRec = $product_cart_s_sample_list->TotalRecs;
}
$product_cart_s_sample_list->RecCnt = $product_cart_s_sample_list->StartRec - 1;
if ($product_cart_s_sample_list->Recordset && !$product_cart_s_sample_list->Recordset->EOF) {
	$product_cart_s_sample_list->Recordset->moveFirst();
	$selectLimit = $product_cart_s_sample_list->UseSelectLimit;
	if (!$selectLimit && $product_cart_s_sample_list->StartRec > 1)
		$product_cart_s_sample_list->Recordset->move($product_cart_s_sample_list->StartRec - 1);
} elseif (!$product_cart_s_sample->AllowAddDeleteRow && $product_cart_s_sample_list->StopRec == 0) {
	$product_cart_s_sample_list->StopRec = $product_cart_s_sample->GridAddRowCount;
}

// Initialize aggregate
$product_cart_s_sample->RowType = ROWTYPE_AGGREGATEINIT;
$product_cart_s_sample->resetAttributes();
$product_cart_s_sample_list->renderRow();
while ($product_cart_s_sample_list->RecCnt < $product_cart_s_sample_list->StopRec) {
	$product_cart_s_sample_list->RecCnt++;
	if ($product_cart_s_sample_list->RecCnt >= $product_cart_s_sample_list->StartRec) {
		$product_cart_s_sample_list->RowCnt++;

		// Set up key count
		$product_cart_s_sample_list->KeyCount = $product_cart_s_sample_list->RowIndex;

		// Init row class and style
		$product_cart_s_sample->resetAttributes();
		$product_cart_s_sample->CssClass = "";
		if ($product_cart_s_sample->isGridAdd()) {
		} else {
			$product_cart_s_sample_list->loadRowValues($product_cart_s_sample_list->Recordset); // Load row values
		}
		$product_cart_s_sample->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_cart_s_sample->RowAttrs = array_merge($product_cart_s_sample->RowAttrs, array('data-rowindex'=>$product_cart_s_sample_list->RowCnt, 'id'=>'r' . $product_cart_s_sample_list->RowCnt . '_product_cart_s_sample', 'data-rowtype'=>$product_cart_s_sample->RowType));

		// Render row
		$product_cart_s_sample_list->renderRow();

		// Render list options
		$product_cart_s_sample_list->renderListOptions();
?>
	<tr<?php echo $product_cart_s_sample->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_cart_s_sample_list->ListOptions->render("body", "left", $product_cart_s_sample_list->RowCnt);
?>
	<?php if ($product_cart_s_sample->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_cart_s_sample->id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_id" class="product_cart_s_sample_id">
<span<?php echo $product_cart_s_sample->id->viewAttributes() ?>>
<?php echo $product_cart_s_sample->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->po_id->Visible) { // po_id ?>
		<td data-name="po_id"<?php echo $product_cart_s_sample->po_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_po_id" class="product_cart_s_sample_po_id">
<span<?php echo $product_cart_s_sample->po_id->viewAttributes() ?>>
<?php echo $product_cart_s_sample->po_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $product_cart_s_sample->company_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_company_id" class="product_cart_s_sample_company_id">
<span<?php echo $product_cart_s_sample->company_id->viewAttributes() ?>>
<?php echo $product_cart_s_sample->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $product_cart_s_sample->partner_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_partner_id" class="product_cart_s_sample_partner_id">
<span<?php echo $product_cart_s_sample->partner_id->viewAttributes() ?>>
<?php echo $product_cart_s_sample->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product_cart_s_sample->grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_grp" class="product_cart_s_sample_grp">
<span<?php echo $product_cart_s_sample->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s_sample->grp->getViewValue())) && $product_cart_s_sample->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s_sample->grp->linkAttributes() ?>><?php echo $product_cart_s_sample->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s_sample->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product_cart_s_sample->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_s_grp" class="product_cart_s_sample_s_grp">
<span<?php echo $product_cart_s_sample->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s_sample->s_grp->getViewValue())) && $product_cart_s_sample->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s_sample->s_grp->linkAttributes() ?>><?php echo $product_cart_s_sample->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s_sample->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->rid_1->Visible) { // rid_1 ?>
		<td data-name="rid_1"<?php echo $product_cart_s_sample->rid_1->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_rid_1" class="product_cart_s_sample_rid_1">
<span<?php echo $product_cart_s_sample->rid_1->viewAttributes() ?>>
<?php echo $product_cart_s_sample->rid_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->partner_size->Visible) { // partner_size ?>
		<td data-name="partner_size"<?php echo $product_cart_s_sample->partner_size->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_partner_size" class="product_cart_s_sample_partner_size">
<span<?php echo $product_cart_s_sample->partner_size->viewAttributes() ?>>
<?php echo $product_cart_s_sample->partner_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $product_cart_s_sample->quantity->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_quantity" class="product_cart_s_sample_quantity">
<span<?php echo $product_cart_s_sample->quantity->viewAttributes() ?>>
<?php echo $product_cart_s_sample->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_cart_s_sample->status->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_status" class="product_cart_s_sample_status">
<span<?php echo $product_cart_s_sample->status->viewAttributes() ?>>
<?php echo $product_cart_s_sample->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_cart_s_sample->operator->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_operator" class="product_cart_s_sample_operator">
<span<?php echo $product_cart_s_sample->operator->viewAttributes() ?>>
<?php echo $product_cart_s_sample->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s_sample->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_cart_s_sample->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_sample_list->RowCnt ?>_product_cart_s_sample_datetime" class="product_cart_s_sample_datetime">
<span<?php echo $product_cart_s_sample->datetime->viewAttributes() ?>>
<?php echo $product_cart_s_sample->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_cart_s_sample_list->ListOptions->render("body", "right", $product_cart_s_sample_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_cart_s_sample->isGridAdd())
		$product_cart_s_sample_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_cart_s_sample->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_cart_s_sample_list->Recordset)
	$product_cart_s_sample_list->Recordset->Close();
?>
<?php if (!$product_cart_s_sample->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_cart_s_sample->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_s_sample_list->Pager)) $product_cart_s_sample_list->Pager = new PrevNextPager($product_cart_s_sample_list->StartRec, $product_cart_s_sample_list->DisplayRecs, $product_cart_s_sample_list->TotalRecs, $product_cart_s_sample_list->AutoHidePager) ?>
<?php if ($product_cart_s_sample_list->Pager->RecordCount > 0 && $product_cart_s_sample_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_s_sample_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_s_sample_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_s_sample_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_s_sample_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_s_sample_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_s_sample_list->pageUrl() ?>start=<?php echo $product_cart_s_sample_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_s_sample_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_s_sample_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_s_sample_list->TotalRecs > 0 && (!$product_cart_s_sample_list->AutoHidePageSizeSelector || $product_cart_s_sample_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_s_sample">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_s_sample_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_s_sample_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_s_sample_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_s_sample->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_s_sample_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_cart_s_sample_list->TotalRecs == 0 && !$product_cart_s_sample->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_cart_s_sample_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_cart_s_sample_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_cart_s_sample->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_cart_s_sample->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_cart_s_sample", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_cart_s_sample_list->terminate();
?>