<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_s_add = new product_cart_s_add();

// Run the page
$product_cart_s_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_s_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproduct_cart_sadd = currentForm = new ew.Form("fproduct_cart_sadd", "add");

// Validate form
fproduct_cart_sadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_cart_s_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->location->caption(), $product_cart_s->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->company_id->caption(), $product_cart_s->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->company_id->errorMessage()) ?>");
		<?php if ($product_cart_s_add->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->partner_id->caption(), $product_cart_s->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->partner_rid->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->partner_rid->caption(), $product_cart_s->partner_rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->product_type->caption(), $product_cart_s->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->grp->caption(), $product_cart_s->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->grp->errorMessage()) ?>");
		<?php if ($product_cart_s_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->s_grp->caption(), $product_cart_s->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->product->caption(), $product_cart_s->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->rid->caption(), $product_cart_s->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->packing_type->caption(), $product_cart_s->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->batch_no->caption(), $product_cart_s->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->shape->caption(), $product_cart_s->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->unit->caption(), $product_cart_s->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->w->Required) { ?>
			elm = this.getElements("x" + infix + "_w");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->w->caption(), $product_cart_s->w->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->w_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->w_cm->caption(), $product_cart_s->w_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->w_cm->errorMessage()) ?>");
		<?php if ($product_cart_s_add->l->Required) { ?>
			elm = this.getElements("x" + infix + "_l");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->l->caption(), $product_cart_s->l->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->l_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->l_cm->caption(), $product_cart_s->l_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->l_cm->errorMessage()) ?>");
		<?php if ($product_cart_s_add->h->Required) { ?>
			elm = this.getElements("x" + infix + "_h");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->h->caption(), $product_cart_s->h->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->h_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_h_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->h_cm->caption(), $product_cart_s->h_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_h_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->h_cm->errorMessage()) ?>");
		<?php if ($product_cart_s_add->partner_size->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->partner_size->caption(), $product_cart_s->partner_size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->sqm->caption(), $product_cart_s->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->sqm->errorMessage()) ?>");
		<?php if ($product_cart_s_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->quantity->caption(), $product_cart_s->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->quantity->errorMessage()) ?>");
		<?php if ($product_cart_s_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->price->caption(), $product_cart_s->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->price->errorMessage()) ?>");
		<?php if ($product_cart_s_add->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->currency->caption(), $product_cart_s->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->amount->caption(), $product_cart_s->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->amount->errorMessage()) ?>");
		<?php if ($product_cart_s_add->shipping_charge->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_charge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->shipping_charge->caption(), $product_cart_s->shipping_charge->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_shipping_charge");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_cart_s->shipping_charge->errorMessage()) ?>");
		<?php if ($product_cart_s_add->buyer_uid->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->buyer_uid->caption(), $product_cart_s->buyer_uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->label->Required) { ?>
			elm = this.getElements("x" + infix + "_label");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->label->caption(), $product_cart_s->label->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->remarks->caption(), $product_cart_s->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->operator->caption(), $product_cart_s->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->datetime->caption(), $product_cart_s->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->product_code->caption(), $product_cart_s->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_cart_s_add->p_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_p_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->p_remarks->caption(), $product_cart_s->p_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_cart_sadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_sadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_sadd.lists["x_location"] = <?php echo $product_cart_s_add->location->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_location"].options = <?php echo JsonEncode($product_cart_s_add->location->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_company_id"] = <?php echo $product_cart_s_add->company_id->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_s_add->company_id->lookupOptions()) ?>;
fproduct_cart_sadd.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_sadd.lists["x_partner_id"] = <?php echo $product_cart_s_add->partner_id->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_s_add->partner_id->lookupOptions()) ?>;
fproduct_cart_sadd.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_sadd.lists["x_partner_rid"] = <?php echo $product_cart_s_add->partner_rid->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_partner_rid"].options = <?php echo JsonEncode($product_cart_s_add->partner_rid->lookupOptions()) ?>;
fproduct_cart_sadd.autoSuggests["x_partner_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_sadd.lists["x_product_type"] = <?php echo $product_cart_s_add->product_type->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_s_add->product_type->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_grp"] = <?php echo $product_cart_s_add->grp->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_grp"].options = <?php echo JsonEncode($product_cart_s_add->grp->lookupOptions()) ?>;
fproduct_cart_sadd.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_sadd.lists["x_s_grp"] = <?php echo $product_cart_s_add->s_grp->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_s_add->s_grp->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_product"] = <?php echo $product_cart_s_add->product->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_product"].options = <?php echo JsonEncode($product_cart_s_add->product->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_rid"] = <?php echo $product_cart_s_add->rid->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_rid"].options = <?php echo JsonEncode($product_cart_s_add->rid->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_packing_type"] = <?php echo $product_cart_s_add->packing_type->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_packing_type"].options = <?php echo JsonEncode($product_cart_s_add->packing_type->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_batch_no"] = <?php echo $product_cart_s_add->batch_no->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_batch_no"].options = <?php echo JsonEncode($product_cart_s_add->batch_no->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_shape"] = <?php echo $product_cart_s_add->shape->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_shape"].options = <?php echo JsonEncode($product_cart_s_add->shape->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_unit"] = <?php echo $product_cart_s_add->unit->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_unit"].options = <?php echo JsonEncode($product_cart_s_add->unit->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_currency"] = <?php echo $product_cart_s_add->currency->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_currency"].options = <?php echo JsonEncode($product_cart_s_add->currency->lookupOptions()) ?>;
fproduct_cart_sadd.lists["x_operator"] = <?php echo $product_cart_s_add->operator->Lookup->toClientList() ?>;
fproduct_cart_sadd.lists["x_operator"].options = <?php echo JsonEncode($product_cart_s_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_cart_s_add->showPageHeader(); ?>
<?php
$product_cart_s_add->showMessage();
?>
<form name="fproduct_cart_sadd" id="fproduct_cart_sadd" class="<?php echo $product_cart_s_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_s_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_s_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_s">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$product_cart_s_add->IsModal ?>">
<?php if ($product_cart_s->getCurrentMasterTable() == "material_status") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="material_status">
<input type="hidden" name="fk_id" value="<?php echo $product_cart_s->rid->getSessionValue() ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($product_cart_s->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_product_cart_s_location" for="x_location" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->location->caption() ?><?php echo ($product_cart_s->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->location->cellAttributes() ?>>
<span id="el_product_cart_s_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_location" data-value-separator="<?php echo $product_cart_s->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $product_cart_s->location->editAttributes() ?>>
		<?php echo $product_cart_s->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $product_cart_s->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $product_cart_s->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_product_cart_s_company_id" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->company_id->caption() ?><?php echo ($product_cart_s->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->company_id->cellAttributes() ?>>
<span id="el_product_cart_s_company_id">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$product_cart_s->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($product_cart_s->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->company_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->company_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_company_id" data-value-separator="<?php echo $product_cart_s->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($product_cart_s->company_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_sadd.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $product_cart_s->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $product_cart_s->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label id="elh_product_cart_s_partner_id" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->partner_id->caption() ?><?php echo ($product_cart_s->partner_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->partner_id->cellAttributes() ?>>
<span id="el_product_cart_s_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_s->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($product_cart_s->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->partner_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->partner_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_id',m:0,n:5,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->partner_id->ReadOnly || $product_cart_s->partner_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($product_cart_s->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_sadd.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $product_cart_s->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
<?php echo $product_cart_s->partner_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->partner_rid->Visible) { // partner_rid ?>
	<div id="r_partner_rid" class="form-group row">
		<label id="elh_product_cart_s_partner_rid" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->partner_rid->caption() ?><?php echo ($product_cart_s->partner_rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->partner_rid->cellAttributes() ?>>
<span id="el_product_cart_s_partner_rid">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$product_cart_s->partner_rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->partner_rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_rid" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_rid" id="sv_x_partner_rid" value="<?php echo RemoveHtml($product_cart_s->partner_rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->partner_rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->partner_rid->getPlaceHolder()) ?>"<?php echo $product_cart_s->partner_rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->partner_rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_rid',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->partner_rid->ReadOnly || $product_cart_s->partner_rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->partner_rid->displayValueSeparatorAttribute() ?>" name="x_partner_rid" id="x_partner_rid" value="<?php echo HtmlEncode($product_cart_s->partner_rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_sadd.createAutoSuggest({"id":"x_partner_rid","forceSelect":true});
</script>
<?php echo $product_cart_s->partner_rid->Lookup->getParamTag("p_x_partner_rid") ?>
</span>
<?php echo $product_cart_s->partner_rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_product_cart_s_product_type" for="x_product_type" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->product_type->caption() ?><?php echo ($product_cart_s->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->product_type->cellAttributes() ?>>
<span id="el_product_cart_s_product_type">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($product_cart_s->product_type->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $product_cart_s->product_type->ViewValue ?></button>
		<div id="dsl_x_product_type" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $product_cart_s->product_type->radioButtonListHtml(TRUE, "x_product_type") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_product_type" class="ew-template"><input type="radio" class="form-check-input" data-table="product_cart_s" data-field="x_product_type" data-value-separator="<?php echo $product_cart_s->product_type->displayValueSeparatorAttribute() ?>" name="x_product_type" id="x_product_type" value="{value}"<?php echo $product_cart_s->product_type->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$product_cart_s->product_type->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
<?php echo $product_cart_s->product_type->Lookup->getParamTag("p_x_product_type") ?>
	<?php } ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<?php echo $product_cart_s->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_product_cart_s_grp" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->grp->caption() ?><?php echo ($product_cart_s->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->grp->cellAttributes() ?>>
<span id="el_product_cart_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_s->grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_grp" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_grp" id="sv_x_grp" value="<?php echo RemoveHtml($product_cart_s->grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->grp->getPlaceHolder()) ?>"<?php echo $product_cart_s->grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->grp->ReadOnly || $product_cart_s->grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->grp->displayValueSeparatorAttribute() ?>" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($product_cart_s->grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_sadd.createAutoSuggest({"id":"x_grp","forceSelect":true});
</script>
<?php echo $product_cart_s->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $product_cart_s->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_product_cart_s_s_grp" for="x_s_grp" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->s_grp->caption() ?><?php echo ($product_cart_s->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->s_grp->cellAttributes() ?>>
<span id="el_product_cart_s_s_grp">
<?php $product_cart_s->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_s->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_s_grp"><?php echo strval($product_cart_s->s_grp->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->s_grp->ViewValue) : $product_cart_s->s_grp->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->s_grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->s_grp->ReadOnly || $product_cart_s->s_grp->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_s_grp',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_s_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="<?php echo $product_cart_s->s_grp->CurrentValue ?>"<?php echo $product_cart_s->s_grp->editAttributes() ?>>
</span>
<?php echo $product_cart_s->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_product_cart_s_product" for="x_product" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->product->caption() ?><?php echo ($product_cart_s->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->product->cellAttributes() ?>>
<span id="el_product_cart_s_product">
<?php $product_cart_s->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_s->product->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_product"><?php echo strval($product_cart_s->product->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->product->ViewValue) : $product_cart_s->product->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->product->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->product->ReadOnly || $product_cart_s->product->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_product',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->product->Lookup->getParamTag("p_x_product") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_product" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo $product_cart_s->product->CurrentValue ?>"<?php echo $product_cart_s->product->editAttributes() ?>>
</span>
<?php echo $product_cart_s->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_product_cart_s_rid" for="x_rid" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->rid->caption() ?><?php echo ($product_cart_s->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->rid->cellAttributes() ?>>
<?php if ($product_cart_s->rid->getSessionValue() <> "") { ?>
<span id="el_product_cart_s_rid">
<span<?php echo $product_cart_s->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_cart_s->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_rid" name="x_rid" value="<?php echo HtmlEncode($product_cart_s->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el_product_cart_s_rid">
<?php $product_cart_s->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_s->rid->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid"><?php echo strval($product_cart_s->rid->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->rid->ViewValue) : $product_cart_s->rid->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->rid->ReadOnly || $product_cart_s->rid->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->rid->Lookup->getParamTag("p_x_rid") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo $product_cart_s->rid->CurrentValue ?>"<?php echo $product_cart_s->rid->editAttributes() ?>>
</span>
<?php } ?>
<?php echo $product_cart_s->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_product_cart_s_packing_type" for="x_packing_type" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->packing_type->caption() ?><?php echo ($product_cart_s->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->packing_type->cellAttributes() ?>>
<span id="el_product_cart_s_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_packing_type" data-value-separator="<?php echo $product_cart_s->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $product_cart_s->packing_type->editAttributes() ?>>
		<?php echo $product_cart_s->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $product_cart_s->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $product_cart_s->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_product_cart_s_batch_no" for="x_batch_no" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->batch_no->caption() ?><?php echo ($product_cart_s->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->batch_no->cellAttributes() ?>>
<span id="el_product_cart_s_batch_no">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_batch_no"><?php echo strval($product_cart_s->batch_no->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->batch_no->ViewValue) : $product_cart_s->batch_no->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->batch_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->batch_no->ReadOnly || $product_cart_s->batch_no->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_batch_no',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_batch_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?php echo $product_cart_s->batch_no->CurrentValue ?>"<?php echo $product_cart_s->batch_no->editAttributes() ?>>
</span>
<?php echo $product_cart_s->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_product_cart_s_shape" for="x_shape" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->shape->caption() ?><?php echo ($product_cart_s->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->shape->cellAttributes() ?>>
<span id="el_product_cart_s_shape">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_shape"><?php echo strval($product_cart_s->shape->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->shape->ViewValue) : $product_cart_s->shape->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->shape->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->shape->ReadOnly || $product_cart_s->shape->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_shape',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->shape->Lookup->getParamTag("p_x_shape") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_shape" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->shape->displayValueSeparatorAttribute() ?>" name="x_shape" id="x_shape" value="<?php echo $product_cart_s->shape->CurrentValue ?>"<?php echo $product_cart_s->shape->editAttributes() ?>>
</span>
<?php echo $product_cart_s->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_product_cart_s_unit" for="x_unit" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->unit->caption() ?><?php echo ($product_cart_s->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->unit->cellAttributes() ?>>
<span id="el_product_cart_s_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_unit" data-value-separator="<?php echo $product_cart_s->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $product_cart_s->unit->editAttributes() ?>>
		<?php echo $product_cart_s->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $product_cart_s->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
<?php echo $product_cart_s->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->w->Visible) { // w ?>
	<div id="r_w" class="form-group row">
		<label id="elh_product_cart_s_w" for="x_w" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->w->caption() ?><?php echo ($product_cart_s->w->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->w->cellAttributes() ?>>
<span id="el_product_cart_s_w">
<input type="text" data-table="product_cart_s" data-field="x_w" name="x_w" id="x_w" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_s->w->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->w->EditValue ?>"<?php echo $product_cart_s->w->editAttributes() ?>>
</span>
<?php echo $product_cart_s->w->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label id="elh_product_cart_s_w_cm" for="x_w_cm" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->w_cm->caption() ?><?php echo ($product_cart_s->w_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->w_cm->cellAttributes() ?>>
<span id="el_product_cart_s_w_cm">
<input type="text" data-table="product_cart_s" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->w_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->w_cm->EditValue ?>"<?php echo $product_cart_s->w_cm->editAttributes() ?>>
</span>
<?php echo $product_cart_s->w_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->l->Visible) { // l ?>
	<div id="r_l" class="form-group row">
		<label id="elh_product_cart_s_l" for="x_l" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->l->caption() ?><?php echo ($product_cart_s->l->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->l->cellAttributes() ?>>
<span id="el_product_cart_s_l">
<input type="text" data-table="product_cart_s" data-field="x_l" name="x_l" id="x_l" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_s->l->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->l->EditValue ?>"<?php echo $product_cart_s->l->editAttributes() ?>>
</span>
<?php echo $product_cart_s->l->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label id="elh_product_cart_s_l_cm" for="x_l_cm" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->l_cm->caption() ?><?php echo ($product_cart_s->l_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->l_cm->cellAttributes() ?>>
<span id="el_product_cart_s_l_cm">
<input type="text" data-table="product_cart_s" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->l_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->l_cm->EditValue ?>"<?php echo $product_cart_s->l_cm->editAttributes() ?>>
</span>
<?php echo $product_cart_s->l_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->h->Visible) { // h ?>
	<div id="r_h" class="form-group row">
		<label id="elh_product_cart_s_h" for="x_h" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->h->caption() ?><?php echo ($product_cart_s->h->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->h->cellAttributes() ?>>
<span id="el_product_cart_s_h">
<input type="text" data-table="product_cart_s" data-field="x_h" name="x_h" id="x_h" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_s->h->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->h->EditValue ?>"<?php echo $product_cart_s->h->editAttributes() ?>>
</span>
<?php echo $product_cart_s->h->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->h_cm->Visible) { // h_cm ?>
	<div id="r_h_cm" class="form-group row">
		<label id="elh_product_cart_s_h_cm" for="x_h_cm" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->h_cm->caption() ?><?php echo ($product_cart_s->h_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->h_cm->cellAttributes() ?>>
<span id="el_product_cart_s_h_cm">
<input type="text" data-table="product_cart_s" data-field="x_h_cm" name="x_h_cm" id="x_h_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->h_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->h_cm->EditValue ?>"<?php echo $product_cart_s->h_cm->editAttributes() ?>>
</span>
<?php echo $product_cart_s->h_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->partner_size->Visible) { // partner_size ?>
	<div id="r_partner_size" class="form-group row">
		<label id="elh_product_cart_s_partner_size" for="x_partner_size" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->partner_size->caption() ?><?php echo ($product_cart_s->partner_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->partner_size->cellAttributes() ?>>
<span id="el_product_cart_s_partner_size">
<input type="text" data-table="product_cart_s" data-field="x_partner_size" name="x_partner_size" id="x_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_s->partner_size->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->partner_size->EditValue ?>"<?php echo $product_cart_s->partner_size->editAttributes() ?>>
</span>
<?php echo $product_cart_s->partner_size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_product_cart_s_sqm" for="x_sqm" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->sqm->caption() ?><?php echo ($product_cart_s->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->sqm->cellAttributes() ?>>
<span id="el_product_cart_s_sqm">
<input type="text" data-table="product_cart_s" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->sqm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->sqm->EditValue ?>"<?php echo $product_cart_s->sqm->editAttributes() ?>>
</span>
<?php echo $product_cart_s->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_product_cart_s_quantity" for="x_quantity" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->quantity->caption() ?><?php echo ($product_cart_s->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->quantity->cellAttributes() ?>>
<span id="el_product_cart_s_quantity">
<input type="text" data-table="product_cart_s" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->quantity->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->quantity->EditValue ?>"<?php echo $product_cart_s->quantity->editAttributes() ?>>
</span>
<?php echo $product_cart_s->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_product_cart_s_price" for="x_price" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->price->caption() ?><?php echo ($product_cart_s->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->price->cellAttributes() ?>>
<span id="el_product_cart_s_price">
<input type="text" data-table="product_cart_s" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->price->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->price->EditValue ?>"<?php echo $product_cart_s->price->editAttributes() ?>>
</span>
<?php echo $product_cart_s->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_product_cart_s_currency" for="x_currency" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->currency->caption() ?><?php echo ($product_cart_s->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->currency->cellAttributes() ?>>
<span id="el_product_cart_s_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_currency" data-value-separator="<?php echo $product_cart_s->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $product_cart_s->currency->editAttributes() ?>>
		<?php echo $product_cart_s->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $product_cart_s->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $product_cart_s->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_product_cart_s_amount" for="x_amount" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->amount->caption() ?><?php echo ($product_cart_s->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->amount->cellAttributes() ?>>
<span id="el_product_cart_s_amount">
<input type="text" data-table="product_cart_s" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->amount->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->amount->EditValue ?>"<?php echo $product_cart_s->amount->editAttributes() ?>>
</span>
<?php echo $product_cart_s->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->shipping_charge->Visible) { // shipping_charge ?>
	<div id="r_shipping_charge" class="form-group row">
		<label id="elh_product_cart_s_shipping_charge" for="x_shipping_charge" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->shipping_charge->caption() ?><?php echo ($product_cart_s->shipping_charge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->shipping_charge->cellAttributes() ?>>
<span id="el_product_cart_s_shipping_charge">
<input type="text" data-table="product_cart_s" data-field="x_shipping_charge" name="x_shipping_charge" id="x_shipping_charge" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->shipping_charge->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->shipping_charge->EditValue ?>"<?php echo $product_cart_s->shipping_charge->editAttributes() ?>>
</span>
<?php echo $product_cart_s->shipping_charge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label id="elh_product_cart_s_buyer_uid" for="x_buyer_uid" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->buyer_uid->caption() ?><?php echo ($product_cart_s->buyer_uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->buyer_uid->cellAttributes() ?>>
<span id="el_product_cart_s_buyer_uid">
<textarea data-table="product_cart_s" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" cols="35" rows="4" placeholder="<?php echo HtmlEncode($product_cart_s->buyer_uid->getPlaceHolder()) ?>"<?php echo $product_cart_s->buyer_uid->editAttributes() ?>><?php echo $product_cart_s->buyer_uid->EditValue ?></textarea>
</span>
<?php echo $product_cart_s->buyer_uid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->label->Visible) { // label ?>
	<div id="r_label" class="form-group row">
		<label id="elh_product_cart_s_label" for="x_label" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->label->caption() ?><?php echo ($product_cart_s->label->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->label->cellAttributes() ?>>
<span id="el_product_cart_s_label">
<textarea data-table="product_cart_s" data-field="x_label" name="x_label" id="x_label" cols="35" rows="2" placeholder="<?php echo HtmlEncode($product_cart_s->label->getPlaceHolder()) ?>"<?php echo $product_cart_s->label->editAttributes() ?>><?php echo $product_cart_s->label->EditValue ?></textarea>
</span>
<?php echo $product_cart_s->label->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_product_cart_s_remarks" for="x_remarks" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->remarks->caption() ?><?php echo ($product_cart_s->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->remarks->cellAttributes() ?>>
<span id="el_product_cart_s_remarks">
<textarea data-table="product_cart_s" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="2" placeholder="<?php echo HtmlEncode($product_cart_s->remarks->getPlaceHolder()) ?>"<?php echo $product_cart_s->remarks->editAttributes() ?>><?php echo $product_cart_s->remarks->EditValue ?></textarea>
</span>
<?php echo $product_cart_s->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_product_cart_s_product_code" for="x_product_code" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->product_code->caption() ?><?php echo ($product_cart_s->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->product_code->cellAttributes() ?>>
<span id="el_product_cart_s_product_code">
<input type="text" data-table="product_cart_s" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_s->product_code->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->product_code->EditValue ?>"<?php echo $product_cart_s->product_code->editAttributes() ?>>
</span>
<?php echo $product_cart_s->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label id="elh_product_cart_s_p_remarks" for="x_p_remarks" class="<?php echo $product_cart_s_add->LeftColumnClass ?>"><?php echo $product_cart_s->p_remarks->caption() ?><?php echo ($product_cart_s->p_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_cart_s_add->RightColumnClass ?>"><div<?php echo $product_cart_s->p_remarks->cellAttributes() ?>>
<span id="el_product_cart_s_p_remarks">
<textarea data-table="product_cart_s" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($product_cart_s->p_remarks->getPlaceHolder()) ?>"<?php echo $product_cart_s->p_remarks->editAttributes() ?>><?php echo $product_cart_s->p_remarks->EditValue ?></textarea>
</span>
<?php echo $product_cart_s->p_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_cart_s_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_cart_s_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_cart_s_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_cart_s_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");
//		var rid = getURL('fk_id');

		var ID = getURL('id');
		if (ID > 0)
		{
		var SGrp = $("#x_s_grp").val();
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
					if (data.calculation_method == '1') {
					$("#elh_product_cart_s_price").html('Price / SQM');}
					else if (data.calculation_method == '11') {
					$("#elh_product_cart_s_price").html('Price / SKU');}
					else if (data.calculation_method == '21') {
					$("#elh_product_cart_s_price").html('Price / KG');}
			 		if (data.pc_shape == '--NA--') {
					$("#x_shape").val('');
					$("#r_shape").hide(); } else {
					$("#r_shape").show();}
			 		if (data.pc_unit == '--NA--') {
					$("#x_unit").val(1);
					$("#r_unit").hide(); } else {
					$("#r_unit").show();}			 		
					if (data.pc_w == '--NA--') {
					$("#x_w").val(0);
					$("#x_w_cm").val(0);
					$("#r_w").hide();					
					$("#r_w_cm").hide();
					} else {
					$("#r_w").show();
					$("#r_w_cm").show();}
					if (data.pc_l == '--NA--') {
					$("#x_l").val(0);
					$("#x_l_cm").val(0);
					$("#r_l").hide();					
					$("#r_l_cm").hide();
					} else {
					$("#r_l").show();
					$("#r_l_cm").show();}					
					if (data.pc_h == '--NA--') {
					$("#x_h").val(0);
					$("#x_h_cm").val(0);
					$("#r_h").hide();					
					$("#r_h_cm").hide();
					} else {
					$("#r_h").show();
					$("#r_h_cm").show();}
			 		if (data.pc_partner_size == '--NA--') {
					$("#x_partner_size").val('');
					$("#r_partner_size").hide(); } else {
					$("#r_partner_size").show();}
			 		if (data.pc_sqm == '--NA--') {
					$("#x_sqm").val(0);
					$("#r_sqm").hide(); } else {
					$("#r_sqm").show();}
			 		if (data.pc_01_head == '--NA--') {
					$("#x__1").val('');
					$("#r__1").hide(); } else {
					$("#r__1").show();					
					$("#elh_product_cart_s__1").html(data.pc_01_head);}
			 		if (data.pc_02_head == '--NA--') {
					$("#x__2").val('');
					$("#r__2").hide(); } else {
					$("#r__2").show();					
					$("#elh_product_cart_s__2").html(data.pc_02_head);}
			 		if (data.pc_03_head == '--NA--') {
					$("#x__3").val('');
					$("#r__3").hide(); } else {
					$("#r__3").show();					
					$("#elh_product_cart_s__3").html(data.pc_03_head);}
			 		if (data.pc_04_head == '--NA--') {
					$("#x__4").val('');
					$("#r__4").hide(); } else {
					$("#r__4").show();					
					$("#elh_product_cart_s__4").html(data.pc_04_head);}
			 		if (data.pc_05_head == '--NA--') {
					$("#x__5").val('');
					$("#r__5").hide(); } else {
					$("#r__5").show();					
					$("#elh_product_cart_s__5").html(data.pc_05_head);}
			 		if (data.pc_06_head == '--NA--') {
					$("#x__6").val('');
					$("#r__6").hide(); } else {
					$("#r__6").show();					
					$("#elh_product_cart_s__6").html(data.pc_06_head);}
			 		if (data.pc_07_head == '--NA--') {
					$("#x__7").val('');
					$("#r__7").hide(); } else {
					$("#r__7").show();					
					$("#elh_product_cart_s__7").html(data.pc_07_head);}
			 		if (data.pc_08_head == '--NA--') {
					$("#x__8").val('');
					$("#r__8").hide(); } else {
					$("#r__8").show();					
					$("#elh_product_cart_s__8").html(data.pc_08_head);}
			});
		}
		} else {
					$("#r_sqm").hide();
					$("#r_product_type").hide();
					$("#r_shape").hide();
					$("#r_unit").hide();
					$("#r_w").hide();
					$("#r_w_cm").hide();
					$("#r_l").hide();
					$("#r_l_cm").hide();
					$("#r_h").hide();
					$("#r_h_cm").hide();
					$("#r_partner_size").hide();
					$("#r_label").hide();
					$("#r__1").hide();
					$("#r__2").hide();
					$("#r__3").hide();
					$("#r__4").hide();
					$("#r__5").hide();
					$("#r__6").hide();
					$("#r__7").hide();
					$("#r__8").hide();					
					$("#elh_product_cart_s_price").html('Price')
		}
					$.getJSON("apcajax.php?pdbyepass=9",function(data) {
			 		if (data == '2') {$("#r_batch_no").hide();}});
</script>
<?php include_once "footer.php" ?>
<?php
$product_cart_s_add->terminate();
?>