<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_s_list = new product_cart_s_list();

// Run the page
$product_cart_s_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_s_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$product_cart_s->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fproduct_cart_slist = currentForm = new ew.Form("fproduct_cart_slist", "list");
fproduct_cart_slist.formKeyCountName = '<?php echo $product_cart_s_list->FormKeyCountName ?>';

// Form_CustomValidate event
fproduct_cart_slist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_slist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_slist.lists["x_location"] = <?php echo $product_cart_s_list->location->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_location"].options = <?php echo JsonEncode($product_cart_s_list->location->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_company_id"] = <?php echo $product_cart_s_list->company_id->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_s_list->company_id->lookupOptions()) ?>;
fproduct_cart_slist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_slist.lists["x_partner_id"] = <?php echo $product_cart_s_list->partner_id->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_s_list->partner_id->lookupOptions()) ?>;
fproduct_cart_slist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_slist.lists["x_partner_rid"] = <?php echo $product_cart_s_list->partner_rid->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_partner_rid"].options = <?php echo JsonEncode($product_cart_s_list->partner_rid->lookupOptions()) ?>;
fproduct_cart_slist.autoSuggests["x_partner_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_slist.lists["x_product_type"] = <?php echo $product_cart_s_list->product_type->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_s_list->product_type->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_grp"] = <?php echo $product_cart_s_list->grp->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_grp"].options = <?php echo JsonEncode($product_cart_s_list->grp->lookupOptions()) ?>;
fproduct_cart_slist.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_slist.lists["x_s_grp"] = <?php echo $product_cart_s_list->s_grp->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_s_list->s_grp->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_product"] = <?php echo $product_cart_s_list->product->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_product"].options = <?php echo JsonEncode($product_cart_s_list->product->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_rid"] = <?php echo $product_cart_s_list->rid->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_rid"].options = <?php echo JsonEncode($product_cart_s_list->rid->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_packing_type"] = <?php echo $product_cart_s_list->packing_type->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_packing_type"].options = <?php echo JsonEncode($product_cart_s_list->packing_type->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_batch_no"] = <?php echo $product_cart_s_list->batch_no->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_batch_no"].options = <?php echo JsonEncode($product_cart_s_list->batch_no->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_shape"] = <?php echo $product_cart_s_list->shape->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_shape"].options = <?php echo JsonEncode($product_cart_s_list->shape->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_unit"] = <?php echo $product_cart_s_list->unit->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_unit"].options = <?php echo JsonEncode($product_cart_s_list->unit->lookupOptions()) ?>;
fproduct_cart_slist.lists["x_status"] = <?php echo $product_cart_s_list->status->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_status"].options = <?php echo JsonEncode($product_cart_s_list->status->options(FALSE, TRUE)) ?>;
fproduct_cart_slist.lists["x_po_id"] = <?php echo $product_cart_s_list->po_id->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_s_list->po_id->lookupOptions()) ?>;
fproduct_cart_slist.autoSuggests["x_po_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_slist.lists["x_operator"] = <?php echo $product_cart_s_list->operator->Lookup->toClientList() ?>;
fproduct_cart_slist.lists["x_operator"].options = <?php echo JsonEncode($product_cart_s_list->operator->lookupOptions()) ?>;

// Form object for search
var fproduct_cart_slistsrch = currentSearchForm = new ew.Form("fproduct_cart_slistsrch");

// Validate function for search
fproduct_cart_slistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->po_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fproduct_cart_slistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_slistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_slistsrch.lists["x_partner_id"] = <?php echo $product_cart_s_list->partner_id->Lookup->toClientList() ?>;
fproduct_cart_slistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_s_list->partner_id->lookupOptions()) ?>;
fproduct_cart_slistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_slistsrch.lists["x_rid"] = <?php echo $product_cart_s_list->rid->Lookup->toClientList() ?>;
fproduct_cart_slistsrch.lists["x_rid"].options = <?php echo JsonEncode($product_cart_s_list->rid->lookupOptions()) ?>;
fproduct_cart_slistsrch.lists["x_po_id"] = <?php echo $product_cart_s_list->po_id->Lookup->toClientList() ?>;
fproduct_cart_slistsrch.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_s_list->po_id->lookupOptions()) ?>;
fproduct_cart_slistsrch.autoSuggests["x_po_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fproduct_cart_slistsrch.filterList = <?php echo $product_cart_s_list->getFilterList() ?>;

// Init search panel as collapsed
fproduct_cart_slistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
var CreateOrder = function(CID, PID){
	  var CAID =[];
	  $("#tbl_product_cart_slist tbody input[type='checkbox']:checked").each(function(){
	  		 CAID.push($(this).val());	  		 
	  });
	  if(CAID.length>0)
	  {
	  	$.getJSON("apcajax.php?t=product_cart_s&getCIDPID=" + CAID,function(data) {
	  	location.href='po_sadd.php?CID='+ data[0] + '&PID=' + data[1] + '&CAID=' + CAID.toString();
	  	});
	  }
	  else
	  {
	  	ew.alert("Please Select atleast a row to Update");
	  }
}
					$.getJSON("apcajax.php?pdbyepass=9",function(data) {
			 		if (data == '2') {$("#r_batch_no").hide();}});	
</script>
<?php } ?>
<?php if (!$product_cart_s->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($product_cart_s_list->TotalRecs > 0 && $product_cart_s_list->ExportOptions->visible()) { ?>
<?php $product_cart_s_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_s_list->ImportOptions->visible()) { ?>
<?php $product_cart_s_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_s_list->SearchOptions->visible()) { ?>
<?php $product_cart_s_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($product_cart_s_list->FilterOptions->visible()) { ?>
<?php $product_cart_s_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$product_cart_s->isExport() || EXPORT_MASTER_RECORD && $product_cart_s->isExport("print")) { ?>
<?php
if ($product_cart_s_list->DbMasterFilter <> "" && $product_cart_s->getCurrentMasterTable() == "material_status") {
	if ($product_cart_s_list->MasterRecordExists) {
		include_once "material_statusmaster.php";
	}
}
?>
<?php } ?>
<?php
$product_cart_s_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$product_cart_s->isExport() && !$product_cart_s->CurrentAction) { ?>
<form name="fproduct_cart_slistsrch" id="fproduct_cart_slistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($product_cart_s_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fproduct_cart_slistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="product_cart_s">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$product_cart_s_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$product_cart_s->RowType = ROWTYPE_SEARCH;

// Render row
$product_cart_s->resetAttributes();
$product_cart_s_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_s->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$product_cart_s->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($product_cart_s->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->partner_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->partner_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_id',m:0,n:5,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->partner_id->ReadOnly || $product_cart_s->partner_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($product_cart_s->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_slistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $product_cart_s->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_s->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $product_cart_s->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="product_cart_s" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->rid->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->rid->EditValue ?>"<?php echo $product_cart_s->rid->editAttributes() ?>>
<?php echo $product_cart_s->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
<?php if ($product_cart_s->po_id->Visible) { // po_id ?>
	<div id="xsc_po_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $product_cart_s->po_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_id" id="z_po_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$product_cart_s->po_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->po_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_po_id" class="text-nowrap" style="z-index: 8700">
	<input type="text" class="form-control" name="sv_x_po_id" id="sv_x_po_id" value="<?php echo RemoveHtml($product_cart_s->po_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->po_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->po_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->po_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_po_id" data-value-separator="<?php echo $product_cart_s->po_id->displayValueSeparatorAttribute() ?>" name="x_po_id" id="x_po_id" value="<?php echo HtmlEncode($product_cart_s->po_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_slistsrch.createAutoSuggest({"id":"x_po_id","forceSelect":false});
</script>
<?php echo $product_cart_s->po_id->Lookup->getParamTag("p_x_po_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($product_cart_s_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($product_cart_s_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $product_cart_s_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($product_cart_s_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($product_cart_s_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($product_cart_s_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($product_cart_s_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $product_cart_s_list->showPageHeader(); ?>
<?php
$product_cart_s_list->showMessage();
?>
<?php if ($product_cart_s_list->TotalRecs > 0 || $product_cart_s->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($product_cart_s_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> product_cart_s">
<?php if (!$product_cart_s->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$product_cart_s->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_s_list->Pager)) $product_cart_s_list->Pager = new PrevNextPager($product_cart_s_list->StartRec, $product_cart_s_list->DisplayRecs, $product_cart_s_list->TotalRecs, $product_cart_s_list->AutoHidePager) ?>
<?php if ($product_cart_s_list->Pager->RecordCount > 0 && $product_cart_s_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_s_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_s_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_s_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_s_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_s_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_s_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_s_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_s_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_s_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_s_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_s_list->TotalRecs > 0 && (!$product_cart_s_list->AutoHidePageSizeSelector || $product_cart_s_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_s">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_s_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_s_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_s_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_s->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_s_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproduct_cart_slist" id="fproduct_cart_slist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_s_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_s_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_s">
<input type="hidden" name="exporttype" id="exporttype" value="">
<?php if ($product_cart_s->getCurrentMasterTable() == "material_status" && $product_cart_s->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="material_status">
<input type="hidden" name="fk_id" value="<?php echo $product_cart_s->rid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_product_cart_s" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($product_cart_s_list->TotalRecs > 0 || $product_cart_s->isGridEdit()) { ?>
<table id="tbl_product_cart_slist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$product_cart_s_list->RowType = ROWTYPE_HEADER;

// Render list options
$product_cart_s_list->renderListOptions();

// Render list options (header, left)
$product_cart_s_list->ListOptions->render("header", "left");
?>
<?php if ($product_cart_s->id->Visible) { // id ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->id) == "") { ?>
		<th data-name="id" class="<?php echo $product_cart_s->id->headerCellClass() ?>"><div id="elh_product_cart_s_id" class="product_cart_s_id"><div class="ew-table-header-caption"><?php echo $product_cart_s->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $product_cart_s->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->id) ?>',1);"><div id="elh_product_cart_s_id" class="product_cart_s_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->location->Visible) { // location ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->location) == "") { ?>
		<th data-name="location" class="<?php echo $product_cart_s->location->headerCellClass() ?>"><div id="elh_product_cart_s_location" class="product_cart_s_location"><div class="ew-table-header-caption"><?php echo $product_cart_s->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $product_cart_s->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->location) ?>',1);"><div id="elh_product_cart_s_location" class="product_cart_s_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->company_id->Visible) { // company_id ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $product_cart_s->company_id->headerCellClass() ?>"><div id="elh_product_cart_s_company_id" class="product_cart_s_company_id"><div class="ew-table-header-caption"><?php echo $product_cart_s->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $product_cart_s->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->company_id) ?>',1);"><div id="elh_product_cart_s_company_id" class="product_cart_s_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_s->partner_id->headerCellClass() ?>"><div id="elh_product_cart_s_partner_id" class="product_cart_s_partner_id"><div class="ew-table-header-caption"><?php echo $product_cart_s->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $product_cart_s->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->partner_id) ?>',1);"><div id="elh_product_cart_s_partner_id" class="product_cart_s_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->partner_rid->Visible) { // partner_rid ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->partner_rid) == "") { ?>
		<th data-name="partner_rid" class="<?php echo $product_cart_s->partner_rid->headerCellClass() ?>"><div id="elh_product_cart_s_partner_rid" class="product_cart_s_partner_rid"><div class="ew-table-header-caption"><?php echo $product_cart_s->partner_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_rid" class="<?php echo $product_cart_s->partner_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->partner_rid) ?>',1);"><div id="elh_product_cart_s_partner_rid" class="product_cart_s_partner_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->partner_rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->partner_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->partner_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->product_type->Visible) { // product_type ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $product_cart_s->product_type->headerCellClass() ?>"><div id="elh_product_cart_s_product_type" class="product_cart_s_product_type"><div class="ew-table-header-caption"><?php echo $product_cart_s->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $product_cart_s->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->product_type) ?>',1);"><div id="elh_product_cart_s_product_type" class="product_cart_s_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->grp->Visible) { // grp ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $product_cart_s->grp->headerCellClass() ?>"><div id="elh_product_cart_s_grp" class="product_cart_s_grp"><div class="ew-table-header-caption"><?php echo $product_cart_s->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $product_cart_s->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->grp) ?>',1);"><div id="elh_product_cart_s_grp" class="product_cart_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->s_grp->Visible) { // s_grp ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_s->s_grp->headerCellClass() ?>"><div id="elh_product_cart_s_s_grp" class="product_cart_s_s_grp"><div class="ew-table-header-caption"><?php echo $product_cart_s->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $product_cart_s->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->s_grp) ?>',1);"><div id="elh_product_cart_s_s_grp" class="product_cart_s_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->product->Visible) { // product ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->product) == "") { ?>
		<th data-name="product" class="<?php echo $product_cart_s->product->headerCellClass() ?>"><div id="elh_product_cart_s_product" class="product_cart_s_product"><div class="ew-table-header-caption"><?php echo $product_cart_s->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $product_cart_s->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->product) ?>',1);"><div id="elh_product_cart_s_product" class="product_cart_s_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->rid->Visible) { // rid ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $product_cart_s->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_rid" class="product_cart_s_rid"><div class="ew-table-header-caption"><?php echo $product_cart_s->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $product_cart_s->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->rid) ?>',1);"><div id="elh_product_cart_s_rid" class="product_cart_s_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->packing_type->Visible) { // packing_type ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $product_cart_s->packing_type->headerCellClass() ?>"><div id="elh_product_cart_s_packing_type" class="product_cart_s_packing_type"><div class="ew-table-header-caption"><?php echo $product_cart_s->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $product_cart_s->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->packing_type) ?>',1);"><div id="elh_product_cart_s_packing_type" class="product_cart_s_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->batch_no->Visible) { // batch_no ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $product_cart_s->batch_no->headerCellClass() ?>"><div id="elh_product_cart_s_batch_no" class="product_cart_s_batch_no"><div class="ew-table-header-caption"><?php echo $product_cart_s->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $product_cart_s->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->batch_no) ?>',1);"><div id="elh_product_cart_s_batch_no" class="product_cart_s_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->shape->Visible) { // shape ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $product_cart_s->shape->headerCellClass() ?>"><div id="elh_product_cart_s_shape" class="product_cart_s_shape"><div class="ew-table-header-caption"><?php echo $product_cart_s->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $product_cart_s->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->shape) ?>',1);"><div id="elh_product_cart_s_shape" class="product_cart_s_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->unit->Visible) { // unit ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $product_cart_s->unit->headerCellClass() ?>"><div id="elh_product_cart_s_unit" class="product_cart_s_unit"><div class="ew-table-header-caption"><?php echo $product_cart_s->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $product_cart_s->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->unit) ?>',1);"><div id="elh_product_cart_s_unit" class="product_cart_s_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->w->Visible) { // w ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->w) == "") { ?>
		<th data-name="w" class="<?php echo $product_cart_s->w->headerCellClass() ?>"><div id="elh_product_cart_s_w" class="product_cart_s_w"><div class="ew-table-header-caption"><?php echo $product_cart_s->w->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w" class="<?php echo $product_cart_s->w->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->w) ?>',1);"><div id="elh_product_cart_s_w" class="product_cart_s_w">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->w->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->w->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->w->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->w_cm->Visible) { // w_cm ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->w_cm) == "") { ?>
		<th data-name="w_cm" class="<?php echo $product_cart_s->w_cm->headerCellClass() ?>"><div id="elh_product_cart_s_w_cm" class="product_cart_s_w_cm"><div class="ew-table-header-caption"><?php echo $product_cart_s->w_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w_cm" class="<?php echo $product_cart_s->w_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->w_cm) ?>',1);"><div id="elh_product_cart_s_w_cm" class="product_cart_s_w_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->w_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->w_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->w_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->l->Visible) { // l ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->l) == "") { ?>
		<th data-name="l" class="<?php echo $product_cart_s->l->headerCellClass() ?>"><div id="elh_product_cart_s_l" class="product_cart_s_l"><div class="ew-table-header-caption"><?php echo $product_cart_s->l->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l" class="<?php echo $product_cart_s->l->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->l) ?>',1);"><div id="elh_product_cart_s_l" class="product_cart_s_l">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->l->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->l->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->l->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->l_cm->Visible) { // l_cm ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->l_cm) == "") { ?>
		<th data-name="l_cm" class="<?php echo $product_cart_s->l_cm->headerCellClass() ?>"><div id="elh_product_cart_s_l_cm" class="product_cart_s_l_cm"><div class="ew-table-header-caption"><?php echo $product_cart_s->l_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l_cm" class="<?php echo $product_cart_s->l_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->l_cm) ?>',1);"><div id="elh_product_cart_s_l_cm" class="product_cart_s_l_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->l_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->l_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->l_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->h->Visible) { // h ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->h) == "") { ?>
		<th data-name="h" class="<?php echo $product_cart_s->h->headerCellClass() ?>"><div id="elh_product_cart_s_h" class="product_cart_s_h"><div class="ew-table-header-caption"><?php echo $product_cart_s->h->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="h" class="<?php echo $product_cart_s->h->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->h) ?>',1);"><div id="elh_product_cart_s_h" class="product_cart_s_h">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->h->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->h->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->h->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->h_cm->Visible) { // h_cm ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->h_cm) == "") { ?>
		<th data-name="h_cm" class="<?php echo $product_cart_s->h_cm->headerCellClass() ?>"><div id="elh_product_cart_s_h_cm" class="product_cart_s_h_cm"><div class="ew-table-header-caption"><?php echo $product_cart_s->h_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="h_cm" class="<?php echo $product_cart_s->h_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->h_cm) ?>',1);"><div id="elh_product_cart_s_h_cm" class="product_cart_s_h_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->h_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->h_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->h_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->partner_size->Visible) { // partner_size ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->partner_size) == "") { ?>
		<th data-name="partner_size" class="<?php echo $product_cart_s->partner_size->headerCellClass() ?>"><div id="elh_product_cart_s_partner_size" class="product_cart_s_partner_size"><div class="ew-table-header-caption"><?php echo $product_cart_s->partner_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_size" class="<?php echo $product_cart_s->partner_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->partner_size) ?>',1);"><div id="elh_product_cart_s_partner_size" class="product_cart_s_partner_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->partner_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->partner_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->partner_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->quantity->Visible) { // quantity ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $product_cart_s->quantity->headerCellClass() ?>"><div id="elh_product_cart_s_quantity" class="product_cart_s_quantity"><div class="ew-table-header-caption"><?php echo $product_cart_s->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $product_cart_s->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->quantity) ?>',1);"><div id="elh_product_cart_s_quantity" class="product_cart_s_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->price->Visible) { // price ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->price) == "") { ?>
		<th data-name="price" class="<?php echo $product_cart_s->price->headerCellClass() ?>"><div id="elh_product_cart_s_price" class="product_cart_s_price"><div class="ew-table-header-caption"><?php echo $product_cart_s->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $product_cart_s->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->price) ?>',1);"><div id="elh_product_cart_s_price" class="product_cart_s_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->amount->Visible) { // amount ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $product_cart_s->amount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_amount" class="product_cart_s_amount"><div class="ew-table-header-caption"><?php echo $product_cart_s->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $product_cart_s->amount->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->amount) ?>',1);"><div id="elh_product_cart_s_amount" class="product_cart_s_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->status->Visible) { // status ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->status) == "") { ?>
		<th data-name="status" class="<?php echo $product_cart_s->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_status" class="product_cart_s_status"><div class="ew-table-header-caption"><?php echo $product_cart_s->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $product_cart_s->status->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->status) ?>',1);"><div id="elh_product_cart_s_status" class="product_cart_s_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->po_id->Visible) { // po_id ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->po_id) == "") { ?>
		<th data-name="po_id" class="<?php echo $product_cart_s->po_id->headerCellClass() ?>"><div id="elh_product_cart_s_po_id" class="product_cart_s_po_id"><div class="ew-table-header-caption"><?php echo $product_cart_s->po_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_id" class="<?php echo $product_cart_s->po_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->po_id) ?>',1);"><div id="elh_product_cart_s_po_id" class="product_cart_s_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->po_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->po_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->operator->Visible) { // operator ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $product_cart_s->operator->headerCellClass() ?>"><div id="elh_product_cart_s_operator" class="product_cart_s_operator"><div class="ew-table-header-caption"><?php echo $product_cart_s->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $product_cart_s->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->operator) ?>',1);"><div id="elh_product_cart_s_operator" class="product_cart_s_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->datetime->Visible) { // datetime ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $product_cart_s->datetime->headerCellClass() ?>"><div id="elh_product_cart_s_datetime" class="product_cart_s_datetime"><div class="ew-table-header-caption"><?php echo $product_cart_s->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $product_cart_s->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->datetime) ?>',1);"><div id="elh_product_cart_s_datetime" class="product_cart_s_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->product_code->Visible) { // product_code ?>
	<?php if ($product_cart_s->sortUrl($product_cart_s->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $product_cart_s->product_code->headerCellClass() ?>"><div id="elh_product_cart_s_product_code" class="product_cart_s_product_code"><div class="ew-table-header-caption"><?php echo $product_cart_s->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $product_cart_s->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $product_cart_s->SortUrl($product_cart_s->product_code) ?>',1);"><div id="elh_product_cart_s_product_code" class="product_cart_s_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_cart_s_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($product_cart_s->ExportAll && $product_cart_s->isExport()) {
	$product_cart_s_list->StopRec = $product_cart_s_list->TotalRecs;
} else {

	// Set the last record to display
	if ($product_cart_s_list->TotalRecs > $product_cart_s_list->StartRec + $product_cart_s_list->DisplayRecs - 1)
		$product_cart_s_list->StopRec = $product_cart_s_list->StartRec + $product_cart_s_list->DisplayRecs - 1;
	else
		$product_cart_s_list->StopRec = $product_cart_s_list->TotalRecs;
}
$product_cart_s_list->RecCnt = $product_cart_s_list->StartRec - 1;
if ($product_cart_s_list->Recordset && !$product_cart_s_list->Recordset->EOF) {
	$product_cart_s_list->Recordset->moveFirst();
	$selectLimit = $product_cart_s_list->UseSelectLimit;
	if (!$selectLimit && $product_cart_s_list->StartRec > 1)
		$product_cart_s_list->Recordset->move($product_cart_s_list->StartRec - 1);
} elseif (!$product_cart_s->AllowAddDeleteRow && $product_cart_s_list->StopRec == 0) {
	$product_cart_s_list->StopRec = $product_cart_s->GridAddRowCount;
}

// Initialize aggregate
$product_cart_s->RowType = ROWTYPE_AGGREGATEINIT;
$product_cart_s->resetAttributes();
$product_cart_s_list->renderRow();
while ($product_cart_s_list->RecCnt < $product_cart_s_list->StopRec) {
	$product_cart_s_list->RecCnt++;
	if ($product_cart_s_list->RecCnt >= $product_cart_s_list->StartRec) {
		$product_cart_s_list->RowCnt++;

		// Set up key count
		$product_cart_s_list->KeyCount = $product_cart_s_list->RowIndex;

		// Init row class and style
		$product_cart_s->resetAttributes();
		$product_cart_s->CssClass = "";
		if ($product_cart_s->isGridAdd()) {
		} else {
			$product_cart_s_list->loadRowValues($product_cart_s_list->Recordset); // Load row values
		}
		$product_cart_s->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$product_cart_s->RowAttrs = array_merge($product_cart_s->RowAttrs, array('data-rowindex'=>$product_cart_s_list->RowCnt, 'id'=>'r' . $product_cart_s_list->RowCnt . '_product_cart_s', 'data-rowtype'=>$product_cart_s->RowType));

		// Render row
		$product_cart_s_list->renderRow();

		// Render list options
		$product_cart_s_list->renderListOptions();
?>
	<tr<?php echo $product_cart_s->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_cart_s_list->ListOptions->render("body", "left", $product_cart_s_list->RowCnt);
?>
	<?php if ($product_cart_s->id->Visible) { // id ?>
		<td data-name="id"<?php echo $product_cart_s->id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_id" class="product_cart_s_id">
<span<?php echo $product_cart_s->id->viewAttributes() ?>>
<?php echo $product_cart_s->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->location->Visible) { // location ?>
		<td data-name="location"<?php echo $product_cart_s->location->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_location" class="product_cart_s_location">
<span<?php echo $product_cart_s->location->viewAttributes() ?>>
<?php echo $product_cart_s->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $product_cart_s->company_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_company_id" class="product_cart_s_company_id">
<span<?php echo $product_cart_s->company_id->viewAttributes() ?>>
<?php echo $product_cart_s->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $product_cart_s->partner_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_partner_id" class="product_cart_s_partner_id">
<span<?php echo $product_cart_s->partner_id->viewAttributes() ?>>
<?php echo $product_cart_s->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->partner_rid->Visible) { // partner_rid ?>
		<td data-name="partner_rid"<?php echo $product_cart_s->partner_rid->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_partner_rid" class="product_cart_s_partner_rid">
<span<?php echo $product_cart_s->partner_rid->viewAttributes() ?>>
<?php echo $product_cart_s->partner_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $product_cart_s->product_type->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_product_type" class="product_cart_s_product_type">
<span<?php echo $product_cart_s->product_type->viewAttributes() ?>>
<?php echo $product_cart_s->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $product_cart_s->grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_grp" class="product_cart_s_grp">
<span<?php echo $product_cart_s->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->grp->getViewValue())) && $product_cart_s->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->grp->linkAttributes() ?>><?php echo $product_cart_s->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $product_cart_s->s_grp->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_s_grp" class="product_cart_s_s_grp">
<span<?php echo $product_cart_s->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->s_grp->getViewValue())) && $product_cart_s->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->s_grp->linkAttributes() ?>><?php echo $product_cart_s->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->product->Visible) { // product ?>
		<td data-name="product"<?php echo $product_cart_s->product->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_product" class="product_cart_s_product">
<span<?php echo $product_cart_s->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->product->getViewValue())) && $product_cart_s->product->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->product->linkAttributes() ?>><?php echo $product_cart_s->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $product_cart_s->rid->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_rid" class="product_cart_s_rid">
<span<?php echo $product_cart_s->rid->viewAttributes() ?>>
<?php echo $product_cart_s->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $product_cart_s->packing_type->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_packing_type" class="product_cart_s_packing_type">
<span<?php echo $product_cart_s->packing_type->viewAttributes() ?>>
<?php echo $product_cart_s->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $product_cart_s->batch_no->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_batch_no" class="product_cart_s_batch_no">
<span<?php echo $product_cart_s->batch_no->viewAttributes() ?>>
<?php echo $product_cart_s->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $product_cart_s->shape->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_shape" class="product_cart_s_shape">
<span<?php echo $product_cart_s->shape->viewAttributes() ?>>
<?php echo $product_cart_s->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $product_cart_s->unit->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_unit" class="product_cart_s_unit">
<span<?php echo $product_cart_s->unit->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->unit->getViewValue())) && $product_cart_s->unit->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->unit->linkAttributes() ?>><?php echo $product_cart_s->unit->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->w->Visible) { // w ?>
		<td data-name="w"<?php echo $product_cart_s->w->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_w" class="product_cart_s_w">
<span<?php echo $product_cart_s->w->viewAttributes() ?>>
<?php echo $product_cart_s->w->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->w_cm->Visible) { // w_cm ?>
		<td data-name="w_cm"<?php echo $product_cart_s->w_cm->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_w_cm" class="product_cart_s_w_cm">
<span<?php echo $product_cart_s->w_cm->viewAttributes() ?>>
<?php echo $product_cart_s->w_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->l->Visible) { // l ?>
		<td data-name="l"<?php echo $product_cart_s->l->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_l" class="product_cart_s_l">
<span<?php echo $product_cart_s->l->viewAttributes() ?>>
<?php echo $product_cart_s->l->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->l_cm->Visible) { // l_cm ?>
		<td data-name="l_cm"<?php echo $product_cart_s->l_cm->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_l_cm" class="product_cart_s_l_cm">
<span<?php echo $product_cart_s->l_cm->viewAttributes() ?>>
<?php echo $product_cart_s->l_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->h->Visible) { // h ?>
		<td data-name="h"<?php echo $product_cart_s->h->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_h" class="product_cart_s_h">
<span<?php echo $product_cart_s->h->viewAttributes() ?>>
<?php echo $product_cart_s->h->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->h_cm->Visible) { // h_cm ?>
		<td data-name="h_cm"<?php echo $product_cart_s->h_cm->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_h_cm" class="product_cart_s_h_cm">
<span<?php echo $product_cart_s->h_cm->viewAttributes() ?>>
<?php echo $product_cart_s->h_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->partner_size->Visible) { // partner_size ?>
		<td data-name="partner_size"<?php echo $product_cart_s->partner_size->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_partner_size" class="product_cart_s_partner_size">
<span<?php echo $product_cart_s->partner_size->viewAttributes() ?>>
<?php echo $product_cart_s->partner_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $product_cart_s->quantity->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_quantity" class="product_cart_s_quantity">
<span<?php echo $product_cart_s->quantity->viewAttributes() ?>>
<?php echo $product_cart_s->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->price->Visible) { // price ?>
		<td data-name="price"<?php echo $product_cart_s->price->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_price" class="product_cart_s_price">
<span<?php echo $product_cart_s->price->viewAttributes() ?>>
<?php echo $product_cart_s->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $product_cart_s->amount->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_amount" class="product_cart_s_amount">
<span<?php echo $product_cart_s->amount->viewAttributes() ?>>
<?php echo $product_cart_s->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->status->Visible) { // status ?>
		<td data-name="status"<?php echo $product_cart_s->status->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_status" class="product_cart_s_status">
<span<?php echo $product_cart_s->status->viewAttributes() ?>>
<?php echo $product_cart_s->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->po_id->Visible) { // po_id ?>
		<td data-name="po_id"<?php echo $product_cart_s->po_id->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_po_id" class="product_cart_s_po_id">
<span<?php echo $product_cart_s->po_id->viewAttributes() ?>>
<?php echo $product_cart_s->po_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $product_cart_s->operator->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_operator" class="product_cart_s_operator">
<span<?php echo $product_cart_s->operator->viewAttributes() ?>>
<?php echo $product_cart_s->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $product_cart_s->datetime->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_datetime" class="product_cart_s_datetime">
<span<?php echo $product_cart_s->datetime->viewAttributes() ?>>
<?php echo $product_cart_s->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($product_cart_s->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $product_cart_s->product_code->cellAttributes() ?>>
<span id="el<?php echo $product_cart_s_list->RowCnt ?>_product_cart_s_product_code" class="product_cart_s_product_code">
<span<?php echo $product_cart_s->product_code->viewAttributes() ?>>
<?php echo $product_cart_s->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$product_cart_s_list->ListOptions->render("body", "right", $product_cart_s_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$product_cart_s->isGridAdd())
		$product_cart_s_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$product_cart_s->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($product_cart_s_list->Recordset)
	$product_cart_s_list->Recordset->Close();
?>
<?php if (!$product_cart_s->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$product_cart_s->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($product_cart_s_list->Pager)) $product_cart_s_list->Pager = new PrevNextPager($product_cart_s_list->StartRec, $product_cart_s_list->DisplayRecs, $product_cart_s_list->TotalRecs, $product_cart_s_list->AutoHidePager) ?>
<?php if ($product_cart_s_list->Pager->RecordCount > 0 && $product_cart_s_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($product_cart_s_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($product_cart_s_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $product_cart_s_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($product_cart_s_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($product_cart_s_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $product_cart_s_list->pageUrl() ?>start=<?php echo $product_cart_s_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $product_cart_s_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($product_cart_s_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $product_cart_s_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $product_cart_s_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $product_cart_s_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($product_cart_s_list->TotalRecs > 0 && (!$product_cart_s_list->AutoHidePageSizeSelector || $product_cart_s_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="product_cart_s">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($product_cart_s_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($product_cart_s_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($product_cart_s_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($product_cart_s->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $product_cart_s_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($product_cart_s_list->TotalRecs == 0 && !$product_cart_s->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $product_cart_s_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$product_cart_s_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$product_cart_s->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$product_cart_s->isExport()) { ?>
<script>
ew.scrollableTable("gmp_product_cart_s", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$product_cart_s_list->terminate();
?>