<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$product_cart_s_preview = new product_cart_s_preview();

// Run the page
$product_cart_s_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_s_preview->Page_Render();
?>
<?php $product_cart_s_preview->showPageHeader(); ?>
<div class="card ew-grid product_cart_s"><!-- .card -->
<?php if ($product_cart_s_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$product_cart_s_preview->renderListOptions();

// Render list options (header, left)
$product_cart_s_preview->ListOptions->render("header", "left");
?>
<?php if ($product_cart_s->id->Visible) { // id ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->id) == "") { ?>
		<th class="<?php echo $product_cart_s->id->headerCellClass() ?>"><?php echo $product_cart_s->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->id->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->id->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->id->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->location->Visible) { // location ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->location) == "") { ?>
		<th class="<?php echo $product_cart_s->location->headerCellClass() ?>"><?php echo $product_cart_s->location->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->location->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->location->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->location->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->location->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->company_id->Visible) { // company_id ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->company_id) == "") { ?>
		<th class="<?php echo $product_cart_s->company_id->headerCellClass() ?>"><?php echo $product_cart_s->company_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->company_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->company_id->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->company_id->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->company_id->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->partner_id) == "") { ?>
		<th class="<?php echo $product_cart_s->partner_id->headerCellClass() ?>"><?php echo $product_cart_s->partner_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->partner_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->partner_id->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->partner_id->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->partner_id->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->partner_rid->Visible) { // partner_rid ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->partner_rid) == "") { ?>
		<th class="<?php echo $product_cart_s->partner_rid->headerCellClass() ?>"><?php echo $product_cart_s->partner_rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->partner_rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->partner_rid->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->partner_rid->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->partner_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->partner_rid->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->product_type->Visible) { // product_type ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->product_type) == "") { ?>
		<th class="<?php echo $product_cart_s->product_type->headerCellClass() ?>"><?php echo $product_cart_s->product_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->product_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->product_type->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->product_type->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->product_type->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->grp->Visible) { // grp ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->grp) == "") { ?>
		<th class="<?php echo $product_cart_s->grp->headerCellClass() ?>"><?php echo $product_cart_s->grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->grp->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->grp->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->grp->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->s_grp->Visible) { // s_grp ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->s_grp) == "") { ?>
		<th class="<?php echo $product_cart_s->s_grp->headerCellClass() ?>"><?php echo $product_cart_s->s_grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->s_grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->s_grp->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->s_grp->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->s_grp->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->product->Visible) { // product ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->product) == "") { ?>
		<th class="<?php echo $product_cart_s->product->headerCellClass() ?>"><?php echo $product_cart_s->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->product->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->product->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->product->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->rid->Visible) { // rid ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->rid) == "") { ?>
		<th class="<?php echo $product_cart_s->rid->headerCellClass() ?>"><?php echo $product_cart_s->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->rid->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->rid->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->rid->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->packing_type->Visible) { // packing_type ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->packing_type) == "") { ?>
		<th class="<?php echo $product_cart_s->packing_type->headerCellClass() ?>"><?php echo $product_cart_s->packing_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->packing_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->packing_type->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->packing_type->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->packing_type->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->batch_no->Visible) { // batch_no ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->batch_no) == "") { ?>
		<th class="<?php echo $product_cart_s->batch_no->headerCellClass() ?>"><?php echo $product_cart_s->batch_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->batch_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->batch_no->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->batch_no->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->batch_no->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->shape->Visible) { // shape ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->shape) == "") { ?>
		<th class="<?php echo $product_cart_s->shape->headerCellClass() ?>"><?php echo $product_cart_s->shape->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->shape->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->shape->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->shape->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->shape->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->unit->Visible) { // unit ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->unit) == "") { ?>
		<th class="<?php echo $product_cart_s->unit->headerCellClass() ?>"><?php echo $product_cart_s->unit->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->unit->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->unit->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->unit->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->unit->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->w->Visible) { // w ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->w) == "") { ?>
		<th class="<?php echo $product_cart_s->w->headerCellClass() ?>"><?php echo $product_cart_s->w->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->w->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->w->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->w->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->w->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->w->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->w_cm->Visible) { // w_cm ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->w_cm) == "") { ?>
		<th class="<?php echo $product_cart_s->w_cm->headerCellClass() ?>"><?php echo $product_cart_s->w_cm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->w_cm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->w_cm->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->w_cm->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->w_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->w_cm->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->l->Visible) { // l ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->l) == "") { ?>
		<th class="<?php echo $product_cart_s->l->headerCellClass() ?>"><?php echo $product_cart_s->l->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->l->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->l->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->l->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->l->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->l->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->l_cm->Visible) { // l_cm ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->l_cm) == "") { ?>
		<th class="<?php echo $product_cart_s->l_cm->headerCellClass() ?>"><?php echo $product_cart_s->l_cm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->l_cm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->l_cm->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->l_cm->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->l_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->l_cm->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->h->Visible) { // h ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->h) == "") { ?>
		<th class="<?php echo $product_cart_s->h->headerCellClass() ?>"><?php echo $product_cart_s->h->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->h->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->h->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->h->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->h->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->h->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->h_cm->Visible) { // h_cm ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->h_cm) == "") { ?>
		<th class="<?php echo $product_cart_s->h_cm->headerCellClass() ?>"><?php echo $product_cart_s->h_cm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->h_cm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->h_cm->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->h_cm->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->h_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->h_cm->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->partner_size->Visible) { // partner_size ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->partner_size) == "") { ?>
		<th class="<?php echo $product_cart_s->partner_size->headerCellClass() ?>"><?php echo $product_cart_s->partner_size->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->partner_size->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->partner_size->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->partner_size->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->partner_size->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->partner_size->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->quantity->Visible) { // quantity ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->quantity) == "") { ?>
		<th class="<?php echo $product_cart_s->quantity->headerCellClass() ?>"><?php echo $product_cart_s->quantity->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->quantity->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->quantity->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->quantity->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->quantity->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->price->Visible) { // price ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->price) == "") { ?>
		<th class="<?php echo $product_cart_s->price->headerCellClass() ?>"><?php echo $product_cart_s->price->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->price->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->price->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->price->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->price->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->amount->Visible) { // amount ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->amount) == "") { ?>
		<th class="<?php echo $product_cart_s->amount->headerCellClass() ?>"><?php echo $product_cart_s->amount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->amount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->amount->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->amount->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->amount->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->status->Visible) { // status ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->status) == "") { ?>
		<th class="<?php echo $product_cart_s->status->headerCellClass() ?>"><?php echo $product_cart_s->status->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->status->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->status->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->status->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->status->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->po_id->Visible) { // po_id ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->po_id) == "") { ?>
		<th class="<?php echo $product_cart_s->po_id->headerCellClass() ?>"><?php echo $product_cart_s->po_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->po_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->po_id->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->po_id->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->po_id->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->operator->Visible) { // operator ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->operator) == "") { ?>
		<th class="<?php echo $product_cart_s->operator->headerCellClass() ?>"><?php echo $product_cart_s->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->operator->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->operator->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->operator->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->datetime->Visible) { // datetime ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->datetime) == "") { ?>
		<th class="<?php echo $product_cart_s->datetime->headerCellClass() ?>"><?php echo $product_cart_s->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->datetime->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->datetime->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->datetime->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($product_cart_s->product_code->Visible) { // product_code ?>
	<?php if ($product_cart_s->SortUrl($product_cart_s->product_code) == "") { ?>
		<th class="<?php echo $product_cart_s->product_code->headerCellClass() ?>"><?php echo $product_cart_s->product_code->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $product_cart_s->product_code->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($product_cart_s->product_code->Name) ?>" data-sort-order="<?php echo $product_cart_s_preview->SortField == $product_cart_s->product_code->Name && $product_cart_s_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $product_cart_s->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($product_cart_s_preview->SortField == $product_cart_s->product_code->Name) { ?><?php if ($product_cart_s_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($product_cart_s_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$product_cart_s_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$product_cart_s_preview->RecCount = 0;
$product_cart_s_preview->RowCnt = 0;
while ($product_cart_s_preview->Recordset && !$product_cart_s_preview->Recordset->EOF) {

	// Init row class and style
	$product_cart_s_preview->RecCount++;
	$product_cart_s_preview->RowCnt++;
	$product_cart_s_preview->CssStyle = "";
	$product_cart_s_preview->loadListRowValues($product_cart_s_preview->Recordset);

	// Render row
	$product_cart_s_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$product_cart_s_preview->resetAttributes();
	$product_cart_s_preview->renderListRow();

	// Render list options
	$product_cart_s_preview->renderListOptions();
?>
	<tr<?php echo $product_cart_s_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$product_cart_s_preview->ListOptions->render("body", "left", $product_cart_s_preview->RowCnt);
?>
<?php if ($product_cart_s->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $product_cart_s->id->cellAttributes() ?>>
<span<?php echo $product_cart_s->id->viewAttributes() ?>>
<?php echo $product_cart_s->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->location->Visible) { // location ?>
		<!-- location -->
		<td<?php echo $product_cart_s->location->cellAttributes() ?>>
<span<?php echo $product_cart_s->location->viewAttributes() ?>>
<?php echo $product_cart_s->location->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->company_id->Visible) { // company_id ?>
		<!-- company_id -->
		<td<?php echo $product_cart_s->company_id->cellAttributes() ?>>
<span<?php echo $product_cart_s->company_id->viewAttributes() ?>>
<?php echo $product_cart_s->company_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
		<!-- partner_id -->
		<td<?php echo $product_cart_s->partner_id->cellAttributes() ?>>
<span<?php echo $product_cart_s->partner_id->viewAttributes() ?>>
<?php echo $product_cart_s->partner_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->partner_rid->Visible) { // partner_rid ?>
		<!-- partner_rid -->
		<td<?php echo $product_cart_s->partner_rid->cellAttributes() ?>>
<span<?php echo $product_cart_s->partner_rid->viewAttributes() ?>>
<?php echo $product_cart_s->partner_rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->product_type->Visible) { // product_type ?>
		<!-- product_type -->
		<td<?php echo $product_cart_s->product_type->cellAttributes() ?>>
<span<?php echo $product_cart_s->product_type->viewAttributes() ?>>
<?php echo $product_cart_s->product_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->grp->Visible) { // grp ?>
		<!-- grp -->
		<td<?php echo $product_cart_s->grp->cellAttributes() ?>>
<span<?php echo $product_cart_s->grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->grp->getViewValue())) && $product_cart_s->grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->grp->linkAttributes() ?>><?php echo $product_cart_s->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_s->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td<?php echo $product_cart_s->s_grp->cellAttributes() ?>>
<span<?php echo $product_cart_s->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->s_grp->getViewValue())) && $product_cart_s->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->s_grp->linkAttributes() ?>><?php echo $product_cart_s->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->s_grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_s->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $product_cart_s->product->cellAttributes() ?>>
<span<?php echo $product_cart_s->product->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->product->getViewValue())) && $product_cart_s->product->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->product->linkAttributes() ?>><?php echo $product_cart_s->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_s->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $product_cart_s->rid->cellAttributes() ?>>
<span<?php echo $product_cart_s->rid->viewAttributes() ?>>
<?php echo $product_cart_s->rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td<?php echo $product_cart_s->packing_type->cellAttributes() ?>>
<span<?php echo $product_cart_s->packing_type->viewAttributes() ?>>
<?php echo $product_cart_s->packing_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td<?php echo $product_cart_s->batch_no->cellAttributes() ?>>
<span<?php echo $product_cart_s->batch_no->viewAttributes() ?>>
<?php echo $product_cart_s->batch_no->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->shape->Visible) { // shape ?>
		<!-- shape -->
		<td<?php echo $product_cart_s->shape->cellAttributes() ?>>
<span<?php echo $product_cart_s->shape->viewAttributes() ?>>
<?php echo $product_cart_s->shape->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->unit->Visible) { // unit ?>
		<!-- unit -->
		<td<?php echo $product_cart_s->unit->cellAttributes() ?>>
<span<?php echo $product_cart_s->unit->viewAttributes() ?>>
<?php if ((!EmptyString($product_cart_s->unit->getViewValue())) && $product_cart_s->unit->linkAttributes() <> "") { ?>
<a<?php echo $product_cart_s->unit->linkAttributes() ?>><?php echo $product_cart_s->unit->getViewValue() ?></a>
<?php } else { ?>
<?php echo $product_cart_s->unit->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($product_cart_s->w->Visible) { // w ?>
		<!-- w -->
		<td<?php echo $product_cart_s->w->cellAttributes() ?>>
<span<?php echo $product_cart_s->w->viewAttributes() ?>>
<?php echo $product_cart_s->w->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->w_cm->Visible) { // w_cm ?>
		<!-- w_cm -->
		<td<?php echo $product_cart_s->w_cm->cellAttributes() ?>>
<span<?php echo $product_cart_s->w_cm->viewAttributes() ?>>
<?php echo $product_cart_s->w_cm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->l->Visible) { // l ?>
		<!-- l -->
		<td<?php echo $product_cart_s->l->cellAttributes() ?>>
<span<?php echo $product_cart_s->l->viewAttributes() ?>>
<?php echo $product_cart_s->l->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->l_cm->Visible) { // l_cm ?>
		<!-- l_cm -->
		<td<?php echo $product_cart_s->l_cm->cellAttributes() ?>>
<span<?php echo $product_cart_s->l_cm->viewAttributes() ?>>
<?php echo $product_cart_s->l_cm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->h->Visible) { // h ?>
		<!-- h -->
		<td<?php echo $product_cart_s->h->cellAttributes() ?>>
<span<?php echo $product_cart_s->h->viewAttributes() ?>>
<?php echo $product_cart_s->h->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->h_cm->Visible) { // h_cm ?>
		<!-- h_cm -->
		<td<?php echo $product_cart_s->h_cm->cellAttributes() ?>>
<span<?php echo $product_cart_s->h_cm->viewAttributes() ?>>
<?php echo $product_cart_s->h_cm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->partner_size->Visible) { // partner_size ?>
		<!-- partner_size -->
		<td<?php echo $product_cart_s->partner_size->cellAttributes() ?>>
<span<?php echo $product_cart_s->partner_size->viewAttributes() ?>>
<?php echo $product_cart_s->partner_size->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td<?php echo $product_cart_s->quantity->cellAttributes() ?>>
<span<?php echo $product_cart_s->quantity->viewAttributes() ?>>
<?php echo $product_cart_s->quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->price->Visible) { // price ?>
		<!-- price -->
		<td<?php echo $product_cart_s->price->cellAttributes() ?>>
<span<?php echo $product_cart_s->price->viewAttributes() ?>>
<?php echo $product_cart_s->price->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->amount->Visible) { // amount ?>
		<!-- amount -->
		<td<?php echo $product_cart_s->amount->cellAttributes() ?>>
<span<?php echo $product_cart_s->amount->viewAttributes() ?>>
<?php echo $product_cart_s->amount->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->status->Visible) { // status ?>
		<!-- status -->
		<td<?php echo $product_cart_s->status->cellAttributes() ?>>
<span<?php echo $product_cart_s->status->viewAttributes() ?>>
<?php echo $product_cart_s->status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->po_id->Visible) { // po_id ?>
		<!-- po_id -->
		<td<?php echo $product_cart_s->po_id->cellAttributes() ?>>
<span<?php echo $product_cart_s->po_id->viewAttributes() ?>>
<?php echo $product_cart_s->po_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $product_cart_s->operator->cellAttributes() ?>>
<span<?php echo $product_cart_s->operator->viewAttributes() ?>>
<?php echo $product_cart_s->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $product_cart_s->datetime->cellAttributes() ?>>
<span<?php echo $product_cart_s->datetime->viewAttributes() ?>>
<?php echo $product_cart_s->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($product_cart_s->product_code->Visible) { // product_code ?>
		<!-- product_code -->
		<td<?php echo $product_cart_s->product_code->cellAttributes() ?>>
<span<?php echo $product_cart_s->product_code->viewAttributes() ?>>
<?php echo $product_cart_s->product_code->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$product_cart_s_preview->ListOptions->render("body", "right", $product_cart_s_preview->RowCnt);
?>
	</tr>
<?php
	$product_cart_s_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($product_cart_s_preview->TotalRecs > 0) { ?>
<?php if (!isset($product_cart_s_preview->Pager)) $product_cart_s_preview->Pager = new PrevNextPager($product_cart_s_preview->StartRec, $product_cart_s_preview->DisplayRecs, $product_cart_s_preview->TotalRecs) ?>
<?php if ($product_cart_s_preview->Pager->RecordCount > 0 && $product_cart_s_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($product_cart_s_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $product_cart_s_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($product_cart_s_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $product_cart_s_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($product_cart_s_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $product_cart_s_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($product_cart_s_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $product_cart_s_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $product_cart_s_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $product_cart_s_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $product_cart_s_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($product_cart_s_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$product_cart_s_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($product_cart_s_preview->Recordset)
	$product_cart_s_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$product_cart_s_preview->terminate();
?>