<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_s_search = new product_cart_s_search();

// Run the page
$product_cart_s_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_s_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($product_cart_s_search->IsModal) { ?>
var fproduct_cart_ssearch = currentAdvancedSearchForm = new ew.Form("fproduct_cart_ssearch", "search");
<?php } else { ?>
var fproduct_cart_ssearch = currentForm = new ew.Form("fproduct_cart_ssearch", "search");
<?php } ?>

// Form_CustomValidate event
fproduct_cart_ssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_ssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_ssearch.lists["x_location"] = <?php echo $product_cart_s_search->location->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_location"].options = <?php echo JsonEncode($product_cart_s_search->location->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_company_id"] = <?php echo $product_cart_s_search->company_id->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_company_id"].options = <?php echo JsonEncode($product_cart_s_search->company_id->lookupOptions()) ?>;
fproduct_cart_ssearch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_ssearch.lists["x_partner_id"] = <?php echo $product_cart_s_search->partner_id->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_s_search->partner_id->lookupOptions()) ?>;
fproduct_cart_ssearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_ssearch.lists["x_partner_rid"] = <?php echo $product_cart_s_search->partner_rid->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_partner_rid"].options = <?php echo JsonEncode($product_cart_s_search->partner_rid->lookupOptions()) ?>;
fproduct_cart_ssearch.autoSuggests["x_partner_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_ssearch.lists["x_product_type"] = <?php echo $product_cart_s_search->product_type->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_product_type"].options = <?php echo JsonEncode($product_cart_s_search->product_type->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_grp"] = <?php echo $product_cart_s_search->grp->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_grp"].options = <?php echo JsonEncode($product_cart_s_search->grp->lookupOptions()) ?>;
fproduct_cart_ssearch.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_ssearch.lists["x_s_grp"] = <?php echo $product_cart_s_search->s_grp->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_s_grp"].options = <?php echo JsonEncode($product_cart_s_search->s_grp->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_product"] = <?php echo $product_cart_s_search->product->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_product"].options = <?php echo JsonEncode($product_cart_s_search->product->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_rid"] = <?php echo $product_cart_s_search->rid->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_rid"].options = <?php echo JsonEncode($product_cart_s_search->rid->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_packing_type"] = <?php echo $product_cart_s_search->packing_type->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_packing_type"].options = <?php echo JsonEncode($product_cart_s_search->packing_type->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_batch_no"] = <?php echo $product_cart_s_search->batch_no->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_batch_no"].options = <?php echo JsonEncode($product_cart_s_search->batch_no->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_shape"] = <?php echo $product_cart_s_search->shape->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_shape"].options = <?php echo JsonEncode($product_cart_s_search->shape->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_unit"] = <?php echo $product_cart_s_search->unit->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_unit"].options = <?php echo JsonEncode($product_cart_s_search->unit->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_currency"] = <?php echo $product_cart_s_search->currency->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_currency"].options = <?php echo JsonEncode($product_cart_s_search->currency->lookupOptions()) ?>;
fproduct_cart_ssearch.lists["x_po_id"] = <?php echo $product_cart_s_search->po_id->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_po_id"].options = <?php echo JsonEncode($product_cart_s_search->po_id->lookupOptions()) ?>;
fproduct_cart_ssearch.autoSuggests["x_po_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fproduct_cart_ssearch.lists["x_operator"] = <?php echo $product_cart_s_search->operator->Lookup->toClientList() ?>;
fproduct_cart_ssearch.lists["x_operator"].options = <?php echo JsonEncode($product_cart_s_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fproduct_cart_ssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_w_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->w_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_l_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->l_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_h_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->h_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->po_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($product_cart_s->cbm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_cart_s_search->showPageHeader(); ?>
<?php
$product_cart_s_search->showMessage();
?>
<form name="fproduct_cart_ssearch" id="fproduct_cart_ssearch" class="<?php echo $product_cart_s_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_s_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_s_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_s">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$product_cart_s_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($product_cart_s->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_id"><?php echo $product_cart_s->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->id->cellAttributes() ?>>
			<span id="el_product_cart_s_id">
<input type="text" data-table="product_cart_s" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($product_cart_s->id->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->id->EditValue ?>"<?php echo $product_cart_s->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_location"><?php echo $product_cart_s->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->location->cellAttributes() ?>>
			<span id="el_product_cart_s_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_location" data-value-separator="<?php echo $product_cart_s->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $product_cart_s->location->editAttributes() ?>>
		<?php echo $product_cart_s->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $product_cart_s->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_company_id"><?php echo $product_cart_s->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->company_id->cellAttributes() ?>>
			<span id="el_product_cart_s_company_id">
<?php
$wrkonchange = "" . trim(@$product_cart_s->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($product_cart_s->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->company_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->company_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_company_id" data-value-separator="<?php echo $product_cart_s->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($product_cart_s->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_ssearch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $product_cart_s->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_partner_id"><?php echo $product_cart_s->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->partner_id->cellAttributes() ?>>
			<span id="el_product_cart_s_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_s->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($product_cart_s->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->partner_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->partner_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_id',m:0,n:5,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->partner_id->ReadOnly || $product_cart_s->partner_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($product_cart_s->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_ssearch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $product_cart_s->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->partner_rid->Visible) { // partner_rid ?>
	<div id="r_partner_rid" class="form-group row">
		<label class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_partner_rid"><?php echo $product_cart_s->partner_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_rid" id="z_partner_rid" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->partner_rid->cellAttributes() ?>>
			<span id="el_product_cart_s_partner_rid">
<?php
$wrkonchange = "" . trim(@$product_cart_s->partner_rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->partner_rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_rid" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_rid" id="sv_x_partner_rid" value="<?php echo RemoveHtml($product_cart_s->partner_rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->partner_rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->partner_rid->getPlaceHolder()) ?>"<?php echo $product_cart_s->partner_rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->partner_rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_rid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->partner_rid->ReadOnly || $product_cart_s->partner_rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->partner_rid->displayValueSeparatorAttribute() ?>" name="x_partner_rid" id="x_partner_rid" value="<?php echo HtmlEncode($product_cart_s->partner_rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_ssearch.createAutoSuggest({"id":"x_partner_rid","forceSelect":false});
</script>
<?php echo $product_cart_s->partner_rid->Lookup->getParamTag("p_x_partner_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_product_type"><?php echo $product_cart_s->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->product_type->cellAttributes() ?>>
			<span id="el_product_cart_s_product_type">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($product_cart_s->product_type->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $product_cart_s->product_type->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_product_type" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $product_cart_s->product_type->radioButtonListHtml(TRUE, "x_product_type") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_product_type" class="ew-template"><input type="radio" class="form-check-input" data-table="product_cart_s" data-field="x_product_type" data-value-separator="<?php echo $product_cart_s->product_type->displayValueSeparatorAttribute() ?>" name="x_product_type" id="x_product_type" value="{value}"<?php echo $product_cart_s->product_type->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$product_cart_s->product_type->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
<?php echo $product_cart_s->product_type->Lookup->getParamTag("p_x_product_type") ?>
	<?php } ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_grp"><?php echo $product_cart_s->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->grp->cellAttributes() ?>>
			<span id="el_product_cart_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$product_cart_s->grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_grp" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_grp" id="sv_x_grp" value="<?php echo RemoveHtml($product_cart_s->grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->grp->getPlaceHolder()) ?>"<?php echo $product_cart_s->grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->grp->ReadOnly || $product_cart_s->grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->grp->displayValueSeparatorAttribute() ?>" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($product_cart_s->grp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_ssearch.createAutoSuggest({"id":"x_grp","forceSelect":true});
</script>
<?php echo $product_cart_s->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_s_grp"><?php echo $product_cart_s->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->s_grp->cellAttributes() ?>>
			<span id="el_product_cart_s_s_grp">
<?php $product_cart_s->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_s->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_s_grp"><?php echo strval($product_cart_s->s_grp->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->s_grp->AdvancedSearch->ViewValue) : $product_cart_s->s_grp->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->s_grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->s_grp->ReadOnly || $product_cart_s->s_grp->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_s_grp',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_s_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="<?php echo $product_cart_s->s_grp->AdvancedSearch->SearchValue ?>"<?php echo $product_cart_s->s_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_product"><?php echo $product_cart_s->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->product->cellAttributes() ?>>
			<span id="el_product_cart_s_product">
<?php $product_cart_s->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_cart_s->product->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_product"><?php echo strval($product_cart_s->product->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->product->AdvancedSearch->ViewValue) : $product_cart_s->product->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->product->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->product->ReadOnly || $product_cart_s->product->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_product',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->product->Lookup->getParamTag("p_x_product") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_product" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo $product_cart_s->product->AdvancedSearch->SearchValue ?>"<?php echo $product_cart_s->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_rid"><?php echo $product_cart_s->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->rid->cellAttributes() ?>>
			<span id="el_product_cart_s_rid">
<input type="text" data-table="product_cart_s" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->rid->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->rid->EditValue ?>"<?php echo $product_cart_s->rid->editAttributes() ?>>
<?php echo $product_cart_s->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_packing_type"><?php echo $product_cart_s->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->packing_type->cellAttributes() ?>>
			<span id="el_product_cart_s_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_packing_type" data-value-separator="<?php echo $product_cart_s->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $product_cart_s->packing_type->editAttributes() ?>>
		<?php echo $product_cart_s->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $product_cart_s->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_batch_no"><?php echo $product_cart_s->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->batch_no->cellAttributes() ?>>
			<span id="el_product_cart_s_batch_no">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_batch_no"><?php echo strval($product_cart_s->batch_no->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->batch_no->AdvancedSearch->ViewValue) : $product_cart_s->batch_no->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->batch_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->batch_no->ReadOnly || $product_cart_s->batch_no->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_batch_no',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_batch_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?php echo $product_cart_s->batch_no->AdvancedSearch->SearchValue ?>"<?php echo $product_cart_s->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_shape"><?php echo $product_cart_s->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->shape->cellAttributes() ?>>
			<span id="el_product_cart_s_shape">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_shape"><?php echo strval($product_cart_s->shape->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($product_cart_s->shape->AdvancedSearch->ViewValue) : $product_cart_s->shape->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->shape->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->shape->ReadOnly || $product_cart_s->shape->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_shape',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $product_cart_s->shape->Lookup->getParamTag("p_x_shape") ?>
<input type="hidden" data-table="product_cart_s" data-field="x_shape" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->shape->displayValueSeparatorAttribute() ?>" name="x_shape" id="x_shape" value="<?php echo $product_cart_s->shape->AdvancedSearch->SearchValue ?>"<?php echo $product_cart_s->shape->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_unit"><?php echo $product_cart_s->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->unit->cellAttributes() ?>>
			<span id="el_product_cart_s_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_unit" data-value-separator="<?php echo $product_cart_s->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $product_cart_s->unit->editAttributes() ?>>
		<?php echo $product_cart_s->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $product_cart_s->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->w->Visible) { // w ?>
	<div id="r_w" class="form-group row">
		<label for="x_w" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_w"><?php echo $product_cart_s->w->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_w" id="z_w" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->w->cellAttributes() ?>>
			<span id="el_product_cart_s_w">
<input type="text" data-table="product_cart_s" data-field="x_w" name="x_w" id="x_w" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_s->w->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->w->EditValue ?>"<?php echo $product_cart_s->w->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label for="x_w_cm" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_w_cm"><?php echo $product_cart_s->w_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_w_cm" id="z_w_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->w_cm->cellAttributes() ?>>
			<span id="el_product_cart_s_w_cm">
<input type="text" data-table="product_cart_s" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->w_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->w_cm->EditValue ?>"<?php echo $product_cart_s->w_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->l->Visible) { // l ?>
	<div id="r_l" class="form-group row">
		<label for="x_l" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_l"><?php echo $product_cart_s->l->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_l" id="z_l" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->l->cellAttributes() ?>>
			<span id="el_product_cart_s_l">
<input type="text" data-table="product_cart_s" data-field="x_l" name="x_l" id="x_l" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_s->l->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->l->EditValue ?>"<?php echo $product_cart_s->l->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label for="x_l_cm" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_l_cm"><?php echo $product_cart_s->l_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_l_cm" id="z_l_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->l_cm->cellAttributes() ?>>
			<span id="el_product_cart_s_l_cm">
<input type="text" data-table="product_cart_s" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->l_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->l_cm->EditValue ?>"<?php echo $product_cart_s->l_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->h->Visible) { // h ?>
	<div id="r_h" class="form-group row">
		<label for="x_h" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_h"><?php echo $product_cart_s->h->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_h" id="z_h" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->h->cellAttributes() ?>>
			<span id="el_product_cart_s_h">
<input type="text" data-table="product_cart_s" data-field="x_h" name="x_h" id="x_h" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($product_cart_s->h->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->h->EditValue ?>"<?php echo $product_cart_s->h->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->h_cm->Visible) { // h_cm ?>
	<div id="r_h_cm" class="form-group row">
		<label for="x_h_cm" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_h_cm"><?php echo $product_cart_s->h_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_h_cm" id="z_h_cm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->h_cm->cellAttributes() ?>>
			<span id="el_product_cart_s_h_cm">
<input type="text" data-table="product_cart_s" data-field="x_h_cm" name="x_h_cm" id="x_h_cm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->h_cm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->h_cm->EditValue ?>"<?php echo $product_cart_s->h_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->partner_size->Visible) { // partner_size ?>
	<div id="r_partner_size" class="form-group row">
		<label for="x_partner_size" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_partner_size"><?php echo $product_cart_s->partner_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_size" id="z_partner_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->partner_size->cellAttributes() ?>>
			<span id="el_product_cart_s_partner_size">
<input type="text" data-table="product_cart_s" data-field="x_partner_size" name="x_partner_size" id="x_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_s->partner_size->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->partner_size->EditValue ?>"<?php echo $product_cart_s->partner_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_size"><?php echo $product_cart_s->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->size->cellAttributes() ?>>
			<span id="el_product_cart_s_size">
<input type="text" data-table="product_cart_s" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_cart_s->size->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->size->EditValue ?>"<?php echo $product_cart_s->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_sqm"><?php echo $product_cart_s->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->sqm->cellAttributes() ?>>
			<span id="el_product_cart_s_sqm">
<input type="text" data-table="product_cart_s" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->sqm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->sqm->EditValue ?>"<?php echo $product_cart_s->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_quantity"><?php echo $product_cart_s->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->quantity->cellAttributes() ?>>
			<span id="el_product_cart_s_quantity">
<input type="text" data-table="product_cart_s" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->quantity->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->quantity->EditValue ?>"<?php echo $product_cart_s->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_price"><?php echo $product_cart_s->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->price->cellAttributes() ?>>
			<span id="el_product_cart_s_price">
<input type="text" data-table="product_cart_s" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->price->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->price->EditValue ?>"<?php echo $product_cart_s->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_currency"><?php echo $product_cart_s->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->currency->cellAttributes() ?>>
			<span id="el_product_cart_s_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_currency" data-value-separator="<?php echo $product_cart_s->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $product_cart_s->currency->editAttributes() ?>>
		<?php echo $product_cart_s->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $product_cart_s->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group row">
		<label class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_po_id"><?php echo $product_cart_s->po_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_id" id="z_po_id" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->po_id->cellAttributes() ?>>
			<span id="el_product_cart_s_po_id">
<?php
$wrkonchange = "" . trim(@$product_cart_s->po_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->po_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_po_id" class="text-nowrap" style="z-index: 8700">
	<input type="text" class="form-control" name="sv_x_po_id" id="sv_x_po_id" value="<?php echo RemoveHtml($product_cart_s->po_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->po_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->po_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->po_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_po_id" data-value-separator="<?php echo $product_cart_s->po_id->displayValueSeparatorAttribute() ?>" name="x_po_id" id="x_po_id" value="<?php echo HtmlEncode($product_cart_s->po_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_ssearch.createAutoSuggest({"id":"x_po_id","forceSelect":false});
</script>
<?php echo $product_cart_s->po_id->Lookup->getParamTag("p_x_po_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_cbm"><?php echo $product_cart_s->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->cbm->cellAttributes() ?>>
			<span id="el_product_cart_s_cbm">
<input type="text" data-table="product_cart_s" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->cbm->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->cbm->EditValue ?>"<?php echo $product_cart_s->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_buyer_uid"><?php echo $product_cart_s->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->buyer_uid->cellAttributes() ?>>
			<span id="el_product_cart_s_buyer_uid">
<input type="text" data-table="product_cart_s" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="35" placeholder="<?php echo HtmlEncode($product_cart_s->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->buyer_uid->EditValue ?>"<?php echo $product_cart_s->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->label->Visible) { // label ?>
	<div id="r_label" class="form-group row">
		<label for="x_label" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_label"><?php echo $product_cart_s->label->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_label" id="z_label" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->label->cellAttributes() ?>>
			<span id="el_product_cart_s_label">
<input type="text" data-table="product_cart_s" data-field="x_label" name="x_label" id="x_label" maxlength="96" placeholder="<?php echo HtmlEncode($product_cart_s->label->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->label->EditValue ?>"<?php echo $product_cart_s->label->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_remarks"><?php echo $product_cart_s->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->remarks->cellAttributes() ?>>
			<span id="el_product_cart_s_remarks">
<input type="text" data-table="product_cart_s" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="255" placeholder="<?php echo HtmlEncode($product_cart_s->remarks->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->remarks->EditValue ?>"<?php echo $product_cart_s->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_operator"><?php echo $product_cart_s->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->operator->cellAttributes() ?>>
			<span id="el_product_cart_s_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_cart_s" data-field="x_operator" data-value-separator="<?php echo $product_cart_s->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $product_cart_s->operator->editAttributes() ?>>
		<?php echo $product_cart_s->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $product_cart_s->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_datetime"><?php echo $product_cart_s->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->datetime->cellAttributes() ?>>
			<span id="el_product_cart_s_datetime">
<input type="text" data-table="product_cart_s" data-field="x_datetime" data-format="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($product_cart_s->datetime->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->datetime->EditValue ?>"<?php echo $product_cart_s->datetime->editAttributes() ?>>
<?php if (!$product_cart_s->datetime->ReadOnly && !$product_cart_s->datetime->Disabled && !isset($product_cart_s->datetime->EditAttrs["readonly"]) && !isset($product_cart_s->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fproduct_cart_ssearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_product_code"><?php echo $product_cart_s->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->product_code->cellAttributes() ?>>
			<span id="el_product_cart_s_product_code">
<input type="text" data-table="product_cart_s" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_s->product_code->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->product_code->EditValue ?>"<?php echo $product_cart_s->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label for="x_p_remarks" class="<?php echo $product_cart_s_search->LeftColumnClass ?>"><span id="elh_product_cart_s_p_remarks"><?php echo $product_cart_s->p_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_p_remarks" id="z_p_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $product_cart_s_search->RightColumnClass ?>"><div<?php echo $product_cart_s->p_remarks->cellAttributes() ?>>
			<span id="el_product_cart_s_p_remarks">
<input type="text" data-table="product_cart_s" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" size="35" placeholder="<?php echo HtmlEncode($product_cart_s->p_remarks->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->p_remarks->EditValue ?>"<?php echo $product_cart_s->p_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_cart_s_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_cart_s_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_cart_s_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_cart_s_search->terminate();
?>