<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_cart_s_update = new product_cart_s_update();

// Run the page
$product_cart_s_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_cart_s_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fproduct_cart_supdate = currentForm = new ew.Form("fproduct_cart_supdate", "update");

// Validate form
fproduct_cart_supdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_cart_s_update->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			uelm = this.getElements("u" + infix + "_partner_id");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->partner_id->caption(), $product_cart_s->partner_id->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($product_cart_s_update->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			uelm = this.getElements("u" + infix + "_product_code");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->product_code->caption(), $product_cart_s->product_code->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($product_cart_s_update->p_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_p_remarks");
			uelm = this.getElements("u" + infix + "_p_remarks");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_cart_s->p_remarks->caption(), $product_cart_s->p_remarks->RequiredErrorMessage)) ?>");
			}
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_cart_supdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_cart_supdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_cart_supdate.lists["x_partner_id"] = <?php echo $product_cart_s_update->partner_id->Lookup->toClientList() ?>;
fproduct_cart_supdate.lists["x_partner_id"].options = <?php echo JsonEncode($product_cart_s_update->partner_id->lookupOptions()) ?>;
fproduct_cart_supdate.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_cart_s_update->showPageHeader(); ?>
<?php
$product_cart_s_update->showMessage();
?>
<form name="fproduct_cart_supdate" id="fproduct_cart_supdate" class="<?php echo $product_cart_s_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_cart_s_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_cart_s_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_cart_s">
<?php if ($product_cart_s->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$product_cart_s_update->IsModal ?>">
<?php foreach ($product_cart_s_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_product_cart_supdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $product_cart_s_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($product_cart_s->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $product_cart_s_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$product_cart_s->isConfirm()) { ?>
<input type="checkbox" name="u_partner_id" id="u_partner_id" class="form-check-input ew-multi-select" value="1"<?php echo ($product_cart_s->partner_id->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_partner_id" id="u_partner_id" value="<?php echo $product_cart_s->partner_id->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($product_cart_s->partner_id->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_partner_id"><?php echo $product_cart_s->partner_id->caption() ?></label></div></label>
		<div class="<?php echo $product_cart_s_update->RightColumnClass ?>"><div<?php echo $product_cart_s->partner_id->cellAttributes() ?>>
<?php if (!$product_cart_s->isConfirm()) { ?>
<span id="el_product_cart_s_partner_id">
<?php
$wrkonchange = "" . trim(@$product_cart_s->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$product_cart_s->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($product_cart_s->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($product_cart_s->partner_id->getPlaceHolder()) ?>"<?php echo $product_cart_s->partner_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($product_cart_s->partner_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_id',m:0,n:5,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($product_cart_s->partner_id->ReadOnly || $product_cart_s->partner_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $product_cart_s->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($product_cart_s->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fproduct_cart_supdate.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $product_cart_s->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
<?php } else { ?>
<span id="el_product_cart_s_partner_id">
<span<?php echo $product_cart_s->partner_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_cart_s->partner_id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($product_cart_s->partner_id->FormValue) ?>">
<?php } ?>
<?php echo $product_cart_s->partner_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $product_cart_s_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$product_cart_s->isConfirm()) { ?>
<input type="checkbox" name="u_product_code" id="u_product_code" class="form-check-input ew-multi-select" value="1"<?php echo ($product_cart_s->product_code->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_product_code" id="u_product_code" value="<?php echo $product_cart_s->product_code->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($product_cart_s->product_code->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_product_code"><?php echo $product_cart_s->product_code->caption() ?></label></div></label>
		<div class="<?php echo $product_cart_s_update->RightColumnClass ?>"><div<?php echo $product_cart_s->product_code->cellAttributes() ?>>
<?php if (!$product_cart_s->isConfirm()) { ?>
<span id="el_product_cart_s_product_code">
<input type="text" data-table="product_cart_s" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($product_cart_s->product_code->getPlaceHolder()) ?>" value="<?php echo $product_cart_s->product_code->EditValue ?>"<?php echo $product_cart_s->product_code->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_product_cart_s_product_code">
<span<?php echo $product_cart_s->product_code->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_cart_s->product_code->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_product_code" name="x_product_code" id="x_product_code" value="<?php echo HtmlEncode($product_cart_s->product_code->FormValue) ?>">
<?php } ?>
<?php echo $product_cart_s->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_cart_s->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label for="x_p_remarks" class="<?php echo $product_cart_s_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$product_cart_s->isConfirm()) { ?>
<input type="checkbox" name="u_p_remarks" id="u_p_remarks" class="form-check-input ew-multi-select" value="1"<?php echo ($product_cart_s->p_remarks->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_p_remarks" id="u_p_remarks" value="<?php echo $product_cart_s->p_remarks->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($product_cart_s->p_remarks->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_p_remarks"><?php echo $product_cart_s->p_remarks->caption() ?></label></div></label>
		<div class="<?php echo $product_cart_s_update->RightColumnClass ?>"><div<?php echo $product_cart_s->p_remarks->cellAttributes() ?>>
<?php if (!$product_cart_s->isConfirm()) { ?>
<span id="el_product_cart_s_p_remarks">
<textarea data-table="product_cart_s" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($product_cart_s->p_remarks->getPlaceHolder()) ?>"<?php echo $product_cart_s->p_remarks->editAttributes() ?>><?php echo $product_cart_s->p_remarks->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el_product_cart_s_p_remarks">
<span<?php echo $product_cart_s->p_remarks->viewAttributes() ?>>
<?php echo $product_cart_s->p_remarks->ViewValue ?></span>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" value="<?php echo HtmlEncode($product_cart_s->p_remarks->FormValue) ?>">
<?php } ?>
<?php echo $product_cart_s->p_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$product_cart_s_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $product_cart_s_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$product_cart_s->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_cart_s_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_cart_s_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_cart_s_update->terminate();
?>