<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_category_add = new product_category_add();

// Run the page
$product_category_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_category_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fproduct_categoryadd = currentForm = new ew.Form("fproduct_categoryadd", "add");

// Validate form
fproduct_categoryadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_category_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_category->item->caption(), $product_category->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_category_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_category->status->caption(), $product_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_category->status->errorMessage()) ?>");
		<?php if ($product_category_add->daily_production_std->Required) { ?>
			elm = this.getElements("x" + infix + "_daily_production_std");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_category->daily_production_std->caption(), $product_category->daily_production_std->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_daily_production_std");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_category->daily_production_std->errorMessage()) ?>");
		<?php if ($product_category_add->capacity_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_capacity_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_category->capacity_percent->caption(), $product_category->capacity_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_capacity_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($product_category->capacity_percent->errorMessage()) ?>");
		<?php if ($product_category_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_category->operator->caption(), $product_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_category_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_category->datetime->caption(), $product_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_categoryadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_categoryadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_category_add->showPageHeader(); ?>
<?php
$product_category_add->showMessage();
?>
<form name="fproduct_categoryadd" id="fproduct_categoryadd" class="<?php echo $product_category_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_category_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_category_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_category">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$product_category_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($product_category->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_product_category_item" for="x_item" class="<?php echo $product_category_add->LeftColumnClass ?>"><?php echo $product_category->item->caption() ?><?php echo ($product_category->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_category_add->RightColumnClass ?>"><div<?php echo $product_category->item->cellAttributes() ?>>
<span id="el_product_category_item">
<input type="text" data-table="product_category" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="36" placeholder="<?php echo HtmlEncode($product_category->item->getPlaceHolder()) ?>" value="<?php echo $product_category->item->EditValue ?>"<?php echo $product_category->item->editAttributes() ?>>
</span>
<?php echo $product_category->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_category->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_product_category_status" for="x_status" class="<?php echo $product_category_add->LeftColumnClass ?>"><?php echo $product_category->status->caption() ?><?php echo ($product_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_category_add->RightColumnClass ?>"><div<?php echo $product_category->status->cellAttributes() ?>>
<span id="el_product_category_status">
<input type="text" data-table="product_category" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($product_category->status->getPlaceHolder()) ?>" value="<?php echo $product_category->status->EditValue ?>"<?php echo $product_category->status->editAttributes() ?>>
</span>
<?php echo $product_category->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_category->daily_production_std->Visible) { // daily_production_std ?>
	<div id="r_daily_production_std" class="form-group row">
		<label id="elh_product_category_daily_production_std" for="x_daily_production_std" class="<?php echo $product_category_add->LeftColumnClass ?>"><?php echo $product_category->daily_production_std->caption() ?><?php echo ($product_category->daily_production_std->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_category_add->RightColumnClass ?>"><div<?php echo $product_category->daily_production_std->cellAttributes() ?>>
<span id="el_product_category_daily_production_std">
<input type="text" data-table="product_category" data-field="x_daily_production_std" name="x_daily_production_std" id="x_daily_production_std" size="30" placeholder="<?php echo HtmlEncode($product_category->daily_production_std->getPlaceHolder()) ?>" value="<?php echo $product_category->daily_production_std->EditValue ?>"<?php echo $product_category->daily_production_std->editAttributes() ?>>
</span>
<?php echo $product_category->daily_production_std->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_category->capacity_percent->Visible) { // capacity_percent ?>
	<div id="r_capacity_percent" class="form-group row">
		<label id="elh_product_category_capacity_percent" for="x_capacity_percent" class="<?php echo $product_category_add->LeftColumnClass ?>"><?php echo $product_category->capacity_percent->caption() ?><?php echo ($product_category->capacity_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_category_add->RightColumnClass ?>"><div<?php echo $product_category->capacity_percent->cellAttributes() ?>>
<span id="el_product_category_capacity_percent">
<input type="text" data-table="product_category" data-field="x_capacity_percent" name="x_capacity_percent" id="x_capacity_percent" size="30" placeholder="<?php echo HtmlEncode($product_category->capacity_percent->getPlaceHolder()) ?>" value="<?php echo $product_category->capacity_percent->EditValue ?>"<?php echo $product_category->capacity_percent->editAttributes() ?>>
</span>
<?php echo $product_category->capacity_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_category_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_category_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_category_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_category_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_category_add->terminate();
?>