<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_f_addopt = new product_f_addopt();

// Run the page
$product_f_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_f_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fproduct_faddopt = currentForm = new ew.Form("fproduct_faddopt", "addopt");

// Validate form
fproduct_faddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_f_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->grp->caption(), $product_f->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->s_grp->caption(), $product_f->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->product->caption(), $product_f->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
				return this.onError(elm, "<?php echo JsEncode($product_f->product->errorMessage()) ?>");
		<?php if ($product_f_addopt->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->remarks->caption(), $product_f->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->status->caption(), $product_f->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->operator->caption(), $product_f->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->datetime->caption(), $product_f->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_faddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_faddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_faddopt.lists["x_grp"] = <?php echo $product_f_addopt->grp->Lookup->toClientList() ?>;
fproduct_faddopt.lists["x_grp"].options = <?php echo JsonEncode($product_f_addopt->grp->options(FALSE, TRUE)) ?>;
fproduct_faddopt.lists["x_s_grp"] = <?php echo $product_f_addopt->s_grp->Lookup->toClientList() ?>;
fproduct_faddopt.lists["x_s_grp"].options = <?php echo JsonEncode($product_f_addopt->s_grp->lookupOptions()) ?>;
fproduct_faddopt.lists["x_status"] = <?php echo $product_f_addopt->status->Lookup->toClientList() ?>;
fproduct_faddopt.lists["x_status"].options = <?php echo JsonEncode($product_f_addopt->status->options(FALSE, TRUE)) ?>;
fproduct_faddopt.lists["x_operator"] = <?php echo $product_f_addopt->operator->Lookup->toClientList() ?>;
fproduct_faddopt.lists["x_operator"].options = <?php echo JsonEncode($product_f_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_f_addopt->showPageHeader(); ?>
<?php
$product_f_addopt->showMessage();
?>
<form name="fproduct_faddopt" id="fproduct_faddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($product_f_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_f_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $product_f_addopt->TableVar ?>">
<?php if ($product_f->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $product_f->grp->caption() ?><?php echo ($product_f->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $product_f->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$product_f->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_grp" data-value-separator="<?php echo $product_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $product_f->grp->editAttributes() ?>>
		<?php echo $product_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $product_f->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_f->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?php echo $product_f->s_grp->caption() ?><?php echo ($product_f->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_s_grp" data-value-separator="<?php echo $product_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $product_f->s_grp->editAttributes() ?>>
		<?php echo $product_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $product_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $product_f->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_f->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $product_f->product->caption() ?><?php echo ($product_f->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="product_f" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_f->product->getPlaceHolder()) ?>" value="<?php echo $product_f->product->EditValue ?>"<?php echo $product_f->product->editAttributes() ?>>
<?php echo $product_f->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_f->remarks->Visible) { // remarks ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remarks"><?php echo $product_f->remarks->caption() ?><?php echo ($product_f->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="product_f" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_f->remarks->getPlaceHolder()) ?>" value="<?php echo $product_f->remarks->EditValue ?>"<?php echo $product_f->remarks->editAttributes() ?>>
<?php echo $product_f->remarks->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_f->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $product_f->status->caption() ?><?php echo ($product_f->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_status" data-value-separator="<?php echo $product_f->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_f->status->editAttributes() ?>>
		<?php echo $product_f->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $product_f->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($product_f->operator->Visible) { // operator ?>
	<input type="hidden" data-table="product_f" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($product_f->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($product_f->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="product_f" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($product_f->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$product_f_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$product_f_addopt->terminate();
?>