<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$product_f_edit = new product_f_edit();

// Run the page
$product_f_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$product_f_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fproduct_fedit = currentForm = new ew.Form("fproduct_fedit", "edit");

// Validate form
fproduct_fedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($product_f_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->id->caption(), $product_f->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->grp->caption(), $product_f->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->s_grp->caption(), $product_f->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->product->caption(), $product_f->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkByRegEx(elm.value, /^[^_]+$/))
				return this.onError(elm, "<?php echo JsEncode($product_f->product->errorMessage()) ?>");
		<?php if ($product_f_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->remarks->caption(), $product_f->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->status->caption(), $product_f->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->operator->caption(), $product_f->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($product_f_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $product_f->datetime->caption(), $product_f->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fproduct_fedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fproduct_fedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fproduct_fedit.lists["x_grp"] = <?php echo $product_f_edit->grp->Lookup->toClientList() ?>;
fproduct_fedit.lists["x_grp"].options = <?php echo JsonEncode($product_f_edit->grp->options(FALSE, TRUE)) ?>;
fproduct_fedit.lists["x_s_grp"] = <?php echo $product_f_edit->s_grp->Lookup->toClientList() ?>;
fproduct_fedit.lists["x_s_grp"].options = <?php echo JsonEncode($product_f_edit->s_grp->lookupOptions()) ?>;
fproduct_fedit.lists["x_status"] = <?php echo $product_f_edit->status->Lookup->toClientList() ?>;
fproduct_fedit.lists["x_status"].options = <?php echo JsonEncode($product_f_edit->status->options(FALSE, TRUE)) ?>;
fproduct_fedit.lists["x_operator"] = <?php echo $product_f_edit->operator->Lookup->toClientList() ?>;
fproduct_fedit.lists["x_operator"].options = <?php echo JsonEncode($product_f_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $product_f_edit->showPageHeader(); ?>
<?php
$product_f_edit->showMessage();
?>
<form name="fproduct_fedit" id="fproduct_fedit" class="<?php echo $product_f_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($product_f_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $product_f_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="product_f">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$product_f_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($product_f->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_product_f_id" class="<?php echo $product_f_edit->LeftColumnClass ?>"><?php echo $product_f->id->caption() ?><?php echo ($product_f->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_f_edit->RightColumnClass ?>"><div<?php echo $product_f->id->cellAttributes() ?>>
<span id="el_product_f_id">
<span<?php echo $product_f->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_f->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="product_f" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($product_f->id->CurrentValue) ?>">
<?php echo $product_f->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_product_f_grp" for="x_grp" class="<?php echo $product_f_edit->LeftColumnClass ?>"><?php echo $product_f->grp->caption() ?><?php echo ($product_f->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_f_edit->RightColumnClass ?>"><div<?php echo $product_f->grp->cellAttributes() ?>>
<span id="el_product_f_grp">
<span<?php echo $product_f->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_f->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="product_f" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($product_f->grp->CurrentValue) ?>">
<?php echo $product_f->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_product_f_s_grp" for="x_s_grp" class="<?php echo $product_f_edit->LeftColumnClass ?>"><?php echo $product_f->s_grp->caption() ?><?php echo ($product_f->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_f_edit->RightColumnClass ?>"><div<?php echo $product_f->s_grp->cellAttributes() ?>>
<span id="el_product_f_s_grp">
<span<?php echo $product_f->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($product_f->s_grp->EditValue)) && $product_f->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $product_f->s_grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_f->s_grp->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($product_f->s_grp->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="product_f" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($product_f->s_grp->CurrentValue) ?>">
<?php echo $product_f->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_product_f_product" for="x_product" class="<?php echo $product_f_edit->LeftColumnClass ?>"><?php echo $product_f->product->caption() ?><?php echo ($product_f->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_f_edit->RightColumnClass ?>"><div<?php echo $product_f->product->cellAttributes() ?>>
<span id="el_product_f_product">
<input type="text" data-table="product_f" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_f->product->getPlaceHolder()) ?>" value="<?php echo $product_f->product->EditValue ?>"<?php echo $product_f->product->editAttributes() ?>>
</span>
<?php echo $product_f->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_product_f_remarks" for="x_remarks" class="<?php echo $product_f_edit->LeftColumnClass ?>"><?php echo $product_f->remarks->caption() ?><?php echo ($product_f->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_f_edit->RightColumnClass ?>"><div<?php echo $product_f->remarks->cellAttributes() ?>>
<span id="el_product_f_remarks">
<input type="text" data-table="product_f" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($product_f->remarks->getPlaceHolder()) ?>" value="<?php echo $product_f->remarks->EditValue ?>"<?php echo $product_f->remarks->editAttributes() ?>>
</span>
<?php echo $product_f->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($product_f->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_product_f_status" for="x_status" class="<?php echo $product_f_edit->LeftColumnClass ?>"><?php echo $product_f->status->caption() ?><?php echo ($product_f->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $product_f_edit->RightColumnClass ?>"><div<?php echo $product_f->status->cellAttributes() ?>>
<span id="el_product_f_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="product_f" data-field="x_status" data-value-separator="<?php echo $product_f->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $product_f->status->editAttributes() ?>>
		<?php echo $product_f->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $product_f->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$product_f_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $product_f_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $product_f_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$product_f_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$product_f_edit->terminate();
?>